/* 
 * serial.h - Win32/NT serial protos and types 
 *
 *  Contributed by Mike Connell (M.Connell@swansea.ac.uk)
 *
 *  $Id: serial.h,v 1.1 1998/08/29 20:41:34 mdanks Exp $
 */

#ifndef __SERIAL_H__
#define __SERIAL_H__

#include <windows.h>

#define SERIAL_MAX_BUFFER_POS 1024 

typedef struct S_serial {
  HANDLE  idComDev ;
  BYTE    bPort /*, abScreen[ MAXROWS * MAXCOLS ] */;
  BOOL    fConnected, fXonXoff, fLocalEcho, fNewLine, fAutoWrap,
           fUseCNReceive, fDisplayErrors;
  BYTE    bByteSize, bFlowCtrl, bParity, bStopBits ;
  DWORD   dwBaudRate ;
  HANDLE      hPostEvent, hWatchThread, hWatchEvent;
  DWORD       dwThreadID ;
  char *waiting_thread_name;
  OVERLAPPED  osWrite, osRead ;
  BYTE buffer[SERIAL_MAX_BUFFER_POS];
  int buffer_used; /* number of bytes in buffer */
} T_serial ;

/* Externals */

/* Open a serial port: 
 *   com number, 
 *   baud (not all supported), 
 *   stopbits (==1), 
 *   parity, 
 *   and a name for the thread (can be null) 
 */
int F_spaceorb_serial_start(T_serial *serial, int port, int speed, int stopbits, int parity, char *name);


/* 
 * close a port down 
 */
int F_spaceorb_serial_close_connection(T_serial *serial);


/* 
 * Write some bytes to a serial port 
 */
int F_spaceorb_serial_write(T_serial *serial, unsigned char *data, int length);


/*  read data off a serial port
 *  you allocate the buffer, so make sure its big enough 
 */
int F_spaceorb_serial_read(T_serial *serial, unsigned char *data, int length);

#endif


