/*
 * main.c -- test program for liborb, opens orb port and displays orb status
 *           as text in real-time.  Does not do anything fancy yet.
 * 
 *   Copyright 1997 John E. Stone (j.stone@acm.org)
 *
 *   $Id: main.c,v 1.1 1998/08/29 20:41:32 mdanks Exp $
 */

#include <stdio.h>
#include <stdlib.h>
#include "orb.h"

int main(int argc, char **argv) {
  char * orbname; 
  OrbHandle orb;
  int nullsize;
  int done = 0;

#if defined(WIN32) || defined(_MSC_VER)
  printf("SpaceOrb 360, Win32 test program, by John Stone (j.stone@acm.org)\n");
#else
  printf("SpaceOrb 360, Unix test program, by John Stone (j.stone@acm.org)\n");
#endif

  if (argc != 2) {
    printf("Usage error, no SpaceOrb port specified!\n");
    printf("  Usage: testorb portname\n");
    printf("  Possible port names are:\n");

#if defined(WIN32) || defined(_MSC_VER)
    printf("    1 2 3 4 5, which correspond to com1, com2, com3 etc.\n");
#else
    printf("    /dev/ttya, /dev/ttyb, /dev/ttyc, /dev/ttyd,\n");
    printf("    /dev/term/a, /dev/term/b, /dev/cua, /dev/cub\n"); 
#endif

    return -1; /* same as a call to exit() */
  } 

  orbname = argv[1];

  printf("Opening SpaceOrb: using port %s for I/O\n", orbname);

  if ((orb = orb_open(orbname)) == NULL) {
    printf("Could not open Orb comm port!\n");
    return -1; /* same as a call to exit() */
  } 
  else {
    printf("Sucessfully opened SpaceOrb port.\n");
    printf("Monitoring Orb, press button A on Orb, or ctrl-c to exit.\n\n"); 
  }

  nullsize = 65;
  printf("Setting default null-region to 65 on all 6 axes...\n");
  orb_set_nullregion(orb, nullsize, nullsize, nullsize, 
                          nullsize, nullsize, nullsize);

  printf("Buttons -- A) Quit\n");
  printf("           B) Software Init \n"); 
  printf("           C) Disable Null Region\n"); 
  printf("           F) Enable Null Region\n"); 

  while (!done) {
    int tx, ty, tz, rx, ry, rz, buttons;

    if (orb_getstatus(orb, &tx, &ty, &tz, &rx, &ry, &rz, &buttons)) {
      done = buttons & ORB_BUTTON_A; 

      if (buttons & ORB_BUTTON_B) {
        printf("\n doing soft orb init.\n");
        orb_init(orb);
      }
      if (buttons & ORB_BUTTON_C) {
        printf("\nSetting null-region to 0 on all 6 axes...\n");
        nullsize = 0;
        orb_set_nullregion(orb, nullsize, nullsize, nullsize, 
                                nullsize, nullsize, nullsize);
      }
      if (buttons & ORB_BUTTON_F) {
        printf("\nSetting null-region to 65 on all 6 axes...\n");
        nullsize = 65;
        orb_set_nullregion(orb, nullsize, nullsize, nullsize, 
                                nullsize, nullsize, nullsize);
      }
      if (buttons & ORB_BUTTON_RESET) {
        printf("\nOrb reset button pressed, orb re-zero'd\n");
      }
     
      printf("tx:%4d ty:%4d tz:%4d rx:%4d ry:%4d rz:%4d buttons:0x%02x\r",
             tx, ty, tz, rx, ry, rz, buttons);
      fflush(stdout);
    }
  }

  printf("\nOrb test complete.\n");
  printf("Closing down Orb port.\n");

  orb_close(orb);

  return 0;
}

