#!/bin/sh
### install.sh - instalacni skript pro ceske a slovenske fortunes
### -- Zdenek Pytela, 98.04.02
###
### Instalace:
### V adresari FORTUNESDIR se vytvori podadresar(e) cs-KODOVANI podle
### verze kodovani, zdrojove texty jsou kodovany v ISO-Latin-2.
### Ceske fortunes se spousti fortune cs-KODOVANI, napr. fortune cs-il2.
### Pripominky a nove prispevky muzete posilat na adresu
### <letty@mrakoplas.phil.muni.cz>.


### Ze zdroju vyradte ty, ktere se vam nelibi
ZDROJE1="zemeplocha mladik pocitace skala prislovi zezivota"
ZDROJE2="citat klasik-sk"
ZDROJE3="cimrman ignac parkinson murphy klasik-cz market"
ZDROJE=${ZDROJE:-"$ZDROJE1 $ZDROJE2 $ZDROJE3"}
### Z dokumentace by mely byt pritomny prinejmensim prvni dva soubory
DOC="README LICENSE HISTORY"
DOCDIR=${DOCDIR:-"/usr/doc/fortune-cs"}
### Z kodovani ponechte jenom ta, ktera potrebujete
KODOVANI=${KODOVANI:-"il2 ascii pc2 1250 kam il1"}
### Kde je adresar s texty fortunes - v RedHatu 5.0 doslo ke zmene!
FORTUNESDIR=${FORTUNESDIR:-"/usr/share/games/fortunes"}
#FORTUNESDIR=${FORTUNESDIR:-"/var/lib/games/fortunes"}
KODZDROJE="il2"


### Dokumentace
if [ -d $DOCDIR ] || mkdir -p $DOCDIR
then cp -f $DOC $DOCDIR
fi

### Pokud neni cstocs, instaluje se jenom jedno kodovani
if [ "`type -path cstocs`" = "" ]
then
 KODOVANI="il2"
 cstocs()
 { 
  cat $3
 }
fi

### Instalace vsech zdroju ve vsech vybranych kodovanich
for KOD in $KODOVANI
do
 if [ -d $FORTUNESDIR/cs-$KOD ] || mkdir -p $FORTUNESDIR/cs-$KOD 
 then
  for SOUBOR in $ZDROJE
  do
   # if touch $FORTUNESDIR/cs-$KOD/$SOUBOR 
   if cstocs $KODZDROJE $KOD $SOUBOR > $FORTUNESDIR/cs-$KOD/$SOUBOR 
   then
    /usr/sbin/strfile -s $FORTUNESDIR/cs-$KOD/$SOUBOR
   else
    echo "Nelze zapsat soubor $FORTUNESDIR/cs-$KOD/$SOUBOR."
   fi
  done
 else
  echo "Nelze vytvorit adresar $FORTUNESDIR/cs-$KOD."
 fi
done

### Zkouska: funguje to?
# /usr/games/fortune cs-il2

