"""Graphical telegram/announcment tool."""

#    Copyright (C) 1998 Kevin O'Connor
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

from Tkinter import *

from Tk_List import *

import empDb

###########################################################################
#############################  Telegrams      #############################
class teleWin:
    """Handle communications in a graphical manner."""
    def __init__(self):
	title = "Empire Correspondence"
	# Create root window
	self.Root = Toplevel(name='telegram')
	self.Root.withdraw()
	self.Root.title(title)
	self.Root.iconname(title)
##	self.Root.minsize(1, 1)

	# TCL variables
	self.type = StringVar()
	self.type.set('telegrams')

	# Create options bar
	oframe = Frame(self.Root, name='oframe')
	oframe.pack(side=BOTTOM, fill=X, expand=1)
	rframe = Frame(oframe, name='rframe')
	rframe.pack(side=LEFT, fill=Y, expand=1)
	anno = Radiobutton(rframe, name='anno', text="Announcements", anchor=W,
			   variable=self.type, value='announcements',
			   command=self.redraw)
	anno.pack(fill=BOTH, expand=1)
	tele = Radiobutton(rframe, name='tele', text="Telegrams", anchor=W,
			   variable=self.type, value='telegrams',
			   command=self.redraw)
	tele.pack(fill=BOTH, expand=1)
	self.RemoveB = Button(oframe, name='delete',
			      text="delete", command=self.DoRemove)
	self.RemoveB.pack(side=RIGHT, fill=Y, expand=1)
	self.ReplyB = Button(oframe, name='reply',
			     text="reply", command=self.DoReply)
	self.ReplyB.pack(side=RIGHT, fill=Y, expand=1)
	self.SendB = Button(oframe, name='send',
			    text="Send", command=self.DoSend,
			    state=DISABLED)
	self.SendB.pack(side=RIGHT, fill=Y, expand=1)

	# Create list box
	lframe = Frame(self.Root, name='lframe')
	lframe.pack(side=TOP, fill=BOTH, expand=1)
	scrollY = Scrollbar(lframe, name='scrollY')
	scrollY.pack(side=RIGHT, fill=Y)
	self.List = MyListbox(lframe, name='list', height=8, selectmode='extended',
			      command=self.SetMsg,
			      yscrollcommand=scrollY.set)
	self.List.pack(side=LEFT, fill=BOTH, expand=1)
	scrollY['command'] = self.List.yview

	# Create text box and scrollbar
	scrollY = Scrollbar(self.Root, name='scrollY')
	scrollY.pack(side=RIGHT, anchor=E, fill=Y)
	self.Text = Text(self.Root, name='text', state=DISABLED,
			 yscrollcommand=scrollY.set)
	self.Text.pack(side=LEFT, anchor=W, expand=1, fill=BOTH)
	scrollY['command'] = self.Text.yview

	# Draw
	self.redraw(1)
	self.List.focus()

	# Register automatic updating
	viewer.updateList.append(self)
	self.Root.protocol('WM_DELETE_WINDOW', self.handleDelete)

    def handleDelete(self):
	self.Root.withdraw()

    def mapWindow(self):
	self.Root.deiconify()
	self.Root.lift()

    def SetMsg(self, msg):
	if self.Text['state'] == NORMAL:
	    return
	self.Text['state'] = NORMAL
	self.Text.delete('1.0', END)
	for i in msg:
	    for j in i:
		self.Text.insert(END, j+"\n")
	self.Text['state'] = DISABLED

    def redraw(self, total=1):
	if total:
	    sts = self.List.getStatus()
	    self.List.delete()
	    db = empDb.megaDB[self.type.get()]
	else:
	    db = empDb.megaDB['updated'][self.type.get()]
	for i in db:
	    self.List.insert(END, (i[0], i))
	if total:
	    apply(self.List.setStatus, sts)

    def DoSend(self):
	self.SendB['state'] = DISABLED
	self.ReplyB['state'] = NORMAL
	self.RemoveB['state'] = NORMAL
	print self.Text.get('1.0', END)
	self.Text['state'] = DISABLED
	self.List.focus()
	self.SetMsg(self.List.curselection())

    def DoReply(self):
	which = self.List.curselection()
	if not which or len(which) > 1:
	    return
	self.Text['state'] = NORMAL
	self.Text.delete('1.0', END)
	for i in which[0]:
	    self.Text.insert(END, " >"+i+"\n")
	self.Text.focus()
	self.SendB['state'] = NORMAL
	self.ReplyB['state'] = DISABLED
	self.RemoveB['state'] = DISABLED
##	self.List['state'] = DISABLED

    def DoRemove(self):
	which = self.List.curselection()
	self.List.delete(which)
	for i in which:
	    empDb.megaDB[self.type.get()].remove(i)
