//  UPrint.h version 1.1
//  yudit package - Unicode Editor for the X Window System (and Linux) 
//
//  Author: gsinai@iname.com (Gaspar Sinai)
//  GNU Copyright (C) 1997,1998  Gaspar Sinai
// 
//  yudit version 1.1  Copyright(C) 23 August,   1998, Tokyo Japan  Gaspar Sinai
//  yudit version 1.0  Copyright(C) 17 May,      1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.99 Copyright(C)  4 April,    1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.97 Copyright(C)  4 February, 1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.95 Copyright(C) 10 January,  1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.94 Copyright(C) 17 December, 1997, Tokyo Japan  Gaspar Sinai
//  yudit version 0.9 Copyright (C)  8 December, 1997, Tokyo Japan  Gaspar Sinai
//  yutex version 0.8 Copyright (C)  5 November, 1997, Tokyo Japan  Gaspar Sinai
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
#ifndef __uprint_h__
#define __uprint_h__

#include <iostream.h>
#include "UCommon.h"
#include "AString.h"

class UPrintMap
{
public:
			UPrintMap ();
			~UPrintMap ();
	int		glyphIndex;
	int		psFont;
	short		xMin;
	short		yMin;
	short		xMax;
	short		yMax;
	int		width;
	int		lsb;
};

class UPrint
{
public:	
	enum UStatus { ERROR, OK};
	enum Tables {TB_NAME, TB_HEAD, TB_HHEA, TB_POST, TB_GLYPH,
		TB_CMAP, TB_KERN, TB_MAXP, TB_HTMX, TB_LOCA, TB_MAX};
	enum Names {TN_NOTICE, TN_FAMILY, TN_WEIGHT, TN_X3, TN_FULLNAME,
		TN_VERSION, TN_FONTNAME, TN_X7, TN_MAX};
			UPrint (const char* fontIn, double fontSizeIn, 
				int tabStopsIn, double headerHeightIn=10.0);
			~UPrint ();
	UStatus		print (ostream* printerIn, const UCS2* const linesIn[], 
				int countIn, const UCS2* headerIn=0);
	AString		errors;
	inline int	getPageCount () 
			{ return pageCount; };
	inline int	getWrappedCount () 
			{ return wrappedCount; };
	
private:
	int		pageCount;
	int		wrappedCount;
	AString		documentTitle;
	enum DrawType   {START, FINISH, TESTONLY, DRAW, FORCE, NEWPAGE, 
				NEWPAGETEST, MOVE};
	void		clear ();
	UStatus		handleName ();
	UStatus		buildCmap ();
	UStatus		buildHtmx ();
	UStatus		printFont ();
	UStatus		checkTables ();
	void		printProlog ();
	double		printChar (int ucs2, UPrintMap* xPrintMap, 
				DrawType type);
	void		getName(Names id, char* str, int len);
	void		doGlyph (int unicode, int base64Code);
	void		doHeader ();
	int		drawGlyph (int glyphno, int parent, int long_offsets);
	void		addMap (const UCS2* lineIn);
	AString		fontFile;
	ostream*	printer;
	UPrintMap**	printMap[256];
	int		printMapSize;
	void*		tables[TB_MAX];
	char*		name_fields[TN_MAX];
	char*		fileBuffer;
	const char*	fontSwitch;
	int		fileBufferLen;
	int		fd;
	int		segmentCount;
	AString		mediaName;
	double		mediaWidth;
	double		mediaHeight;
	double		marginWidth;
	double		marginHeight;
	double		headerHeight;
	double		headerFontSize;
	double		cursorX;
	double		cursorY;
	double		fontSize;
	double		lineHeight;
	double		charWidth;
	double		charDescent;
	double		scaleFactor;

	// This is to have missing postcript table
	double		italicAngle;
	short		underlineThickness;
	short		underlinePosition;
	int		isFixedPitch;
	int		fontNow;
	int		tabChars;
	int		pageIndex;
	const UCS2*	headerString;
};

#endif /* __uprint_h__ */
