//  UParser.h version 1.1
//  yudit package - Unicode Editor for the X Window System (and Linux) 
//
//  Author: gsinai@iname.com (Gaspar Sinai)
//  GNU Copyright (C) 1997,1998  Gaspar Sinai
// 
//  yudit version 1.1  Copyright(C) 23 August,   1998, Tokyo Japan  Gaspar Sinai
//  yudit version 1.0  Copyright(C) 17 May,      1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.99 Copyright(C)  4 April,    1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.97 Copyright(C)  4 February, 1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.95 Copyright(C) 10 January,  1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.94 Copyright(C) 17 December, 1997, Tokyo Japan  Gaspar Sinai
//  yudit version 0.9 Copyright (C)  8 December, 1997, Tokyo Japan  Gaspar Sinai
//  yutex version 0.8 Copyright (C)  5 November, 1997, Tokyo Japan  Gaspar Sinai
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//
// UParser
//
#ifndef __uparser_h__
#define __uparser_h__

#include <fstream.h>
#include <iostream.h>

#ifndef yyFlexLexer
#define yyFlexLexer UMFlexLexer
#include <FlexLexer.h>
#endif

class UParser : public UMFlexLexer
{
public:
	enum UType 	{UNKNOWN=0, CHAR, SHORT, INT, FLOAT, DOUBLE,
			 CHAR_ARRAY=0x81, 
			 SHORT_ARRAY, INT_ARRAY, 
			 FLOAT_ARRAY, DOUBLE_ARRAY };

			UParser (ifstream* file);
			~UParser ();

	int 		parseInput (int arraySize,  char* names[], 
				UType types[], int sizes[], void* values[]);

	char**		names;
	UType		*types;
	int 		*sizes;
	void** 		values;

	int		index;
	int		size;

	int		sizeArray;
	int		type;
	int		error;
	enum UBufferSize {SIZE_BUFFER=1024 };
};

#endif /* __uparser_h__ */
