//  UFont.h version 1.1
//  yudit package - Unicode Editor for the X Window System (and Linux) 
//
//  Author: gsinai@iname.com (Gaspar Sinai)
//  GNU Copyright (C) 1997,1998  Gaspar Sinai
// 
//  yudit version 1.1  Copyright(C) 23 August,   1998, Tokyo Japan  Gaspar Sinai
//  yudit version 1.0  Copyright(C) 17 May,      1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.99 Copyright(C)  4 April,    1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.97 Copyright(C)  4 February, 1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.95 Copyright(C) 10 January,  1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.94 Copyright(C) 17 December, 1997, Tokyo Japan  Gaspar Sinai
//  yudit version 0.9 Copyright (C)  8 December, 1997, Tokyo Japan  Gaspar Sinai
//  yutex version 0.8 Copyright (C)  5 November, 1997, Tokyo Japan  Gaspar Sinai
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//
//

#ifndef __ufont_h__
#define __ufont_h__

#include <UFontMap.h>
#include <X11/Xlib.h>
#include <UFreeType.h>
#include "UPixmapCache.h"

#ifdef FREETYPE
#include <freetype.h>
#endif


class UFontCache
{
public:
				UFontCache(void);
	virtual			~UFontCache();
	virtual int		getDirection();
	virtual int		getWidth (const XChar2b& char2B);
	virtual inline int	getAscent ()
				{ return 0; }
	virtual inline int	getDescent ()
				{ return 0; }
	virtual void 		drawImageString (Display* dsp, 
					Window window, GC gc,
					int x, int y, int ascent,
					const XChar2b* char2B, 
					int count, UPixmapCache* pmc);
	virtual void 		drawString (Display* dsp,
					Window window, GC gc,
					int x, int y, int ascent,
					const XChar2b* char2B, 
					int count, UPixmapCache* pmc);
};

class UFont
{
public:
	enum			UFontType {UFONT, UX11, UFREE };
	enum			UWeight	{ANYWEIGHT, REGULAR, MEDIUM, 
					DEMIBOLD, BOLD};
	enum			USlant	{ANYSLANT, ROMAN, ITALIC, OBLIQUE};
	enum			USpacing{ANYSPACING, MONOSPACE, CONDENSED, PROPORTIONAL};
				UFont (UFontMap* fontMapIn);
				UFont (UFreeType* freeTypeIn);
	virtual			~UFont ();
	virtual void		setPixel (const int pixelIn);
	virtual UFontCache*	getFont (const UCS2 *text=0, const int from=0, 
					int *to=0);
	inline virtual const int	isNew() const {return 0;}

	// For free type fonts this is a new font!
	virtual void		setWeight (const UWeight weightIn);
	virtual	void		setSlant (const USlant slantIn);
	virtual	void		setSpacing (const USpacing spacingIn);

	virtual void		setWeight (const char* weightIn);
	virtual	void		setSlant (const char* slantIn);
	virtual	void		setSpacing (const char* spacingIn);
	virtual int		isA (UFontType ftype);
	virtual const UFontMapStruct* getFontMapStruct (const UCS2 input);

	inline int		getPixel ()
				{ return pixel; }
	inline UWeight		getWeight ()
				{ return weight; }
	inline USlant		getSlant ()
				{ return slant; }
	inline USpacing		getSpacing ()
				{ return spacing; }

	int			fontAscent;
	int			fontDescent;
	int			fontWidth;
	int			fontHeight;
	int			minFontWidth;
	UFontMap*		fontMap; // the pointer should exist for X11
	UFreeType*		freeType; // The handles are here but the
					  // instances are not
protected:
	int			pixel;  // size in pixels
	UWeight			weight;
	USlant			slant;
	USpacing		spacing;
};

class UFontX11Cache : public UFontCache
{
public:				// name and font will be mine
				UFontX11Cache::UFontX11Cache (
					const char *name, 
					Display* displayIn, 
					const UFontMapStruct* fontMapIn, 
					const int pixelIn, 
					const UFont::UWeight weightIn, 
					const UFont::USlant slantIn,
					const UFont::USpacing spacingIn);
	virtual			~UFontX11Cache ();

	virtual int		getDirection();
	virtual int		getWidth (const XChar2b& char2B);
	virtual void 		drawImageString (Display* dsp, 
					Window window, GC gc,
					int x, int y, int ascent,
					const XChar2b* char2B, 
					int count, UPixmapCache* pmc);
	virtual void 		drawString (Display *dsp,
					Window window, GC gc,
					int x, int y, int ascent,
					const XChar2b* char2B, 
					int count, UPixmapCache* pmc);

	virtual inline int	getAscent () 
				{ return (font==0)? 0 : font->ascent;}
	virtual inline int	getDescent ()
				{ return (font==0)? 0 : font->descent;}

	XFontStruct*		font;
	char*			cacheName;
private:
	char*			getFontName(
					const UFontMapStruct* fontMapIn,
					const int pixelIn, 
					const UFont::UWeight weightIn,
					const UFont::USlant slantIn,
					const UFont::USpacing spacingIn);
	char*			fontName;
	Display*		display;

};

class UFontIndexCache
{
public:
				UFontIndexCache (const char* name);
				~UFontIndexCache ();
	char*			name;
	unsigned char*		index[256];
};

//
// X11 font
// FreeType fonts use UFontFreeType
//
class UFontX11 : public UFont
{
public:
		
				// We need to reorganize things here
				// to use const . Currently fontMap is
				// used by the copy as well.
				UFontX11 (UFontX11 &fontCpy);
				UFontX11 (UFontMap* fontMapIn, 
					Display *displayIN, int screen);
	virtual			~UFontX11 ();
	virtual void		setPixel (const int pixelIn);

	virtual void		setWeight (const UWeight weightIn);
	virtual	void		setSlant (const USlant slantIn);
	virtual	void		setSpacing (const USpacing spacingIn);

	virtual void		setWeight (const char* weightIn);
	virtual	void		setSlant (const char* slantIn);
	virtual	void		setSpacing (const char* spacingIn);
	inline const int	getSize () 
				{ 
					if (fontChanged) getFont();
					return size; 
				}
	const XFontStruct*	getFontAt (const int size);

	// it returns XFontStruct *
	virtual UFontCache*	getFont (const UCS2 *text=0, const int from=0, 
					int *to=0);
	inline virtual const int	isNew() const {return fontChanged;}
	virtual int		isA (UFontType ftype);
	int			getFontIndex (const UCS2 char_);
	virtual const UFontMapStruct* getFontMapStruct (const UCS2 input);
private:
	UFontIndexCache*	fontIndex;
	void			clear();
	char*			getCacheName(const UFontMapStruct*  fontMapStruct);
	char*			getFontIndexCacheName ();
	Display*		display;
	int			screen;
	int			size;
	UFontX11Cache** 	fonts;
	int			fontChanged;		
};

UFont* UNewFont(Display* disp, int screen, const char* name);
void UDeleteFont (UFont* font);

#endif /* __ufont_h__ */
