//  UPromptDialog.cpp version 1.1
//  yudit package - Unicode Editor for the X Window System (and Linux) 
//
//  Author: gsinai@iname.com (Gaspar Sinai)
//  GNU Copyright (C) 1997,1998  Gaspar Sinai
// 
//  yudit version 1.1  Copyright(C) 23 August,   1998, Tokyo Japan  Gaspar Sinai
//  yudit version 1.0  Copyright(C) 17 May,      1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.99 Copyright(C)  4 April,    1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.97 Copyright(C)  4 February, 1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.95 Copyright(C) 10 January,  1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.94 Copyright(C) 17 December, 1997, Tokyo Japan  Gaspar Sinai
//  yudit version 0.9 Copyright (C)  8 December, 1997, Tokyo Japan  Gaspar Sinai
//  yutex version 0.8 Copyright (C)  5 November, 1997, Tokyo Japan  Gaspar Sinai
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#define CMARGIN 4
#define MARGIN 10
#define BUTTON_MARGIN 20

#include "UPromptDialog.h"
#include "UTextButton.h"
#include "UTextLabel.h"
#include "UTextMenu.h"
#include "UTextFrame.h"
#include "UButton.h"
#include "UChoice.h"
#include "UScrolledList.h"
#include "strings.h"

#define DEBUG

UPromptDialog::UPromptDialog (UShell* transient_, int frameSize_) :
	UDialog (transient_, frameSize_)
{
	setUp();
}

UPromptDialog::UPromptDialog (UTop* top_, int frameSize_) :
	UDialog (top_, frameSize_)
{
	setUp ();
}

void 
UPromptDialog::setUp()
{
	UColor	white (top->display);

	white = "#FFFFFF";

	component[OK] = new UTextButton (this, "OK");
	component[OK]->setMargin (CMARGIN);
	component[CANCEL] = new UTextButton (this, "CANCEL");
	component[CANCEL]->setMargin (CMARGIN);
	lastButton = CANCEL;

	component[LABEL] = new UTextLabel (this, "Input", UTextLine::LEFT);
	component[LABEL]->setMargin (CMARGIN);

	component[TEXT] = new UTextFrame (this);
	component[TEXT]->setMargin (CMARGIN);
	((UTextFrame*)component[TEXT])->uSetBackground (white.getPixel());
	((UTextFrame*)component[TEXT])->uSetMultiLine (UWidget::SINGLE);

	rectangle.width = 20;
	rectangle.height = 20;
}

UPromptDialog::~UPromptDialog ()
{
	// autodelete
}

#define MAXVLE(_a, _b) ((_a>_b)?_a:_b)

const UBestSize&
UPromptDialog::getBestSize ()
{
	UBestSize	bsComp[COMP_MAX];
	int		tHeight;
	int 		i;

#ifdef DEBUG
	UEvent		event;

	XFlush (top->display);
	while (XPending (top->display) !=0)
	{
		UNextEvent (top, &event);
		UDispatchEvent (top, &event);
	}
#endif
	for (i=0; i<(int)COMP_MAX; i++)
	{
		bsComp[i] = component[i]->getBestSize ();
	}

	bsComp[OK].width = MAXVLE (bsComp[OK].width, bsComp[CANCEL].width);
	bsComp[CANCEL].width = bsComp[OK].width;

	bsComp[LABEL].width = MAXVLE (bsComp[TEXT].width, bsComp[LABEL].width);
	bsComp[TEXT].width = bsComp[LABEL].width;

	bestSize.width = MAXVLE (bsComp[OK].width + bsComp[CANCEL].width,
		bsComp[LABEL].width + bsComp[TEXT].width);


	tHeight = MAXVLE (bsComp[LABEL].height, bsComp[TEXT].height);
	component[LABEL]->place (MARGIN, 
		(tHeight-bsComp[LABEL].height)/2+MARGIN, 
		-bsComp[LABEL].width - MARGIN,
		-((tHeight+bsComp[LABEL].height)/2+MARGIN)); 

	component[TEXT]->place (bsComp[LABEL].width + MARGIN, 
		(tHeight-bsComp[TEXT].height)/2+MARGIN, MARGIN,
		-((tHeight+bsComp[TEXT].height)/2+MARGIN)); 

	bestSize.height = bsComp[OK].height + tHeight;

	component[CANCEL]->place (-bsComp[CANCEL].width-MARGIN, 
			-bsComp[CANCEL].height-MARGIN, 
			MARGIN, MARGIN);
	component[OK]->place (MARGIN, -bsComp[OK].height-MARGIN, 
			-bsComp[OK].width-MARGIN, MARGIN);


	bestSize.width += 2*MARGIN;
	bestSize.height += 3*MARGIN;

	minimumWidth = bestSize.width;
	minimumHeight = bestSize.height;
	if (rectangle.width > bestSize.width) bestSize.width = rectangle.width;
	if (rectangle.height > bestSize.height) bestSize.height = rectangle.height;
	return bestSize;
}

UDialog::UValue
UPromptDialog::getValue()
{
	lastButton = CANCEL;
	((UTextFrame*)component[TEXT])->setFocus();
	UDialog::getValue();
	if (lastButton==OK) return (UDialog::OK);
	return  (UDialog::CANCEL);
}

void
UPromptDialog::setButtonFont (UFont* font_)
{
	component[OK]->setFont (font_);
	component[CANCEL]->setFont (font_);
}

void
UPromptDialog::setTextFont (UFont* font_)
{
	component[LABEL]->setFont (font_);
	((UTextFrame*)component[TEXT])->uSetFont (font_);
	((UTextFrame*)component[TEXT])->uRefresh();
}

int
UPromptDialog::setEncoding (const char* enco_)
{
	if (((UTextFrame*)component[TEXT])->uSetConverter (enco_)
		== UString::ERROR)
	{
		return 0;
	}
	return 1;
}

int
UPromptDialog::setInput (const char* input_)
{
	if (strcasecmp (input_, "Straight") ==0
		|| strcasecmp (input_, "None")==0)
	{
		((UTextFrame*)component[TEXT])->uSetInput (0);
		return 1;
	}
	if (((UTextFrame*)component[TEXT])->uSetInput (input_)
		== UWidget::ERROR)
	{
		return 0;
	}
	return 1;
}

void
UPromptDialog::setText (USubComponent comp_, const char* utf8_)
{
	switch (comp_)
	{
	case CANCEL:
	case OK:
		((UTextButton*) component[comp_])->setText (utf8_);
		break;
	case LABEL:
		((UTextLabel*) component[comp_])->setText (utf8_);
		break;
	default:
		break;
	}
}

const char*
UPromptDialog::getSelected ()
{
	const UCS2* const*	ucs2;
	UString			ustr;
	char*			str;

	ucs2 = ((UTextFrame*)component[TEXT])->uGetTextBuffer();

	if (ucs2!=0 && ucs2[0]!=0)
	{
		ustr.setConverter("UTF8");
		ustr.putUString (ucs2[0]);
		str = (char*) ustr.getString();
		selected = str;
		delete str;
	}
	else
	{
		selected = "";
	}
	return ((const char*) selected);
}

void	
UPromptDialog::eventUp (UEvent* event)
{
	AString		newDir;
	UBestSize	bs;

	switch (event->type)
	{
	case UEvent::ACTIVATED:
		if (event->client !=0 && event->client==component[CANCEL])
		{
			lastButton = CANCEL;
			hide ();
			return;
		}
		if (event->client !=0 && event->client==component[OK])
		{
			lastButton = OK;
			hide ();
			return;
		}
		break;
	case UEvent::SCROLL_RANGE_HORIZONTAL:
		if (event->client !=0 && event->client==component[TEXT])
		{
			((UTextFrame*)component[TEXT])->uHScroll (event->value);
		}
		break;
	default:
		UShell::eventUp (event);
		break;
	}
}

