/* GXedit
 * Copyright 1998 Patrick Lambert <drow@wildstar.net>
 *
 * This program is free software. You can use, copy and modify it under
 * the terms of the GPL. See the file COPYING for the full GPL license.
*/

#include "gxedit.h"
#include "pixmaps.h"

#define VERSION "1.15"

#ifdef GTKEDITOR_PATCH
static GtkEditorHilitePatterns c_patterns =
{ "/\\*",
  "\\*/",
  "\"",
  "\"",
  C_STYLE
/* "\\b\\(if\\|else\\|for\\|while\\)\\b" */
};
static GtkEditorHilitePatterns html_patterns =
{
 "<!-",
 "->",
 "<",
 ">",
 HTML_STYLE
/* "JavaScript\\|VBScript" */
};
static GtkEditorHilitePatterns perl_patterns =
{
 "#",
 "\n",
 "\"",
 "\"",
 PERL_STYLE
/* "print\\|if\\|while\\|for\\|foreach\\|import\\|require\\|chop\\|chomp\\|eval" */
};
static GtkEditorHilitePatterns java_patterns =
{
 "//",
 "\n",
 "\"",
 "\"",
 JAVA_STYLE
/* "System\\|Class" */
};
#endif

const gchar *list_item_data_key1 = "list_item_data";

char *lindex(char *input_string, int word_number)
{
 char *tokens[1024];
 static char tmpstring[1024];
 int i;
 strncpy(tmpstring,input_string,1024);
 (char *)tokens[i=0] = (char *)strtok(tmpstring, " ");
 while (((char *)tokens[++i] = (char *)strtok(NULL, " ")));
 tokens[i] = NULL;
 return(tokens[word_number]);
}

char *lrange(char *input_string, int starting_at)
{
 char *tokens[1024];
 static char tmpstring[1024]="";
 int i;
 char out_string[1024]="";
 strcpy(out_string,"");
 if(input_string==NULL) {
  strcpy(out_string," ");
  strcat(out_string,NULL);   
  strcpy(global_var,out_string);
  return (char *)global_var; }
 strncpy(tmpstring,input_string,1024);
 (char *)tokens[i=0] = (char *)strtok(tmpstring, " ");
 while(((char *)tokens[++i] = (char *)strtok(NULL, " ")));
 tokens[i] = NULL;
 i++;
 if(i<starting_at)
 {
  return (char *)"";
 }
 while(tokens[starting_at] != NULL)
 {
  strncat(out_string,tokens[starting_at],1024);
  strcat(out_string, " ");
  starting_at++;  
 }   
 strncpy(global_var,out_string,511);
 return (char *)global_var;
}

char ndcode(char trans)
{
 /* from rot13 v1.3 */
 if ((trans >= 65 && trans <= 90) || (trans >= 97 && trans <= 122))
 {
  if (trans >= 78 && trans <= 90) trans -= 26;
  if (trans >= 110 && trans <= 122) trans -= 26;
  trans += 13;
 }
 return (trans);
}

void print_debug(char *string)
{
 if(debug)
 gtk_text_insert (GTK_TEXT (text_debug), NULL, &color, NULL, string, -1);
}

static gushort convert_color(unsigned c)
{
 if (c==0) return(0);
 c *= 257;
 return(c > 0xffff)? 0xffff : c;
}
 
void extract_color(GdkColor *color, unsigned red, unsigned green, unsigned blue)
{
 color->red = convert_color(red);
 color->green = convert_color(green);
 color->blue = convert_color(blue);
}

static GtkWidget *new_pixmap_from_file (char *filename, GdkWindow *window, GdkColor  *background)
{
 GtkWidget *wpixmap;
 GdkPixmap *pixmap;
 GdkBitmap *mask;
 pixmap = gdk_pixmap_create_from_xpm (window, &mask, background, filename);
 wpixmap = gtk_pixmap_new (pixmap, mask);
 return wpixmap;
}

static GtkWidget *new_pixmap(int type, GdkWindow *window, GdkColor *background)
{
 GtkWidget *wpixmap;
 /* GdkPixmap *pixm; */
 GdkBitmap *mask;
 if(type==0)
  pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, new_xpm);
 if(type==1)
  pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, open_xpm);
 if(type==2)
  pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, save_xpm);
 if(type==3)
  pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, help_xpm);
 if(type==4)
  pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, exit_xpm);
 if(type==5)
  pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, copy_xpm);
 if(type==6)
  pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, paste_xpm);
 if(type==7)
  pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, settings_xpm);
 if(type==10)
  pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, print_xpm);
 if(type==101)
  pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, reply_xpm);
 if(type==102)
  pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, open_mail_xpm);
 if(type==103)
  pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, send_xpm);
 if(type==104)
  pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, open_news_xpm);
 if(type==105)
  pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, post_xpm);
 if(type==200)
  pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, about_xpm);
 if(type==301)
  pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, html_center_xpm);
 if(type==302)
  pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, html_font_xpm);
 if(type==303)
  pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, html_header_xpm);
 if(type==304)
  pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, html_image_xpm);
 if(type==305)
  pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, html_list_xpm);
 if(type==306)
  pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, html_line_xpm);
 if(type==307)
  pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, html_style_xpm);
 if(type==308)
  pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, html_table_xpm);
 if(type==309)
  pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, html_break_xpm);
 if(type==310)
  pixm = gdk_pixmap_create_from_xpm_d(window, &mask, background, html_link_xpm);
 wpixmap = gtk_pixmap_new (pixm, mask);
 return wpixmap;
}

void CB_bookmarks(gint type, GtkWidget *entry)
{
 sprintf(temp, "%s/.gxedit.bookmarks", home);
 fd = fopen(temp, "r");
 if(fd==NULL)
 {
  print_debug("Can't open bookmarks file\n");
  return;
 }
 while(fgets(line, 500, fd)!=NULL)
 {
  if(atoi(lindex(line,1))==type)
  {
   if(modified)
   {
    sprintf(temp, "%s %s &", progname, lindex(line,0));
    system(temp);
   }
   else
   {
    if(fd!=NULL) fclose(fd);
    gtk_text_set_point(GTK_TEXT(text), 0);
    gtk_text_forward_delete(GTK_TEXT(text),
    gtk_text_get_length(GTK_TEXT(text)));
    modified = 0;
    strcpy(filename,lindex(line,0));
    gtk_window_set_title (GTK_WINDOW (window), filename);
    sprintf(line, "GXedit %s - %s\n", VERSION, filename);
    sprintf(temp, "%s/.gxedit.last", home);
    fd = fopen(temp, "a");
    if(fd!=NULL) 
    {
     fputs(filename, fd);
     fputs("\n", fd);
     fclose(fd);
    }
    fd = fopen(filename,"r");
    if(fd==NULL)
    {
     print_debug("Can't open file for reading\n");
     msgbox("Can't open file for reading");
     return;
    }
    gtk_text_freeze(GTK_TEXT(text));
    while(fgets(line,512,fd)!=NULL)
    {
     gtk_text_insert (GTK_TEXT (text), NULL, &color, NULL, line, -1);
    }
    gtk_text_thaw (GTK_TEXT (text));
    fclose(fd);
#ifdef GTKEDITOR_PATCH
    if(syntax_h)
    gtk_editor_hilite_buffer(GTK_EDITOR(text));
#endif
    return;
   }
  }
 }
 fclose(fd);
}

void CB_mark(GtkWidget *widget, gpointer data)
{
 if(marked==0) marked = gtk_text_get_point(GTK_TEXT(text)); 
 else
 {
  gtk_editable_select_region(GTK_EDITABLE(text), marked, gtk_text_get_point(GTK_TEXT(text))); 
  marked = 0;
 }
}

void CB_encrypt_ok(GtkWidget *widget, GtkWidget *entry)
{
 strncpy(tmp_name, tempnam(NULL,".gxe"), 50);
 fd = fopen(tmp_name, "w");
 if(fd==NULL)
 {
  msgbox("Can't open temp file for writing");
  print_debug("Can't open temp file for writing\n");
  return;
 }
 fputs((char *)gtk_editable_get_chars(GTK_EDITABLE (text), 0, gtk_text_get_length(GTK_TEXT(text))),fd);
 fclose(fd);
 strcpy(temp,"");
 sprintf(line, "%s.enc", filename);
 if(!strcmp(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(eb11)->entry)),"DES weak encryption (/bin/des)"))
 sprintf(temp, "/bin/des -E -k \"%s\" %s %s", gtk_entry_get_text(GTK_ENTRY(entry_box)), tmp_name, line);
 if(!strcmp(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(eb11)->entry)),"IDEA medium/strong encryption (/bin/idea)"))
 sprintf(temp, "/bin/idea -e -k \"%s\" %s %s", gtk_entry_get_text(GTK_ENTRY(entry_box)), tmp_name, line);
 system(temp);
 gtk_widget_destroy(window2);
}

void CB_encrypt(GtkWidget *widget, GtkWidget *entry)
{
 GList *cbitems = NULL;
 if(window2!=NULL)
 {
  gtk_widget_destroy(window2);
 }
 window2 = gtk_window_new (GTK_WINDOW_TOPLEVEL);
 gtk_signal_connect (GTK_OBJECT (window2), "destroy",
  GTK_SIGNAL_FUNC(CB_open_cancel), &window2);
 gtk_signal_connect (GTK_OBJECT (window2), "delete_event",
  GTK_SIGNAL_FUNC(CB_open_cancel), &window2);
 gtk_window_set_title (GTK_WINDOW (window2), "Encrypt file");
 gtk_container_border_width (GTK_CONTAINER (window2), 2);
 gtk_widget_set_uposition (window2, (x_pos+100), (y_pos+100));
 gtk_widget_set_usize (window2, 400, 150);
 
 vbox = gtk_vbox_new (FALSE, 0);
 gtk_container_add (GTK_CONTAINER (window2), vbox);
 gtk_container_border_width (GTK_CONTAINER (window2), 5);
 gtk_widget_show (vbox);
 
 label = gtk_label_new ("Encrypt text (see Help for info)\nEnter one-word key to use (8-100 chars):");
 gtk_box_pack_start (GTK_BOX (vbox), label, TRUE, TRUE, 0);
 gtk_widget_show (label);
 
 entry_box = gtk_entry_new ();
 gtk_editable_select_region (GTK_EDITABLE (entry_box), 0, -1);
 gtk_box_pack_start (GTK_BOX (vbox), entry_box, TRUE, TRUE, 0);
 gtk_widget_show (entry_box);

 cbitems = g_list_append(cbitems, "DES weak encryption (/bin/des)");
 cbitems = g_list_append(cbitems, "IDEA medium/strong encryption (/bin/idea)");

 eb11 = gtk_combo_new ();
 gtk_combo_set_popdown_strings (GTK_COMBO (eb11), cbitems);
 gtk_entry_set_text (GTK_ENTRY (GTK_COMBO(eb11)->entry), "DES weak encryption (/bin/des)");
 gtk_box_pack_start (GTK_BOX (vbox), eb11, TRUE, TRUE, 0);
 gtk_widget_show (eb11);

 button = gtk_button_new_with_label ("OK");
 gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
  GTK_SIGNAL_FUNC(CB_encrypt_ok), GTK_OBJECT (window2));
 gtk_box_pack_start (GTK_BOX (vbox), button, TRUE, TRUE, 0);
 GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
 gtk_widget_grab_default (button);
 gtk_widget_show (button);
 gtk_widget_show (window2);
}

void CB_decrypt_ok(GtkWidget *widget, GtkFileSelection *fs)
{
 strncpy(tmp_name, tempnam(NULL,".gxe"), 50);
 strcpy(temp, "");
 if(!strcmp(temp,"DES weak encryption (/bin/des)"))
 sprintf(temp, "/bin/des -D -k \"%s\" %s %s", line, gtk_file_selection_get_filename(GTK_FILE_SELECTION(fs)), tmp_name);
 if(!strcmp(temp,"IDEA medium/strong encryption (/bin/idea)"))
 sprintf(temp, "/bin/idea -d -k \"%s\" %s %s", line, gtk_file_selection_get_filename(GTK_FILE_SELECTION(fs)), tmp_name);
 system(temp);
 open_file(tmp_name, "Can't open temp file for reading\n");
 gtk_widget_destroy(window2);
}

void CB_decrypt_1(GtkWidget *widget, GtkWidget *entry)
{
 strncpy(line, gtk_entry_get_text(GTK_ENTRY(entry_box)), 500);
 strncpy(temp, gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(eb11)->entry)), 500);
 if(window2!=NULL)
 {
  gtk_widget_destroy(window2);
 }
 window2 = gtk_file_selection_new ("Select file");
 gtk_signal_connect (GTK_OBJECT (window2), "destroy",
  GTK_SIGNAL_FUNC(CB_open_cancel), &window2);
 gtk_signal_connect (GTK_OBJECT (window2), "delete_event",
  GTK_SIGNAL_FUNC(CB_open_cancel), &window2);
 gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION(window2)->ok_button),
  "clicked", GTK_SIGNAL_FUNC(CB_decrypt_ok), window2);
 gtk_signal_connect (GTK_OBJECT(GTK_FILE_SELECTION(window2)->cancel_button),
  "clicked", GTK_SIGNAL_FUNC(CB_open_cancel), &window2);
 gtk_widget_set_uposition (window2, (x_pos+50), (y_pos+50));
 gtk_widget_show (window2);
}

void CB_decrypt(GtkWidget *widget, GtkWidget *entry)
{
 GList *cbitems = NULL;
 if(window2!=NULL)
 {
  gtk_widget_destroy(window2);
 }
 window2 = gtk_window_new (GTK_WINDOW_TOPLEVEL);
 gtk_signal_connect (GTK_OBJECT (window2), "destroy",
  GTK_SIGNAL_FUNC(CB_open_cancel), &window2);
 gtk_signal_connect (GTK_OBJECT (window2), "delete_event",
  GTK_SIGNAL_FUNC(CB_open_cancel), &window2);
 gtk_window_set_title (GTK_WINDOW (window2), "Decrypt file");
 gtk_container_border_width (GTK_CONTAINER (window2), 2);
 gtk_widget_set_uposition (window2, (x_pos+100), (y_pos+100));
 gtk_widget_set_usize (window2, 400, 150);

 vbox = gtk_vbox_new (FALSE, 0);
 gtk_container_add (GTK_CONTAINER (window2), vbox);
 gtk_container_border_width (GTK_CONTAINER (window2), 5);
 gtk_widget_show (vbox);
 
 label = gtk_label_new ("Decrypt file (see Help for info)\nEnter one-word key to use (8-100 chars):");
 gtk_box_pack_start (GTK_BOX (vbox), label, TRUE, TRUE, 0);
 gtk_widget_show (label);
 
 entry_box = gtk_entry_new ();
 gtk_editable_select_region (GTK_EDITABLE (entry_box), 0, -1);
 gtk_box_pack_start (GTK_BOX (vbox), entry_box, TRUE, TRUE, 0);
 gtk_widget_show (entry_box);

 cbitems = g_list_append(cbitems, "DES weak encryption (/bin/des)");
 cbitems = g_list_append(cbitems, "IDEA medium/strong encryption (/bin/idea)");

 eb11 = gtk_combo_new ();
 gtk_combo_set_popdown_strings (GTK_COMBO (eb11), cbitems);
 gtk_entry_set_text (GTK_ENTRY (GTK_COMBO(eb11)->entry), "DES weak encryption (/bin/des)");
 gtk_box_pack_start (GTK_BOX (vbox), eb11, TRUE, TRUE, 0);
 gtk_widget_show (eb11);

 button = gtk_button_new_with_label ("OK");
 gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
  GTK_SIGNAL_FUNC(CB_decrypt_1), GTK_OBJECT (window2));
 gtk_box_pack_start (GTK_BOX (vbox), button, TRUE, TRUE, 0);
 GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
 gtk_widget_grab_default (button);
 gtk_widget_show (button);
 gtk_widget_show (window2);
}

void CB_bookmarks_add(GtkWidget *widget, GtkWidget *entry)
{
 int i=1;
 if(!strcasecmp(filename,"Unknown filename")) return;
 sprintf(temp, "%s/.gxedit.bookmarks", home);
 fd = fopen(temp, "r");
 if(fd!=NULL)
 {
  while(fgets(line, 500, fd)!=NULL)
  {
   if(atoi(lindex(line,1))<(i+1)) i = (atoi(lindex(line,1))+1);
  }
  fclose(fd);
 }
 fd = fopen(temp, "a");
 if(fd==NULL)
 {
  print_debug("Can't open bookmarks file\n");
  return;
 }
 fputs(filename, fd);
 sprintf(temp, "%d", i);
 fputs(" ", fd);
 fputs(temp, fd);
 fputs(" ;\n", fd);
 fclose(fd);
 menuitem = gtk_menu_item_new_with_label(filename);
 gtk_menu_append(GTK_MENU(BMmenu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
 GTK_SIGNAL_FUNC(CB_bookmarks), (gpointer)i);
 gtk_widget_show(menuitem);
}

void CB_bookmarks_del(GtkWidget *widget, GtkWidget *entry)
{
 sprintf(temp, "%s/.gxedit.bookmarks", home);
 fd = fopen(temp, "r");
 strncpy(tmp_name, tempnam(NULL,".gxe"), 50);
 fd2 = fopen(tmp_name, "w");
 if(fd==NULL && fd2==NULL)
 {
  print_debug("Can't open bookmarks file or temp file\n");
  return;
 }
 while(fgets(line, 500, fd)!=NULL)
 {
  if(strcasecmp(lindex(line,0),filename)) fputs(line, fd2);
 }
 fclose(fd);
 fclose(fd2);
 sprintf(temp, "cp %s %s/.gxedit.bookmarks", tmp_name, home);
 system(temp);
}

void CB_application(GtkWidget *blah, gint type)
{
 sprintf(temp, "%s/.gxedit.applications", home);
 fd = fopen(temp, "r");
 while(fgets(line, 512, fd)!=NULL)
 {
  if(!strcasecmp(lindex(line,0),"application:") && atoi(lindex(line,1))==type)
  {
   sprintf(temp, "%s &", lindex(line,4));
   system(temp);
  }
 }
 if(fd!=NULL) fclose(fd);
}

void CB_msgbox_close(GtkWidget *widget, GtkWidget *entry)
{
#ifdef USE_GNOME
 if(wingnome!=NULL) gtk_widget_destroy(wingnome);
 wingnome = NULL;
#endif
 if(window2!=NULL) gtk_widget_destroy(window2);
 window2 = NULL;
}

void CB_find_case(GtkWidget *widget, GtkWidget *entry)
{
 s = GTK_TOGGLE_BUTTON(widget)->active;
}

void CB_find_start(GtkWidget *widget, GtkWidget *entry)
{
 ss = GTK_TOGGLE_BUTTON(widget)->active;
}

void CB_filters_ok(GtkWidget *widget, GtkFileSelection *fs)
{
 int i;
 char buf[50];
 strncpy(buf, gtk_file_selection_get_filename(GTK_FILE_SELECTION(fs)), 50);
 strncpy(tmp_name, tempnam(NULL,".gxe"), 50);
 sprintf(temp, "%s/.gxedit", home);
 fd = fopen(temp, "r");
 if(fd==NULL)
 {
  print_debug("Can't open config file\n");
  return;
 }
 while(fgets(line, 512, fd)!=NULL)
 {
  line[strlen(line)-1]=' ';
  if(!strcasecmp(lindex(line,0),"filter:") && atoi(lindex(line,1))==s)
  {
   bzero(temp, 1024);
   for(i=2;lindex(line,i)!=NULL;i++)
   {
    if(!strcasecmp(lindex(line,i),"$i")) strcat(temp, buf);
    else if(!strcasecmp(lindex(line,i),"$o")) strcat(temp, tmp_name);
    else strcat(temp, lindex(line,i));
    strcat(temp, " ");
   }
   system(temp);
  }
 }
 open_file(tmp_name, "Can't open temp file\n");
 gtk_widget_destroy(window2);
}

void CB_filters(gint type, GtkWidget *entry)
{
 if(window2!=NULL)
 {   
  gtk_widget_destroy(window2);
 }
 window2 = gtk_file_selection_new ("Open file");
 gtk_signal_connect (GTK_OBJECT (window2), "destroy",
  GTK_SIGNAL_FUNC(CB_open_cancel), &window2);
 gtk_signal_connect (GTK_OBJECT (window2), "delete_event",
  GTK_SIGNAL_FUNC(CB_open_cancel), &window2);
 s = type;
 gtk_signal_connect (GTK_OBJECT(GTK_FILE_SELECTION(window2)->ok_button),
  "clicked", GTK_SIGNAL_FUNC(CB_filters_ok), window2);
 gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(window2)->cancel_button),
  "clicked", GTK_SIGNAL_FUNC(CB_open_cancel), &window2);
 gtk_widget_set_uposition (window2, (x_pos+50), (y_pos+50));
 gtk_widget_show (window2);
}

void CB_macros(gint type, GtkWidget *entry)
{
 CB_save_undo();
 sprintf(temp, "%s/.gxedit", home);
 strncpy(tmp_name, tempnam(NULL,".gxe"), 50);
 strncpy(tmp_name2, tempnam(NULL,".gxe"), 50);
 fd = fopen(tmp_name, "w");
 fputs((char *)gtk_editable_get_chars(GTK_EDITABLE (text), 0, gtk_text_get_length(GTK_TEXT(text))),fd);
 fclose(fd);
 fd = fopen(temp, "r");
 while(fgets(line, 512, fd)!=NULL)
 {
  if(!strcasecmp(lindex(line,0),"macro:") && atoi(lindex(line,1))==type)
  {
   sprintf(temp, "awk '%s' %s > %s", lrange(line,2), tmp_name, tmp_name2);
   system(temp);
  }
  if(!strcasecmp(lindex(line,0),"awk_macro:") && atoi(lindex(line,1))==type)
  {
   sprintf(temp, "awk '%s' %s > %s", lrange(line,2), tmp_name, tmp_name2);
   system(temp);
  }
  if(!strcasecmp(lindex(line,0),"sed_macro:") && atoi(lindex(line,1))==type)
  {
   sprintf(temp, "sed '%s' %s > %s", lrange(line,2), tmp_name, tmp_name2);
   system(temp);
  }
 }
 if(fd!=NULL) fclose(fd);
 open_file(tmp_name2, "Can't open temp file\n");
}

void CB_indent_ok(GtkWidget *widget, GtkWidget *entry)
{
 indent = atoi(gtk_entry_get_text(GTK_ENTRY(entry_box)));
 gtk_widget_destroy(window2);
}

void CB_indent_plus(GtkWidget *widget, gpointer data)
{
 indent++;
}

void CB_indent_minus(GtkWidget *widget, gpointer data)
{
 indent--;
}

void CB_indent(GtkWidget *widget, gpointer data)
{
 if(window2!=NULL)
 {
  gtk_widget_destroy(window2);
 }
 window2 = gtk_window_new (GTK_WINDOW_TOPLEVEL);
 gtk_signal_connect (GTK_OBJECT (window2), "destroy",
  GTK_SIGNAL_FUNC(CB_msgbox_close), &window2);
 gtk_signal_connect (GTK_OBJECT (window2), "delete_event",
  GTK_SIGNAL_FUNC(CB_msgbox_close), &window2);
 gtk_window_set_title (GTK_WINDOW (window2), "Set indent");
 gtk_container_border_width (GTK_CONTAINER (window2), 2);
 gtk_widget_set_uposition (window2, (x_pos+100), (y_pos+100));
  
 vbox = gtk_vbox_new (FALSE, 0);
 gtk_container_add (GTK_CONTAINER (window2), vbox);
 gtk_container_border_width (GTK_CONTAINER (window2), 5);
 gtk_widget_show (vbox);

 label = gtk_label_new ("Level of indent:");
 gtk_box_pack_start (GTK_BOX (vbox), label, TRUE, TRUE, 0);
 gtk_widget_show (label);
 
 entry_box = gtk_entry_new ();
 gtk_editable_select_region (GTK_EDITABLE (entry_box), 0, -1);
 gtk_box_pack_start (GTK_BOX (vbox), entry_box, TRUE, TRUE, 0);
 sprintf(temp, "%d", indent);
 gtk_entry_set_text (GTK_ENTRY (entry_box), temp);
 gtk_widget_show (entry_box);

 button = gtk_button_new_with_label ("OK");
 gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
  GTK_SIGNAL_FUNC(CB_indent_ok), NULL);
 gtk_box_pack_start (GTK_BOX (vbox), button, TRUE, TRUE, 0);
 GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
 gtk_widget_grab_default (button);
 gtk_widget_show (button);
 gtk_widget_show (window2);
}

/* damn thing was the hardest thing to do. Thanks to Evan for figuring
 the adjustment functions which had 0 documentation in the GTK lib */

void CB_find_again(GtkWidget *widget, gpointer data)
{
 int i, j, string_len, text_len, begin_at, result, line_number=0, line_total=0;
 char buf[512];
 gtk_text_freeze(GTK_TEXT(text));
 text_len = gtk_text_get_length(GTK_TEXT(text));
 string_len = strlen(search_string);
 begin_at = gtk_text_get_point(GTK_TEXT(text))+string_len;
 for(i=0;i<(text_len-string_len);i++)   
 {
  if(*gtk_editable_get_chars(GTK_EDITABLE(text), i, i+1)=='\n') line_number++;
  strncpy(buf,gtk_editable_get_chars(GTK_EDITABLE(text), i, i+string_len),50);
  if(s==0) result = strcasecmp(buf, search_string);
  else result = strcmp(buf, search_string);
  if(i>begin_at && result==0)
  {
   for(j=0;j<(text_len-string_len);j++)
   {
    if(*gtk_editable_get_chars(GTK_EDITABLE(text), j, j+1)=='\n') line_total++;
   }
   gtk_text_thaw(GTK_TEXT(text));   
   if(i>100)
   gtk_adjustment_set_value(GTK_ADJUSTMENT(GTK_TEXT(text)->vadj), ((line_number * GTK_ADJUSTMENT(GTK_TEXT(text)->vadj)->upper) / line_total - GTK_ADJUSTMENT(GTK_TEXT(text)->vadj)->page_increment));
   gtk_editable_insert_text(GTK_EDITABLE(text), " ", 1, &i);
   gtk_editable_delete_text(GTK_EDITABLE(text), i-1, i);
   gtk_text_set_point(GTK_TEXT(text), i+string_len-1);
   gtk_editable_select_region(GTK_EDITABLE(text), i-1, i+string_len-1);
   break;
  }
 }
 gtk_text_thaw(GTK_TEXT(text));
}  

void CB_say_file_ok(GtkWidget *widget, GtkFileSelection *fs)
{
 fd = fopen(gtk_file_selection_get_filename(GTK_FILE_SELECTION(fs)),"r");
 if(fd==NULL)
 {
  print_debug("Can't open file for reading\n");
  return;
 }
 while(fgets(line, 512, fd)!=NULL)
 {
  sprintf(temp, "say \"%s\"", line);
  system(temp);
 }
 fclose(fd);
 gtk_widget_destroy(window2);
}

void CB_say_file(GtkWidget *widget, GtkWidget *entry)
{
 if(window2!=NULL)
 {   
  gtk_widget_destroy(window2);
 }
 s = 0;
 fd = fopen("say", "r");
 if(fd!=NULL) { s = 1; fclose(fd); }
 fd = fopen("/usr/bin/say", "r");
 if(fd!=NULL) { s = 1; fclose(fd); }
 if(s==0)
 {
  msgbox("I could not find the 'say' program in /usr/bin. Please make sure you typed 'make say' in the\nGXedit source tree before using this command.\n");
  return;
 }
 window2 = gtk_file_selection_new ("Open file");
 gtk_signal_connect (GTK_OBJECT (window2), "destroy",
  GTK_SIGNAL_FUNC(CB_msgbox_close), &window2);
 gtk_signal_connect (GTK_OBJECT (window2), "delete_event",
  GTK_SIGNAL_FUNC(CB_msgbox_close), &window2);
 gtk_signal_connect (GTK_OBJECT(GTK_FILE_SELECTION(window2)->ok_button),
  "clicked", GTK_SIGNAL_FUNC(CB_say_file_ok), window2);
 gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(window2)->cancel_button),
  "clicked", GTK_SIGNAL_FUNC(CB_msgbox_close), &window2);
 gtk_widget_set_uposition (window2, (x_pos+50), (y_pos+50));
 gtk_widget_show (window2);
}

void CB_say_current(GtkWidget *widget, GtkWidget *entry)
{
 s = 0;
 fd = fopen("say", "r");
 if(fd!=NULL) { s = 1; fclose(fd); }
 fd = fopen("/usr/bin/say", "r");
 if(fd!=NULL) { s = 1; fclose(fd); }
 if(s==0)
 {
  msgbox("I could not find the 'say' program in /usr/bin. Please make sure you typed 'make say' in the\nGXedit source tree before using this command.\n");
  return;
 }
 strncpy(tmp_name, tempnam(NULL,".gxe"), 50); 
 fd=fopen(tmp_name, "w");
 if(fd==NULL)
 {
  print_debug("Can't open temporary file\n");
  return;
 }
 fputs((char *)gtk_editable_get_chars(GTK_EDITABLE (text), 0, gtk_text_get_length(GTK_TEXT(text))), fd);
 if(fd!=NULL) fclose(fd);
 fd = fopen(tmp_name, "r");
 if(fd==NULL)
 {
  print_debug("Can't open file for reading\n");
  return;
 }
 while(fgets(line, 512, fd)!=NULL)
 {
  sprintf(temp, "say \"%s\"", line);
  system(temp);
 }
 fclose(fd);
}

void CB_goto_ok(GtkWidget *widget, GtkWidget *entry)
{
 int i, cl=0, tl=0, text_len;
 gtk_text_freeze(GTK_TEXT(text));
 text_len = gtk_text_get_length(GTK_TEXT(text));
 if(atoi(gtk_entry_get_text(GTK_ENTRY(entry_box)))>(text_len-1)) return;
 for(i=0;i<text_len;i++)
 {
  if(*gtk_editable_get_chars(GTK_EDITABLE(text), i, i+1)=='\n') tl++;
 }
 for(i=0;i<text_len;i++)
 {
  if(*gtk_editable_get_chars(GTK_EDITABLE(text), i, i+1)=='\n') cl++;
  if(cl==atoi(gtk_entry_get_text(GTK_ENTRY(entry_box)))) break;
 }
 gtk_text_thaw(GTK_TEXT(text));
 gtk_adjustment_set_value(GTK_ADJUSTMENT(GTK_TEXT(text)->vadj), ((cl * GTK_ADJUSTMENT(GTK_TEXT(text)->vadj)->upper) / tl - GTK_ADJUSTMENT(GTK_TEXT(text)->vadj)->page_increment));
 gtk_editable_insert_text(GTK_EDITABLE(text), " ", 1, &i);
 gtk_editable_delete_text(GTK_EDITABLE(text), i-1, i);
 gtk_text_set_point(GTK_TEXT(text), i);
 gtk_editable_select_region(GTK_EDITABLE(text), i-1, i+1);
 gtk_widget_destroy(window2);
}

void CB_goto(GtkWidget *widget, GtkWidget *entry)  
{
 if(window2!=NULL)
 { 
  gtk_widget_destroy(window2);
 }
 window2 = gtk_window_new (GTK_WINDOW_TOPLEVEL);
 gtk_signal_connect (GTK_OBJECT (window2), "destroy",
  GTK_SIGNAL_FUNC(CB_open_cancel), &window2);
 gtk_signal_connect (GTK_OBJECT (window2), "delete_event",
  GTK_SIGNAL_FUNC(CB_open_cancel), &window2);
 gtk_window_set_title (GTK_WINDOW (window2), "Go to");
 gtk_container_border_width (GTK_CONTAINER (window2), 2);
 gtk_widget_set_uposition (window2, (x_pos+100), (y_pos+100));
   
 vbox = gtk_vbox_new (FALSE, 0);
 gtk_container_add (GTK_CONTAINER (window2), vbox);
 gtk_container_border_width (GTK_CONTAINER (window2), 5);
 gtk_widget_show (vbox);
  
 label = gtk_label_new ("Enter the line number you want to go to:");
 gtk_box_pack_start (GTK_BOX (vbox), label, TRUE, TRUE, 0);
 gtk_widget_show (label);
 
 entry_box = gtk_entry_new ();
 gtk_editable_select_region (GTK_EDITABLE (entry_box), 0, -1);
 gtk_box_pack_start (GTK_BOX (vbox), entry_box, TRUE, TRUE, 0);
 gtk_widget_show (entry_box);
 
 button = gtk_button_new_with_label ("OK");
 gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
  GTK_SIGNAL_FUNC(CB_goto_ok), GTK_OBJECT (window2));
 gtk_box_pack_start (GTK_BOX (vbox), button, TRUE, TRUE, 0);
 GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
 gtk_widget_grab_default (button);
 gtk_widget_show (button);
 gtk_widget_show (window2);
}

void CB_find_ok(GtkWidget *widget, GtkWidget *entry)
{
 int i, j, string_len, text_len, begin_at, result, line_number=0, line_total=0;
 char buf[512];
 strncpy(search_string,gtk_entry_get_text(GTK_ENTRY(entry_box)),50);
 gtk_text_freeze(GTK_TEXT(text));
 text_len = gtk_text_get_length(GTK_TEXT(text));
 string_len = strlen(search_string);
 begin_at = gtk_text_get_point(GTK_TEXT(text));
 if(ss==1) begin_at = 0;
 if(begin_at==text_len) begin_at = 1;
 for(i=0;i<(text_len-string_len);i++)
 {
  if(*gtk_editable_get_chars(GTK_EDITABLE(text), i, i+1)=='\n') line_number++;
  strncpy(buf,gtk_editable_get_chars(GTK_EDITABLE(text), i, i+string_len),50);
  if(s==0) result = strcasecmp(buf, search_string);
  else result = strcmp(buf, search_string);
  if(i>begin_at && result==0)
  {
   for(j=0;j<(text_len-string_len);j++)
   {
    if(*gtk_editable_get_chars(GTK_EDITABLE(text), j, j+1)=='\n') line_total++;
   }
   gtk_text_thaw(GTK_TEXT(text));
   if(i>100)
   gtk_adjustment_set_value(GTK_ADJUSTMENT(GTK_TEXT(text)->vadj), ((line_number * GTK_ADJUSTMENT(GTK_TEXT(text)->vadj)->upper) / line_total - GTK_ADJUSTMENT(GTK_TEXT(text)->vadj)->page_increment));
   gtk_editable_insert_text(GTK_EDITABLE(text), " ", 1, &i);
   gtk_editable_delete_text(GTK_EDITABLE(text), i-1, i);
   gtk_text_set_point(GTK_TEXT(text), i+string_len-1);
   gtk_editable_select_region(GTK_EDITABLE(text), i-1, i+string_len-1);
   break;
  }
 }
 gtk_text_thaw(GTK_TEXT(text));
 gtk_widget_destroy(window2);
}

void CB_find(GtkWidget *widget, gpointer data)
{
 s = 0;
 if(window2!=NULL)
 {
  gtk_widget_destroy(window2);
 }
 window2 = gtk_window_new (GTK_WINDOW_TOPLEVEL);
 gtk_signal_connect (GTK_OBJECT (window2), "destroy",
  GTK_SIGNAL_FUNC(CB_msgbox_close), &window2);
 gtk_signal_connect (GTK_OBJECT (window2), "delete_event",
  GTK_SIGNAL_FUNC(CB_msgbox_close), &window2);     
 gtk_window_set_title (GTK_WINDOW (window2), "Find");
 gtk_container_border_width (GTK_CONTAINER (window2), 2);
 gtk_widget_set_uposition (window2, (x_pos+100), (y_pos+100));
  
 vbox = gtk_vbox_new (FALSE, 0);
 gtk_container_add (GTK_CONTAINER (window2), vbox);
 gtk_container_border_width (GTK_CONTAINER (window2), 5);
 gtk_widget_show (vbox);
  
 label = gtk_label_new ("Enter a string to look for:");
 gtk_box_pack_start (GTK_BOX (vbox), label, TRUE, TRUE, 0);
 gtk_widget_show (label);
 
 entry_box = gtk_entry_new ();
 gtk_editable_select_region (GTK_EDITABLE (entry_box), 0, -1);
 gtk_box_pack_start (GTK_BOX (vbox), entry_box, TRUE, TRUE, 0);
 if(search_string!=NULL) gtk_entry_set_text (GTK_ENTRY (entry_box), search_string);
 gtk_widget_show (entry_box);

 cb1 = gtk_check_button_new_with_label("Case sensitive");
 gtk_signal_connect (GTK_OBJECT(cb1), "toggled",
  GTK_SIGNAL_FUNC(CB_find_case), cb1);
 gtk_box_pack_start (GTK_BOX (vbox), cb1, TRUE, TRUE, 0);
 gtk_widget_show (cb1);

 ss = 0;
 cb1 = gtk_check_button_new_with_label("Search from start");
 gtk_signal_connect (GTK_OBJECT(cb1), "toggled",
  GTK_SIGNAL_FUNC(CB_find_start), cb1);
 gtk_box_pack_start (GTK_BOX (vbox), cb1, TRUE, TRUE, 0);
 gtk_widget_show (cb1);
 
 button = gtk_button_new_with_label ("OK");
 gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
  GTK_SIGNAL_FUNC(CB_find_ok), NULL);
 gtk_box_pack_start (GTK_BOX (vbox), button, TRUE, TRUE, 0);
 GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
 gtk_widget_grab_default (button);
 gtk_widget_show (button);
 gtk_widget_show (window2);
}

void CB_man(gint what, GtkWidget *entry)
{
 gtk_text_freeze(GTK_TEXT(text));
 if(what==0)
 {
  gtk_text_insert (GTK_TEXT (text), NULL, &html, NULL, "\n.TH MYPROGRAM 1\n", -1);
  gtk_text_insert (GTK_TEXT (text), NULL, &html, NULL, ".SH NAME\n\n", -1);
  gtk_text_insert (GTK_TEXT (text), NULL, &color, NULL, "MyProg \\- Does nothing yet\n", -1);
 }
 if(what==1)
 {
  gtk_text_insert (GTK_TEXT (text), NULL, &html, NULL, "\n.\\\" ", -1);
  gtk_text_insert (GTK_TEXT (text), NULL, &color, NULL, "This is a comment\n", -1);
 }
 if(what==2)
 {
  gtk_text_insert (GTK_TEXT (text), NULL, &html, NULL, ".SH SYNOPSIS\n.B ", -1);
  gtk_text_insert (GTK_TEXT (text), NULL, &color, NULL, "MyProg [\\-n] [\\-p] [\\-s] [\\-l] [\\-k]\n", -1);
 }
 if(what==3)
 {
  gtk_text_insert (GTK_TEXT (text), NULL, &html, NULL, ".SH DESCRIPTION\n.BR ", -1);
  gtk_text_insert (GTK_TEXT (text), NULL, &color, NULL, "MyProg\nis an example that does nothing yet.\n", -1);
 }
 if(what==4)
 {
  gtk_text_insert (GTK_TEXT (text), NULL, &html, NULL, ".SH OPTIONS\n.TP\n.I ", -1);
  gtk_text_insert (GTK_TEXT (text), NULL, &color, NULL, "\"\\-v\"\nSets on verbose mode.\n", -1);
  gtk_text_insert (GTK_TEXT (text), NULL, &html, NULL, ".TP\n.I ", -1);
  gtk_text_insert (GTK_TEXT (text), NULL, &color, NULL, "\"\\-n\"\nSets on the no-mode switch.\n", -1);
 }
 gtk_text_thaw(GTK_TEXT(text));
}

void CB_insert_note_ok(GtkWidget *widget, GtkWidget *entry)
{
 sprintf(temp, "%s.gxnote", filename);
 fd = fopen(temp, "w");
 if(fd==NULL)
 {
  msgbox("Can't open file to add note");
  gtk_widget_destroy(window2);
  return;
 }
 fputs(gtk_entry_get_text(GTK_ENTRY(entry_box)), fd);
 fclose(fd);
 gtk_widget_destroy(window2);
}

void CB_insert_note(GtkWidget *widget, GtkWidget *entry)
{
 if(window2!=NULL)
 {
  gtk_widget_destroy(window2);
 }
 window2 = gtk_window_new (GTK_WINDOW_TOPLEVEL);
 gtk_signal_connect (GTK_OBJECT (window2), "destroy",
  GTK_SIGNAL_FUNC(CB_open_cancel), &window2);
 gtk_signal_connect (GTK_OBJECT (window2), "delete_event",
  GTK_SIGNAL_FUNC(CB_open_cancel), &window2);
 gtk_window_set_title (GTK_WINDOW (window2), "Note");
 gtk_container_border_width (GTK_CONTAINER (window2), 2);
 gtk_widget_set_uposition (window2, (x_pos+100), (y_pos+100));

 vbox = gtk_vbox_new (FALSE, 0);
 gtk_container_add (GTK_CONTAINER (window2), vbox);
 gtk_container_border_width (GTK_CONTAINER (window2), 5);
 gtk_widget_show (vbox);

 label = gtk_label_new ("Enter a note for this file:");
 gtk_box_pack_start (GTK_BOX (vbox), label, TRUE, TRUE, 0);
 gtk_widget_show (label);

 entry_box = gtk_entry_new ();
 gtk_editable_select_region (GTK_EDITABLE (entry_box), 0, -1);
 gtk_box_pack_start (GTK_BOX (vbox), entry_box, TRUE, TRUE, 0);
 gtk_widget_show (entry_box);

 button = gtk_button_new_with_label ("OK");
 gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
  GTK_SIGNAL_FUNC(CB_insert_note_ok), GTK_OBJECT (window2));
 gtk_box_pack_start (GTK_BOX (vbox), button, TRUE, TRUE, 0);
 GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
 gtk_widget_grab_default (button);
 gtk_widget_show (button);
 gtk_widget_show (window2);
}

void CB_insert(gint what, GtkWidget *entry)
{
 time_t lt;
 lt = time(NULL);
 gtk_text_freeze(GTK_TEXT(text));
 if(what==0) gtk_text_insert (GTK_TEXT (text), NULL, &color, NULL, ctime(&lt), -1);
 if(what==1)
 {
  sprintf(temp,"UID=%d GID=%d EUID=%d EGID=%d", getuid(), getgid(), geteuid(), getegid());
  gtk_text_insert (GTK_TEXT (text), NULL, &color, NULL, temp, -1);
 }
 if(what==2)
 {
  sprintf(temp, "%s/.signature", home);
  fd = fopen(temp, "r");
  if(fd!=NULL)
  {
   while(fgets(line, 255, fd)!=NULL)
   gtk_text_insert (GTK_TEXT (text), NULL, &color, NULL, line, -1);
   fclose(fd);
  }
 }
 gtk_text_thaw(GTK_TEXT(text));
}

void CB_HTML_styles(GtkWidget *widget, GtkWidget *entry)
{
 if(window2!=NULL)
 {
  gtk_widget_destroy(window2);
 }
 window2 = gtk_window_new (GTK_WINDOW_TOPLEVEL); 
 gtk_signal_connect (GTK_OBJECT (window2), "destroy",
  GTK_SIGNAL_FUNC(CB_msgbox_close), &window2);
 gtk_signal_connect (GTK_OBJECT (window2), "delete_event",
  GTK_SIGNAL_FUNC(CB_msgbox_close), &window2);
 gtk_window_set_title (GTK_WINDOW (window2), "HTML text styles");
 gtk_container_border_width (GTK_CONTAINER (window2), 2);
 gtk_widget_set_uposition (window2, (x_pos+100), (y_pos+100));

 vbox = gtk_vbox_new (FALSE, 0);
 gtk_container_add (GTK_CONTAINER (window2), vbox);
 gtk_container_border_width (GTK_CONTAINER (window2), 5);
 gtk_widget_show (vbox);

 button = gtk_button_new_with_label ("Bold");
 gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
  GTK_SIGNAL_FUNC(CB_HTML), (gpointer) 8);
 gtk_box_pack_start (GTK_BOX (vbox), button, TRUE, TRUE, 0);
 gtk_widget_show (button);

 button = gtk_button_new_with_label ("Italic");                 
 gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
  GTK_SIGNAL_FUNC(CB_HTML), (gpointer) 9);
 gtk_box_pack_start (GTK_BOX (vbox), button, TRUE, TRUE, 0);
 gtk_widget_show (button);

 button = gtk_button_new_with_label ("Underline");                 
 gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
  GTK_SIGNAL_FUNC(CB_HTML), (gpointer) 11);
 gtk_box_pack_start (GTK_BOX (vbox), button, TRUE, TRUE, 0);
 gtk_widget_show (button);

 button = gtk_button_new_with_label ("Superscript");                 
 gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
  GTK_SIGNAL_FUNC(CB_HTML), (gpointer) 12);
 gtk_box_pack_start (GTK_BOX (vbox), button, TRUE, TRUE, 0);
 gtk_widget_show (button);

 button = gtk_button_new_with_label ("Subscript");                 
 gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
  GTK_SIGNAL_FUNC(CB_HTML), (gpointer) 13);
 gtk_box_pack_start (GTK_BOX (vbox), button, TRUE, TRUE, 0);
 gtk_widget_show (button);

 gtk_widget_show (window2);
}

void CB_HTML_ok(GtkWidget *widget, GtkWidget *entry)
{
 int what = ss;
 gtk_text_freeze(GTK_TEXT(text));
 if(what==0)
 {
  gtk_text_insert (GTK_TEXT (text), NULL, &html, NULL, "\n<HTML><HEAD><TITLE>", -1);
  gtk_text_insert (GTK_TEXT (text), NULL, &color, NULL, gtk_entry_get_text(GTK_ENTRY(entry_box)), -1);
  gtk_text_insert (GTK_TEXT (text), NULL, &html, NULL, "</TITLE></HEAD>\n<BODY BGCOLOR=#FFFFFF TEXT=#000000>", -1);
  gtk_text_insert (GTK_TEXT (text), NULL, &color, NULL, "\n", -1);
 }
 if(what==1)
 {
  gtk_text_insert (GTK_TEXT (text), NULL, &html, NULL, "\n<FONT SIZE=+", -1);
  gtk_text_insert (GTK_TEXT (text), NULL, &color, NULL, "1", -1);
  gtk_text_insert (GTK_TEXT (text), NULL, &html, NULL, " FACE=", -1);
  gtk_text_insert (GTK_TEXT (text), NULL, &color, NULL, gtk_entry_get_text(GTK_ENTRY(entry_box)), -1);
  gtk_text_insert (GTK_TEXT (text), NULL, &html, NULL, ">", -1);
  gtk_text_insert (GTK_TEXT (text), NULL, &color, NULL, "\n\n", -1);
  gtk_text_insert (GTK_TEXT (text), NULL, &html, NULL, "</FONT>", -1);
  gtk_text_insert (GTK_TEXT (text), NULL, &color, NULL, "\n", -1);
 }
 if(what==2)
 {
  gtk_text_insert (GTK_TEXT (text), NULL, &html, NULL, "<CENTER>", -1);
  gtk_text_insert (GTK_TEXT (text), NULL, &color, NULL, gtk_entry_get_text(GTK_ENTRY(entry_box)), -1);
  gtk_text_insert (GTK_TEXT (text), NULL, &html, NULL, "</CENTER>", -1);
  gtk_text_insert (GTK_TEXT (text), NULL, &color, NULL, "\n", -1);
 }
 if(what==3)
 {
  gtk_text_insert (GTK_TEXT (text), NULL, &html, NULL, "<HR WIDTH=", -1);
  gtk_text_insert (GTK_TEXT (text), NULL, &color, NULL, gtk_entry_get_text(GTK_ENTRY(entry_box)), -1);
  gtk_text_insert (GTK_TEXT (text), NULL, &html, NULL, ">", -1);
 }
 if(what==4)
 {
  gtk_text_insert (GTK_TEXT (text), NULL, &html, NULL, "<TABLE BORDER=", -1);
  gtk_text_insert (GTK_TEXT (text), NULL, &color, NULL, "0", -1);
  gtk_text_insert (GTK_TEXT (text), NULL, &html, NULL, "><TR><TD>", -1);
  gtk_text_insert (GTK_TEXT (text), NULL, &color, NULL, gtk_entry_get_text(GTK_ENTRY(entry_box)), -1);
  gtk_text_insert (GTK_TEXT (text), NULL, &html, NULL, "</TD></TR></TABLE>", -1);
  gtk_text_insert (GTK_TEXT (text), NULL, &color, NULL, "\n", -1);
 }
 if(what==5)
 {
  gtk_text_insert (GTK_TEXT (text), NULL, &html, NULL, "<IMG SRC=\"", -1); 
  gtk_text_insert (GTK_TEXT (text), NULL, &color, NULL, gtk_entry_get_text(GTK_ENTRY(entry_box)), -1);
  gtk_text_insert (GTK_TEXT (text), NULL, &html, NULL, "\" ALT=\"", -1);
  gtk_text_insert (GTK_TEXT (text), NULL, &color, NULL, "An image", -1);
  gtk_text_insert (GTK_TEXT (text), NULL, &html, NULL, "\">", -1);
  gtk_text_insert (GTK_TEXT (text), NULL, &color, NULL, "\n", -1);
 }
 if(what==6)
 {
  gtk_text_insert (GTK_TEXT (text), NULL, &html, NULL, "<A HREF=\"", -1);
  gtk_text_insert (GTK_TEXT (text), NULL, &color, NULL, gtk_entry_get_text(GTK_ENTRY(entry_box)), -1);
  gtk_text_insert (GTK_TEXT (text), NULL, &html, NULL, "\">", -1);
  gtk_text_insert (GTK_TEXT (text), NULL, &color, NULL, "Click here\n\n", -1);
  gtk_text_insert (GTK_TEXT (text), NULL, &html, NULL, "</A>", -1);
  gtk_text_insert (GTK_TEXT (text), NULL, &color, NULL, "\n", -1);
 }
 if(what==7)
 {
  gtk_text_insert (GTK_TEXT (text), NULL, &color, NULL, gtk_entry_get_text(GTK_ENTRY(entry_box)), -1);
  gtk_text_insert (GTK_TEXT (text), NULL, &html, NULL, "<BR>", -1);
  gtk_text_insert (GTK_TEXT (text), NULL, &color, NULL, "\n", -1);
 }
 if(what==8)
 {
  gtk_text_insert (GTK_TEXT (text), NULL, &html, NULL, "<B>", -1);  
  gtk_text_insert (GTK_TEXT (text), NULL, &color, NULL, gtk_entry_get_text(GTK_ENTRY(entry_box)), -1);
  gtk_text_insert (GTK_TEXT (text), NULL, &html, NULL, "</B>", -1);  
  gtk_text_insert (GTK_TEXT (text), NULL, &color, NULL, "\n", -1);  
 }
 if(what==9)
 {
  gtk_text_insert (GTK_TEXT (text), NULL, &html, NULL, "<I>", -1);  
  gtk_text_insert (GTK_TEXT (text), NULL, &color, NULL,
  gtk_entry_get_text(GTK_ENTRY(entry_box)), -1);
  gtk_text_insert (GTK_TEXT (text), NULL, &html, NULL, "</I>", -1);  
  gtk_text_insert (GTK_TEXT (text), NULL, &color, NULL, "\n", -1);  
 }
 if(what==10)
 {
  gtk_text_insert (GTK_TEXT (text), NULL, &html, NULL, "<LI>", -1);  
  gtk_text_insert (GTK_TEXT (text), NULL, &color, NULL, gtk_entry_get_text(GTK_ENTRY(entry_box)), -1);  
  gtk_text_insert (GTK_TEXT (text), NULL, &color, NULL, "\n", -1);
 }
 if(what==11)
 {
  gtk_text_insert (GTK_TEXT (text), NULL, &html, NULL, "<U>", -1);
  gtk_text_insert (GTK_TEXT (text), NULL, &color, NULL,
  gtk_entry_get_text(GTK_ENTRY(entry_box)), -1);
  gtk_text_insert (GTK_TEXT (text), NULL, &html, NULL, "</U>", -1);
  gtk_text_insert (GTK_TEXT (text), NULL, &color, NULL, "\n", -1);
 }
 if(what==12)
 {
  gtk_text_insert (GTK_TEXT (text), NULL, &html, NULL, "<SUP>", -1);
  gtk_text_insert (GTK_TEXT (text), NULL, &color, NULL,
  gtk_entry_get_text(GTK_ENTRY(entry_box)), -1);
  gtk_text_insert (GTK_TEXT (text), NULL, &html, NULL, "</SUP>", -1);
  gtk_text_insert (GTK_TEXT (text), NULL, &color, NULL, "\n", -1);
 }
 if(what==13)
 {
  gtk_text_insert (GTK_TEXT (text), NULL, &html, NULL, "<SUB>", -1);
  gtk_text_insert (GTK_TEXT (text), NULL, &color, NULL,
  gtk_entry_get_text(GTK_ENTRY(entry_box)), -1);
  gtk_text_insert (GTK_TEXT (text), NULL, &html, NULL, "</SUB>", -1);
  gtk_text_insert (GTK_TEXT (text), NULL, &color, NULL, "\n", -1);
 }
 gtk_text_thaw(GTK_TEXT(text));
 if(window2!=NULL) gtk_widget_destroy(window2);
}

/* all this because GTK cant pass numbers to fcts from toolbars */
void CB_HTML_0(GtkWidget *widget, GtkWidget *entry)
{
 CB_HTML(0, NULL);
}

void CB_HTML_1(GtkWidget *widget, GtkWidget *entry)
{
 CB_HTML(1, NULL);
}

void CB_HTML_2(GtkWidget *widget, GtkWidget *entry)
{
 CB_HTML(2, NULL);
}

void CB_HTML_3(GtkWidget *widget, GtkWidget *entry)
{
 CB_HTML(3, NULL);
}

void CB_HTML_4(GtkWidget *widget, GtkWidget *entry)
{
 CB_HTML(4, NULL);
}

void CB_HTML_5(GtkWidget *widget, GtkWidget *entry)
{
 CB_HTML(5, NULL);
}

void CB_HTML_6(GtkWidget *widget, GtkWidget *entry)
{
 CB_HTML(6, NULL);
}

void CB_HTML_7(GtkWidget *widget, GtkWidget *entry)
{
 CB_HTML(7, NULL);
}

void CB_HTML_8(GtkWidget *widget, GtkWidget *entry)
{
 CB_HTML(8, NULL);
}

void CB_HTML_9(GtkWidget *widget, GtkWidget *entry)
{
 CB_HTML(9, NULL);
}

void CB_HTML_10(GtkWidget *widget, GtkWidget *entry)
{
 CB_HTML(10, NULL);
}

void CB_HTML(int what, GtkWidget *entry)
{
 ss = what;
 if(window2!=NULL)
 {
  gtk_widget_destroy(window2);
 }
 window2 = gtk_window_new (GTK_WINDOW_TOPLEVEL);
 gtk_signal_connect (GTK_OBJECT (window2), "destroy",
  GTK_SIGNAL_FUNC(CB_msgbox_close), &window2);
 gtk_signal_connect (GTK_OBJECT (window2), "delete_event",
  GTK_SIGNAL_FUNC(CB_msgbox_close), &window2);
 gtk_window_set_title (GTK_WINDOW (window2), "HTML tag adding");
 gtk_container_border_width (GTK_CONTAINER (window2), 2);
 gtk_widget_set_uposition (window2, (x_pos+100), (y_pos+100));
  
 vbox = gtk_vbox_new (FALSE, 0);
 gtk_container_add (GTK_CONTAINER (window2), vbox);
 gtk_container_border_width (GTK_CONTAINER (window2), 5);
 gtk_widget_show (vbox);

 if(what==0) label = gtk_label_new ("Header\nTitle:");
 if(what==1) label = gtk_label_new ("Font\nFont face:");
 if(what==2) label = gtk_label_new ("Center\nCentered text:");
 if(what==3) label = gtk_label_new ("Horizontal line\nLine width:");
 if(what==4) label = gtk_label_new ("Table\nSample text:");
 if(what==5) label = gtk_label_new ("Image\nURL:");
 if(what==6) label = gtk_label_new ("Link\nURL:");
 if(what==7) label = gtk_label_new ("Line break\nLine of text:");
 if(what==8) label = gtk_label_new ("Bold\nLine of text:");
 if(what==9) label = gtk_label_new ("Italic\nLine of text:");
 if(what==10) label = gtk_label_new ("List item\nLine of text:");
 if(what==11) label = gtk_label_new ("Underline\nLine of text:");
 if(what==12) label = gtk_label_new ("Superscript\nLine of text:");
 if(what==13) label = gtk_label_new ("Subscript\nLine of text:");
 gtk_box_pack_start (GTK_BOX (vbox), label, TRUE, TRUE, 0);
 gtk_widget_show (label);
 
 entry_box = gtk_entry_new ();
 gtk_editable_select_region (GTK_EDITABLE (entry_box), 0, -1);
 gtk_box_pack_start (GTK_BOX (vbox), entry_box, TRUE, TRUE, 0);
 gtk_widget_show (entry_box);

 button = gtk_button_new_with_label ("OK");
 gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
  GTK_SIGNAL_FUNC(CB_HTML_ok), NULL);
 gtk_box_pack_start (GTK_BOX (vbox), button, TRUE, TRUE, 0);
 GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
 gtk_widget_grab_default (button);
 gtk_widget_show (button);
 gtk_widget_show (window2);
}

void CB_reply(GtkWidget *widget, GtkWidget *entry)
{
 strncpy(tmp_name, tempnam(NULL,".gxe"), 50);
 fd=fopen(tmp_name, "w");
 if(fd==NULL)
 {
  print_debug("Can't open temporary file\n");
  return;
 }
 fputs((char *)gtk_editable_get_chars(GTK_EDITABLE (text), 0, gtk_text_get_length(GTK_TEXT(text))),fd);
 if(fd!=NULL) fclose(fd);
 gtk_text_set_point(GTK_TEXT(text), 0);
 gtk_text_forward_delete(GTK_TEXT(text),gtk_text_get_length(GTK_TEXT(text)));
 gtk_text_freeze(GTK_TEXT(text));
 fd = fopen(tmp_name, "r");
 while(fgets(line, 512, fd)!=NULL)
 {
  sprintf(temp, "> %s", line);
  gtk_text_insert (GTK_TEXT (text), NULL, &color, NULL, temp, -1);
 }
 fclose(fd);
 sprintf(temp, "%s/.signature", home);
 fd = fopen(temp, "r");
 if(fd!=NULL)
 {
  while(fgets(line, 512, fd)!=NULL)   
  gtk_text_insert (GTK_TEXT (text), NULL, &color, NULL, line, -1);
  fclose(fd);
 }
 gtk_text_thaw(GTK_TEXT(text));
}

void CB_grep_ok2(GtkWidget *widget, GtkFileSelection *fs)
{
 strncpy(tmp_name, tempnam(NULL,".gxe"), 50);
 sprintf(temp, "grep \"%s\" %s* > %s", line, gtk_file_selection_get_filename(GTK_FILE_SELECTION(fs)), tmp_name);
 system(temp);
 gtk_widget_destroy(window2);
 open_file(tmp_name, "Can't open temp file\n");
}

void CB_grep_ok(GtkWidget *widget, GtkWidget *entry)
{
 strncpy(line, gtk_entry_get_text(GTK_ENTRY(entry_box)), 500);
 gtk_widget_destroy(window2);
 window2 = gtk_file_selection_new ("Select directory or filter");
 gtk_signal_connect (GTK_OBJECT (window2), "destroy",
  GTK_SIGNAL_FUNC(CB_open_cancel), &window2);
 gtk_signal_connect (GTK_OBJECT (window2), "delete_event",
  GTK_SIGNAL_FUNC(CB_open_cancel), &window2);
 gtk_signal_connect (GTK_OBJECT(GTK_FILE_SELECTION(window2)->ok_button),
  "clicked", GTK_SIGNAL_FUNC(CB_grep_ok2), window2);
 gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(window2)->cancel_button),
  "clicked", GTK_SIGNAL_FUNC(CB_open_cancel), &window2);
 gtk_widget_set_uposition (window2, (x_pos+50), (y_pos+50));
 gtk_widget_show (window2);
}

void CB_grep(GtkWidget *widget, GtkWidget *entry)
{
 if(window2!=NULL)
 {
  gtk_widget_destroy(window2);
 }
 window2 = gtk_window_new (GTK_WINDOW_TOPLEVEL);
 gtk_signal_connect (GTK_OBJECT (window2), "destroy",
  GTK_SIGNAL_FUNC(CB_open_cancel), &window2);
 gtk_signal_connect (GTK_OBJECT (window2), "delete_event",
  GTK_SIGNAL_FUNC(CB_open_cancel), &window2);
 gtk_window_set_title (GTK_WINDOW (window2), "Search in a dir");
 gtk_container_border_width (GTK_CONTAINER (window2), 2);
 gtk_widget_set_uposition (window2, (x_pos+100), (y_pos+100));
  
 vbox = gtk_vbox_new (FALSE, 0);
 gtk_container_add (GTK_CONTAINER (window2), vbox);
 gtk_container_border_width (GTK_CONTAINER (window2), 5);
 gtk_widget_show (vbox);

 label = gtk_label_new ("Simple string to search for:");
 gtk_box_pack_start (GTK_BOX (vbox), label, TRUE, TRUE, 0);
 gtk_widget_show (label);
 
 entry_box = gtk_entry_new ();
 gtk_editable_select_region (GTK_EDITABLE (entry_box), 0, -1);
 gtk_box_pack_start (GTK_BOX (vbox), entry_box, TRUE, TRUE, 0);
 gtk_widget_show (entry_box);
 
 button = gtk_button_new_with_label ("OK");
 gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
  GTK_SIGNAL_FUNC(CB_grep_ok), GTK_OBJECT (window2));
 gtk_box_pack_start (GTK_BOX (vbox), button, TRUE, TRUE, 0);
 GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
 gtk_widget_grab_default (button);
 gtk_widget_show (button);
 gtk_widget_show (window2);
}

void CB_files_xfm(GtkWidget *widget, GtkWidget *entry)
{
 sprintf(temp, "%s &", xfm);
 system(temp);
}

void CB_awk_callbacks(gint type, GtkWidget *entry)
{
 CB_save_undo();
 strncpy(tmp_name, tempnam(NULL,".gxe"), 50);
 strncpy(tmp_name2, tempnam(NULL,".gxe"), 50);
 fd = fopen(tmp_name, "w");
 if(fd==NULL)
 {
  msgbox("Can't open temporary file");
  return;
 }
 fputs((char *)gtk_editable_get_chars(GTK_EDITABLE (text), 0, gtk_text_get_length(GTK_TEXT(text))),fd);
 if(fd!=NULL) fclose(fd);
 if(type==0)
 sprintf(line, "awk %s '%s' %s > %s",gtk_entry_get_text(GTK_ENTRY(eb1)),gtk_entry_get_text(GTK_ENTRY(entry_box)),tmp_name,tmp_name2);
 else
 sprintf(line, "sed %s '%s' %s > %s",gtk_entry_get_text(GTK_ENTRY(eb1)),gtk_entry_get_text(GTK_ENTRY(entry_box)),tmp_name,tmp_name2);
 system(line);
 open_file(tmp_name2, "Can't open temp file\n");
 gtk_widget_destroy(window2);
}

void CB_mirror_server(GtkWidget *widget, GtkWidget *entry)
{
 mirr_serv = 1;
 fd = fopen("/tmp/.gxedit.mirror-server", "w");
 if(fd!=NULL) fclose(fd);
 sprintf(temp, "%s -server &", progname);
 system(temp);
}

void CB_mirror_client_loop(int sockfd, GtkWidget *entry)
{
#ifdef USE_NET
 gtk_timeout_remove(mirr_timeout);
 strncpy(tmp_name, tempnam(NULL,".gxe"), 50);
 mirror_listen(tmp_name);
 gtk_text_set_point(GTK_TEXT(text), 0);
 gtk_text_forward_delete(GTK_TEXT(text),
 gtk_text_get_length(GTK_TEXT(text)));
 fd = fopen(tmp_name, "r");
 gtk_text_freeze(GTK_TEXT(text));
 while(fgets(line, 512, fd)!=NULL)
 gtk_text_insert (GTK_TEXT (text), NULL, &color, NULL, line, -1);
 gtk_text_thaw(GTK_TEXT(text));
 if(fd!=NULL) fclose(fd);
 if(mirr_cl)
 mirr_timeout=gtk_timeout_add(1000, (GtkFunction)CB_mirror_client_loop, (gpointer)0);
#endif
}

void CB_mirror_close(GtkWidget *widget, GtkWidget *entry)
{
 mirr_cl = 0;
 gtk_timeout_remove(mirr_timeout);
}

void CB_mirror_client(GtkWidget *widget, GtkWidget *entry)
{
#ifdef USE_NET
 mirr_cl = 0;
 mirror_init();
 sprintf(line, "GXedit %s - MIRROR CLIENT\n", VERSION);
 gtk_window_set_title (GTK_WINDOW (window), line);
 mirr_timeout=gtk_timeout_add(1000, (GtkFunction)CB_mirror_client_loop, (gpointer)0);
#endif
}

void CB_autosave(GtkWidget *widget, GtkWidget *entry)
{
 int i, j, len;
 len = strlen(gtk_editable_get_chars(GTK_EDITABLE(text), 0, gtk_text_get_length(GTK_TEXT(text))));
 if(page_width>0)
 {
  if(GTK_TEXT(text)->cursor_pos_x > page_width) gtk_text_insert (GTK_TEXT (text), NULL, &color, NULL, "\n", -1);
 }
 if(auto_indent)
 {
  if(*(gtk_editable_get_chars(GTK_EDITABLE (text), 0, gtk_text_get_length(GTK_TEXT(text)))+len-1)=='{')
  indent++;
  if(*(gtk_editable_get_chars(GTK_EDITABLE (text), 0, gtk_text_get_length(GTK_TEXT(text)))+len-1)=='}')
  indent--;
 }
 if(indent && *(gtk_editable_get_chars(GTK_EDITABLE (text), 0, gtk_text_get_length(GTK_TEXT(text)))+len-1)=='\n')
 {
  for(i=0;i<indent;i++)
  {
   j = gtk_text_get_point(GTK_TEXT(text));
   gtk_editable_insert_text(GTK_EDITABLE(text), "\t", 1, &j);
  }
 }
 if(autosave)
 {
  sprintf(temp, "%s/.gxedit.autosave", home);
  fd = fopen(temp, "w");
  fputs((char *)gtk_editable_get_chars(GTK_EDITABLE (text), 0, gtk_text_get_length(GTK_TEXT(text))),fd);
  fclose(fd);
 }
 if(mirr_serv)
 {
  fd = fopen("/tmp/.gxedit.mirror-server", "w");
  fputs((char *)gtk_editable_get_chars(GTK_EDITABLE (text), 0, gtk_text_get_length(GTK_TEXT(text))), fd);
  fclose(fd);
 }
 if(original==-1)
 {
  original = time(NULL);
  letters_count = 0;
  words_count = 0;
  print_debug("We're started!\n");
 }
 if(original>1)
 {
  if((time(NULL) - original)==30) print_debug("Still 30 secs to go!\n");
  if((time(NULL) - original) > 59)
  {
   sprintf(temp, "You typed %d words (%d letters) in %ld seconds\n", words_count, letters_count, (time(NULL) - original));
   msgbox(temp);
   print_debug(temp);
   original = 0;
  }
  else
  {
   letters_count++;
   if(*(gtk_editable_get_chars(GTK_EDITABLE (text), 0, gtk_text_get_length(GTK_TEXT(text)))+len-1)=='\n') words_count++;
   if(*(gtk_editable_get_chars(GTK_EDITABLE (text), 0, gtk_text_get_length(GTK_TEXT(text)))+len-1)==' ') words_count++;
  }
 }
 if(!modified) modified = 1;
}

void CB_awk(GtkWidget *widget, gpointer data)
{
 if(window2!=NULL)
 {
  gtk_widget_destroy(window2);
 }
 window2 = gtk_window_new (GTK_WINDOW_TOPLEVEL);
 gtk_signal_connect (GTK_OBJECT (window2), "destroy",
  GTK_SIGNAL_FUNC(CB_msgbox_close), &window2);
 gtk_signal_connect (GTK_OBJECT (window2), "delete_event",
  GTK_SIGNAL_FUNC(CB_msgbox_close), &window2);
 gtk_window_set_title (GTK_WINDOW (window2), "Scripting");
 gtk_container_border_width (GTK_CONTAINER (window2), 2);
 gtk_widget_set_uposition (window2, (x_pos+100), (y_pos+100));

 vbox = gtk_vbox_new (FALSE, 0);
 gtk_container_add (GTK_CONTAINER (window2), vbox);
 gtk_container_border_width (GTK_CONTAINER (window2), 5);
 gtk_widget_show (vbox);

 label = gtk_label_new ("Enter a command line:");
 gtk_box_pack_start (GTK_BOX (vbox), label, TRUE, TRUE, 0);
 gtk_widget_show (label);

 entry_box = gtk_entry_new ();
 gtk_editable_select_region (GTK_EDITABLE (entry_box), 0, -1);
 gtk_box_pack_start (GTK_BOX (vbox), entry_box, TRUE, TRUE, 0);
 gtk_widget_show (entry_box);

 label = gtk_label_new ("Optional flags:");
 gtk_box_pack_start (GTK_BOX (vbox), label, TRUE, TRUE, 0);
 gtk_widget_show (label);
 
 eb1 = gtk_entry_new ();
 gtk_editable_select_region (GTK_EDITABLE (eb1), 0, -1);
 gtk_box_pack_start (GTK_BOX (vbox), eb1, TRUE, TRUE, 0);
 gtk_widget_show (eb1);
 
 button = gtk_button_new_with_label ("Awk command");
 gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
  GTK_SIGNAL_FUNC(CB_awk_callbacks), (gpointer) 0);
 gtk_box_pack_start (GTK_BOX (vbox), button, TRUE, TRUE, 0);
 gtk_widget_show (button);

 button = gtk_button_new_with_label ("Sed command");
 gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
  GTK_SIGNAL_FUNC(CB_awk_callbacks), (gpointer) 1);
 gtk_box_pack_start (GTK_BOX (vbox), button, TRUE, TRUE, 0);
 gtk_widget_show (button);

 gtk_widget_show (window2);
}

void msgbox(char *string)
{
 if(window2!=NULL)
 {
  gtk_widget_destroy(window2);
 }
#ifdef USE_GNOME
 wingnome = gnome_dialog_new("GXedit", GNOME_STOCK_BUTTON_OK, NULL);
 gtk_widget_set_usize (GTK_WIDGET (wingnome), strlen(string)+400, 130);
 gtk_widget_set_uposition (wingnome, (x_pos+50), (y_pos+50));
 gtk_container_border_width (GTK_CONTAINER (wingnome), 0);   
 gtk_widget_show(wingnome);

 gnome_dialog_button_connect(GNOME_DIALOG(wingnome), 0,
 GTK_SIGNAL_FUNC(CB_msgbox_close), NULL);

 label = gtk_label_new (string);
 gtk_box_pack_start (GTK_BOX (GNOME_DIALOG (wingnome)->vbox),
  label, TRUE, TRUE, 0);
 gtk_widget_show (label);
#else
 window2 = gtk_dialog_new ();
 gtk_widget_set_usize (GTK_WIDGET (window2), strlen(string)+400, 120);
 gtk_signal_connect (GTK_OBJECT (window2), "destroy",
  GTK_SIGNAL_FUNC(CB_msgbox_close), &window2);
 gtk_signal_connect (GTK_OBJECT (window2), "delete_event",
  GTK_SIGNAL_FUNC(CB_msgbox_close), &window2);
 gtk_window_set_title (GTK_WINDOW (window2), "GXedit");
 gtk_container_border_width (GTK_CONTAINER (window2), 0);
 gtk_widget_set_uposition (window2, (x_pos+50), (y_pos+50));
 
 label = gtk_label_new (string);
 gtk_box_pack_start (GTK_BOX (GTK_DIALOG (window2)->vbox),
  label, TRUE, TRUE, 0);
 gtk_widget_show (label);

 button = gtk_button_new_with_label ("OK");
 gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
  GTK_SIGNAL_FUNC(CB_msgbox_close), GTK_OBJECT (window2));
 gtk_box_pack_start (GTK_BOX (GTK_DIALOG (window2)->action_area),
  button, TRUE, TRUE, 0);
 GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
 gtk_widget_grab_default (button);
 gtk_widget_show (button);
 gtk_widget_show (window2);
#endif
}

void CB_new_gxedit(GtkWidget *widget, GtkWidget *entry)
{
 sprintf(line, "%s &", progname);
 system(line);
}

void CB_close_debug(GtkWidget *widget, GtkWidget *entry)
{
 debug = 0;
 gtk_widget_destroy(dw);
}

void CB_open_cancel(GtkWidget *widget, GtkFileSelection *fs)
{
 gtk_widget_destroy(window2);
 window2 = NULL;
}

void CB_open_last(gint type, GtkWidget *entry)
{
 sprintf(filename, "%s/.gxedit.last", home);
 open_file(filename, "History file is empty\n");
 sprintf(line, "GXedit %s - %s\n", VERSION, filename);
 gtk_window_set_title (GTK_WINDOW (window), line);
}

void CB_bytes_count(GtkWidget *widget, gpointer data)
{
 sprintf(line, "Number of bytes:  %d", gtk_text_get_length(GTK_TEXT(text)));
 msgbox(line);
}

void CB_words_count(GtkWidget *widget, gpointer data)
{
 int i;
 strncpy(tmp_name, tempnam(NULL,".gxe"), 50);
 strncpy(tmp_name2, tempnam(NULL,".gxe"), 50);
 fd = fopen(tmp_name, "w");
 if(fd==NULL)
 {
  msgbox("Can't open temporary file");
  return;
 }
 fputs((char *)gtk_editable_get_chars(GTK_EDITABLE (text), 0, gtk_text_get_length(GTK_TEXT(text))),fd);
 if(fd!=NULL) fclose(fd);
 sprintf(temp, "cat %s |wc -l > %s", tmp_name, tmp_name2);
 system(temp);
 fd = fopen(tmp_name2, "r");
 fgets(line,255,fd);
 for(i=0;lindex(gtk_editable_get_chars(GTK_EDITABLE (text), 0, gtk_text_get_length(GTK_TEXT(text))),i)!=NULL;i++) { }
 sprintf(global_var, "Number of words:  %d", (i+atoi(line)));
 msgbox(global_var);
}

void CB_lines_count(GtkWidget *widget, gpointer data)
{
 strncpy(tmp_name, tempnam(NULL,".gxe"), 50);
 strncpy(tmp_name2, tempnam(NULL,".gxe"), 50);
 fd = fopen(tmp_name, "w");
 if(fd==NULL)
 {
  msgbox("Can't open temporary file");
  return;
 }
 fputs((char *)gtk_editable_get_chars(GTK_EDITABLE (text), 0, gtk_text_get_length(GTK_TEXT(text))),fd);
 if(fd!=NULL) fclose(fd);
 sprintf(temp, "cat %s |wc -l > %s", tmp_name, tmp_name2);
 system(temp);
 fd = fopen(tmp_name2, "r");
 fgets(line,255,fd);
 line[strlen(line)-1]=' ';
 sprintf(global_var, "Number of lines: %s", line);
 msgbox(global_var);
}

void CB_copy(GtkWidget *widget, gpointer data)
{
#ifdef GTK_1_1
 gtk_editable_copy_clipboard (GTK_EDITABLE(text));
#else
 gtk_editable_copy_clipboard (GTK_EDITABLE(text), TS);
#endif
}

void CB_paste(GtkWidget *widget, gpointer data)
{
#ifdef GTK_1_1
 gtk_editable_paste_clipboard (GTK_EDITABLE(text));
#else
 gtk_editable_paste_clipboard (GTK_EDITABLE(text), TS);
#endif
}

void CB_files_ok(GtkWidget *widget, GtkFileSelection *fs) 
{
 strncpy(tmp_name, tempnam(NULL,".gxe"), 50);
 strcat(line, " ");
 strncat(line,gtk_file_selection_get_filename(GTK_FILE_SELECTION(fs)),255);
 gtk_widget_destroy(window2);
 if(s==0) sprintf(temp, "diff %s > %s", line, tmp_name);
 if(s==1) sprintf(temp, "cat %s %s > %s", lindex(line,0), lindex(line,1), tmp_name);
 if(s==2) sprintf(temp, "sort %s %s > %s", lindex(line,0), lindex(line,1), tmp_name);
 system(temp);
 open_file(tmp_name, "Can't open temp file\n");
}

void CB_files_2(GtkWidget *widget, GtkFileSelection *fs)
{
 strncpy(line,gtk_file_selection_get_filename(GTK_FILE_SELECTION(fs)),255);
 gtk_widget_destroy(window2);
 window2 = gtk_file_selection_new ("Second file");
 gtk_signal_connect (GTK_OBJECT (window2), "destroy",
  GTK_SIGNAL_FUNC(CB_open_cancel), &window2);
 gtk_signal_connect (GTK_OBJECT (window2), "delete_event",
  GTK_SIGNAL_FUNC(CB_open_cancel), &window2);
 gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(window2)->ok_button),
  "clicked", GTK_SIGNAL_FUNC(CB_files_ok), window2);
 gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(window2)->cancel_button),
  "clicked", GTK_SIGNAL_FUNC(CB_open_cancel), &window2);
 gtk_widget_set_uposition (window2, (x_pos+50), (y_pos+50));
 gtk_widget_show (window2);
}

void CB_files_1(gint type, GtkWidget *entry)
{
 s = type;
 strcpy(temp, "");
 if(window2!=NULL)
 {   
  gtk_widget_destroy(window2);
 }
 window2 = gtk_file_selection_new ("First file");
 gtk_signal_connect (GTK_OBJECT (window2), "destroy",
  GTK_SIGNAL_FUNC(CB_open_cancel), &window2);
 gtk_signal_connect (GTK_OBJECT (window2), "delete_event",
  GTK_SIGNAL_FUNC(CB_open_cancel), &window2);
 gtk_signal_connect (GTK_OBJECT(GTK_FILE_SELECTION(window2)->ok_button),
  "clicked", GTK_SIGNAL_FUNC(CB_files_2), window2);
 gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(window2)->cancel_button),
  "clicked", GTK_SIGNAL_FUNC(CB_open_cancel), &window2);
 gtk_widget_set_uposition (window2, (x_pos+50), (y_pos+50));
 gtk_widget_show (window2);
}

void CB_ispell_ok(GtkWidget *widget, GtkWidget *entry)
{
 CB_save_undo();
 open_file(tmp_name, "Can't open temp file\n");
 gtk_widget_destroy(window2);
}

void CB_spell(GtkWidget *widget, gpointer data)
{
 strncpy(tmp_name, tempnam(NULL,".gxe"), 50);
 fd = fopen(tmp_name, "w");
 if(fd==NULL)
 {
  msgbox("Can't open temporary file");
  return;
 }
 fputs((char *)gtk_editable_get_chars(GTK_EDITABLE (text), 0, gtk_text_get_length(GTK_TEXT(text))),fd);
 if(fd!=NULL) fclose(fd);
 sprintf(temp, "xterm -e ispell -d %s %s &", dict, tmp_name);
 system(temp);
 if(window2!=NULL)
 {
  gtk_widget_destroy(window2);
 }
 window2 = gtk_dialog_new ();
 gtk_widget_set_usize (GTK_WIDGET (window2), 400, 100);
 gtk_signal_connect (GTK_OBJECT (window2), "destroy",
  GTK_SIGNAL_FUNC(CB_msgbox_close), &window2);
 gtk_signal_connect (GTK_OBJECT (window2), "delete_event",
  GTK_SIGNAL_FUNC(CB_msgbox_close), &window2);
 gtk_window_set_title (GTK_WINDOW (window2), "GXedit");
 gtk_container_border_width (GTK_CONTAINER (window2), 0);
 gtk_widget_set_uposition (window2, (x_pos+50), (y_pos+50));
  
 label = gtk_label_new ("Press OK when your correction is done.");
 gtk_box_pack_start (GTK_BOX (GTK_DIALOG (window2)->vbox),
  label, TRUE, TRUE, 0);
 gtk_widget_show (label);
  
 button = gtk_button_new_with_label ("OK");
 gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
  GTK_SIGNAL_FUNC(CB_ispell_ok), GTK_OBJECT (window2));
 gtk_box_pack_start (GTK_BOX (GTK_DIALOG (window2)->action_area),
  button, TRUE, TRUE, 0);
 GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
 gtk_widget_grab_default (button);
 gtk_widget_show (button);
 gtk_widget_show (window2);
}

void CB_settings_save(GtkWidget *widget, GtkWidget *entry)
{
 sprintf(line, "%s/.gxedit", home);
 fd = fopen(line, "w");
 if(fd==NULL) print_debug("Can't open config file\n");
 x_size = atoi(gtk_entry_get_text(GTK_ENTRY(eb1)));
 y_size = atoi(gtk_entry_get_text(GTK_ENTRY(eb2)));
 x_pos = atoi(gtk_entry_get_text(GTK_ENTRY(eb3)));
 y_pos = atoi(gtk_entry_get_text(GTK_ENTRY(eb4)));
 page_width = atoi(gtk_entry_get_text(GTK_ENTRY(eb21)));
 strcpy(col_name, gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(eb5)->entry)));
 strcpy(images, gtk_entry_get_text(GTK_ENTRY(eb6)));
 strcpy(xfm, gtk_entry_get_text(GTK_ENTRY(eb15)));
 strcpy(compile, gtk_entry_get_text(GTK_ENTRY(eb22)));
 strcpy(gzip, gtk_entry_get_text(GTK_ENTRY(eb17)));
 strcpy(doc_dir, gtk_entry_get_text(GTK_ENTRY(eb20)));
 strcpy(dict, gtk_entry_get_text(GTK_ENTRY(eb16)));
 strcpy(mail_server, gtk_entry_get_text(GTK_ENTRY(eb7)));
 strcpy(mail_from, gtk_entry_get_text(GTK_ENTRY(eb8)));
 strcpy(default_news, gtk_entry_get_text(GTK_ENTRY(eb18)));
 strcpy(default_web, gtk_entry_get_text(GTK_ENTRY(eb19)));
 strcpy(mirror_remote, gtk_entry_get_text(GTK_ENTRY(eb14)));
#ifdef GTKEDITOR_PATCH
 if(!strcmp(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(eb23)->entry)),"HTML style"))
 { syntax_h = 1; h_style = 1; }
 else if(!strcmp(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(eb23)->entry)),"C style"))
 { syntax_h = 1; h_style = 2; } 
 else  if(!strcmp(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(eb23)->entry)),"Perl style"))
 { syntax_h = 1; h_style = 3; }
 else  if(!strcmp(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(eb23)->entry)),"Java style"))
 { syntax_h = 1; h_style = 4; }
 else { syntax_h = 0; h_style = 0; }
#else
 syntax_h = 0;
 h_style = 0;
#endif
#ifndef GTK_1_1
 sprintf(font, "%s", gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(eb11)->entry)));
#endif
 strcpy(bg_pixmap, gtk_entry_get_text(GTK_ENTRY(eb12)));
 strcpy(bg, gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(eb13)->entry)));
#ifdef USE_NET
 if(!nonet) strcpy(mail_ip, (char *)resolve(mail_server));
 else strcpy(mail_ip, "127.0.0.1");
 strcpy(news_server, gtk_entry_get_text(GTK_ENTRY(eb10)));
 if(!nonet) strcpy(news_ip, (char *)resolve(news_server));
 else strcpy(news_ip, "127.0.0.1");
#endif
 strcpy(login, gtk_entry_get_text(GTK_ENTRY(eb9)));
 fputs("# This is the configuration file for GXedit\n", fd);
 sprintf(line, "line_wrap: %d\n", line_wrap);
 fputs(line, fd);
 sprintf(line, "toolbar: %d\n", toolbar);
 fputs(line, fd);
 sprintf(line, "tooltips: %d\n", tooltips);
 fputs(line, fd);
 sprintf(line, "debug: %d\n", debug);
 fputs(line, fd);
 sprintf(line, "x_size: %d\n", x_size);
 fputs(line, fd);
 sprintf(line, "y_size: %d\n", y_size);
 fputs(line, fd);
 sprintf(line, "full_toolbar: %d\n", full_tb);
 fputs(line, fd);
 sprintf(line, "netbar: %d\n", netbar);
 fputs(line, fd);
 sprintf(line, "htmlbar: %d\n", htmlbar);
 fputs(line, fd);
 sprintf(line, "syntax_h: %d\n", syntax_h);
 fputs(line, fd);
 sprintf(line, "h_style: %d\n", h_style);
 fputs(line, fd);
 sprintf(line, "fortune: %d\n", fortune);
 fputs(line, fd);
 sprintf(line, "old_open: %d\n", old_open);
 fputs(line, fd);
 sprintf(line, "scrollbar_location: %d\n", scroll_loc);
 fputs(line, fd);
 sprintf(line, "use_socks: %d\n", use_socks);
 fputs(line, fd);
 sprintf(line, "auto_indent: %d\n", auto_indent);
 fputs(line, fd);
 sprintf(line, "mail_cmd: %d\n", mail_cmd);
 fputs(line, fd);
 sprintf(line, "access: %d\n", access_opt);
 fputs(line, fd);
 sprintf(line, "audio: %d\n", audio);
 fputs(line, fd);
 sprintf(line, "x_position: %d\n", x_pos);
 fputs(line, fd);
 sprintf(line, "y_position: %d\n", y_pos);
 fputs(line, fd);
 sprintf(line, "autosave: %d\n", autosave);
 fputs(line, fd);
 sprintf(line, "page_width: %d\n", page_width);
 fputs(line, fd);
 sprintf(line, "toolbar_icons: %d\n", icons);
 fputs(line, fd);
 sprintf(line, "xfm: %s\n", xfm);
 fputs(line, fd);
 sprintf(line, "compile: %s\n", compile);
 fputs(line, fd);
 sprintf(line, "gzip: %s\n", gzip);
 fputs(line, fd);
 sprintf(line, "document_dir: %s\n", doc_dir);
 fputs(line, fd);
 sprintf(line, "dictionary: %s\n", dict);
 fputs(line, fd);
 sprintf(line, "color: %s\n", col_name);
 fputs(line, fd);
 sprintf(line, "images: %s\n", images);
 fputs(line, fd);
 sprintf(line, "mail_server: %s\n", mail_server);
 fputs(line, fd);
 sprintf(line, "mail_address: %s\n", mail_from);
 fputs(line, fd);
 sprintf(line, "mail_reply: %d\n", reply);  
 fputs(line, fd);
 sprintf(line, "default_news: %s\n", default_news);
 fputs(line, fd);
 sprintf(line, "default_web: %s\n", default_web);
 fputs(line, fd);
 sprintf(line, "mirror_server: %s\n", mirror_remote);
 fputs(line, fd);
 sprintf(line, "login_name: %s\n", login);
 fputs(line, fd);
 sprintf(line, "news_server: %s\n", news_server);
 fputs(line, fd);
 sprintf(line, "font: %s\n", font);
 fputs(line, fd);
 sprintf(line, "pixmap: %s\n", bg_pixmap);
 fputs(line, fd);
 sprintf(line, "background: %s\n", bg);
 fputs(line, fd);
 fputs((char *)gtk_editable_get_chars(GTK_EDITABLE (text2), 0, gtk_text_get_length(GTK_TEXT(text2))),fd);
 fputs((char *)gtk_editable_get_chars(GTK_EDITABLE (text3), 0, gtk_text_get_length(GTK_TEXT(text3))),fd);
 if(fd!=NULL) fclose(fd);
 gtk_widget_destroy(window2);
 window2 = NULL;
}

void CB_settings_icons(GtkWidget *widget, GtkWidget *entry)
{
 icons = GTK_TOGGLE_BUTTON(widget)->active;
}

void CB_settings_toolbar(GtkWidget *widget, GtkWidget *entry)
{
 toolbar = GTK_TOGGLE_BUTTON(widget)->active;
}

void CB_settings_reply(GtkWidget *widget, GtkWidget *entry)
{
 reply = GTK_TOGGLE_BUTTON(widget)->active;
}

void CB_settings_wrap(GtkWidget *widget, GtkWidget *entry)
{
 line_wrap = GTK_TOGGLE_BUTTON(widget)->active;
}

void CB_settings_autosave(GtkWidget *widget, GtkWidget *entry)
{   
 autosave = GTK_TOGGLE_BUTTON(widget)->active;
}

void CB_settings_toolbar_full(GtkWidget *widget, GtkWidget *entry)
{
 full_tb = GTK_TOGGLE_BUTTON(widget)->active;
}

void CB_settings_netbar(GtkWidget *widget, GtkWidget *entry)
{
 netbar = GTK_TOGGLE_BUTTON(widget)->active; 
}

void CB_settings_htmlbar(GtkWidget *widget, GtkWidget *entry)
{
 htmlbar = GTK_TOGGLE_BUTTON(widget)->active;
}

void CB_settings_fortune(GtkWidget *widget, GtkWidget *entry)
{
 fortune = GTK_TOGGLE_BUTTON(widget)->active;
}

void CB_settings_old_open(GtkWidget *widget, GtkWidget *entry)
{
 old_open = GTK_TOGGLE_BUTTON(widget)->active;
}

void CB_settings_scroll_loc(GtkWidget *widget, GtkWidget *entry)
{
 scroll_loc = GTK_TOGGLE_BUTTON(widget)->active;
}

void CB_settings_use_socks(GtkWidget *widget, GtkWidget *entry)
{
 use_socks = GTK_TOGGLE_BUTTON(widget)->active;
}

void CB_settings_auto_indent(GtkWidget *widget, GtkWidget *entry)
{
 auto_indent = GTK_TOGGLE_BUTTON(widget)->active;
}

void CB_settings_mail_cmd(GtkWidget *widget, GtkWidget *entry)
{
 mail_cmd = GTK_TOGGLE_BUTTON(widget)->active;
}

void CB_settings_access(GtkWidget *widget, GtkWidget *entry)
{
 access_opt = GTK_TOGGLE_BUTTON(widget)->active;
}

void CB_settings_audio(GtkWidget *widget, GtkWidget *entry)
{
 audio = GTK_TOGGLE_BUTTON(widget)->active;
}

void CB_settings_debug(GtkWidget *widget, GtkWidget *entry)
{
 debug = GTK_TOGGLE_BUTTON(widget)->active;
}

void CB_settings_tooltips(GtkWidget *widget, GtkWidget *entry)
{
 tooltips = GTK_TOGGLE_BUTTON(widget)->active;   
}

void CB_settings_rc(GtkWidget *widget, GtkWidget *entry)
{
 sprintf(temp, "%s %s/.gxeditrc &", progname, home);
 system(temp);
}

void CB_settings_bookm(GtkWidget *widget, GtkWidget *entry)
{
 sprintf(temp, "%s %s/.gxedit.bookmarks &", progname, home);
 system(temp);
}

void CB_settings_apps(GtkWidget *widget, GtkWidget *entry)
{
 sprintf(temp, "%s %s/.gxedit.applications &", progname, home);
 system(temp);
}

void CB_settings(GtkWidget *widget, gpointer data)
{
 GList *cbitems = NULL;
 if(window2!=NULL)
 {
  gtk_widget_destroy(window2);
 }
 window2 = gtk_window_new (GTK_WINDOW_TOPLEVEL);
 gtk_signal_connect (GTK_OBJECT (window2), "destroy",
  GTK_SIGNAL_FUNC(CB_open_cancel), &window2);
 gtk_signal_connect (GTK_OBJECT (window2), "delete_event",
  GTK_SIGNAL_FUNC(CB_open_cancel), &window2);
 gtk_window_set_title (GTK_WINDOW (window2), "Settings");
 gtk_container_border_width (GTK_CONTAINER (window2), 2);
 gtk_widget_set_uposition (window2, (x_pos+10), (y_pos+10));
 gtk_widget_set_usize (window2, 400, 500);

 vbox2 = gtk_vbox_new (FALSE, 0);
 gtk_container_add (GTK_CONTAINER (window2), vbox2);
 gtk_container_border_width (GTK_CONTAINER (vbox2), 5);
 gtk_widget_show (vbox2);
 
 notebook = gtk_notebook_new ();
 gtk_notebook_set_tab_pos (GTK_NOTEBOOK (notebook), GTK_POS_TOP);
 gtk_box_pack_start (GTK_BOX (vbox2), notebook, TRUE, TRUE, 0);
 gtk_widget_show (notebook);

 frame = gtk_frame_new ("General and display options");
 gtk_container_border_width (GTK_CONTAINER (frame), 10);
 gtk_widget_show (frame);
 
 label = gtk_label_new ("Display");
 gtk_notebook_append_page (GTK_NOTEBOOK (notebook), frame, label);

 vbox = gtk_vbox_new (FALSE, 0);
 gtk_container_add (GTK_CONTAINER (frame), vbox);
 gtk_container_border_width (GTK_CONTAINER (vbox), 5);
 gtk_widget_show (vbox);

 if(tooltips) 
 {
  tips = gtk_tooltips_new();
  gtk_object_set_data (GTK_OBJECT (window), "GXedit", tips);
 }

 cb1 = gtk_check_button_new_with_label("Show toolbar");
 gtk_signal_connect (GTK_OBJECT(cb1), "toggled",
  GTK_SIGNAL_FUNC(CB_settings_toolbar), cb1);
 gtk_box_pack_start (GTK_BOX (vbox), cb1, TRUE, TRUE, 0);
 if(toolbar) gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(cb1), TRUE);
 gtk_widget_show (cb1);
 if(tooltips) gtk_tooltips_set_tip(tips, cb1, "This option shows the main GXedit toolbar", "");

 cb1 = gtk_check_button_new_with_label("Show only icons in toolbars");
 gtk_signal_connect (GTK_OBJECT(cb1), "toggled",
  GTK_SIGNAL_FUNC(CB_settings_icons), cb1);
 gtk_box_pack_start (GTK_BOX (vbox), cb1, TRUE, TRUE, 0);
 if(icons) gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(cb1), TRUE);
 gtk_widget_show (cb1);
 if(tooltips) gtk_tooltips_set_tip(tips, cb1, "Do not show the text below the pixmaps in the main toolbar", "");

 cb1 = gtk_check_button_new_with_label("Full toolbar");
 gtk_signal_connect (GTK_OBJECT(cb1), "toggled",
  GTK_SIGNAL_FUNC(CB_settings_toolbar_full), cb1);
 gtk_box_pack_start (GTK_BOX (vbox), cb1, TRUE, TRUE, 0);
 if(full_tb) gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(cb1), TRUE);
 gtk_widget_show (cb1);
 if(tooltips) gtk_tooltips_set_tip(tips, cb1, "Show all the toolbar buttons", "");

 cb1 = gtk_check_button_new_with_label("Show network toolbar");
 gtk_signal_connect (GTK_OBJECT(cb1), "toggled",
  GTK_SIGNAL_FUNC(CB_settings_netbar), cb1);
 gtk_box_pack_start (GTK_BOX (vbox), cb1, TRUE, TRUE, 0);
 if(netbar) gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(cb1), TRUE);
 gtk_widget_show (cb1);
 if(tooltips) gtk_tooltips_set_tip(tips, cb1, "Show the network toolbar for mail and news", "");

 cb1 = gtk_check_button_new_with_label("Show HTML toolbar");
 gtk_signal_connect (GTK_OBJECT(cb1), "toggled",
  GTK_SIGNAL_FUNC(CB_settings_htmlbar), cb1);
 gtk_box_pack_start (GTK_BOX (vbox), cb1, TRUE, TRUE, 0);
 if(htmlbar) gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(cb1), TRUE);
 gtk_widget_show (cb1);
 if(tooltips) gtk_tooltips_set_tip(tips, cb1, "Show the HTML toolbar", "");

 cb1 = gtk_check_button_new_with_label("Show tooltips");
 gtk_signal_connect (GTK_OBJECT(cb1), "toggled",
  GTK_SIGNAL_FUNC(CB_settings_tooltips), cb1);
 gtk_box_pack_start (GTK_BOX (vbox), cb1, TRUE, TRUE, 0);
 if(tooltips) gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(cb1), TRUE);
 gtk_widget_show (cb1);
 if(tooltips) gtk_tooltips_set_tip(tips, cb1, "Show these tooltips", "");

 cb1 = gtk_check_button_new_with_label("Show debug window");
 gtk_signal_connect (GTK_OBJECT(cb1), "toggled",
  GTK_SIGNAL_FUNC(CB_settings_debug), cb1);
 gtk_box_pack_start (GTK_BOX (vbox), cb1, TRUE, TRUE, 0);
 if(debug) gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(cb1), TRUE);
 gtk_widget_show (cb1);
 if(tooltips) gtk_tooltips_set_tip(tips, cb1, "Show the debug window where all kind of notices and errors are printed", "");

 cb1 = gtk_check_button_new_with_label("Auto save text");
 gtk_signal_connect (GTK_OBJECT(cb1), "toggled",
  GTK_SIGNAL_FUNC(CB_settings_autosave), cb1);
 gtk_box_pack_start (GTK_BOX (vbox), cb1, TRUE, TRUE, 0);
 if(autosave) gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(cb1), TRUE);
 gtk_widget_show (cb1);
 if(tooltips) gtk_tooltips_set_tip(tips, cb1, "Auto save current text in ~/.gxedit.autosave", "");

 label = gtk_label_new ("X size of the main window:");
 gtk_box_pack_start (GTK_BOX (vbox), label, TRUE, TRUE, 0);
 gtk_widget_show (label);

 eb1 = gtk_entry_new ();
 gtk_editable_select_region (GTK_EDITABLE (eb1), 0, -1);
 gtk_box_pack_start (GTK_BOX (vbox), eb1, TRUE, TRUE, 0);
 sprintf(line, "%d", x_size);
 gtk_entry_set_text (GTK_ENTRY (eb1), line);
 gtk_widget_show (eb1);
 if(tooltips) gtk_tooltips_set_tip(tips, eb1, "Horizontal size of the window", "");

 label = gtk_label_new ("Y size of the main window:");
 gtk_box_pack_start (GTK_BOX (vbox), label, TRUE, TRUE, 0);
 gtk_widget_show (label);

 eb2 = gtk_entry_new ();
 gtk_editable_select_region (GTK_EDITABLE (eb2), 0, -1);
 gtk_box_pack_start (GTK_BOX (vbox), eb2, TRUE, TRUE, 0);
 sprintf(line, "%d", y_size);
 gtk_entry_set_text (GTK_ENTRY (eb2), line);
 gtk_widget_show (eb2);
 if(tooltips) gtk_tooltips_set_tip(tips, eb2, "Vertical size of the window", "");

 label = gtk_label_new ("X position of the main window:");
 gtk_box_pack_start (GTK_BOX (vbox), label, TRUE, TRUE, 0);
 gtk_widget_show (label);

 eb3 = gtk_entry_new ();
 gtk_editable_select_region (GTK_EDITABLE (eb3), 0, -1);
 gtk_box_pack_start (GTK_BOX (vbox), eb3, TRUE, TRUE, 0);
 sprintf(line, "%d", x_pos);
 gtk_entry_set_text (GTK_ENTRY (eb3), line);
 gtk_widget_show (eb3);
 if(tooltips) gtk_tooltips_set_tip(tips, eb3, "Horizontal position of the window", "");

 label = gtk_label_new ("Y position of the main window:");
 gtk_box_pack_start (GTK_BOX (vbox), label, TRUE, TRUE, 0);
 gtk_widget_show (label);

 eb4 = gtk_entry_new ();
 gtk_editable_select_region (GTK_EDITABLE (eb4), 0, -1);
 gtk_box_pack_start (GTK_BOX (vbox), eb4, TRUE, TRUE, 0);
 sprintf(line, "%d", y_pos);
 gtk_entry_set_text (GTK_ENTRY (eb4), line);
 gtk_widget_show (eb4);
 if(tooltips) gtk_tooltips_set_tip(tips, eb4, "Vertical position of the window", "");

 frame = gtk_frame_new ("Mail and network options");
 gtk_container_border_width (GTK_CONTAINER (frame), 10);
 gtk_widget_show (frame);
  
 label = gtk_label_new ("Network");
 gtk_notebook_append_page (GTK_NOTEBOOK (notebook), frame, label);
 
 vbox = gtk_vbox_new (FALSE, 0);
 gtk_container_add (GTK_CONTAINER (frame), vbox);
 gtk_container_border_width (GTK_CONTAINER (vbox), 5);
 gtk_widget_show (vbox);

 label = gtk_label_new ("Login name:");
 gtk_box_pack_start (GTK_BOX (vbox), label, TRUE, TRUE, 0);
 gtk_widget_show (label);
 
 eb9 = gtk_entry_new();
 gtk_editable_select_region (GTK_EDITABLE (eb9), 0, -1);
 gtk_box_pack_start (GTK_BOX (vbox), eb9, TRUE, TRUE, 0);
 gtk_entry_set_text (GTK_ENTRY (eb9), login);
 gtk_widget_show (eb9);
 if(tooltips) gtk_tooltips_set_tip(tips, eb9, "Your login name, for the mail opening", "");

 label = gtk_label_new ("Mail server:");
 gtk_box_pack_start (GTK_BOX (vbox), label, TRUE, TRUE, 0);
 gtk_widget_show (label);

 eb7 = gtk_entry_new();
 gtk_editable_select_region (GTK_EDITABLE (eb7), 0, -1);
 gtk_box_pack_start (GTK_BOX (vbox), eb7, TRUE, TRUE, 0);
 gtk_entry_set_text (GTK_ENTRY (eb7), mail_server);
 gtk_widget_show (eb7); 
 if(tooltips) gtk_tooltips_set_tip(tips, eb7, "The server I should use to send mail, usually the local host", "");

 label = gtk_label_new ("Your e-mail address:");
 gtk_box_pack_start (GTK_BOX (vbox), label, TRUE, TRUE, 0);
 gtk_widget_show (label);

 eb8 = gtk_entry_new();
 gtk_editable_select_region (GTK_EDITABLE (eb8), 0, -1);
 gtk_box_pack_start (GTK_BOX (vbox), eb8, TRUE, TRUE, 0);
 gtk_entry_set_text (GTK_ENTRY (eb8), mail_from);
 gtk_widget_show (eb8);
 if(tooltips) gtk_tooltips_set_tip(tips, eb8, "The e-mail address for mail and news posting", "");

 label = gtk_label_new ("News server:");
 gtk_box_pack_start (GTK_BOX (vbox), label, TRUE, TRUE, 0);
 gtk_widget_show (label);
 
 eb10 = gtk_entry_new();
 gtk_editable_select_region (GTK_EDITABLE (eb10), 0, -1);
 gtk_box_pack_start (GTK_BOX (vbox), eb10, TRUE, TRUE, 0);
 gtk_entry_set_text (GTK_ENTRY (eb10), news_server);
 gtk_widget_show (eb10);
 if(tooltips) gtk_tooltips_set_tip(tips, eb10, "The server for news fetching and posting", "");

 label = gtk_label_new ("Mirror server:");
 gtk_box_pack_start (GTK_BOX (vbox), label, TRUE, TRUE, 0);
 gtk_widget_show (label);

 eb14 = gtk_entry_new();
 gtk_editable_select_region (GTK_EDITABLE (eb14), 0, -1);
 gtk_box_pack_start (GTK_BOX (vbox), eb14, TRUE, TRUE, 0);
 gtk_entry_set_text (GTK_ENTRY (eb14), mirror_remote);
 gtk_widget_show (eb14);
 if(tooltips) gtk_tooltips_set_tip(tips, eb14, "The server to use for the mirror connection, from the Options menu", "");

 label = gtk_label_new ("Default news group:");
 gtk_box_pack_start (GTK_BOX (vbox), label, TRUE, TRUE, 0);
 gtk_widget_show (label);
 
 eb18 = gtk_entry_new();
 gtk_editable_select_region (GTK_EDITABLE (eb18), 0, -1);
 gtk_box_pack_start (GTK_BOX (vbox), eb18, TRUE, TRUE, 0);
 gtk_entry_set_text (GTK_ENTRY (eb18), default_news);
 gtk_widget_show (eb18);
 if(tooltips) gtk_tooltips_set_tip(tips, eb18, "Your default newsgroup", "");

 label = gtk_label_new ("Default web site:");
 gtk_box_pack_start (GTK_BOX (vbox), label, TRUE, TRUE, 0);
 gtk_widget_show (label);
 
 eb19 = gtk_entry_new();
 gtk_editable_select_region (GTK_EDITABLE (eb19), 0, -1);
 gtk_box_pack_start (GTK_BOX (vbox), eb19, TRUE, TRUE, 0);
 gtk_entry_set_text (GTK_ENTRY (eb19), default_web);
 gtk_widget_show (eb19);
 if(tooltips) gtk_tooltips_set_tip(tips, eb19, "Your default web server", "");

 cb1 = gtk_check_button_new_with_label("Open mail for reply");
 gtk_signal_connect (GTK_OBJECT(cb1), "toggled",
  GTK_SIGNAL_FUNC(CB_settings_reply), cb1);
 gtk_box_pack_start (GTK_BOX (vbox), cb1, TRUE, TRUE, 0);
 if(reply) gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(cb1), TRUE);
 gtk_widget_show (cb1);
 if(tooltips) gtk_tooltips_set_tip(tips, cb1, "Use the Reply option for every e-mail, adding your ~/.signature file at the end", "");

 cb1 = gtk_check_button_new_with_label("Use mail command");
 gtk_signal_connect (GTK_OBJECT(cb1), "toggled",
  GTK_SIGNAL_FUNC(CB_settings_mail_cmd), cb1);
 gtk_box_pack_start (GTK_BOX (vbox), cb1, TRUE, TRUE, 0);
 if(mail_cmd) gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(cb1), TRUE);
 gtk_widget_show (cb1);
 if(tooltips) gtk_tooltips_set_tip(tips, cb1, "Use the mail command to send mail rather then communicating to the mail server", "");

 cb1 = gtk_check_button_new_with_label("Use proxy server");
 gtk_signal_connect (GTK_OBJECT(cb1), "toggled",
  GTK_SIGNAL_FUNC(CB_settings_use_socks), cb1);
 gtk_box_pack_start (GTK_BOX (vbox), cb1, TRUE, TRUE, 0);
 if(use_socks) gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(cb1), TRUE);
 gtk_widget_show (cb1);
 if(tooltips) gtk_tooltips_set_tip(tips, cb1, "Use SOCKS proxy server", "");
#ifndef USE_SOCKS
 gtk_widget_set_sensitive (cb1, FALSE);
#endif

 frame = gtk_frame_new ("Scripting macros");
 gtk_container_border_width (GTK_CONTAINER (frame), 10);
 gtk_widget_show (frame);

 label = gtk_label_new ("Macros");
 gtk_notebook_append_page (GTK_NOTEBOOK (notebook), frame, label);
 
 vbox = gtk_vbox_new (FALSE, 0);
 gtk_container_add (GTK_CONTAINER (frame), vbox);
 gtk_container_border_width (GTK_CONTAINER (vbox), 5);
 gtk_widget_show (vbox);

 table = gtk_table_new (2, 2, FALSE);
 gtk_table_set_row_spacing (GTK_TABLE (table), 0, 2);
 gtk_table_set_col_spacing (GTK_TABLE (table), 0, 2);
 gtk_box_pack_start (GTK_BOX (vbox), table, TRUE, TRUE, 0);
 gtk_widget_show (table);

 text2 = gtk_text_new (NULL, NULL);
 gtk_text_set_word_wrap(GTK_TEXT (text2), TRUE);
 gtk_table_attach_defaults (GTK_TABLE (table), text2, 0, 1, 0, 1);
 gtk_text_set_editable (GTK_TEXT (text2), TRUE);
 gtk_widget_show (text2);

 vscrollbar = gtk_vscrollbar_new (GTK_TEXT (text2)->vadj);
 gtk_table_attach (GTK_TABLE (table), vscrollbar, 1, 2, 0, 1,
  GTK_FILL, GTK_EXPAND | GTK_FILL, 0, 0);
 gtk_widget_show (vscrollbar);
 gtk_text_freeze (GTK_TEXT (text2));
 gtk_widget_realize (text2);
 sprintf(temp, "%s/.gxedit", home);
 fd = fopen(temp, "r");
 if(fd!=NULL)
 {
  while(fgets(line, 512, fd)!=NULL)
  {
   if(!strcasecmp(lindex(line,0),"macro:") ||
      !strcasecmp(lindex(line,0),"macro_title:") ||
      !strcasecmp(lindex(line,0),"awk_macro:") ||
      !strcasecmp(lindex(line,0),"awk_macro_title:") || 
      !strcasecmp(lindex(line,0),"sed_macro:") ||
      !strcasecmp(lindex(line,0),"sed_macro_title:"))
   gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, line, -1);
  }
  fclose(fd);
 }
 gtk_text_thaw (GTK_TEXT (text2));

 frame = gtk_frame_new ("Importing filters");
 gtk_container_border_width (GTK_CONTAINER (frame), 10);
 gtk_widget_show (frame);
 
 label = gtk_label_new ("Filters");
 gtk_notebook_append_page (GTK_NOTEBOOK (notebook), frame, label);
  
 vbox = gtk_vbox_new (FALSE, 0);
 gtk_container_add (GTK_CONTAINER (frame), vbox);
 gtk_container_border_width (GTK_CONTAINER (vbox), 5);
 gtk_widget_show (vbox);

 
 table = gtk_table_new (2, 2, FALSE);
 gtk_table_set_row_spacing (GTK_TABLE (table), 0, 2);
 gtk_table_set_col_spacing (GTK_TABLE (table), 0, 2);
 gtk_box_pack_start (GTK_BOX (vbox), table, TRUE, TRUE, 0);
 gtk_widget_show (table);
  
 text3 = gtk_text_new (NULL, NULL);
 gtk_text_set_word_wrap(GTK_TEXT (text3), TRUE); 
 gtk_table_attach_defaults (GTK_TABLE (table), text3, 0, 1, 0, 1);
 gtk_text_set_editable (GTK_TEXT (text3), TRUE);
 gtk_widget_show (text3);
 
 vscrollbar = gtk_vscrollbar_new (GTK_TEXT (text3)->vadj);
 gtk_table_attach (GTK_TABLE (table), vscrollbar, 1, 2, 0, 1,
  GTK_FILL, GTK_EXPAND | GTK_FILL, 0, 0);
 gtk_widget_show (vscrollbar);
 gtk_text_freeze (GTK_TEXT (text3));
 gtk_widget_realize (text3);
 sprintf(temp, "%s/.gxedit", home);
 fd = fopen(temp, "r");
 if(fd!=NULL)
 {
  while(fgets(line, 512, fd)!=NULL)
  {
   if(!strcasecmp(lindex(line,0),"filter:") || !strcasecmp(lindex(line,0),"filter_title:"))
   gtk_text_insert (GTK_TEXT (text3), NULL, &color, NULL, line, -1);
  }
  fclose(fd);
 }
 gtk_text_thaw (GTK_TEXT (text3));

 frame = gtk_frame_new ("Other advanced options");
 gtk_container_border_width (GTK_CONTAINER (frame), 10);
 gtk_widget_show (frame);

 label = gtk_label_new ("Advanced");
 gtk_notebook_append_page (GTK_NOTEBOOK (notebook), frame, label);

 vbox = gtk_vbox_new (FALSE, 0);
 gtk_container_add (GTK_CONTAINER (frame), vbox);
 gtk_container_border_width (GTK_CONTAINER (vbox), 5);
 gtk_widget_show (vbox);

 cbitems = g_list_append(cbitems, "-adobe-helvetica-*-r-*-*-12-*-*-*-*-*-*-*");
 cbitems = g_list_append(cbitems, "-adobe-helvetica-*-r-*-*-14-*-*-*-*-*-*-*");
 cbitems = g_list_append(cbitems, "-adobe-helvetica-*-r-*-*-16-*-*-*-*-*-*-*");
 cbitems = g_list_append(cbitems, "-adobe-courier-*-r-*-*-12-*-*-*-*-*-*-*");
 cbitems = g_list_append(cbitems, "-adobe-courier-*-r-*-*-14-*-*-*-*-*-*-*");
 cbitems = g_list_append(cbitems, "-adobe-courier-*-r-*-*-16-*-*-*-*-*-*-*");
 cbitems = g_list_append(cbitems, "-b&h-lucida-*-r-*-*-12-*-*-*-*-*-*-*");
 cbitems = g_list_append(cbitems, "-b&h-lucida-*-r-*-*-14-*-*-*-*-*-*-*");
 cbitems = g_list_append(cbitems, "-b&h-lucida-*-r-*-*-16-*-*-*-*-*-*-*");
 cbitems = g_list_append(cbitems, "-misc-fixed-*-r-*-*-12-*-*-*-*-*-*-*");
 cbitems = g_list_append(cbitems, "-misc-fixed-*-r-*-*-14-*-*-*-*-*-*-*");
 cbitems = g_list_append(cbitems, "-misc-fixed-*-r-*-*-16-*-*-*-*-*-*-*");

 label = gtk_label_new ("Font selection:");
 gtk_box_pack_start (GTK_BOX (vbox), label, TRUE, TRUE, 0);
 gtk_widget_show (label);

#ifndef GTK_1_1
 eb11 = gtk_combo_new ();
 gtk_combo_set_popdown_strings (GTK_COMBO (eb11), cbitems);
 gtk_entry_set_text (GTK_ENTRY (GTK_COMBO(eb11)->entry), font);
 gtk_box_pack_start (GTK_BOX (vbox), eb11, TRUE, TRUE, 0);
 gtk_widget_show (eb11);
 if(tooltips) gtk_tooltips_set_tip(tips, eb11, "The font to use for GXedit", "");
#else
 button = gtk_button_new_with_label ("Select font here");
 gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
  GTK_SIGNAL_FUNC(CB_sel_font), GTK_OBJECT (window2));
 gtk_box_pack_start (GTK_BOX (vbox), button, TRUE, TRUE, 0);
 gtk_widget_show (button);
#endif

 label = gtk_label_new ("Background pixmap:");
 gtk_box_pack_start (GTK_BOX (vbox), label, TRUE, TRUE, 0);
 gtk_widget_show (label);

 eb12 = gtk_entry_new();
 gtk_editable_select_region (GTK_EDITABLE (eb12), 0, -1); 
 gtk_box_pack_start (GTK_BOX (vbox), eb12, TRUE, TRUE, 0);
 gtk_entry_set_text (GTK_ENTRY (eb12), bg_pixmap);
 gtk_widget_show (eb12);
 if(tooltips) gtk_tooltips_set_tip(tips, eb12, "The .xpm image to use as the background, available only in view mode (-v)", "");

 cbitems = NULL;
 cbitems = g_list_append(cbitems, "black");
 cbitems = g_list_append(cbitems, "red");
 cbitems = g_list_append(cbitems, "green");
 cbitems = g_list_append(cbitems, "blue");
 cbitems = g_list_append(cbitems, "white");

 label = gtk_label_new ("Text color:");
 gtk_box_pack_start (GTK_BOX (vbox), label, TRUE, TRUE, 0);
 gtk_widget_show (label);

 eb5 = gtk_combo_new ();
 gtk_combo_set_popdown_strings (GTK_COMBO (eb5), cbitems);
 gtk_entry_set_text (GTK_ENTRY (GTK_COMBO(eb5)->entry), col_name);
 gtk_box_pack_start (GTK_BOX (vbox), eb5, TRUE, TRUE, 0);
 gtk_widget_show (eb5);
 if(tooltips) gtk_tooltips_set_tip(tips, eb5, "The color of the text", "");

 label = gtk_label_new ("Background color:");
 gtk_box_pack_start (GTK_BOX (vbox), label, TRUE, TRUE, 0);
 gtk_widget_show (label);

 eb13 = gtk_combo_new ();
 gtk_combo_set_popdown_strings (GTK_COMBO (eb13), cbitems);
 gtk_entry_set_text (GTK_ENTRY (GTK_COMBO(eb13)->entry), bg);
 gtk_box_pack_start (GTK_BOX (vbox), eb13, TRUE, TRUE, 0);
 gtk_widget_show (eb13); 
 if(tooltips) gtk_tooltips_set_tip(tips, eb13, "The color of the background", "");

 label = gtk_label_new ("Images viewer:");
 gtk_box_pack_start (GTK_BOX (vbox), label, TRUE, TRUE, 0);
 gtk_widget_show (label);
 
 eb6 = gtk_entry_new();
 gtk_editable_select_region (GTK_EDITABLE (eb6), 0, -1);
 gtk_box_pack_start (GTK_BOX (vbox), eb6, TRUE, TRUE, 0);
 gtk_entry_set_text (GTK_ENTRY (eb6), images);
 gtk_widget_show (eb6);
 if(tooltips) gtk_tooltips_set_tip(tips, eb6, "The program to start if you try to load .gif or .jpg files", "");

 label = gtk_label_new ("File manager:");
 gtk_box_pack_start (GTK_BOX (vbox), label, TRUE, TRUE, 0);
 gtk_widget_show (label);
 
 eb15 = gtk_entry_new();
 gtk_editable_select_region (GTK_EDITABLE (eb15), 0, -1);
 gtk_box_pack_start (GTK_BOX (vbox), eb15, TRUE, TRUE, 0);
 gtk_entry_set_text (GTK_ENTRY (eb15), xfm);
 gtk_widget_show (eb15);
 if(tooltips) gtk_tooltips_set_tip(tips, eb15, "Your favorite file manager", "");

 label = gtk_label_new ("Spelling dictionary:");
 gtk_box_pack_start (GTK_BOX (vbox), label, TRUE, TRUE, 0);
 gtk_widget_show (label);
 
 eb16 = gtk_entry_new();
 gtk_editable_select_region (GTK_EDITABLE (eb16), 0, -1);
 gtk_box_pack_start (GTK_BOX (vbox), eb16, TRUE, TRUE, 0);
 gtk_entry_set_text (GTK_ENTRY (eb16), dict);
 gtk_widget_show (eb16);
 if(tooltips) gtk_tooltips_set_tip(tips, eb16, "The ispell dictionary to use", "");

 label = gtk_label_new ("UnGzip command:");
 gtk_box_pack_start (GTK_BOX (vbox), label, TRUE, TRUE, 0);
 gtk_widget_show (label);
 
 eb17 = gtk_entry_new();
 gtk_editable_select_region (GTK_EDITABLE (eb17), 0, -1);
 gtk_box_pack_start (GTK_BOX (vbox), eb17, TRUE, TRUE, 0);
 gtk_entry_set_text (GTK_ENTRY (eb17), gzip);
 gtk_widget_show (eb17);
 if(tooltips) gtk_tooltips_set_tip(tips, eb17, "The command to uncompress man pages", "");

 label = gtk_label_new ("Document directory:");
 gtk_box_pack_start (GTK_BOX (vbox), label, TRUE, TRUE, 0);
 gtk_widget_show (label);

 eb20 = gtk_entry_new();
 gtk_editable_select_region (GTK_EDITABLE (eb20), 0, -1);
 gtk_box_pack_start (GTK_BOX (vbox), eb20, TRUE, TRUE, 0);
 gtk_entry_set_text (GTK_ENTRY (eb20), doc_dir);
 gtk_widget_show (eb20);
 if(tooltips) gtk_tooltips_set_tip(tips, eb20, "Optional document dir", "");

 label = gtk_label_new ("Compile command:");
 gtk_box_pack_start (GTK_BOX (vbox), label, TRUE, TRUE, 0);
 gtk_widget_show (label);
 
 eb22 = gtk_entry_new();
 gtk_editable_select_region (GTK_EDITABLE (eb22), 0, -1);
 gtk_box_pack_start (GTK_BOX (vbox), eb22, TRUE, TRUE, 0);
 gtk_entry_set_text (GTK_ENTRY (eb22), compile);
 gtk_widget_show (eb22);
 if(tooltips) gtk_tooltips_set_tip(tips, eb22, "Command to use for the Compile option", "");

 frame = gtk_frame_new ("Editing and accessibility options");
 gtk_container_border_width (GTK_CONTAINER (frame), 10);
 gtk_widget_show (frame);

 label = gtk_label_new ("Misc");
 gtk_notebook_append_page (GTK_NOTEBOOK (notebook), frame, label);

 vbox = gtk_vbox_new (FALSE, 0);
 gtk_container_add (GTK_CONTAINER (frame), vbox);     
 gtk_container_border_width (GTK_CONTAINER (vbox), 5);
 gtk_widget_show (vbox);

 cb1 = gtk_check_button_new_with_label("Bold menu fonts");
 gtk_signal_connect (GTK_OBJECT(cb1), "toggled",
  GTK_SIGNAL_FUNC(CB_settings_access), cb1);
 gtk_box_pack_start (GTK_BOX (vbox), cb1, TRUE, TRUE, 0);
 if(access_opt) gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(cb1), TRUE);
 gtk_widget_show (cb1);
 if(tooltips) gtk_tooltips_set_tip(tips, cb1, "Turn on the bold fonts and Access menu", "");

 cb1 = gtk_check_button_new_with_label("Scrollbar on the left");
 gtk_signal_connect (GTK_OBJECT(cb1), "toggled",
  GTK_SIGNAL_FUNC(CB_settings_scroll_loc), cb1);
 gtk_box_pack_start (GTK_BOX (vbox), cb1, TRUE, TRUE, 0);
 if(scroll_loc) gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(cb1), TRUE);
 gtk_widget_show (cb1);
 if(tooltips) gtk_tooltips_set_tip(tips, cb1, "Scrollbar on the left", "");

 cb1 = gtk_check_button_new_with_label("Audio menu");
 gtk_signal_connect (GTK_OBJECT(cb1), "toggled",
  GTK_SIGNAL_FUNC(CB_settings_audio), cb1);
 gtk_box_pack_start (GTK_BOX (vbox), cb1, TRUE, TRUE, 0);
 if(audio) gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(cb1), TRUE);
 gtk_widget_show (cb1);
 if(tooltips) gtk_tooltips_set_tip(tips, cb1, "Audio features", "");

 label = gtk_label_new ("Page width in pixels:");
 gtk_box_pack_start (GTK_BOX (vbox), label, TRUE, TRUE, 0);
 gtk_widget_show (label);
 
 sprintf(temp, "%d", page_width);
 eb21 = gtk_entry_new();
 gtk_editable_select_region (GTK_EDITABLE (eb21), 0, -1);
 gtk_box_pack_start (GTK_BOX (vbox), eb21, TRUE, TRUE, 0);   
 gtk_entry_set_text (GTK_ENTRY (eb21), temp);
 gtk_widget_show (eb21);
 if(tooltips) gtk_tooltips_set_tip(tips, eb21, "Page width", "");

 cb1 = gtk_check_button_new_with_label("Line wrapping");
 gtk_signal_connect (GTK_OBJECT(cb1), "toggled",
  GTK_SIGNAL_FUNC(CB_settings_wrap), cb1);
 gtk_box_pack_start (GTK_BOX (vbox), cb1, TRUE, TRUE, 0); 
 if(line_wrap) gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(cb1), TRUE);
 gtk_widget_show (cb1); 
 if(tooltips) gtk_tooltips_set_tip(tips, cb1, "Wrap at end of line", "");

 cb1 = gtk_check_button_new_with_label("Auto indent");
 gtk_signal_connect (GTK_OBJECT(cb1), "toggled",
  GTK_SIGNAL_FUNC(CB_settings_auto_indent), cb1);
 gtk_box_pack_start (GTK_BOX (vbox), cb1, TRUE, TRUE, 0);
 if(auto_indent) gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(cb1), TRUE);
 gtk_widget_show (cb1);
 if(tooltips) gtk_tooltips_set_tip(tips, cb1, "Set automatic indent of lines", "");

 cbitems = NULL;
 cbitems = g_list_append(cbitems, "No highlighting");
 cbitems = g_list_append(cbitems, "HTML style");
 cbitems = g_list_append(cbitems, "C style");
 cbitems = g_list_append(cbitems, "Perl style");
 cbitems = g_list_append(cbitems, "Java style");

 label = gtk_label_new ("Syntax highlighting style:");
 gtk_box_pack_start (GTK_BOX (vbox), label, TRUE, TRUE, 0);
 gtk_widget_show (label);

 eb23 = gtk_combo_new ();
 gtk_combo_set_popdown_strings (GTK_COMBO (eb23), cbitems);
 if(h_style==0)
 gtk_entry_set_text (GTK_ENTRY (GTK_COMBO(eb23)->entry), "No highlighting");
 if(h_style==1)
 gtk_entry_set_text (GTK_ENTRY (GTK_COMBO(eb23)->entry), "HTML style");
 if(h_style==2)
 gtk_entry_set_text (GTK_ENTRY (GTK_COMBO(eb23)->entry), "C style");
 if(h_style==3)
 gtk_entry_set_text (GTK_ENTRY (GTK_COMBO(eb23)->entry), "Perl style");
 if(h_style==4)
 gtk_entry_set_text (GTK_ENTRY (GTK_COMBO(eb23)->entry), "Java style");
 gtk_box_pack_start (GTK_BOX (vbox), eb23, TRUE, TRUE, 0);
 gtk_widget_show (eb23);
 if(tooltips) gtk_tooltips_set_tip(tips, eb23, "The type of highlighting", "");
#ifndef GTKEDITOR_PATCH
 gtk_widget_set_sensitive (eb23, FALSE);
#endif

 cb1 = gtk_check_button_new_with_label("Fortune on start");
 gtk_signal_connect (GTK_OBJECT(cb1), "toggled",
  GTK_SIGNAL_FUNC(CB_settings_fortune), cb1);
 gtk_box_pack_start (GTK_BOX (vbox), cb1, TRUE, TRUE, 0);
 if(fortune) gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(cb1), TRUE);
 gtk_widget_show (cb1);
 if(tooltips) gtk_tooltips_set_tip(tips, cb1, "Show fortune on startup", "");

 cb1 = gtk_check_button_new_with_label("Open button has old meaning");
 gtk_signal_connect (GTK_OBJECT(cb1), "toggled",
  GTK_SIGNAL_FUNC(CB_settings_old_open), cb1);
 gtk_box_pack_start (GTK_BOX (vbox), cb1, TRUE, TRUE, 0);
 if(old_open) gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(cb1), TRUE);
 gtk_widget_show (cb1);
 if(tooltips) gtk_tooltips_set_tip(tips, cb1, "The open button opens the text in the same window", "");

 label = gtk_label_new ("");
 gtk_box_pack_start (GTK_BOX (vbox), label, TRUE, TRUE, 0);
 gtk_widget_show (label);

 button = gtk_button_new_with_label ("Edit bookmarks");
 gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
  GTK_SIGNAL_FUNC(CB_settings_bookm), GTK_OBJECT (window2));
 gtk_box_pack_start (GTK_BOX (vbox), button, TRUE, TRUE, 0);
 if(tooltips) gtk_tooltips_set_tip(tips, button, "Edit the bookmarks","");
 gtk_widget_show (button);

 button = gtk_button_new_with_label ("Add applications");
 gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
  GTK_SIGNAL_FUNC(CB_settings_apps), GTK_OBJECT (window2));
 gtk_box_pack_start (GTK_BOX (vbox), button, TRUE, TRUE, 0);
 if(tooltips) gtk_tooltips_set_tip(tips, button, "Add applications to the toolbar","");
 gtk_widget_show (button);

 button = gtk_button_new_with_label ("Add more RC settings");
 gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
  GTK_SIGNAL_FUNC(CB_settings_rc), GTK_OBJECT (window2));
 gtk_box_pack_start (GTK_BOX (vbox), button, TRUE, TRUE, 0);
 if(tooltips) gtk_tooltips_set_tip(tips, button, "Add advanced RC settings","");
 gtk_widget_show (button);

 label = gtk_label_new ("");
 gtk_box_pack_start (GTK_BOX (vbox), label, TRUE, TRUE, 0);
 gtk_widget_show (label);

 sep = gtk_hseparator_new ();
 gtk_box_pack_start (GTK_BOX (vbox2), sep, FALSE, TRUE, 0);
 gtk_widget_show (sep);

 hbox = gtk_hbutton_box_new();  
 gtk_button_box_set_layout(GTK_BUTTON_BOX(hbox), GTK_BUTTONBOX_END);
 gtk_button_box_set_spacing(GTK_BUTTON_BOX(hbox), 5);
 gtk_box_pack_start (GTK_BOX (vbox2), hbox, FALSE, FALSE, 0);
 gtk_widget_show (hbox);

 button = gtk_button_new_with_label ("Save settings");
 gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
  GTK_SIGNAL_FUNC(CB_settings_save), GTK_OBJECT (window2));
 gtk_box_pack_start (GTK_BOX (hbox), button, TRUE, TRUE, 0);
 gtk_widget_show (button);

 button = gtk_button_new_with_label ("Cancel");
 gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
  GTK_SIGNAL_FUNC(CB_open_cancel), GTK_OBJECT (window2));
 gtk_box_pack_start (GTK_BOX (hbox), button, TRUE, TRUE, 0);
 gtk_widget_show (button);
 gtk_widget_show (window2);
}

void CB_run_ok(GtkWidget *widget, GtkWidget *entry)
{
 if(run_in_bg==0 && run_in_xterm==0)
 sprintf(temp, "%s", gtk_entry_get_text(GTK_ENTRY(entry_box)));
 if(run_in_bg==1 && run_in_xterm==0)
 sprintf(temp, "%s &", gtk_entry_get_text(GTK_ENTRY(entry_box)));
 if(run_in_bg==0 && run_in_xterm==1)
 sprintf(temp, "xterm -e %s &", gtk_entry_get_text(GTK_ENTRY(entry_box)));
 if(run_in_bg==1 && run_in_xterm==1)
 sprintf(temp, "xterm -e %s &", gtk_entry_get_text(GTK_ENTRY(entry_box)));
 system(temp);
 gtk_widget_destroy(window2);
 window2 = NULL;
}

#ifdef GTK_1_1
void CB_sel_font_ok(GtkWidget *widget, GtkFontSelectionDialog *fs)
{
 strcpy(font, gtk_font_selection_dialog_get_font_name(fs));
 gtk_widget_destroy(window3);
}
#endif

void CB_sel_font(GtkWidget *widget, GtkWidget *entry)
{
#ifdef GTK_1_1
 if(window3!=NULL) return;
 window3 = gtk_font_selection_dialog_new ("Select font to use");
 gtk_window_position (GTK_WINDOW (window3), GTK_WIN_POS_MOUSE);
 gtk_signal_connect (GTK_OBJECT (window3), "destroy",
 GTK_SIGNAL_FUNC(gtk_widget_destroyed), &window3);
 gtk_signal_connect (GTK_OBJECT (GTK_FONT_SELECTION_DIALOG(window3)->ok_button),
 "clicked", GTK_SIGNAL_FUNC(CB_sel_font_ok), GTK_FONT_SELECTION_DIALOG (window3));
 gtk_signal_connect_object (GTK_OBJECT (GTK_FONT_SELECTION_DIALOG(window3)->cancel_button),
 "clicked", GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT (window3));
 gtk_widget_show (window3);
#endif
}

void CB_compile(GtkWidget *widget, GtkWidget *entry)
{
 int i;
 strncpy(tmp_name, tempnam(NULL,".gxe"), 50);
 bzero(temp, 1024);
 strcpy(temp, "");
 for(i=0;lindex(compile,i)!=NULL;i++)
 {
  if(!strcasecmp(lindex(compile,i),"$f"))
  strcat(temp, filename);
  else strcat(temp, lindex(compile,i));
  strcat(temp, " ");
 }
 sprintf(line, "> %s 2> %s", tmp_name, tmp_name);
 strcat(temp, line);
 system(temp);
 fd = fopen(tmp_name, "r");
 print_debug("*** Compile results:\n");
 while(fgets(line, 500, fd)!=NULL) print_debug(line);
 if(fd!=NULL) fclose(fd);
}

void CB_print_ok(GtkWidget *widget, GtkWidget *entry)  
{
 if(!strcasecmp(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(eb11)->entry)),"default"))
 sprintf(line, "%s %s", gtk_entry_get_text(GTK_ENTRY(entry_box)),tmp_name);
 else
 sprintf(line, "%s -P%s %s", gtk_entry_get_text(GTK_ENTRY(entry_box)), gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(eb11)->entry)), tmp_name);
 system(line);
 gtk_widget_destroy(window2);
 window2 = NULL;
}

void CB_open_news_list(GtkWidget *widget, GtkWidget *entry)
{
#ifdef USE_NET
 modified = 0;
 sprintf(temp, "%s/.gxedit.newsgroups", home);
 fd = fopen(temp, "r");
 if(fd==NULL)
 {
  list_groups();
  sprintf(temp, "%s/.gxedit.newsgroups", home);
  fd = fopen(temp, "r");
 }
 gtk_text_set_point(GTK_TEXT(text), 0);
 gtk_text_forward_delete(GTK_TEXT(text), gtk_text_get_length(GTK_TEXT(text)));
 gtk_text_freeze(GTK_TEXT(text));
 while(fgets(line, 512, fd)!=NULL)
 {
  gtk_text_insert (GTK_TEXT (text), NULL, &color, NULL, line, -1);
 }
 gtk_text_thaw(GTK_TEXT(text));
 fclose(fd);
#endif
}

void CB_open_article_ok(GtkWidget *gtklist, gpointer func_data)
{
 char group1[101], article1[101];
 GList *dlist;
 dlist = GTK_LIST(gtklist)->selection;
 modified = 0;
#ifdef USE_NET
 while (dlist)
 {
  GtkObject *list_item;
  gchar *item_data_string;
  list_item = GTK_OBJECT(dlist->data);
  item_data_string = gtk_object_get_data(list_item,list_item_data_key1);
  strncpy(article1, lindex(item_data_string,0), 100);
  strncpy(group1, temp2, 100);
  strncpy(subject, lrange(item_data_string,2), 50);
  get_article(group1, article1);
  dlist = dlist->next;
 }
 sprintf(line, "GXedit %s - %s (%s)\n", VERSION, filename, group1);
 gtk_window_set_title (GTK_WINDOW (window), line);
#endif
}

void CB_open_news_ok(GtkWidget *widget, GtkWidget *entry)
{
 char *string;
 strncpy(tmp_name, tempnam(NULL,".gxe"), 50);
 strncpy(tmp_name2, tempnam(NULL,".gxe"), 50);
#ifdef USE_NET
 fd = fopen(tmp_name2, "w");
 if(fd!=NULL) fclose(fd);
 fd = fopen(tmp_name, "w");
 if(fd==NULL)
 {
  msgbox("Can't open temporary file");
  return;
 }
 if(!strcmp(gtk_entry_get_text(GTK_ENTRY(eb1)),"")) return;
 strncpy(temp2, gtk_entry_get_text(GTK_ENTRY(eb1)), 100);
 get_groups(temp2, tmp_name, tmp_name2);
 fclose(fd);
 gtk_widget_destroy(window2);
 fd = fopen(tmp_name2, "r");
 if(fd==NULL)
 {
  msgbox("Can't open mail file");
  return;  
 }
 window2 = gtk_window_new (GTK_WINDOW_TOPLEVEL);
 gtk_signal_connect (GTK_OBJECT (window2), "destroy",
  GTK_SIGNAL_FUNC(CB_open_cancel), &window2);
 gtk_signal_connect (GTK_OBJECT (window2), "delete_event",
  GTK_SIGNAL_FUNC(CB_open_cancel), &window2);
 gtk_window_set_title (GTK_WINDOW (window2), "Newsgroup list");
 gtk_container_border_width (GTK_CONTAINER (window2), 2);
 gtk_widget_set_usize (window2, 400, 300);
 gtk_widget_set_uposition (window2, 50, 50);
  
 vbox = gtk_vbox_new (FALSE, 0);
 gtk_container_add (GTK_CONTAINER (window2), vbox);
 gtk_container_border_width (GTK_CONTAINER (vbox), 5);
 gtk_widget_show (vbox);

 label = gtk_label_new (temp2);
 gtk_box_pack_start (GTK_BOX (vbox), label, TRUE, TRUE, 0); 
 gtk_widget_show (label);
 
 scrolled_window = gtk_scrolled_window_new(NULL, NULL);
 gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolled_window),
 GTK_POLICY_AUTOMATIC,GTK_POLICY_AUTOMATIC);
 gtk_widget_set_usize(scrolled_window, 350, 250);
 gtk_container_add(GTK_CONTAINER(vbox), scrolled_window);
 gtk_widget_show(scrolled_window);

 gtklist1 = gtk_list_new();
 gtk_container_add(GTK_CONTAINER(scrolled_window), gtklist1);
 gtk_widget_show(gtklist1);
 gtk_signal_connect(GTK_OBJECT(gtklist1), "selection_changed",
 GTK_SIGNAL_FUNC(CB_open_article_ok), NULL);
 gtk_container_set_focus_vadjustment (GTK_CONTAINER (gtklist1),
 gtk_scrolled_window_get_vadjustment(GTK_SCROLLED_WINDOW(scrolled_window)));

 while(fgets(line, 512, fd)!=NULL)
 {
  line[strlen(line)-1]=' ';
  label = gtk_label_new(line);
  list_item1 = gtk_list_item_new_with_label(line);
  gtk_container_add(GTK_CONTAINER(gtklist1), list_item1);
  gtk_widget_show(list_item1);
  gtk_label_get(GTK_LABEL(label), &string);
  gtk_object_set_data(GTK_OBJECT(list_item1), list_item_data_key1, string);
 }
 if(fd!=NULL) fclose(fd);

 button = gtk_button_new_with_label ("Close");
 gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
  GTK_SIGNAL_FUNC(CB_open_cancel), GTK_OBJECT (window2));
 gtk_box_pack_start (GTK_BOX (vbox), button, TRUE, TRUE, 0);
 gtk_widget_show (button);   
 gtk_widget_show (window2);
#endif 
 strcpy(filename, "Unknown filename");
 sprintf(line, "GXedit %s - %s\n", VERSION, filename);
 gtk_window_set_title (GTK_WINDOW (window), line);
}

void CB_news_post_ok(GtkWidget *widget, GtkWidget *entry)
{
#ifdef USE_NET
 post_news(gtk_entry_get_text(GTK_ENTRY(eb1)),gtk_entry_get_text(GTK_ENTRY(eb2)));
 gtk_widget_destroy(window2);
#endif
}

void CB_news_post(GtkWidget *widget, GtkWidget *entry)
{
 if(window2!=NULL)
 {
  gtk_widget_destroy(window2);
 }
 window2 = gtk_window_new (GTK_WINDOW_TOPLEVEL);
 gtk_signal_connect (GTK_OBJECT (window2), "destroy",
  GTK_SIGNAL_FUNC(CB_open_cancel), &window2);
 gtk_signal_connect (GTK_OBJECT (window2), "delete_event",
  GTK_SIGNAL_FUNC(CB_open_cancel), &window2);
 gtk_window_set_title (GTK_WINDOW (window2), "Which newsgroup");
 gtk_container_border_width (GTK_CONTAINER (window2), 2);
 gtk_widget_set_uposition (window2, (x_pos+100), (y_pos+100));
  
 vbox = gtk_vbox_new (FALSE, 0);
 gtk_container_add (GTK_CONTAINER (window2), vbox);
 gtk_container_border_width (GTK_CONTAINER (window2), 5);
 gtk_widget_show (vbox);

 label = gtk_label_new ("Newsgroups:");
 gtk_box_pack_start (GTK_BOX (vbox), label, TRUE, TRUE, 0);
 gtk_widget_show (label);
  
 eb1 = gtk_entry_new ();
 gtk_editable_select_region (GTK_EDITABLE (eb1), 0, -1);
 gtk_box_pack_start (GTK_BOX (vbox), eb1, TRUE, TRUE, 0);
 gtk_widget_show (eb1);

 label = gtk_label_new ("Subject:");
 gtk_box_pack_start (GTK_BOX (vbox), label, TRUE, TRUE, 0); 
 gtk_widget_show (label);
 
 eb2 = gtk_entry_new ();
 gtk_editable_select_region (GTK_EDITABLE (eb2), 0, -1);
 gtk_box_pack_start (GTK_BOX (vbox), eb2, TRUE, TRUE, 0);
 if(subject!=NULL) gtk_entry_set_text (GTK_ENTRY (eb2), subject);
 gtk_widget_show (eb2);

 button = gtk_button_new_with_label ("OK");
 gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
  GTK_SIGNAL_FUNC(CB_news_post_ok), GTK_OBJECT (window2));
 gtk_box_pack_start (GTK_BOX (vbox), button, TRUE, TRUE, 0);
 GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
 gtk_widget_grab_default (button);
 gtk_widget_show (button);
 gtk_widget_show (window2);
}

void CB_open_news(GtkWidget *widget, GtkWidget *entry)
{
 if(window2!=NULL)
 {
  gtk_widget_destroy(window2);
 }
 window2 = gtk_window_new (GTK_WINDOW_TOPLEVEL);
 gtk_signal_connect (GTK_OBJECT (window2), "destroy",
  GTK_SIGNAL_FUNC(CB_open_cancel), &window2);
 gtk_signal_connect (GTK_OBJECT (window2), "delete_event",
  GTK_SIGNAL_FUNC(CB_open_cancel), &window2);
 gtk_window_set_title (GTK_WINDOW (window2), "Which newsgroup");
 gtk_container_border_width (GTK_CONTAINER (window2), 2);
 gtk_widget_set_uposition (window2, (x_pos+100), (y_pos+100));
  
 vbox = gtk_vbox_new (FALSE, 0);
 gtk_container_add (GTK_CONTAINER (window2), vbox);
 gtk_container_border_width (GTK_CONTAINER (window2), 5);
 gtk_widget_show (vbox);

 label = gtk_label_new ("Which newsgroup do you want to open:");
 gtk_box_pack_start (GTK_BOX (vbox), label, TRUE, TRUE, 0);
 gtk_widget_show (label);

 eb1 = gtk_entry_new ();
 gtk_entry_set_text (GTK_ENTRY (eb1), default_news);
 gtk_editable_select_region (GTK_EDITABLE (eb1), 0, -1);
 gtk_box_pack_start (GTK_BOX (vbox), eb1, TRUE, TRUE, 0);  
 gtk_widget_show (eb1);  

 button = gtk_button_new_with_label ("OK");
 gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
  GTK_SIGNAL_FUNC(CB_open_news_ok), GTK_OBJECT (window2));
 gtk_box_pack_start (GTK_BOX (vbox), button, TRUE, TRUE, 0);
 GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
 gtk_widget_grab_default (button);
 gtk_widget_show (button);

 button = gtk_button_new_with_label ("Get groups list");
 gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
  GTK_SIGNAL_FUNC(CB_open_news_list), GTK_OBJECT (window2));
 gtk_box_pack_start (GTK_BOX (vbox), button, TRUE, TRUE, 0);
 gtk_widget_show (button);
 gtk_widget_show (window2);
}

void CB_open_article(GtkWidget *widget, GtkWidget *entry)
{
 if(window2!=NULL)
 {
  gtk_widget_destroy(window2);
 }
 window2 = gtk_window_new (GTK_WINDOW_TOPLEVEL);
 gtk_signal_connect (GTK_OBJECT (window2), "destroy",
  GTK_SIGNAL_FUNC(CB_open_cancel), &window2);
 gtk_signal_connect (GTK_OBJECT (window2), "delete_event",
  GTK_SIGNAL_FUNC(CB_open_cancel), &window2);
 gtk_window_set_title (GTK_WINDOW (window2), "Which article");
 gtk_container_border_width (GTK_CONTAINER (window2), 2);
 gtk_widget_set_uposition (window2, (x_pos+100), (y_pos+100));
  
 vbox = gtk_vbox_new (FALSE, 0);
 gtk_container_add (GTK_CONTAINER (window2), vbox);
 gtk_container_border_width (GTK_CONTAINER (window2), 5);
 gtk_widget_show (vbox);
  
 label = gtk_label_new ("Which article ID you do you to see:");
 gtk_box_pack_start (GTK_BOX (vbox), label, TRUE, TRUE, 0);
 gtk_widget_show (label);
 
 eb1 = gtk_entry_new ();
 gtk_editable_select_region (GTK_EDITABLE (eb1), 0, -1);
 gtk_box_pack_start (GTK_BOX (vbox), eb1, TRUE, TRUE, 0);
 gtk_widget_show (eb1);

 label = gtk_label_new ("From which newsgroup:");
 gtk_box_pack_start (GTK_BOX (vbox), label, TRUE, TRUE, 0);
 gtk_widget_show (label);
 
 eb2 = gtk_entry_new ();
 gtk_editable_select_region (GTK_EDITABLE (eb2), 0, -1);
 gtk_box_pack_start (GTK_BOX (vbox), eb2, TRUE, TRUE, 0);
 gtk_widget_show (eb2);

 button = gtk_button_new_with_label ("OK");
 gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
  GTK_SIGNAL_FUNC(CB_open_article_ok), GTK_OBJECT (window2));
 gtk_box_pack_start (GTK_BOX (vbox), button, TRUE, TRUE, 0);
 GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
 gtk_widget_grab_default (button);
 gtk_widget_show (button);
 gtk_widget_show (window2);
}

void CB_opennet_ok(GtkWidget *widget, GtkWidget *entry)
{
 char server[255], dir[255], buf[512];
 int i,j;
 modified = 0;
 bzero(server, 255);
 bzero(dir, 255);
 strncpy(buf, gtk_entry_get_text(GTK_ENTRY(entry_box)), 512);
 i=0;
 if(buf[0]=='h' && buf[1]=='t' && buf[2]=='t' && buf[3]=='p')
 {
  for(i=0;i<7;i++) buf[i]=' ';
 }
 j=0;
 for(i=i;(char)buf[i]!=(char)NULL;i++)
 {
  if(buf[i]=='/') break;
  server[j]=buf[i];
  j++;
 }
 j=0;
 for(i=i;(char)buf[i]!=(char)NULL;i++)
 {
  dir[j]=buf[i];
  j++;
 }
 gtk_text_set_point(GTK_TEXT(text), 0);
 gtk_text_forward_delete(GTK_TEXT(text), gtk_text_get_length(GTK_TEXT(text)));
#ifdef USE_NET
 sprintf(line, "GXedit %s - web-get.txt (from %s)", VERSION, buf);
 strcpy(filename, "web-get.txt");
 gtk_window_set_title (GTK_WINDOW (window), line);
 network_fetch(server, dir, convert);
#endif
 gtk_widget_destroy(window2);
 window2 = NULL;
 strcpy(filename, "Unknown filename");
 sprintf(line, "GXedit %s - %s\n", VERSION, filename);
 gtk_window_set_title (GTK_WINDOW (window), line);
}

void CB_opennet_convert(GtkWidget *widget, GtkWidget *entry)
{
 convert = GTK_TOGGLE_BUTTON(widget)->active;
} 

void CB_opennet(GtkWidget *widget, GtkWidget *entry)
{
 convert = 0;
 if(window2!=NULL)
 {
  gtk_widget_destroy(window2);
 }
 window2 = gtk_window_new (GTK_WINDOW_TOPLEVEL);
 gtk_signal_connect (GTK_OBJECT (window2), "destroy",
  GTK_SIGNAL_FUNC(CB_open_cancel), &window2);
 gtk_signal_connect (GTK_OBJECT (window2), "delete_event",
  GTK_SIGNAL_FUNC(CB_open_cancel), &window2);
 gtk_window_set_title (GTK_WINDOW (window2), "Open");
 gtk_container_border_width (GTK_CONTAINER (window2), 2);
 gtk_widget_set_uposition (window2, (x_pos+100), (y_pos+100));
  
 vbox = gtk_vbox_new (FALSE, 0);
 gtk_container_add (GTK_CONTAINER (window2), vbox);
 gtk_container_border_width (GTK_CONTAINER (window2), 5);
 gtk_widget_show (vbox);
  
 label = gtk_label_new ("Enter the URL to fetch (ie. www.darkelf.net/index.html):");
 gtk_box_pack_start (GTK_BOX (vbox), label, TRUE, TRUE, 0);
 gtk_widget_show (label);

 entry_box = gtk_entry_new ();
 gtk_entry_set_text (GTK_ENTRY (entry_box), default_web);
 gtk_editable_select_region (GTK_EDITABLE (entry_box), 0, -1);
 gtk_box_pack_start (GTK_BOX (vbox), entry_box, TRUE, TRUE, 0);
 gtk_widget_show (entry_box);

 cb1 = gtk_check_button_new_with_label("Convert HTML to text"); 
 gtk_signal_connect (GTK_OBJECT(cb1), "toggled",
  GTK_SIGNAL_FUNC(CB_opennet_convert), cb1);
 gtk_box_pack_start (GTK_BOX (vbox), cb1, TRUE, TRUE, 0);
 gtk_widget_show (cb1);

 button = gtk_button_new_with_label ("OK");
 gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
  GTK_SIGNAL_FUNC(CB_opennet_ok), GTK_OBJECT (window2));
 gtk_box_pack_start (GTK_BOX (vbox), button, TRUE, TRUE, 0);
 GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
 gtk_widget_grab_default (button);
 gtk_widget_show (button);
 gtk_widget_show (window2);
}

void CB_msg_ok(GtkWidget *gtklist, gpointer func_data)
{
 GList *dlist;
 dlist = GTK_LIST(gtklist)->selection;
 while (dlist)
 {
  GtkObject *list_item;
  gchar *item_data_string;
  list_item = GTK_OBJECT(dlist->data);
  item_data_string = gtk_object_get_data(list_item, list_item_data_key1);
  sprintf(temp, "/usr/X11R6/bin/xterm -e write %s %s", lindex(item_data_string, 0), lindex(item_data_string, 1));
  system(temp);
  dlist = dlist->next;
 }
 if(window2!=NULL) gtk_widget_destroy(window2);
 window2 = NULL;
 return;
}

void CB_msg(GtkWidget *widget, GtkWidget *entry)
{
 char *string;

 if(window2!=NULL)
 {
  gtk_widget_destroy(window2);
 }

 strncpy(tmp_name, tempnam(NULL,".gxe"), 50);
 sprintf(temp, "who > %s", tmp_name);
 system(temp);
 fd = fopen(tmp_name, "r");
 if(fd==NULL)
 {
  msgbox("Can't run the WHO program\n");
  return;
 }

 window2 = gtk_window_new (GTK_WINDOW_TOPLEVEL);
 gtk_signal_connect (GTK_OBJECT (window2), "destroy",
  GTK_SIGNAL_FUNC(CB_open_cancel), &window2);
 gtk_signal_connect (GTK_OBJECT (window2), "delete_event",
  GTK_SIGNAL_FUNC(CB_open_cancel), &window2);
 gtk_window_set_title (GTK_WINDOW (window2), "Folder list");
 gtk_container_border_width (GTK_CONTAINER (window2), 2);
 gtk_widget_set_usize (window2, 400, 300);
 gtk_widget_set_uposition (window2, 50, 50);
  
 vbox = gtk_vbox_new (FALSE, 0);
 gtk_container_add (GTK_CONTAINER (window2), vbox);
 gtk_container_border_width (GTK_CONTAINER (vbox), 5);
 gtk_widget_show (vbox);

 label = gtk_label_new ("Online users:");
 gtk_box_pack_start (GTK_BOX (vbox), label, TRUE, TRUE, 0); 
 gtk_widget_show (label);

 scrolled_window = gtk_scrolled_window_new(NULL, NULL);
 gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolled_window), GTK_POLICY_AUTOMATIC,GTK_POLICY_AUTOMATIC);
 gtk_widget_set_usize(scrolled_window, 350, 250);
 gtk_container_add(GTK_CONTAINER(vbox), scrolled_window);
 gtk_widget_show(scrolled_window);

 gtklist1 = gtk_list_new();
 gtk_container_add(GTK_CONTAINER(scrolled_window), gtklist1);
 gtk_widget_show(gtklist1);
 gtk_signal_connect(GTK_OBJECT(gtklist1), "selection_changed",
 GTK_SIGNAL_FUNC(CB_msg_ok), NULL);
 gtk_container_set_focus_vadjustment (GTK_CONTAINER (gtklist1),
 gtk_scrolled_window_get_vadjustment(GTK_SCROLLED_WINDOW(scrolled_window)));

 while(fgets(line, 512, fd)!=NULL)
 {
  line[strlen(line)-1]=' ';
  label = gtk_label_new(line);
  list_item1 = gtk_list_item_new_with_label(line);
  gtk_container_add(GTK_CONTAINER(gtklist1), list_item1);
  gtk_widget_show(list_item1);
  gtk_label_get(GTK_LABEL(label), &string);
  gtk_object_set_data(GTK_OBJECT(list_item1), list_item_data_key1, string);
 }

 button = gtk_button_new_with_label ("Cancel");
 gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
  GTK_SIGNAL_FUNC(CB_open_cancel), GTK_OBJECT (window2));
 gtk_box_pack_start (GTK_BOX (vbox), button, TRUE, TRUE, 0);
 gtk_widget_show (button);   
 gtk_widget_show(window2);
 fclose(fd);
}

void CB_print(GtkWidget *widget, GtkWidget *entry)
{
 GList *cbitems = NULL;
 int i;

 if(window2!=NULL)
 {
  gtk_widget_destroy(window2);
 }
 strncpy(tmp_name, tempnam(NULL,".gxe"), 50);
 fd=fopen(tmp_name, "w");
 if(fd==NULL)
 {
  print_debug("Can't open temporary file in /tmp\n");
  return;
 }
 fputs((char *)gtk_editable_get_chars(GTK_EDITABLE (text), 0, gtk_text_get_length(GTK_TEXT(text))),fd);
 if(fd!=NULL) fclose(fd);

 window2 = gtk_window_new (GTK_WINDOW_TOPLEVEL);
 gtk_signal_connect (GTK_OBJECT (window2), "destroy",
  GTK_SIGNAL_FUNC(CB_open_cancel), &window2);
 gtk_signal_connect (GTK_OBJECT (window2), "delete_event",
  GTK_SIGNAL_FUNC(CB_open_cancel), &window2);  
 gtk_window_set_title (GTK_WINDOW (window2), "Print");
 gtk_container_border_width (GTK_CONTAINER (window2), 2);
 gtk_widget_set_uposition (window2, (x_pos+100), (y_pos+100));

 vbox = gtk_vbox_new (FALSE, 0);
 gtk_container_add (GTK_CONTAINER (window2), vbox);
 gtk_container_border_width (GTK_CONTAINER (window2), 5);
 gtk_widget_show (vbox);

 cbitems = g_list_append(cbitems, "default");
 fd = fopen("/etc/printcap", "r");
 if(fd!=NULL)
 {
  while(fgets(line, 255, fd)!=NULL)
  {
   if(line!=NULL && line[0]!='#' && line[0]!=' ' && line[0]!='\t')
   {
    bzero(temp, 512);
    for(i=0;line[i]!='|';i++)
    {
     if(line[i]=='\0') break;
     if(line[i]==':') break;
     if(line[i]==' ') break;
     temp[i]=line[i];
    }
    cbitems = g_list_append(cbitems, g_strdup(temp));
   }
   bzero(line, 513);
  }
  fclose(fd);
 }

 eb11 = gtk_combo_new ();
 gtk_combo_set_popdown_strings (GTK_COMBO (eb11), cbitems);
 gtk_entry_set_text (GTK_ENTRY (GTK_COMBO(eb11)->entry), "default");
 gtk_box_pack_start (GTK_BOX (vbox), eb11, TRUE, TRUE, 0);
 gtk_widget_show (eb11);

 label = gtk_label_new ("Print command and optional flags:");
 gtk_box_pack_start (GTK_BOX (vbox), label, TRUE, TRUE, 0);
 gtk_widget_show (label);

 entry_box = gtk_entry_new ();
 gtk_editable_select_region (GTK_EDITABLE (entry_box), 0, -1);
 gtk_box_pack_start (GTK_BOX (vbox), entry_box, TRUE, TRUE, 0);
 gtk_entry_set_text (GTK_ENTRY(entry_box), "lpr");
 gtk_widget_show (entry_box);

 button = gtk_button_new_with_label ("Print");
 gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
  GTK_SIGNAL_FUNC(CB_print_ok), GTK_OBJECT (window2));
 gtk_box_pack_start (GTK_BOX (vbox), button, TRUE, TRUE, 0);
 GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
 gtk_widget_grab_default (button);
 gtk_widget_show (button);
 gtk_widget_show (window2);
}

void CB_run_bg(GtkWidget *widget, GtkWidget *entry)
{
 run_in_bg = GTK_TOGGLE_BUTTON(widget)->active;
}

void CB_run_xterm(GtkWidget *widget, GtkWidget *entry)
{
 run_in_xterm = GTK_TOGGLE_BUTTON(widget)->active;
}

void CB_run(GtkWidget *widget, gpointer data)
{
 run_in_bg = 1; run_in_xterm = 0;
 if(window2!=NULL)
 {
  gtk_widget_destroy(window2);
 }
 window2 = gtk_window_new (GTK_WINDOW_TOPLEVEL);
 gtk_signal_connect (GTK_OBJECT (window2), "destroy",
  GTK_SIGNAL_FUNC(CB_open_cancel), &window2);
 gtk_signal_connect (GTK_OBJECT (window2), "delete_event",
  GTK_SIGNAL_FUNC(CB_open_cancel), &window2);
 gtk_window_set_title (GTK_WINDOW (window2), "Run");
 gtk_container_border_width (GTK_CONTAINER (window2), 2);
 gtk_widget_set_uposition (window2, (x_pos+100), (y_pos+100));
 
 vbox = gtk_vbox_new (FALSE, 0);
 gtk_container_add (GTK_CONTAINER (window2), vbox);
 gtk_container_border_width (GTK_CONTAINER (window2), 5);
 gtk_widget_show (vbox);
 
 label = gtk_label_new ("Enter the shell command or file to run:");
 gtk_box_pack_start (GTK_BOX (vbox), label, TRUE, TRUE, 0);
 gtk_widget_show (label);
 
 entry_box = gtk_entry_new ();
 gtk_editable_select_region (GTK_EDITABLE (entry_box), 0, -1);
 gtk_box_pack_start (GTK_BOX (vbox), entry_box, TRUE, TRUE, 0);
 gtk_widget_show (entry_box);

 cb1 = gtk_check_button_new_with_label("Go to background");
 gtk_signal_connect (GTK_OBJECT(cb1), "toggled",
  GTK_SIGNAL_FUNC(CB_run_bg), cb1);
 gtk_box_pack_start (GTK_BOX (vbox), cb1, TRUE, TRUE, 0);
 gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(cb1), TRUE);
 gtk_widget_show (cb1);

 cb1 = gtk_check_button_new_with_label("In an xterm");
 gtk_signal_connect (GTK_OBJECT(cb1), "toggled",
  GTK_SIGNAL_FUNC(CB_run_xterm), cb1);
 gtk_box_pack_start (GTK_BOX (vbox), cb1, TRUE, TRUE, 0);
 gtk_widget_show (cb1);

 button = gtk_button_new_with_label ("OK");
 gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
  GTK_SIGNAL_FUNC(CB_run_ok), GTK_OBJECT (window2));
 gtk_box_pack_start (GTK_BOX (vbox), button, TRUE, TRUE, 0);  
 GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
 gtk_widget_grab_default (button);
 gtk_widget_show (button);
 gtk_widget_show (window2);
}

void CB_exit_ok(GtkWidget *widget, GtkWidget *entry)
{
 system("rm -f /tmp/.gxe* 2> /dev/null");
 exit(0);
}

void CB_exit(GtkWidget *widget, gpointer data)
{
 if(modified)
 {
  if(window2!=NULL)
  {
   gtk_widget_destroy(window2);
  }
  window2 = gtk_dialog_new ();
  gtk_widget_set_usize (GTK_WIDGET (window2), 400, 100);
  gtk_signal_connect (GTK_OBJECT (window2), "destroy",
   GTK_SIGNAL_FUNC(CB_msgbox_close), &window2);
  gtk_signal_connect (GTK_OBJECT (window2), "delete_event",
   GTK_SIGNAL_FUNC(CB_msgbox_close), &window2);
  gtk_window_set_title (GTK_WINDOW (window2), "GXedit");
  gtk_container_border_width (GTK_CONTAINER (window2), 0);
  gtk_widget_set_uposition (window2, (x_pos+50), (y_pos+50));
   
  label = gtk_label_new ("Text was modified. Are you sure you want to quit?");
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (window2)->vbox),
   label, TRUE, TRUE, 0);
  gtk_widget_show (label);
 
  button = gtk_button_new_with_label ("Yes");
  gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
   GTK_SIGNAL_FUNC(CB_exit_ok), GTK_OBJECT (window2));
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (window2)->action_area),
   button, TRUE, TRUE, 0);
  gtk_widget_show (button);
 
  button = gtk_button_new_with_label ("No");
  gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
   GTK_SIGNAL_FUNC(CB_msgbox_close), GTK_OBJECT (window2));
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (window2)->action_area),
   button, TRUE, TRUE, 0);
  gtk_widget_show (button);
  gtk_widget_show (window2);
 }
 else
 {
  gtk_widget_destroy(window);
  gtk_main_quit();
  system("rm -f /tmp/.gxe* 2> /dev/null");
  exit(0);
 }
}

void CB_new(GtkWidget *widget, gpointer data)
{
 strcpy(filename, "Unknown filename");
 sprintf(line, "GXedit %s - %s\n", VERSION, filename);
 gtk_window_set_title (GTK_WINDOW (window), line);
 gtk_text_set_point(GTK_TEXT(text), 0);
 gtk_text_forward_delete(GTK_TEXT(text),
 gtk_text_get_length(GTK_TEXT(text)));
 modified = 0;
}

void CB_undo_as(GtkWidget *widget, GtkWidget *entry)   
{
 sprintf(temp, "%s/.gxedit.autosave", home);
 open_file(temp, "Can't open AUTOSAVE file for reading\n");
} 

void CB_undo(GtkWidget *widget, GtkWidget *entry)
{
 sprintf(temp, "%s/.gxedit.undo", home);
 open_file(temp, "Can't open UNDO file for reading\n");
}

void CB_open_ok(GtkWidget *widget, GtkFileSelection *fs)
{
 char buf[100], buf2[200];
 modified = 0;
 strncpy(buf,gtk_file_selection_get_filename(GTK_FILE_SELECTION(fs)),100);
 if(tolower(buf[strlen(buf)-3])=='g'
  && tolower(buf[strlen(buf)-2])=='i'
  && tolower(buf[strlen(buf)-1])=='f')
 {
  sprintf(buf2, "%s %s &", images, buf);
  system(buf2);
  gtk_widget_destroy(window2);
  window2 = NULL;
  return;
 }
 else if(tolower(buf[strlen(buf)-3])=='j'
  && tolower(buf[strlen(buf)-2])=='p'
  && tolower(buf[strlen(buf)-1])=='g')
 {
  sprintf(buf2, "%s %s &", images, buf);
  system(buf2);
  gtk_widget_destroy(window2);
  window2 = NULL;
  return;
 }
 else if(tolower(buf[strlen(buf)-3])=='t'
  && tolower(buf[strlen(buf)-2])=='i'
  && tolower(buf[strlen(buf)-1])=='f') 
 {
  sprintf(buf2, "%s %s &", images, buf);
  system(buf2);
  gtk_widget_destroy(window2);
  window2 = NULL;
  return;
 }
 else if(tolower(buf[strlen(buf)-3])=='f'
  && tolower(buf[strlen(buf)-2])=='i'
  && tolower(buf[strlen(buf)-1])=='t') 
 {
  sprintf(buf2, "%s %s &", images, buf);
  system(buf2);
  gtk_widget_destroy(window2);
  window2 = NULL;
  return;
 }
 else if(tolower(buf[strlen(buf)-3])=='b'
  && tolower(buf[strlen(buf)-2])=='m'
  && tolower(buf[strlen(buf)-1])=='p') 
 {
  sprintf(buf2, "%s %s &", images, buf);
  system(buf2);
  gtk_widget_destroy(window2);
  window2 = NULL;
  return;
 }
 else
 {
  strcpy(filename,buf);
  sprintf(line, "GXedit %s - %s\n", VERSION, filename);
  sprintf(temp, "%s/.gxedit.last", home);
  fd = fopen(temp, "a");
  if(fd!=NULL)
  {
   fputs(filename, fd);
   fputs("\n", fd);
   fclose(fd);
  }
  gtk_window_set_title (GTK_WINDOW (window), line);
  gtk_widget_destroy(window2);
  window2 = NULL;
  open_file(filename, "Can't open file for reading\n");
  sprintf(temp, "%s.gxnote", filename);
  fd = fopen(temp, "r");
  if(fd!=NULL)
  {
   create_note(fd);
   fclose(fd);
  }
  return;
 }
}

void delete_note(GtkWidget *widget, GtkWidget *event)
{
 gtk_widget_destroy(noteWin);
}

void create_note(FILE *nd)
{
 fgets(temp, 1000, nd);
 if(noteWin!=NULL) gtk_widget_destroy(noteWin);
 noteWin = gtk_window_new (GTK_WINDOW_TOPLEVEL);
 gtk_widget_set_usize (GTK_WIDGET (noteWin), 150, 70);
 gtk_signal_connect (GTK_OBJECT (noteWin), "destroy", 
  GTK_SIGNAL_FUNC(delete_note), &noteWin);
 gtk_signal_connect (GTK_OBJECT (noteWin), "delete_event",
  GTK_SIGNAL_FUNC(delete_note), &noteWin);
 gtk_window_set_title (GTK_WINDOW (noteWin), "File note");
 gtk_container_border_width (GTK_CONTAINER (noteWin), 0);

 vbox = gtk_vbox_new (FALSE, 0);
 gtk_container_add (GTK_CONTAINER (noteWin), vbox);
 gtk_widget_show (vbox);

 text2 = gtk_text_new(NULL, NULL);
 gtk_text_set_editable (GTK_TEXT (text2), FALSE);
 gtk_text_set_word_wrap(GTK_TEXT (text2), TRUE);
 gtk_box_pack_start (GTK_BOX (vbox), text2, TRUE, TRUE, 0);
 gtk_widget_show (text2);
 gtk_widget_show(noteWin);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, temp, -1);
}

void open_file(char *file, char *errmsg)
{
 int i;
 fd = fopen(file,"r");
 if(fd==NULL)
 {
  print_debug(errmsg);
  msgbox(errmsg);
  return;
 }
 gtk_text_freeze(GTK_TEXT(text));
 gtk_text_set_point(GTK_TEXT(text), 0);
 gtk_text_forward_delete(GTK_TEXT(text),gtk_text_get_length(GTK_TEXT(text)));
 i=0;
 while(fgets(line,512,fd)!=NULL)
 {
  i++;
  gtk_text_insert (GTK_TEXT (text), NULL, &color, NULL, line, -1);
 }
 gtk_text_thaw (GTK_TEXT (text));
 sprintf(temp, "File loaded (%d lines)\n", i+1);
 print_debug(temp);
 fclose(fd);
#ifdef GTKEDITOR_PATCH
 if(syntax_h)
  gtk_editor_hilite_buffer(GTK_EDITOR(text));
#endif
 return;
}

void CB_about_close(GtkWidget *widget, GtkWidget *entry)
{
 gtk_widget_destroy(window2);
 window2 = NULL;
}

void CB_open_window_ok(GtkWidget *widget, GtkFileSelection *fs)   
{
 sprintf(line, "%s %s &", progname, gtk_file_selection_get_filename(GTK_FILE_SELECTION(fs)));
 system(line);
 gtk_widget_destroy(window2);
 window2 = NULL;
}

void CB_open_window(GtkWidget *widget, GtkWidget *entry)
{ 
 if(window2!=NULL)
 {
  gtk_widget_destroy(window2);
 }
 window2 = gtk_file_selection_new ("Open file");
 gtk_signal_connect (GTK_OBJECT (window2), "destroy",
  GTK_SIGNAL_FUNC(CB_open_cancel), &window2);
 gtk_signal_connect (GTK_OBJECT (window2), "delete_event",
  GTK_SIGNAL_FUNC(CB_open_cancel), &window2);   
 gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION(window2)->ok_button),
  "clicked", GTK_SIGNAL_FUNC(CB_open_window_ok), window2);
 gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(window2)->cancel_button),
  "clicked", GTK_SIGNAL_FUNC(CB_open_cancel), &window2);
 gtk_widget_set_uposition (window2, (x_pos+50), (y_pos+50));
 gtk_widget_show (window2);
}

void CB_open_mail_ok(GtkWidget *gtklist, gpointer func_data)
{
 int i = 0;
 GList *dlist;
 dlist = GTK_LIST(gtklist)->selection;
 modified = 0;
 sprintf(line, "%s/%s", MAIL_PATH, login);
 fd = fopen(line, "r");
 while (dlist)
 {
  GtkObject *list_item;
  gchar *item_data_string;
  list_item = GTK_OBJECT(dlist->data);
  item_data_string = gtk_object_get_data(list_item, list_item_data_key1);  
  while(fgets(line, 512, fd)!=NULL)
  {
   if(!strcmp(lindex(line,0),"From")) i++;
   if(i==atoi(lindex(item_data_string,0))) break;
  }
  strncpy(subject, lrange(item_data_string,2), 50);
  gtk_text_set_point(GTK_TEXT(text), 0);
  gtk_text_forward_delete(GTK_TEXT(text), gtk_text_get_length(GTK_TEXT(text)));
  gtk_text_freeze(GTK_TEXT (text));
  while(fgets(line, 512, fd)!=NULL)
  {
   if(!strcmp(lindex(line,0),"From")) break;
   if(reply)
   {
    sprintf(temp, "> %s", line);
    gtk_text_insert (GTK_TEXT (text), NULL, &color, NULL, temp, -1);
   }
   else gtk_text_insert (GTK_TEXT (text), NULL, &color, NULL, line, -1);
  }
  if(reply)
  {
   sprintf(temp, "%s/.signature", home);
   fd2 = fopen(temp, "r");
   if(fd2!=NULL)
   {
    while(fgets(line, 512, fd2)!=NULL)
    {
     gtk_text_insert (GTK_TEXT (text), NULL, &color, NULL, line, -1);
    }
    fclose(fd2);
   }
  }
  gtk_text_thaw(GTK_TEXT (text));
  dlist = dlist->next;
 }
 if(fd!=NULL) fclose(fd);
 if(window2!=NULL) gtk_widget_destroy(window2);
 window2 = NULL;
 strcpy(filename, "Unknown filename");
 sprintf(line, "GXedit %s - %s\n", VERSION, filename);
 gtk_window_set_title (GTK_WINDOW (window), line);
}

void CB_open_mail(GtkWidget *widget, GtkWidget *entry)
{
 int i = 1;
 char *string;
 if(window2!=NULL)
 {
  gtk_widget_destroy(window2);
 }
 sprintf(line, "%s/%s", MAIL_PATH, login);
 fd = fopen(line, "r");
 if(fd==NULL)
 {
  msgbox("Can't open mail file");
  return;
 }

 window2 = gtk_window_new (GTK_WINDOW_TOPLEVEL);
 gtk_signal_connect (GTK_OBJECT (window2), "destroy",
  GTK_SIGNAL_FUNC(CB_open_cancel), &window2);
 gtk_signal_connect (GTK_OBJECT (window2), "delete_event",
  GTK_SIGNAL_FUNC(CB_open_cancel), &window2);
 gtk_window_set_title (GTK_WINDOW (window2), "Folder list");
 gtk_container_border_width (GTK_CONTAINER (window2), 2);
 gtk_widget_set_usize (window2, 400, 300);
 gtk_widget_set_uposition (window2, 50, 50);

 vbox = gtk_vbox_new (FALSE, 0);
 gtk_container_add (GTK_CONTAINER (window2), vbox);
 gtk_container_border_width (GTK_CONTAINER (vbox), 5);
 gtk_widget_show (vbox);

 label = gtk_label_new ("Mail folder:");
 gtk_box_pack_start (GTK_BOX (vbox), label, TRUE, TRUE, 0);
 gtk_widget_show (label);

 scrolled_window = gtk_scrolled_window_new(NULL, NULL);
 gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolled_window),GTK_POLICY_AUTOMATIC,GTK_POLICY_AUTOMATIC);
 gtk_widget_set_usize(scrolled_window, 350, 250);
 gtk_container_add(GTK_CONTAINER(vbox), scrolled_window);
 gtk_widget_show(scrolled_window);
 
 gtklist1 = gtk_list_new();
 gtk_container_add(GTK_CONTAINER(scrolled_window), gtklist1);
 gtk_widget_show(gtklist1);
 gtk_signal_connect(GTK_OBJECT(gtklist1), "selection_changed",
 GTK_SIGNAL_FUNC(CB_open_mail_ok), NULL);
 gtk_container_set_focus_vadjustment (GTK_CONTAINER (gtklist1),
 gtk_scrolled_window_get_vadjustment(GTK_SCROLLED_WINDOW(scrolled_window)));

 /* because the file begins with a From.. */
 fgets(line, 512, fd);
 sprintf(temp, "%d - No subject        ", i);

 while(fgets(line, 512, fd)!=NULL)
 {
  if(!strcasecmp(lindex(line,0),"Subject:"))
  {
   sprintf(temp, "%d - %s", i, lrange(line,1));
  }
  if(!strcmp(lindex(line,0),"From"))
  {
   temp[strlen(temp)-1]=' ';
   temp[strlen(temp)-2]=' ';
   label = gtk_label_new(temp);
   list_item1 = gtk_list_item_new_with_label(temp);
   gtk_container_add(GTK_CONTAINER(gtklist1), list_item1);
   gtk_widget_show(list_item1);
   gtk_label_get(GTK_LABEL(label), &string);
   gtk_object_set_data(GTK_OBJECT(list_item1), list_item_data_key1, string);
   i++;
   sprintf(temp, "%d - No subject          ", i);
  }
 }
 /* because a mail file doesn't end with a From.. */
 temp[strlen(temp)-1]=' ';
 temp[strlen(temp)-2]=' ';
 label = gtk_label_new(temp);
 list_item1 = gtk_list_item_new_with_label(temp);
 gtk_container_add(GTK_CONTAINER(gtklist1), list_item1);  
 gtk_widget_show(list_item1);
 gtk_label_get(GTK_LABEL(label), &string);
 gtk_object_set_data(GTK_OBJECT(list_item1), list_item_data_key1, string);

 button = gtk_button_new_with_label ("Cancel");
 gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
  GTK_SIGNAL_FUNC(CB_open_cancel), GTK_OBJECT (window2));
 gtk_box_pack_start (GTK_BOX (vbox), button, TRUE, TRUE, 0);
 gtk_widget_show (button);
 gtk_widget_show(window2);
 fclose(fd);
}

void CB_mins(GtkWidget *widget, GtkWidget *entry)
{
 original = -1;
 msgbox("Close this dialog box and begin typing as fast as you can.\nWhen 1 minute has passed, you will see the results.\n");
}

void CB_agenda_open(GtkWidget *widget, GtkWidget *entry)
{
 sprintf(temp, "%s/.gxedit.agenda.%s%s%s", home, 
 gtk_entry_get_text(GTK_ENTRY(eb1)),
 gtk_entry_get_text(GTK_ENTRY(eb2)),
 gtk_entry_get_text(GTK_ENTRY(eb3)));
 gtk_text_set_point(GTK_TEXT(text), 0);
 gtk_text_forward_delete(GTK_TEXT(text),
 gtk_text_get_length(GTK_TEXT(text)));
 fd = fopen(temp, "r");
 if(fd!=NULL)
 {
  while(fgets(line, 512, fd)!=NULL)
  gtk_text_insert (GTK_TEXT (text), NULL, &color, NULL, line, -1);
  fclose(fd);
 }
 else gtk_text_insert (GTK_TEXT (text), NULL, &color, NULL, "Nothing for that date\n", -1);
 gtk_widget_destroy(window2);
 strcpy(filename, "Unknown filename");
 sprintf(line, "GXedit %s - %s\n", VERSION, filename);
 gtk_window_set_title (GTK_WINDOW (window), line);
}

void CB_agenda_save(GtkWidget *widget, GtkWidget *entry)  
{
 sprintf(temp, "%s/.gxedit.agenda.%s%s%s", home,
 gtk_entry_get_text(GTK_ENTRY(eb1)),
 gtk_entry_get_text(GTK_ENTRY(eb2)),
 gtk_entry_get_text(GTK_ENTRY(eb3)));
 fd = fopen(temp, "w");
 if(fd==NULL)
 {
  print_debug("Can't open file for saving\n");
  return;
 }
 fputs((char *)gtk_editable_get_chars(GTK_EDITABLE (text), 0, gtk_text_get_length(GTK_TEXT(text))),fd);
 if(fd!=NULL) fclose(fd);
 print_debug("File saved.\n");
 gtk_widget_destroy(window2);
 modified = 0;
}

void CB_agenda_cal(GtkWidget *widget, GtkWidget *entry)
{
 strncpy(tmp_name, tempnam(NULL,".gxe"), 50);
 sprintf(temp, "cal %s > %s", gtk_entry_get_text(GTK_ENTRY(eb1)), tmp_name);
 system(temp);
 open_file(tmp_name, "Can't run the calendar command\n");
 gtk_widget_destroy(window2);
}

void CB_agenda(gint type, GtkWidget *entry)
{
 time_t lt;
 struct tm *current;
 lt = time(NULL);
 current = localtime(&lt);

 window2 = gtk_window_new (GTK_WINDOW_TOPLEVEL);
 gtk_signal_connect (GTK_OBJECT (window2), "destroy",
  GTK_SIGNAL_FUNC(CB_open_cancel), &window2);
 gtk_signal_connect (GTK_OBJECT (window2), "delete_event",
  GTK_SIGNAL_FUNC(CB_open_cancel), &window2);
 gtk_window_set_title (GTK_WINDOW (window2), "Agenda");
 gtk_container_border_width (GTK_CONTAINER (window2), 2);
 gtk_widget_set_usize (window2, 300, 150);
 gtk_widget_set_uposition (window2, 100, 100);

 vbox = gtk_vbox_new (FALSE, 0);
 gtk_container_add (GTK_CONTAINER (window2), vbox);
 gtk_container_border_width (GTK_CONTAINER (window2), 5);
 gtk_widget_show (vbox);

 hbox = gtk_hbox_new (FALSE, 10);
 gtk_container_border_width (GTK_CONTAINER (hbox), 0);
 gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 0);
 gtk_widget_show (hbox);

 label = gtk_label_new ("Date: Year (ie. 1998):");
 gtk_box_pack_start (GTK_BOX (hbox), label, TRUE, TRUE, 0);
 gtk_widget_show (label);

 sprintf(temp, "19%d", current->tm_year);
 eb1 = gtk_entry_new();
 gtk_editable_select_region (GTK_EDITABLE (eb1), 0, -1);
 gtk_box_pack_start (GTK_BOX (hbox), eb1, TRUE, TRUE, 0);
 gtk_entry_set_text (GTK_ENTRY (eb1), temp);
 gtk_widget_show (eb1);

 hbox = gtk_hbox_new (FALSE, 10);
 gtk_container_border_width (GTK_CONTAINER (hbox), 0);
 gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 0);
 gtk_widget_show (hbox);
 
 label = gtk_label_new ("Month (ie. 5):");
 gtk_box_pack_start (GTK_BOX (hbox), label, TRUE, TRUE, 0);
 gtk_widget_show (label);

 sprintf(temp, "%d", (current->tm_mon+1));
 eb2 = gtk_entry_new();
 gtk_editable_select_region (GTK_EDITABLE (eb2), 0, -1);
 gtk_box_pack_start (GTK_BOX (hbox), eb2, TRUE, TRUE, 0);
 gtk_entry_set_text (GTK_ENTRY (eb2), temp);
 gtk_widget_show (eb2);

 hbox = gtk_hbox_new (FALSE, 10);
 gtk_container_border_width (GTK_CONTAINER (hbox), 0);
 gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 0);
 gtk_widget_show (hbox);

 label = gtk_label_new ("Day (ie. 27):");
 gtk_box_pack_start (GTK_BOX (hbox), label, TRUE, TRUE, 0);
 gtk_widget_show (label);

 sprintf(temp, "%d", current->tm_mday);
 eb3 = gtk_entry_new();
 gtk_editable_select_region (GTK_EDITABLE (eb3), 0, -1);
 gtk_box_pack_start (GTK_BOX (hbox), eb3, TRUE, TRUE, 0);
 gtk_entry_set_text (GTK_ENTRY (eb3), temp);
 gtk_widget_show (eb3);
 
 button = gtk_button_new_with_label ("OK");
 if(type==0)
 gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
  GTK_SIGNAL_FUNC(CB_agenda_open), GTK_OBJECT (window2));
 else
 gtk_signal_connect_object (GTK_OBJECT (button), "clicked", 
  GTK_SIGNAL_FUNC(CB_agenda_save), GTK_OBJECT (window2));
 gtk_box_pack_start (GTK_BOX (vbox), button, TRUE, TRUE, 0);
 gtk_widget_show (button);

 button = gtk_button_new_with_label ("Show calendar");
 gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
  GTK_SIGNAL_FUNC(CB_agenda_cal), GTK_OBJECT (window2));  
 gtk_box_pack_start (GTK_BOX (vbox), button, TRUE, TRUE, 0);
 gtk_widget_show (button);
 gtk_widget_show (window2);
}

void CB_open(GtkWidget *widget, gpointer data)
{
 if(window2!=NULL)
 {
  gtk_widget_destroy(window2);
 }
 window2 = gtk_file_selection_new ("Open file");
 gtk_signal_connect (GTK_OBJECT (window2), "destroy",
  GTK_SIGNAL_FUNC(CB_open_cancel), &window2);
 gtk_signal_connect (GTK_OBJECT (window2), "delete_event",
  GTK_SIGNAL_FUNC(CB_open_cancel), &window2);
 gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION(window2)->ok_button),
  "clicked", GTK_SIGNAL_FUNC(CB_open_ok), window2);
 gtk_signal_connect (GTK_OBJECT(GTK_FILE_SELECTION(window2)->cancel_button),
  "clicked", GTK_SIGNAL_FUNC(CB_open_cancel), &window2);
 gtk_widget_set_uposition (window2, (x_pos+50), (y_pos+50));
 gtk_widget_show (window2);
}

void CB_import_rot13(GtkWidget *widget, GtkFileSelection *fs)
{
 char inchar;
 fd = fopen(gtk_file_selection_get_filename(GTK_FILE_SELECTION(fs)), "r");
 if(fd==NULL)
 {
  print_debug("Can't open file\n");
  msgbox("Can't open file for reading");
  return;
 }
 gtk_text_set_point(GTK_TEXT(text), 0);
 gtk_text_forward_delete(GTK_TEXT(text),
 gtk_text_get_length(GTK_TEXT(text)));
 gtk_text_freeze(GTK_TEXT(text));
 while((inchar=fgetc(fd))!=EOF)
 {
  sprintf(line, "%c", ndcode(inchar)); /* to prevent cast warnings */
  gtk_text_insert (GTK_TEXT (text), NULL, &color, NULL, line, -1);
 }
 gtk_text_thaw(GTK_TEXT(text));
 fclose(fd);
 gtk_widget_destroy(window2);
}

void CB_import_ps(GtkWidget *widget, GtkFileSelection *fs)
{
 /* this function based on ps2ascii-2 */
 char buf[101], junk[80];
 int ch, prev_ch = '\n', in_paren = 0, b_flag = 0, b_space = 1, lines, broke;
 strncpy(buf,gtk_file_selection_get_filename(GTK_FILE_SELECTION(fs)),100);
 gtk_text_set_point(GTK_TEXT(text), 0);
 gtk_text_forward_delete(GTK_TEXT(text),
 gtk_text_get_length(GTK_TEXT(text)));  
 fd = fopen(buf,"r");
 if(fd==NULL)
 {
  print_debug("Can't open file\n");
  msgbox("Can't open file for reading");
  return;
 }
 strncpy(tmp_name, tempnam(NULL,".gxe"), 50);
 fd2 = fopen(tmp_name, "w");
 if(fd2==NULL)
 {
  print_debug("Can't open temporary file\n");
  return;
 }
 lines = 0; broke = 0;
 while ((ch = fgetc(fd)) != EOF)
 {
  lines++;
  if (ch == '\n') ch = fgetc(fd);
  if (in_paren)
   switch(ch)
   {
    case ')'  : in_paren--; b_flag=1; break;
    case '\n' : fputc(' ', fd2); break;
    case '\\' :
     switch(ch=fgetc(fd))
     {
      case '(' :
      case ')' : fputc(ch, fd2); break;
      case 't' : fputc('\t', fd2); break;
      case 'n' : fputc('\n', fd2); break;
      case '\\': fputc('"', fd2); break;
      case '0' : switch(ch=fgetc(fd))
      {
       case '1': switch(ch=fgetc(fd))
       {
        case '3' : fputs("ff", fd2); break;
        case '4' : fputs("fi", fd2); break;
        case '5' : fputs("fl", fd2); break;
        case '6' : fputs("ffi", fd2); break;
        case '7' : fputs("ffl", fd2); break;
        default: broke++; fputc(ch, fd2);
       } break;
       default: broke++; fputc(ch, fd2);
      } break;
      case '1' : case '2' : case '3' : case '4' :
      case '5' : case '6' : case '7' : fputc('\\', fd2);
      default: broke++; fputc(ch, fd2);
     } break;
     default: broke++; fputc(ch, fd2);
    }
    else
    switch(ch)
    {
     case '%'  : fgets(junk, 80, fd); break;
     case '\n' : break;
     case '-'  : if (b_flag)
     {
      b_flag = 0;
      b_space = 0;
     } break;
     case '('  : in_paren++;
     switch(prev_ch)
     {
      case 'l' : case 'm' : case 'n' : case 'o' :
      case 'q' : case 'r' : case 's' : case 't' :
      break;
      case 'y' : fputc('\n', fd2); break;
      case 'b' : if (b_space) fputc(' ', fd2); break; 
      case 'a' : case 'c' : case 'd' : case 'e' :
      case 'f' : case 'g' : case 'h' : case 'i' :
      case 'j' : case 'k' : case 'x' : fputc(' ', fd2); break;
     default: break;
    }
    b_space = 1;
    break;
   default: b_flag = 0; break;
  }
  prev_ch=ch; 
 }
 fclose(fd);
 fclose(fd2);
 fd = fopen(tmp_name, "r");
 gtk_text_freeze(GTK_TEXT(text));
 while(fgets(line,512,fd)!=NULL)
 {
  gtk_text_insert (GTK_TEXT (text), NULL, &color, NULL, line, -1);
 }
 gtk_text_thaw (GTK_TEXT (text));
 gtk_widget_destroy(window2);
 sprintf(temp, "Converted. Text broken at %d%%", ((broke*100)/lines));
 msgbox(temp);
 fclose(fd);
}

void CB_import_rtf(GtkWidget *widget, GtkFileSelection *fs)
{
 char buf[101];
 int slash=0, com=0, i, lines, broke;
 strncpy(buf,gtk_file_selection_get_filename(GTK_FILE_SELECTION(fs)),100);
 gtk_text_set_point(GTK_TEXT(text), 0);
 gtk_text_forward_delete(GTK_TEXT(text),
 gtk_text_get_length(GTK_TEXT(text)));
 fd = fopen(buf,"r");
 if(fd==NULL)
 {
  print_debug("Can't open file\n");
  msgbox("Can't open file for reading");
  return;
 }
 strncpy(tmp_name, tempnam(NULL,".gxe"), 50);
 fd2 = fopen(tmp_name, "w");
 if(fd2==NULL)
 {
  print_debug("Can't open temporary file\n");
  return;
 }
 lines = 0; broke = 0;
 while(fgets(line, 512, fd)!=NULL)
 {
  lines++;
  for(i=0;line[i]!='\0';i++)
  {
   if(line[i]=='\\') slash=1;
   if(line[i]=='{') { com=1; broke++; }
   if(line[i]=='}') com=0;
   if(line[i]==' ') slash=0;
   if(slash==0 && com==0 && line[i]!='{' && line[i]!='}' && line[i]!='\\')
   fputc(line[i], fd2);
  }
 }
 fclose(fd);
 fclose(fd2);
 fd = fopen(tmp_name, "r");
 gtk_text_freeze(GTK_TEXT(text));
 while(fgets(line,512,fd)!=NULL)
 {
  gtk_text_insert (GTK_TEXT (text), NULL, &color, NULL, line, -1);
 }
 gtk_text_thaw (GTK_TEXT (text));
 gtk_widget_destroy(window2);
 sprintf(temp, "Converted. Text broken at %d%%", ((broke*100)/lines));
 msgbox(temp);
 fclose(fd);
}

void CB_import_man(GtkWidget *widget, GtkFileSelection *fs)
{
 char buf[101];
 int lines, broke;
 strncpy(buf,gtk_file_selection_get_filename(GTK_FILE_SELECTION(fs)),100);
 if(buf[strlen(buf)-1]=='z')
 {
  system("rm -f /tmp/file.man.gz");
  sprintf(temp,"cp %s /tmp/file.man.gz",buf);
  system(temp);
  sprintf(temp,"%s /tmp/file.man.gz",gzip);
  system(temp);
 }
 else
 {
  sprintf(temp,"cp %s /tmp/file.man",buf);
  system(temp);
 }
 gtk_text_set_point(GTK_TEXT(text), 0);
 gtk_text_forward_delete(GTK_TEXT(text),
 gtk_text_get_length(GTK_TEXT(text)));
 fd = fopen("/tmp/file.man","r");
 if(fd==NULL)
 {
  print_debug("Can't open file for reading\n");
  msgbox("Can't open file for reading");
  return;
 }
 gtk_text_freeze(GTK_TEXT(text));
 lines = 0; broke = 0;
 while(fgets(line,512,fd)!=NULL)
 {
  lines++;
  line[strlen(line)-1]=' ';
  if(lindex(line,0)==NULL) strcpy(line,". ");
  if(!strcasecmp(lindex(line,0),".SH"))
  {
   gtk_text_insert (GTK_TEXT (text), NULL, &color, NULL, "\n\n", -1);
   gtk_text_insert (GTK_TEXT (text), NULL, &html, NULL, lrange(line,1), -1);
   gtk_text_insert (GTK_TEXT (text), NULL, &color, NULL, "\n\n", -1);
  }
  else if(!strcasecmp(lindex(line,0),".B") || !strcasecmp(lindex(line,0),".I") || !strcasecmp(lindex(line,0),".BI") || !strcasecmp(lindex(line,0),".IB"))
  {
   gtk_text_insert (GTK_TEXT (text), NULL, &html, NULL, lrange(line,1), -1);
  }
  else if(!strcasecmp(lindex(line,0),".BR") || !strcasecmp(lindex(line,0),".NL"))
  {
   gtk_text_insert (GTK_TEXT (text), NULL, &color, NULL, "\n", -1);
  }
  else if(!strcasecmp(lindex(line,0),".SO"))
  {
   gtk_text_insert (GTK_TEXT (text), NULL, &html, NULL, "See ", -1);
   gtk_text_insert (GTK_TEXT (text), NULL, &html, NULL, lrange(line,1), -1);
   gtk_text_insert (GTK_TEXT (text), NULL, &html, NULL, "\n", -1);
  }
  else if(!strcasecmp(lindex(line,0),".TP"))
  {
   gtk_text_insert (GTK_TEXT (text), NULL, &color, NULL, "\n", -1);
  }
  else if(*lindex(line,0)=='.')
  {
   broke++;
  }
  else
  {
   gtk_text_insert (GTK_TEXT (text), NULL, &color, NULL, " ", -1);
   gtk_text_insert (GTK_TEXT (text), NULL, &color, NULL, line, -1);
  }
 }
 gtk_text_thaw (GTK_TEXT (text));
 gtk_widget_destroy(window2);
 sprintf(temp, "Converted. Text broken at %d%%", ((broke*100)/lines));
 msgbox(temp);
 system("rm -f /tmp/file.man");
 fclose(fd);
}

void CB_import(gint type, GtkWidget *entry)
{
 if(window2!=NULL)
 {   
  gtk_widget_destroy(window2);
 }
 window2 = gtk_file_selection_new ("Import file");
 gtk_signal_connect (GTK_OBJECT (window2), "destroy",
  GTK_SIGNAL_FUNC(CB_open_cancel), &window2);
 gtk_signal_connect (GTK_OBJECT (window2), "delete_event",
  GTK_SIGNAL_FUNC(CB_open_cancel), &window2);
 if(type==0)
 gtk_signal_connect (GTK_OBJECT(GTK_FILE_SELECTION(window2)->ok_button),
  "clicked", GTK_SIGNAL_FUNC(CB_import_man), window2);
 if(type==1)
 gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(window2)->ok_button),
  "clicked", GTK_SIGNAL_FUNC(CB_import_rtf), window2);
 if(type==2)
 gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(window2)->ok_button),
  "clicked", GTK_SIGNAL_FUNC(CB_import_ps), window2);
 if(type==3)
 gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(window2)->ok_button),
  "clicked", GTK_SIGNAL_FUNC(CB_import_rot13), window2);
 gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(window2)->cancel_button),
  "clicked", GTK_SIGNAL_FUNC(CB_open_cancel), &window2);
 gtk_widget_set_uposition (window2, (x_pos+50), (y_pos+50));
 gtk_widget_show (window2);
 strcpy(filename, "Unknown filename");
 sprintf(line, "GXedit %s - %s\n", VERSION, filename);
 gtk_window_set_title (GTK_WINDOW (window), line);
}

void CB_save(GtkWidget *widget, gpointer data)
{
 if(!strcmp(filename,"Unknown filename"))
 {
  CB_saveas(window, NULL);
  return;
 }
 fd=fopen(filename,"w");
 if(fd==NULL)
 {
  print_debug("Can't open file for saving\n");
  msgbox("Saving failed\nCan't open file for writing");
  return;
 }
 fputs((char *)gtk_editable_get_chars(GTK_EDITABLE (text), 0, gtk_text_get_length(GTK_TEXT(text))),fd);
 if(fd!=NULL) fclose(fd);
 print_debug("File saved.\n");
 modified = 0;
}

void CB_save_undo()
{
 sprintf(temp, "%s/.gxedit.undo", home);
 fd=fopen(temp,"w");
 if(fd!=NULL)
 {
  fputs((char *)gtk_editable_get_chars(GTK_EDITABLE (text), 0, gtk_text_get_length(GTK_TEXT(text))),fd);
  fclose(fd);
 }
}

void CB_emacs(GtkWidget *widget, GtkWidget *entry) 
{
 strncpy(tmp_name, tempnam(NULL,".gxe"), 50);
 fd=fopen(tmp_name, "w");
 if(fd==NULL)
 {
  print_debug("Can't open file for saving\n");
  return;
 }
 fputs((char *)gtk_editable_get_chars(GTK_EDITABLE (text), 0, gtk_text_get_length(GTK_TEXT(text))),fd);
 if(fd!=NULL) fclose(fd);
 sprintf(temp, "/usr/bin/emacs %s &", tmp_name);
 system(temp);
}

void CB_links_ok(GtkWidget *widget, GtkWidget *entry)
{
 strncpy(tmp_name, tempnam(NULL,".gxe"), 50);
 fd=fopen(tmp_name,"w");
 if(fd==NULL)
 {
  print_debug("Can't open file for saving\n");
  return;
 }
 fputs((char *)gtk_editable_get_chars(GTK_EDITABLE (text), 0, gtk_text_get_length(GTK_TEXT(text))),fd);
 if(fd!=NULL) fclose(fd);
 sprintf(temp, "%s %s &", gtk_entry_get_text(GTK_ENTRY(entry_box)), tmp_name);
 system(temp);
 gtk_widget_destroy(window2);
}

void CB_links_in(GtkWidget *widget, GtkWidget *entry)
{
 if(window2!=NULL)
 {
  gtk_widget_destroy(window2);
 }
 window2 = gtk_window_new (GTK_WINDOW_TOPLEVEL);
 gtk_signal_connect (GTK_OBJECT (window2), "destroy",
  GTK_SIGNAL_FUNC(CB_open_cancel), &window2);
 gtk_signal_connect (GTK_OBJECT (window2), "delete_event",
  GTK_SIGNAL_FUNC(CB_open_cancel), &window2);  
 gtk_window_set_title (GTK_WINDOW (window2), "Links");
 gtk_container_border_width (GTK_CONTAINER (window2), 2);
 gtk_widget_set_uposition (window2, (x_pos+100), (y_pos+100));
  
 vbox = gtk_vbox_new (FALSE, 0);
 gtk_container_add (GTK_CONTAINER (window2), vbox);
 gtk_container_border_width (GTK_CONTAINER (window2), 5);
 gtk_widget_show (vbox);
  
 label = gtk_label_new ("Open this text in:");
 gtk_box_pack_start (GTK_BOX (vbox), label, TRUE, TRUE, 0);
 gtk_widget_show (label);
 
 entry_box = gtk_entry_new ();
 gtk_editable_select_region (GTK_EDITABLE (entry_box), 0, -1);
 gtk_box_pack_start (GTK_BOX (vbox), entry_box, TRUE, TRUE, 0);
 gtk_widget_show (entry_box);
 
 button = gtk_button_new_with_label ("OK");
 gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
 GTK_SIGNAL_FUNC(CB_links_ok), GTK_OBJECT (window2));
 gtk_box_pack_start (GTK_BOX (vbox), button, TRUE, TRUE, 0);
 GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
 gtk_widget_grab_default (button);
 gtk_widget_show (button);
 gtk_widget_show (window2);
}

void CB_xv(GtkWidget *widget, GtkWidget *entry)
{
 sprintf(temp, "%s &", images);
 system(temp);
}

void CB_netscape(GtkWidget *widget, GtkWidget *entry)
{
 strncpy(tmp_name, tempnam(NULL,".gxe"), 50);
 fd=fopen(tmp_name, "w");
 if(fd==NULL)
 {
  print_debug("Can't open file for saving\n");
  return;
 }
 fputs((char *)gtk_editable_get_chars(GTK_EDITABLE (text), 0, gtk_text_get_length(GTK_TEXT(text))),fd);
 if(fd!=NULL) fclose(fd);
 sprintf(temp, "/usr/local/bin/netscape %s &", tmp_name);
 system(temp);
}

void CB_vi(GtkWidget *widget, GtkWidget *entry)
{
 strncpy(tmp_name, tempnam(NULL,".gxe"), 50);
 fd=fopen(tmp_name, "w");
 if(fd==NULL)
 {
  print_debug("Can't open file for saving\n");
  return;
 }
 fputs((char *)gtk_editable_get_chars(GTK_EDITABLE (text), 0, gtk_text_get_length(GTK_TEXT(text))),fd);
 if(fd!=NULL) fclose(fd);
 sprintf(temp, "/usr/X11R6/bin/xterm -e /usr/bin/vi %s &", tmp_name);
 system(temp);
}

void CB_saveas_cancel(GtkWidget *widget, GtkFileSelection *fs)
{
 gtk_widget_destroy(window2);
 window2 = NULL;
}

void CB_saveas_ok(GtkWidget *widget, GtkFileSelection *fs)
{
 strcpy(filename,gtk_file_selection_get_filename(GTK_FILE_SELECTION(fs)));
 sprintf(line, "GXedit %s - %s\n", VERSION, filename);
 gtk_window_set_title (GTK_WINDOW (window), line);
 gtk_widget_destroy(window2);
 window2 = NULL;
 fd=fopen(filename,"w");
 if(fd==NULL)
 {
  print_debug("Can't open file for saving\n");
  msgbox("Saving failed\n Can't open file for writing");
  return;
 }
 fputs((char *)gtk_editable_get_chars(GTK_EDITABLE (text), 0, gtk_text_get_length(GTK_TEXT(text))),fd);
 if(fd!=NULL) fclose(fd);
 modified = 0;
 print_debug("File saved.\n");
} 

void CB_email_ok(GtkWidget *widget, GtkWidget *entry)
{
 if(mail_cmd)
 {
  strncpy(tmp_name, tempnam(NULL,".gxe"), 50);
  fd=fopen(tmp_name,"w");
  if(fd==NULL)
  {
   msgbox("Can't open temporary file");
   return;
  }
  fputs((char *)gtk_editable_get_chars(GTK_EDITABLE (text), 0, gtk_text_get_length(GTK_TEXT(text))),fd);
  if(fd!=NULL) fclose(fd);
  sprintf(temp, "mail -s \"%s\" %s < %s", gtk_entry_get_text(GTK_ENTRY(eb2)), gtk_entry_get_text(GTK_ENTRY(eb1)), tmp_name);
  system(temp);
 }
 else
 {
#ifdef USE_NET
 send_email(gtk_entry_get_text(GTK_ENTRY(eb1)),
  gtk_entry_get_text(GTK_ENTRY(eb2)),
  gtk_entry_get_text(GTK_ENTRY(eb3)),
  gtk_editable_get_chars(GTK_EDITABLE (text), 0, gtk_text_get_length(GTK_TEXT(text))));
#endif
 }
 gtk_widget_destroy(window2);
 window2 = NULL;
}

void CB_email(GtkWidget *widget, GtkWidget *entry)
{
 if(window2!=NULL)
 {
  gtk_widget_destroy(window2);
 }
 window2 = gtk_window_new (GTK_WINDOW_TOPLEVEL);
 gtk_signal_connect (GTK_OBJECT (window2), "destroy",
  GTK_SIGNAL_FUNC(CB_open_cancel), &window2);
 gtk_signal_connect (GTK_OBJECT (window2), "delete_event",
  GTK_SIGNAL_FUNC(CB_open_cancel), &window2);     
 gtk_window_set_title (GTK_WINDOW (window2), "Send text as an e-mail");
 gtk_container_border_width (GTK_CONTAINER (window2), 2);
 gtk_widget_set_uposition (window2, (x_pos+100), (y_pos+100));
  
 vbox = gtk_vbox_new (FALSE, 0);
 gtk_container_add (GTK_CONTAINER (window2), vbox);
 gtk_container_border_width (GTK_CONTAINER (window2), 5);
 gtk_widget_show (vbox);
  
 label = gtk_label_new ("To:");
 gtk_box_pack_start (GTK_BOX (vbox), label, TRUE, TRUE, 0); 
 gtk_widget_show (label);

 eb1 = gtk_entry_new ();
 gtk_editable_select_region (GTK_EDITABLE (eb1), 0, -1);
 gtk_box_pack_start (GTK_BOX (vbox), eb1, TRUE, TRUE, 0);
 gtk_widget_show (eb1);
  
 label = gtk_label_new ("Subject:");
 gtk_box_pack_start (GTK_BOX (vbox), label, TRUE, TRUE, 0);
 gtk_widget_show (label);
 
 eb2 = gtk_entry_new ();
 gtk_editable_select_region (GTK_EDITABLE (eb2), 0, -1);
 gtk_box_pack_start (GTK_BOX (vbox), eb2, TRUE, TRUE, 0);
 gtk_widget_show (eb2);

 label = gtk_label_new ("Optional attached file:");
 gtk_box_pack_start (GTK_BOX (vbox), label, TRUE, TRUE, 0);
 if(mail_cmd) gtk_widget_set_sensitive (label, FALSE);
 gtk_widget_show (label);
 
 eb3 = gtk_entry_new (); 
 gtk_editable_select_region (GTK_EDITABLE (eb3), 0, -1);
 gtk_box_pack_start (GTK_BOX (vbox), eb3, TRUE, TRUE, 0);
 if(mail_cmd) gtk_widget_set_sensitive (eb3, FALSE);
 gtk_widget_show (eb3);

 button = gtk_button_new_with_label ("Send");
 gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
  GTK_SIGNAL_FUNC(CB_email_ok), GTK_OBJECT (window2));
 gtk_box_pack_start (GTK_BOX (vbox), button, TRUE, TRUE, 0);
 GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
 gtk_widget_grab_default (button);
 gtk_widget_show (button);
 gtk_widget_show (window2);
}

void CB_saveas(GtkWidget *widget, gpointer data)
{
 if(window2!=NULL)
 {
  gtk_widget_destroy(window2);
 }
 window2 = gtk_file_selection_new ("Save file");
 gtk_signal_connect (GTK_OBJECT (window2), "destroy",
  GTK_SIGNAL_FUNC(CB_saveas_cancel), &window2);
 gtk_signal_connect (GTK_OBJECT (window2), "delete_event",
  GTK_SIGNAL_FUNC(CB_saveas_cancel), &window2);
 gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION(window2)->ok_button),
  "clicked", GTK_SIGNAL_FUNC(CB_saveas_ok), window2);
 gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(window2)->cancel_button),
  "clicked", GTK_SIGNAL_FUNC(CB_saveas_cancel), &window2);
 gtk_widget_set_uposition (window2, (x_pos+50), (y_pos+50));
 gtk_widget_show (window2);
}

void CB_about(GtkWidget *widget, GtkWidget *entry)
{
 if(window2!=NULL)
 {
  gtk_widget_destroy(window2);
 }
 window2 = gtk_window_new (GTK_WINDOW_TOPLEVEL);
 gtk_signal_connect (GTK_OBJECT (window2), "destroy",
  GTK_SIGNAL_FUNC(CB_open_cancel), &window2);
 gtk_signal_connect (GTK_OBJECT (window2), "delete_event",
  GTK_SIGNAL_FUNC(CB_open_cancel), &window2);
 gtk_window_set_title (GTK_WINDOW (window2), "Help");
 gtk_container_border_width (GTK_CONTAINER (window2), 2);
 gtk_widget_set_uposition (window2, (x_pos+100), (y_pos+100));
 gtk_widget_set_usize (window2, 310, 200);

 vbox = gtk_vbox_new (FALSE, 0);
 gtk_container_add (GTK_CONTAINER (window2), vbox);
 gtk_widget_show (vbox);

 label = new_pixmap (200, window->window, &color);
 gtk_box_pack_start (GTK_BOX (vbox), label, TRUE, TRUE, 0);
 gtk_widget_show (label);

 label = gtk_label_new (ABOUT);
 gtk_box_pack_start (GTK_BOX (vbox), label, TRUE, TRUE, 0);
 gtk_widget_show (label);

 button = gtk_button_new_with_label ("Close");
 gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
  GTK_SIGNAL_FUNC(CB_about_close), GTK_OBJECT (window2));
 gtk_box_pack_start (GTK_BOX (vbox), button, TRUE, TRUE, 0);
 GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
 gtk_widget_grab_default (button);
 gtk_widget_show (button);
 gtk_widget_show (window2);
}

void CB_sysinfo(GtkWidget *widget, GtkWidget *entry)
{
 system("xproc &");
}

void CB_ref_close(GtkWidget *widget, GtkWidget *entry)
{
 if(window4!=NULL) gtk_widget_destroy(window4);
 window4 = NULL;
}

void CB_ref(GtkWidget *widget, GtkWidget *entry)
{
 if(window4!=NULL)
 {
  gtk_widget_destroy(window4);
 }
 window4 = gtk_window_new (GTK_WINDOW_TOPLEVEL);
 gtk_signal_connect (GTK_OBJECT (window4), "destroy",
  GTK_SIGNAL_FUNC(CB_ref_close), &window4);
 gtk_signal_connect (GTK_OBJECT (window4), "delete_event",
  GTK_SIGNAL_FUNC(CB_ref_close), &window4);
 gtk_window_set_title (GTK_WINDOW (window4), "Help");
 gtk_container_border_width (GTK_CONTAINER (window4), 2);
 gtk_widget_set_uposition (window4, (x_pos+100), (y_pos+100));
 gtk_widget_set_usize (window4, 500, 300);

 vbox = gtk_vbox_new (FALSE, 0);
 gtk_container_add (GTK_CONTAINER (window4), vbox);
 gtk_widget_show (vbox);

 table = gtk_table_new (2, 2, FALSE);
 gtk_table_set_row_spacing (GTK_TABLE (table), 0, 2);
 gtk_table_set_col_spacing (GTK_TABLE (table), 0, 2);
 gtk_box_pack_start (GTK_BOX (vbox), table, TRUE, TRUE, 0);
 gtk_widget_show (table);
 
 text2 = gtk_text_new (NULL, NULL);
 gtk_text_set_word_wrap(GTK_TEXT (text2), TRUE);
 gtk_table_attach_defaults (GTK_TABLE (table), text2, 0, 1, 0, 1);
 gtk_widget_show (text2);
 
 vscrollbar = gtk_vscrollbar_new (GTK_TEXT (text2)->vadj);
 gtk_table_attach (GTK_TABLE (table), vscrollbar, 1, 2, 0, 1,
  GTK_FILL, GTK_EXPAND | GTK_FILL, 0, 0);
 gtk_widget_show (vscrollbar);
 gtk_text_freeze (GTK_TEXT (text2));
 gtk_widget_realize (text2);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "HTML reference guide\n\n\n\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &html, NULL, "General issues:\n\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "GXedit can be used to make full HTML pages easily with the simple HTML tags adding commands, the option to preview your work in Netscape, and the HTML syntax highlighting. It works on a simple principle, every tag adding command asking you a question about the tag\n\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "You can access those commands from the HTML menu. Althought you can add HTML tags yourself, we included the most common ones there.\n\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &html, NULL, "\n\nTags adding:\n\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "When adding a tag (a tag is simply a way to tell the browser what to do), it turns blue for easy editing.\n\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "Let's see all major tags, with an URL for a complete reference about them.\n\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &html, NULL, "Header: http://developer.netscape.com/docs/manuals/htmlguid/tags2.htm #1210408\n\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "The header is what goes at the top of the HTML file. It tells the browser what background you want to use, what text color, and the page's title.\n\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "Also remember that an HTML document start with <HTML> and ends with </HTML>. The body of the page is between <BODY> and </BODY>\n\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &html, NULL, "Font: http://developer.netscape.com/docs/manuals/htmlguid/tags6.htm #1288938\n\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "The <FONT> tag lets you change the appearance of the text. It can be used to change the size, color and face of the text between <FONT> and </FONT>\n\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &html, NULL, "Center: http://developer.netscape.com/docs/manuals/htmlguid/tags15.htm #1609285\n\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "Center is a simple tag to tell the browser to put a line (or more) of text in the center of the screen.\n\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &html, NULL, "Line: http://developer.netscape.com/docs/manuals/htmlguid/tags15.htm #1045422\n\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "This command adds an horizontal line in the page.\n\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &html, NULL, "Table: http://developer.netscape.com/docs/manuals/htmlguid/tags9.htm #1480420\n\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "The table is a complex tag which defines a table between <TABLE> and </TABLE>. In it, you must define lines inside <TR> and </TR>, and columns within <TD> and </TD>\n\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "The <TABLE> tag allows you to define a table with borders, or without borders. It also allows you to define how the table will appear on the page.\n\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &html, NULL, "Image: http://developer.netscape.com/docs/manuals/htmlguid/tags8.htm #1310399\n\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "The <IMG> tag is easy to use. It tells the browser to load an image and display it on the screen. It can be useful to add colors to the page, or to use an image as a link to an other site.\n\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &html, NULL, "Link: http://developer.netscape.com/docs/manuals/htmlguid/tags7.htm #1227754\n\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "Links are defined within the anchor tag: <A> </A>. This is used a lot to define links to other pages, and to places inside your page.\n\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "Note that <A> can also be used to define anchors inside a page with <A NAME=something>\n\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &html, NULL, "Line break: http://developer.netscape.com/docs/manuals/htmlguid/tags15.htm #1628041\n\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "Line breaks are used after lines of text, where you want to put a return key.\n\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &html, NULL, "Bold: http://developer.netscape.com/docs/manuals/htmlguid/tags6.htm #1243987\n\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "The <B> tag is very simple. Anything inside <B> and </B> are in bold.\n\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &html, NULL, "Italic: http://developer.netscape.com/docs/manuals/htmlguid/tags6.htm #1306248\n\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "The <I> tag works the same way as the Bold tag.\n\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &html, NULL, "List item: http://developer.netscape.com/docs/manuals/htmlguid/tags5.htm #1742067\n\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "A list item is a way to make a list of important strings. It usualy makes a little circle at the left of the line of text.\n\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "Usualy, a list item isn't used by itself. You use many of them to make the actual list.\n\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &html, NULL, "\n\nLinks:\n\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "For more information about the HTML tags, check out this site: http://developer.netscape.com/docs/manuals/htmlguid/index.htm\n\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "For information about how to use JavaScript in your web site, check out: http://developer.netscape.com/docs/manuals/communicator/jsguide4/index.htm\n\n", -1);
 hbox = gtk_hbutton_box_new();
 gtk_button_box_set_layout(GTK_BUTTON_BOX(hbox), GTK_BUTTONBOX_END);
 gtk_button_box_set_spacing(GTK_BUTTON_BOX(hbox), 5);
 gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
 gtk_widget_show (hbox);

 button = gtk_button_new_with_label ("Close");
 gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
  GTK_SIGNAL_FUNC(CB_ref_close), GTK_OBJECT (window));
 gtk_box_pack_start (GTK_BOX (hbox), button, TRUE, TRUE, 0);
 GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
 gtk_widget_grab_default (button);
 gtk_widget_show (button);
 gtk_widget_show(window4); 
}

void CB_help(GtkWidget *widget, gpointer data)
{
 if(window2!=NULL)
 {
  gtk_widget_destroy(window2);
 }
 window2 = gtk_window_new (GTK_WINDOW_TOPLEVEL);
 gtk_signal_connect (GTK_OBJECT (window2), "destroy",
  GTK_SIGNAL_FUNC(CB_open_cancel), &window2);
 gtk_signal_connect (GTK_OBJECT (window2), "delete_event",
  GTK_SIGNAL_FUNC(CB_open_cancel), &window2);
 gtk_window_set_title (GTK_WINDOW (window2), "Help");
 gtk_container_border_width (GTK_CONTAINER (window2), 2);
 gtk_widget_set_uposition (window2, (x_pos+100), (y_pos+100));
 gtk_widget_set_usize (window2, 500, 300);

 vbox = gtk_vbox_new (FALSE, 0);
 gtk_container_add (GTK_CONTAINER (window2), vbox);
 gtk_widget_show (vbox);

 table = gtk_table_new (2, 2, FALSE);
 gtk_table_set_row_spacing (GTK_TABLE (table), 0, 2);
 gtk_table_set_col_spacing (GTK_TABLE (table), 0, 2);
 gtk_box_pack_start (GTK_BOX (vbox), table, TRUE, TRUE, 0);
 gtk_widget_show (table);
 
 text2 = gtk_text_new (NULL, NULL);
 gtk_text_set_word_wrap(GTK_TEXT (text2), TRUE);
 gtk_table_attach_defaults (GTK_TABLE (table), text2, 0, 1, 0, 1);
 gtk_widget_show (text2);
 
 vscrollbar = gtk_vscrollbar_new (GTK_TEXT (text2)->vadj);
 gtk_table_attach (GTK_TABLE (table), vscrollbar, 1, 2, 0, 1,
  GTK_FILL, GTK_EXPAND | GTK_FILL, 0, 0);
 gtk_widget_show (vscrollbar);
 gtk_text_freeze (GTK_TEXT (text2));
 gtk_widget_realize (text2);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, HELP1, -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &html, NULL, "\n\nGeneral help:\n\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "Syntax: gxedit [text files] [-v] [-f] [-n] [-i]\n\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "The -v option is used to open the file in view only mode.\n\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "The -f option disables the menus and toolbars\n\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "The -n option disables the networking part. Useful if you do not have access to a network.\n\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "The -i option waits for input. Useful with tail -f\n\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "GXedit is a graphical multi function text editor. It allows you to edit text in a X Window program.\n\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "You can call all the available GXedit functions from the menus. Also, you can use the toolbars for functions like Open and Exit.\n\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "You'll notice that from the File menu you can import various formats. These commands use simple converters to convert a foreign format to plain text. It ", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "might not be completely accurate, but it makes it easier to read if you have no program that natively reads that file format. The converting functions should get better in next versions\n\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "From the Edit menu, you can Copy and Paste text, and you can include man tags in your text.\n\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "The Edit menu also has an Restore command, that will restore the text as it was just before you used a scripting command, a macro or checked spelling.\n\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "A new thing you will find is the mirror feature. With it, you can set your GXedit as a server where other people using the program on other ", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "systems will be able to connect to yours, and see everything you type as you type it. It allows up to 99 connections. This can be very useful for a meeting across the Internet or on a LAN.\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "Note that the data is not encrypted and anyone can connect if they know the server/port. Use only on a local LAN if sensitive data will be sent.\n\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "From the Links menu, you can open your text in various other programs. There is also the Options menu for various tools like spell checking.\n\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "The lines count, word count and bytes count are approximate.\n\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "Finally, the Help menu provides this help screen.\n\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "GXedit also has an autosave feature that can save your text in ~/.gxedit.autosave while you're writing, until you exit gxedit, in case something crashes. ", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "You can turn this on or off in the settings panel.\n\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "It also has a debug window. Major notices will appear in a message box, but other ones will appear in the debug window.\n\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "Note that while this is a text editor, if you try to load images, an image viewer will be called to load them.\n\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "You should not confuse the Add man tags option and the Import man page option. One is to make a man page and will insert 'tags' in your text, while the other will load a man page and convert", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, " its tags to plain text.\n\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "GXedit now provides syntax highlighting. For this you need to install the GtkEditor patch to GTK (http://www.daimi.aau.dk/~mailund/gtk.html) and enable it in the Settings panel.\n\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "GXedit is Copyright 1998 Patrick Lambert <drow@darkelf.net> - http://devplanet.fastethernet.net\nYou can freely use and distribute this program following the GPL license.\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "I'd like to thank everyone who gave me ideas and provided comments about GXedit, especially Glen Parker.\n\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &html, NULL, "\n\nNetwork options:\n\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "GXedit is fully network aware. You can load an e-mail from your e-mails folder, send your current text as an e-mail, load a text from the web, and more.\n\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "All these functions are available from the menus.\n\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "Note that you'll want to configure your settings correctly before using any network function.\n\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &html, NULL, "\n\nSettings panel:\n\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "The settings panel can be accessed from the Options menu or from the toolbar.\n\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "The settings are kept in a file called .gxedit in your home directory, and the file is created the first time you start GXedit.\n\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "There are several panels. The display settings are easy to setup. The advanced panel can be left unchanged, but you have to configure the networking part.\n\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "The advanced panel is for fonts and colors. Interesting fonts include 'misc fixed', 'adobe courier', 'adobe helvetica' and 'b&h lucida'. Check with xfontsel to get your fonts list.\n\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "If you don't know what your mail server or e-mail address is, you should ask your system admin.\n\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "Note that if the Reply option is on, any mail or news article will be opened with a reply char '>' and ~/.signature will be appended at the end of the text, to allow easy replying.\n\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "The auto indent option means that the indent level will go up when you add a { and go down when you type }. You can also use CTRL = and CTRL - to change the indent level.\n\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "The importing filters are simple filters used to add choices to the Import menu. If you have binaries on your system that convert a file format to plain text, like ", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "dvi2tty does, then you can use a filter to add an import option to GXedit. In the filter line, $i means the input file and $o the output one. GXedit will replace them as needed. ", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "The default choices are dvi to text and RPM file info. This obviously means that you must have dvi2tty and RPM installed on your system.\n\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "The last panel is Misc. From it, you can toggle on or off the option to have bolded menu and toolbar text, the Audio menu, and other misc things.\n\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "The Audio menu choices require you to type 'make say' and 'make say-install' in the GXedit source tree. The say utility is based on rsynth. See the README in the access dir for more.\n\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "You can compile GXedit to access a SOCKS proxy server (with the proxy option on) if you define USE_SOCKS and link with the SOCKS static lib.\n\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &html, NULL, "\n\nKeybindings:\n\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "CTRL N\t\tClose current file and start a new one\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "CTRL O\t\tOpen a file from disk\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "CTRL S\t\tSave current file\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "CTRL E\t\tSave text under a new filename\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "CTRL X\t\tClose this window\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "CTRL C\t\tCopy selected text\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "CTRL V\t\tPaste text\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "CTRL F\t\tFind a string of text\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "CTRL G\t\tFind again\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "CTRL H\t\tGetting started\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "CTRL T\t\tSettings\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "CTRL I\t\tCheck spelling\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "CTRL A\t\tAwk scripting commands\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "CTRL R\t\tRun a shell command line\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "CTRL D\t\tSet indent level\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "CTRL =\t\tAdd to the indent level\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "CTRL -\t\tSubstract to the indent level\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "CTRL L\t\tCheck the lines count\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "CTRL W\t\tCheck the words count\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "CTRL B\t\tCheck the number of bytes your text takes\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "CTRL M\t\tMark a block for selecting\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &html, NULL, "\n\n\nEncryption:\n\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "GXedit can use the des(1) or idea(l) binary to encrypt and decrypt text files. The DES binary is part of the libdes library and can be found at ftp://ftp.psy.uq.oz.au/pub/Crypto/DES/ while IDEA is available from ftp://idea.sec.dsi.unimi.it/pub/crypt/code/\n\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "The encryption is based on key using. You encrypt a file with a key, and decrypt it with the same key. The encrypted text is saved under filename.enc\n\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "Note that this encryption could possibly be broken by powerful computers, even if IDEA is more secure then what DES can offer. Also, since GXedit uses temporary files, the text is not secure on the computer where GXedit is used, only wherever you send the .enc file. Also make sure the key doesn't appears in logs like .bash_history\n\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "The encryption command can be useful for data storage, or for sending a text over an insecure network.\n\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "Also note that this is not compatible with SunOS's default des(1) binary. See the des(1) and idea(l)man pages for more information.\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &html, NULL, "\n\n\nGXedit scripting:\n\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "The scripting function in the Options menu can be very useful for complex text manipulation.\n\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "The scripting languages chosen in GXedit are awk and sed, because those languages go well together to manipulate text.\n\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "Let's see some examples of what you could do with awk. Open the README file and use the scripting command:\n/is/\nThis will remove every line that does not have 'is' in it.\n\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "On the contrary, if you want all the lines that do not contain 'is', you would use:\n!/is/\n\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "If you wanted the pattern to match both 'is' and 'Is', you could have used:\n/[iI]s/\n\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "Let's take another example:\n{ count=count+1 } END { print count }\nAlways remember that anything before BEGIN and after END is executed once, while what's between the two is executed ", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "for every line of text. ", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "So this command means add 1 to the variable count for every line of text, and when all lines have been counted, print the variable. The result is awk will print the number of lines.\n\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "Now let's say you want to change all your text to upper-case chars. Awk has a function called toupper() to do that. So the proper command line would be:\n{ print toupper($0) }\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "Where $0 means the complete line, and $1 would mean the first word of that line, $2 the second word, etc...\n\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "Let's say that you need a quick way to get all the real names of all users on the system. Open /etc/passwd then use this script:\nBEGIN { FS=\":\" } { print $5 }\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "This tells awk to use ':' between the words, and to print word 5 of every line.\nAnother way to do it is:\n{ print $5 }\n with:\n-F:\nIn the 'Optional flags' entry box.\n\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "Another interesting command is length. This command line will print every line with at least 10 chars in it:\nlength > 10\n\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "This command will print the total amount of chars (letters or spaces) in your text:\n{ count=count+length($0) } END { print count }\n\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "Also, this command will count the number of times the word 'is' can be found and print the result:\n{ for (i=1; i<=NF; i++) if ($i==\"is\") count=count+1 } END { print count }\n\n", -1);
 gtk_text_insert (GTK_TEXT (text2), NULL, &color, NULL, "Finally, you might need to add a flag to the Optional flag entry box. If you want to see all the hidden chars like EOL, then enter the letter l in the command line, and -n in flags.\n\n", -1);
 gtk_text_thaw (GTK_TEXT (text2));

 hbox = gtk_hbutton_box_new();
 gtk_button_box_set_layout(GTK_BUTTON_BOX(hbox), GTK_BUTTONBOX_END);
 gtk_button_box_set_spacing(GTK_BUTTON_BOX(hbox), 5);
 gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
 gtk_widget_show (hbox);

 button = gtk_button_new_with_label ("HTML reference");
 gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
 GTK_SIGNAL_FUNC(CB_ref), GTK_OBJECT (window));
 gtk_box_pack_start (GTK_BOX (hbox), button, TRUE, TRUE, 0);
 gtk_widget_show (button);

 button = gtk_button_new_with_label ("Close");
 gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
  GTK_SIGNAL_FUNC(CB_about_close), GTK_OBJECT (window));
 gtk_box_pack_start (GTK_BOX (hbox), button, TRUE, TRUE, 0);
 gtk_widget_show (button);
 gtk_widget_show (window2);
}

void set_defaults()
{
 /* set defaults */
 original = 0;
 scroll_loc = 0;
 use_socks = 0;
 indent = 0;
 mirr_serv = 0;
 debug = 0;
 icons = 0;
 autosave = 0;
 toolbar = 1;
 tooltips = 1;
 x_size = 550;
 y_size = 300;
 full_tb = 1;
 netbar = 0;
 htmlbar = 0;
 syntax_h = 0;
 h_style = 0;
 fortune = 0;
 old_open = 0;
 auto_indent = 0;
 mail_cmd = 0;
 access_opt = 0;
 audio = 0;
 x_pos = 20;
 y_pos = 20;
 reply = 0;
 page_width = 0;
 line_wrap = 1;
 strcpy(col_name,"black");
 strcpy(xfm,"xfm");
 strcpy(compile,"gcc -Wall -o ./a.out -g $f");
 strcpy(gzip,"gzip -d");
 strcpy(doc_dir,"");
 strcpy(dict,"english");
 strcpy(images,"xv");
 strcpy(mail_server, "localhost");
 strcpy(mail_from, "root@localhost");
 strcpy(default_news, "");
 strcpy(default_web, "");
 strcpy(mail_ip, "127.0.0.1");
 strcpy(mirror_remote, "localhost");
 strcpy(news_server, "localhost");
 strcpy(news_ip, "127.0.0.1");
 strcpy(font, "-adobe-helvetica-*-r-*-*-12-*-*-*-*-*-*-*");
 strcpy(bg, "white");
 strcpy(bg_pixmap, "none");
 strncpy(login, getenv("LOGNAME"), 100);
 modified = 0;
 sprintf(temp, "%s/.gxedit.applications", home);
 fd = fopen(temp, "r");
 if(fd==NULL)
 {
  fd = fopen(temp, "w");
  fputs("# This is the applications file for GXedit\n", fd);
  fputs("# From here, you can add applications to the toolbar\n", fd);
  fputs("# Be careful not to let any empty line in this file\n", fd);
  fputs("# The syntax of the file is:\n", fd);
  fputs("#   aplication: <number> <1 word name> <icon file name> <program binary> <description>\n", fd);
  fputs("# Example:\n", fd);
  fputs("#   application: 1 Netscape /usr/X11R6/include/X11/pixmaps/mini-nscape.xpm /usr/local/bin/netscape The netscape browser\n", fd);
 }
 fclose(fd);
}

void parse_rc()
{
 strncpy(tmp_name, tempnam(NULL,".gxe"), 50);
 fd = fopen(tmp_name, "w");
 if(fd==NULL)
 {
  printf("Fatal error: Can't open temporary file in /tmp\n");
  exit(1);
 }
 fputs("pixmap_path \".:/usr/X11R6/include/X11/pixmaps\"\n", fd);
 fputs("style \"text\"\n", fd);
 fputs("{\n", fd);
 sprintf(temp, "font = \"%s\"\n", font);
 fputs(temp, fd);
 if(strcasecmp(bg_pixmap,"none"))
 {
  sprintf(temp, "  bg_pixmap[NORMAL] = \"%s\"\n", bg_pixmap);
  fputs(temp, fd);
 }
 if(!strcasecmp(bg,"white"))
 fputs("  base[NORMAL] = { 1.0, 1.0, 1.0 }\n", fd);
 if(!strcasecmp(bg,"black"))
 fputs("  base[NORMAL] = { 0.0, 0.0, 0.0 }\n", fd);
 if(!strcasecmp(bg,"red"))
 fputs("  base[NORMAL] = { 1.0, 0.0, 0.0 }\n", fd);
 if(!strcasecmp(bg,"blue"))
 fputs("  base[NORMAL] = { 0.0, 0.0, 1.0 }\n", fd);
 if(!strcasecmp(bg,"green"))
 fputs("  base[NORMAL] = { 0.0, 1.0, 0.0 }\n", fd);
 if(!strcasecmp(col_name,"white"))
 fputs("  text[NORMAL] = { 1.0, 1.0, 1.0 }\n", fd);
 if(!strcasecmp(col_name,"black"))   
 fputs("  text[NORMAL] = { 0.0, 0.0, 0.0 }\n", fd);
 if(!strcasecmp(col_name,"red"))
 fputs("  text[NORMAL] = { 1.0, 0.0, 0.0 }\n", fd);
 if(!strcasecmp(col_name,"blue"))
 fputs("  text[NORMAL] = { 0.0, 0.0, 1.0 }\n", fd);
 if(!strcasecmp(col_name,"green"))
 fputs("  text[NORMAL] = { 0.0, 1.0, 0.0 }\n", fd);
 fputs("}\n\n", fd);
 if(access_opt)
 {
  fputs("style \"access\"\n", fd);
  fputs("{\n", fd);
  fputs("font = \"-misc-fixed-bold-r-*-*-14-*-*-*-*-*-*-*\"\n", fd);
  fputs("}\n\n", fd);
  fputs("widget_class \"*GtkMenu*\" style \"access\"\n", fd);
  fputs("widget_class \"*GtkToolbar*\" style \"access\"\n", fd);
 }
 fputs("widget_class \"*GtkText\" style \"text\"\n", fd);
#ifdef GTKEDITOR_PATCH
 fputs("widget_class \"*GtkEditor\" style \"text\"\n", fd);
#endif
 fclose(fd);
 gtk_rc_parse(tmp_name);
 sprintf(temp, "%s/.gxeditrc", home);
 fd = fopen(temp, "r");
 if(fd!=NULL)
 {
  fclose(fd);
  gtk_rc_parse(temp);
 }
}

int main(int argc, char *argv[])
{
 int i, j = 0;
#ifdef BG_ON_START
 if(fork()) exit(0);
#endif
#ifdef USE_SOCKS
 if(use_socks)
 SOCKSinit(argv[0]);
#endif
 if(getenv("HOME")==NULL || getenv("LOGNAME")==NULL)
 {
  printf("Can't get HOME or LOGNAME env variables. Set them first.\n");
  exit(1);
 }
 /* general check for temp write access perms */
 if(tempnam(NULL,".gxe")==NULL)
 {
  printf("Fatal error: Can't create emporary files\n");
  exit(1);
 }
#ifdef USE_GNOME
 gnome_init("GXedit", NULL, argc, argv, 0, NULL);
#endif
 strncpy(progname, argv[0], 100);
 strncpy(home, getenv("HOME"), 100);
 strcpy(filename,"Unknown filename");
 if(argv[1]!=NULL)
 {
#ifdef USE_NET
  if(!strcasecmp(argv[1],"-server"))
  {
   mirror_server("/tmp/.gxedit.mirror-server");
  }
#endif
 }
 /* cmd line args check */
 flat = 0; nonet = 0; set_edit = 1; tail = 0;
 for(i=1;argv[i]!=NULL;i++)
 {
  if(!strcasecmp(argv[i],"-n")) nonet = 1;
  else if(!strcasecmp(argv[i],"-v")) set_edit = 0;
  else if(!strcasecmp(argv[i],"-i")) tail = 1;
  else if(!strcasecmp(argv[i],"-f")) {flat = 1; set_edit = 0;}
  else
  {
   if(!strcasecmp(filename,"Unknown filename")) strcpy(filename,argv[i]);
   else
   {
    sprintf(temp,"%s %s &", progname, argv[i]);
    system(temp);
   }
  }
 }
 sprintf(line, "%s/.gxedit", home);
#ifndef USE_GNOME
 gtk_init(&argc, &argv);
#endif
 /* allocating a color for special stuff */
 cmap = gdk_colormap_get_system();
 extract_color(&html, 50, 50, 200);
 gdk_color_alloc(cmap, &html);
 set_defaults();
 fd = fopen(line, "r");
 if(fd!=NULL) read_cfg();
 else
 {
  /* 1st use of GXedit */
  make_cfg();
  j = 1;
 }
 parse_rc();
 if(strcasecmp(doc_dir,""))
 {
  strcpy(temp, lindex(doc_dir,0));
  chdir(temp);
 }
 /* main GUI window is created here */
 make_gui();
 if(j == 1) msgbox("Welcome to GXedit! I created ~/.gxedit where I will store your settings.\nYou can get help on how to use this program by clicking on the Help button.");
 if(fortune && !strcasecmp(filename,"Unknown filename"))
 {
  strncpy(tmp_name, tempnam(NULL,".gxe"), 50);
  sprintf(temp, "/usr/games/fortune > %s", tmp_name);
  system(temp);
  open_file(tmp_name, "Fortune command could not be run\n");
 }
#ifdef GTKEDITOR_PATCH
 /* patterns customization */
 if(h_style==1) gtk_editor_set_patterns(GTK_EDITOR(text), &html_patterns);
 if(h_style==2) gtk_editor_set_patterns(GTK_EDITOR(text), &c_patterns);
 if(h_style==3) gtk_editor_set_patterns(GTK_EDITOR(text), &perl_patterns);
 if(h_style==4) gtk_editor_set_patterns(GTK_EDITOR(text), &java_patterns);
#endif
 sprintf(temp, "Debug messages:\nStarting GXedit...\nUsing GTK version %d.%d.%d\n", gtk_major_version, gtk_minor_version, gtk_micro_version);
 print_debug(temp);
 if(strcasecmp(filename,"Unknown filename"))
 {
  /* load file */
  fd = fopen(argv[1], "r");
  if(fd!=NULL)
  {
   while(fgets(line,512,fd)!=NULL)
   {
    gtk_text_insert (GTK_TEXT (text), NULL, &color, NULL, line, -1);
   }
  }
  gtk_text_thaw (GTK_TEXT (text));
  if(fd!=NULL) fclose(fd);
  sprintf(temp, "%s.gxnote", filename);
  fd = fopen(temp, "r");
  if(fd!=NULL)
  {
   create_note(fd);
   fclose(fd);
  }
#ifdef GTKEDITOR_PATCH
  if(syntax_h)
  gtk_editor_hilite_buffer(GTK_EDITOR(text));
#endif
 }
 else gtk_text_thaw (GTK_TEXT (text));
 if(tail)
 {
  tail_t = gtk_timeout_add(1000, (GtkFunction)tail_loop, NULL);
  tail_cancel();
 }
 gtk_main();
 return(0);
}

void CB_tail_cancel_ok(GtkWidget *widget, GtkWidget *event)
{
 gtk_widget_destroy(window2);
 gtk_timeout_remove(tail_t);
}

void tail_cancel()
{
 if(window2!=NULL)
 {
  gtk_widget_destroy(window2);
 }
 window2 = gtk_dialog_new ();
 gtk_widget_set_usize (GTK_WIDGET (window2), 400, 120);
 gtk_signal_connect (GTK_OBJECT (window2), "destroy",
  GTK_SIGNAL_FUNC(CB_msgbox_close), &window2);
 gtk_signal_connect (GTK_OBJECT (window2), "delete_event",
  GTK_SIGNAL_FUNC(CB_msgbox_close), &window2);
 gtk_window_set_title (GTK_WINDOW (window2), "GXedit");
 gtk_container_border_width (GTK_CONTAINER (window2), 0);
 gtk_widget_set_uposition (window2, (x_pos+50), (y_pos+50));
 
 label = gtk_label_new ("Reading input from stdin");
 gtk_box_pack_start (GTK_BOX (GTK_DIALOG (window2)->vbox),
  label, TRUE, TRUE, 0);
 gtk_widget_show (label);

 button = gtk_button_new_with_label ("Cancel");
 gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
  GTK_SIGNAL_FUNC(CB_tail_cancel_ok), GTK_OBJECT (window2));
 gtk_box_pack_start (GTK_BOX (GTK_DIALOG (window2)->action_area),
  button, TRUE, TRUE, 0);
 GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
 gtk_widget_grab_default (button);
 gtk_widget_show (button);
 gtk_widget_show (window2);
}

void tail_loop(GtkWidget *widget, GtkWidget *entry)
{
 gtk_timeout_remove(tail_t);
 fgets(temp, 500, stdin);
 gtk_text_insert (GTK_TEXT (text), NULL, &color, NULL, temp, -1);
 tail_t = gtk_timeout_add(1000, (GtkFunction)tail_loop, NULL);
}

void read_cfg()
{
 while(fgets(line,512,fd)!=NULL)
 {
  line[strlen(line)-1]=' ';
  if(!strcasecmp(lindex(line,0),"toolbar:"))
  {
   if(lindex(line,1)!=NULL)
   toolbar = atoi(lindex(line,1));
  }
  else if(!strcasecmp(lindex(line,0),"tooltips:"))
  {
   if(lindex(line,1)!=NULL)
   tooltips = atoi(lindex(line,1));
  }
  else if(!strcasecmp(lindex(line,0),"x_size:"))
  {
   if(lindex(line,1)!=NULL)
   x_size = atoi(lindex(line,1));
  }
  else if(!strcasecmp(lindex(line,0),"y_size:"))
  {
   if(lindex(line,1)!=NULL)
   y_size = atoi(lindex(line,1));
  }
  else if(!strcasecmp(lindex(line,0),"line_wrap:"))
  {
   if(lindex(line,1)!=NULL)
   line_wrap = atoi(lindex(line,1));
  }
  else if(!strcasecmp(lindex(line,0),"page_width:"))
  {
   if(lindex(line,1)!=NULL)
   page_width = atoi(lindex(line,1));
  }
  else if(!strcasecmp(lindex(line,0),"full_toolbar:"))
  {
   if(lindex(line,1)!=NULL)
   full_tb = atoi(lindex(line,1));
  }
  else if(!strcasecmp(lindex(line,0),"netbar:"))
  {
   if(lindex(line,1)!=NULL)
   netbar = atoi(lindex(line,1));
  }
  else if(!strcasecmp(lindex(line,0),"htmlbar:"))
  {
   if(lindex(line,1)!=NULL)
   htmlbar = atoi(lindex(line,1));
  }
  else if(!strcasecmp(lindex(line,0),"syntax_h:"))
  {
   if(lindex(line,1)!=NULL)
   syntax_h = atoi(lindex(line,1));
  }
  else if(!strcasecmp(lindex(line,0),"h_style:"))
  {
   if(lindex(line,1)!=NULL)
   h_style = atoi(lindex(line,1));
  }
  else if(!strcasecmp(lindex(line,0),"fortune:"))
  {
   if(lindex(line,1)!=NULL)
   fortune = atoi(lindex(line,1));
  }
  else if(!strcasecmp(lindex(line,0),"old_open:"))
  {
   if(lindex(line,1)!=NULL)
   old_open = atoi(lindex(line,1));
  }
  else if(!strcasecmp(lindex(line,0),"scrollbar_location:"))
  {
   if(lindex(line,1)!=NULL)
   scroll_loc = atoi(lindex(line,1));
  }
  else if(!strcasecmp(lindex(line,0),"use_socks:"))
  {
   if(lindex(line,1)!=NULL)
   use_socks = atoi(lindex(line,1));
  }
  else if(!strcasecmp(lindex(line,0),"auto_indent:"))
  {
   if(lindex(line,1)!=NULL)
   auto_indent = atoi(lindex(line,1));
  }
  else if(!strcasecmp(lindex(line,0),"mail_cmd:"))
  {
   if(lindex(line,1)!=NULL)
   mail_cmd = atoi(lindex(line,1));
  }
  else if(!strcasecmp(lindex(line,0),"access:"))
  {
   if(lindex(line,1)!=NULL)
   access_opt = atoi(lindex(line,1));
  }
  else if(!strcasecmp(lindex(line,0),"audio:"))
  {
   if(lindex(line,1)!=NULL)
   audio = atoi(lindex(line,1));
  }
  else if(!strcasecmp(lindex(line,0),"x_position:"))
  {
   if(lindex(line,1)!=NULL)
   x_pos = atoi(lindex(line,1));
  }
  else if(!strcasecmp(lindex(line,0),"y_position:"))
  {
   if(lindex(line,1)!=NULL)
   y_pos = atoi(lindex(line,1));
  }
  else if(!strcasecmp(lindex(line,0),"debug:"))
  {
   if(lindex(line,1)!=NULL)
   debug = atoi(lindex(line,1));
  }
  else if(!strcasecmp(lindex(line,0),"autosave:"))
  {
   if(lindex(line,1)!=NULL)
   autosave = atoi(lindex(line,1));
  }
  else if(!strcasecmp(lindex(line,0),"toolbar_icons:"))
  {
   if(lindex(line,1)!=NULL)
   icons = atoi(lindex(line,1));
  }
  else if(!strcasecmp(lindex(line,0),"images:"))
  {
   if(lindex(line,1)!=NULL)
   strncpy(images, lindex(line,1), 100);
  }
  else if(!strcasecmp(lindex(line,0),"xfm:"))
  {
   if(lindex(line,1)!=NULL)
   strncpy(xfm, lindex(line,1), 100);
  }
  else if(!strcasecmp(lindex(line,0),"compile:"))
  {
   if(lindex(line,1)!=NULL)
   strncpy(compile, lrange(line,1), 100);
  }
  else if(!strcasecmp(lindex(line,0),"gzip:"))
  {
   if(lindex(line,1)!=NULL)
   strncpy(gzip, lrange(line,1), 100);
  }
  else if(!strcasecmp(lindex(line,0),"document_dir:"))
  {
   if(lindex(line,1)!=NULL)
   strncpy(doc_dir, lrange(line,1), 100);
   else strcpy(doc_dir,"");
  }
  else if(!strcasecmp(lindex(line,0),"dictionary:"))
  {
   if(lindex(line,1)!=NULL)
   strncpy(dict, lindex(line,1), 100);
  }
  else if(!strcasecmp(lindex(line,0),"login_name:"))
  {
   if(lindex(line,1)!=NULL)
   strncpy(login, lindex(line,1), 100);
  }
  else if(!strcasecmp(lindex(line,0),"news_server:"))
  {
#ifdef USE_NET
   if(lindex(line,1)!=NULL)
   {
    strncpy(news_server, lindex(line,1), 100);
    if(!nonet) strncpy(news_ip, resolve(lindex(line,1)), 100);
    else strcpy(news_ip, "127.0.0.1");
   }
#endif
  }
  else if(!strcasecmp(lindex(line,0),"mail_server:"))
  {
#ifdef USE_NET
   if(lindex(line,1)!=NULL)
   {
    strncpy(mail_server, lindex(line,1), 100);
    if(!nonet) strncpy(mail_ip, resolve(lindex(line,1)), 100);
    else strcpy(mail_ip, "127.0.0.1");
   }
#endif
  }
  else if(!strcasecmp(lindex(line,0),"mail_address:"))
  {
   if(lindex(line,1)!=NULL)
   strncpy(mail_from, lindex(line,1), 100);
  }
  else if(!strcasecmp(lindex(line,0),"default_news:"))
  {
   if(lindex(line,1)!=NULL)
   strncpy(default_news, lindex(line,1), 100);
  }
  else if(!strcasecmp(lindex(line,0),"default_web:"))
  {
   if(lindex(line,1)!=NULL)
   strncpy(default_web, lindex(line,1), 100);
  }
  else if(!strcasecmp(lindex(line,0),"mirror_server:"))
  {
   if(lindex(line,1)!=NULL)
   strncpy(mirror_remote, lindex(line,1), 100);
  }
  else if(!strcasecmp(lindex(line,0),"font:"))
  {
   if(lindex(line,1)!=NULL)
   strncpy(font, lindex(line,1), 100);
  }
  else if(!strcasecmp(lindex(line,0),"background:"))
  {
   if(lindex(line,1)!=NULL)
   strncpy(bg, lindex(line,1), 100);
  }
  else if(!strcasecmp(lindex(line,0),"pixmap:"))
  {
   if(lindex(line,1)!=NULL)
   strncpy(bg_pixmap, lindex(line,1), 100);
  }
  else if(!strcasecmp(lindex(line,0),"mail_reply:"))
  {
   if(lindex(line,1)!=NULL)
   reply = atoi(lindex(line,1));
  }
  else if(!strcasecmp(lindex(line,0),"color:"))
  {
   strncpy(col_name, lindex(line,1), 10);
   if(!strcasecmp(lindex(line,1),"black"))
   {
    extract_color(&color, 0, 0, 0);
    gdk_color_alloc(cmap, &color);
   }
   else if(!strcasecmp(lindex(line,1),"green"))
   {
    extract_color(&color, 0, 255, 0);
    gdk_color_alloc(cmap, &color);
   }
   else if(!strcasecmp(lindex(line,1),"white"))
   {
    extract_color(&color, 255, 255, 255);
    gdk_color_alloc(cmap, &color);
   }
   else if(!strcasecmp(lindex(line,1),"red"))
   {
    extract_color(&color, 255, 0, 0);
    gdk_color_alloc(cmap, &color); 
   }
   else if(!strcasecmp(lindex(line,1),"blue"))
   {
    extract_color(&color, 0, 0, 255);
    gdk_color_alloc(cmap, &color); 
   }
   else print_debug("Invalid color in config file\n");
  }
 }
 fclose(fd);
}

void make_cfg()
{
 fd = fopen(line, "w");
 fputs("# This is the configuration file for GXedit\n", fd);
 fputs("toolbar: 1\n", fd);
 fputs("full_toolbar: 1\n", fd);
 fputs("netbar: 0\n", fd);
 fputs("htmlbar: 0\n", fd);
 fputs("syntax_h: 0\n", fd);
 fputs("h_style: 0\n", fd);
 fputs("fortune: 0\n", fd);
 fputs("old_open: 0\n", fd);
 fputs("scroll_loc: 0\n", fd);
 fputs("use_socks: 0\n", fd);
 fputs("auto_indent: 0\n", fd);
 fputs("mail_cmd: 0\n", fd);
 fputs("access: 0\n", fd);
 fputs("tooltips: 1\n", fd);
 fputs("x_size: 600\n", fd);
 fputs("y_size: 300\n", fd);
 fputs("x_position: 20\n", fd);
 fputs("y_position: 20\n", fd);
 fputs("color: black\n", fd);
 extract_color(&color, 0, 0, 0);
 gdk_color_alloc(cmap, &color);
 fputs("debug: 0\n", fd);
 fputs("images: xv\n", fd);
 fputs("line_wrap: 1\n", fd);
 fputs("page_width: 0\n", fd);
 fputs("xfm: xfm\n", fd);
 fputs("compile: gcc -Wall -o ./a.out -g $f\n", fd);
 fputs("gzip: gzip -d\n", fd);
 fputs("document_dir: \n", fd);
 fputs("dictionary: english\n", fd);
 fputs("mail_server: localhost\n", fd);
 fputs("mail_from: root@localhost\n", fd);
 fputs("default_news: \n", fd); 
 fputs("default_web: \n", fd); 
 fputs("mail_reply: 0\n", fd);
 fputs("mirror_server: localhost\n", fd);
 fputs("news_server: localhost\n", fd);
 fputs("font: -adobe-helvetica-*-r-*-*-12-*-*-*-*-*-*-*\n", fd);
 fputs("background: white\n", fd);
 fputs("pixmap: none\n", fd);
 fputs("login_name: ", fd);
 fputs(getenv("LOGNAME"), fd);
 fputs("\n", fd);
 fputs("awk_macro_title: 1 To upper chars\n", fd);
 fputs("awk_macro: 1 { print toupper($0) }\n", fd);
 fputs("awk_macro_title: 2 Remove empty lines\n", fd);
 fputs("awk_macro: 2 length > 0\n", fd);
 fputs("sed_macro_title: 3 Remove all spaces\n", fd);
 fputs("sed_macro: 3 s/ //g\n", fd);
 fputs("filter_title: 1 Import a .dvi file\n", fd);
 fputs("filter: 1 /usr/local/bin/dvi2tty $i > $o\n", fd);
 fputs("filter_title: 2 Query an RPM package\n", fd);
 fputs("filter: 2 rpm -qp $i > $o\n", fd);
 fputs("filter: 2 rpm -qip $i >> $o\n", fd);
 fputs("filter: 2 rpm -qlp $i >> $o\n", fd);
 fclose(fd);
}

#ifdef USE_GNOME
 GnomeUIInfo toolbar_gnome[] = {
  {GNOME_APP_UI_ITEM, N_("New"), N_("Start a new text file"),
   CB_new_gxedit, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
   GNOME_STOCK_PIXMAP_NEW, 0, 0, NULL},
  {GNOME_APP_UI_ITEM, N_("Open"), N_("Open a text file"), 
   CB_open, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
   GNOME_STOCK_PIXMAP_OPEN, 0, 0, NULL},
  {GNOME_APP_UI_ITEM, N_("Save"), N_("Save the current file"), 
   CB_save, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
   GNOME_STOCK_PIXMAP_SAVE, 0, 0, NULL},
  GNOMEUIINFO_SEPARATOR,
  {GNOME_APP_UI_ITEM, N_("Copy"), N_("Copy selected text"), 
   CB_copy, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
   GNOME_STOCK_PIXMAP_COPY, 0, 0, NULL},
  {GNOME_APP_UI_ITEM, N_("Paste"), N_("Paste text"), 
   CB_paste, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
   GNOME_STOCK_PIXMAP_PASTE, 0, 0, NULL},
  GNOMEUIINFO_SEPARATOR,
  {GNOME_APP_UI_ITEM, N_("Print"), N_("Print the current text"),
   CB_print, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
   GNOME_STOCK_PIXMAP_PRINT, 0, 0, NULL},
  {GNOME_APP_UI_ITEM, N_("Settings"), N_("Change settings"), 
   CB_settings, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
   GNOME_STOCK_PIXMAP_PREFERENCES, 0, 0, NULL},
  {GNOME_APP_UI_ITEM, N_("Help"), N_("Getting started"), 
   CB_help, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
   GNOME_STOCK_PIXMAP_HELP, 0, 0, NULL},
  {GNOME_APP_UI_ITEM, N_("Exit"), N_("Close this window"), 
   CB_exit, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
   GNOME_STOCK_PIXMAP_QUIT, 0, 0, NULL},
  GNOMEUIINFO_END
 };
 GnomeUIInfo netbar_gnome[] = {
  {GNOME_APP_UI_ITEM, N_("New"), N_("Start a new text file"),
   CB_new_gxedit, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
   GNOME_STOCK_PIXMAP_NEW, 0, 0, NULL},
  {GNOME_APP_UI_ITEM, N_("Open"), N_("Open a text file"),
   CB_open, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
   GNOME_STOCK_PIXMAP_OPEN, 0, 0, NULL},
  {GNOME_APP_UI_ITEM, N_("Save"), N_("Save the current file"),
   CB_save, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
   GNOME_STOCK_PIXMAP_SAVE, 0, 0, NULL},
  GNOMEUIINFO_SEPARATOR,
  {GNOME_APP_UI_ITEM, N_("Copy"), N_("Copy selected text"),
   CB_copy, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
   GNOME_STOCK_PIXMAP_COPY, 0, 0, NULL},
  {GNOME_APP_UI_ITEM, N_("Paste"), N_("Paste text"),
   CB_paste, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
   GNOME_STOCK_PIXMAP_PASTE, 0, 0, NULL},
  GNOMEUIINFO_SEPARATOR,
  {GNOME_APP_UI_ITEM, N_("Print"), N_("Print the current text"),
   CB_print, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
   GNOME_STOCK_PIXMAP_PRINT, 0, 0, NULL},
  {GNOME_APP_UI_ITEM, N_("Settings"), N_("Change settings"),
   CB_settings, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
   GNOME_STOCK_PIXMAP_PREFERENCES, 0, 0, NULL},
  {GNOME_APP_UI_ITEM, N_("Help"), N_("Getting started"),
   CB_help, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
   GNOME_STOCK_PIXMAP_HELP, 0, 0, NULL},
  {GNOME_APP_UI_ITEM, N_("Exit"), N_("Close this window"),
   CB_exit, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
   GNOME_STOCK_PIXMAP_QUIT, 0, 0, NULL},
  GNOMEUIINFO_SEPARATOR,
  GNOMEUIINFO_SEPARATOR,
  {GNOME_APP_UI_ITEM, N_("Reply"), N_("Reply"),
   CB_new_gxedit, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
   GNOME_STOCK_PIXMAP_MAIL_NEW, 0, 0, NULL},
  GNOMEUIINFO_SEPARATOR,
  {GNOME_APP_UI_ITEM, N_("Receive"), N_("Open an e-mail"),
   CB_new_gxedit, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
   GNOME_STOCK_PIXMAP_MAIL_RCV, 0, 0, NULL},
  {GNOME_APP_UI_ITEM, N_("Send"), N_("Send an e-mail"),
   CB_new_gxedit, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
   GNOME_STOCK_PIXMAP_MAIL_SND, 0, 0, NULL},
  GNOMEUIINFO_SEPARATOR,
  {GNOME_APP_UI_ITEM, N_("Fetch"), N_("Fetch a news article"),
   CB_new_gxedit, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
   GNOME_STOCK_PIXMAP_BOOK_YELLOW, 0, 0, NULL},
  {GNOME_APP_UI_ITEM, N_("Post"), N_("Post to a newsgroup"),
   CB_new_gxedit, NULL, NULL, GNOME_APP_PIXMAP_STOCK,
   GNOME_STOCK_PIXMAP_BOOK_OPEN, 0, 0, NULL},
  GNOMEUIINFO_END
 };
#endif

void make_gui()
{
#ifndef GTK_1_1
 GtkAcceleratorTable *accel;
#endif
#ifdef USE_GNOME
 window = gnome_app_new("GXedit", "GTK text editor");
#else
 window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
#endif
 gtk_widget_set_usize (GTK_WIDGET (window), x_size, y_size);
 gtk_signal_connect (GTK_OBJECT (window), "destroy",
  GTK_SIGNAL_FUNC(CB_exit), &window);
 gtk_signal_connect (GTK_OBJECT (window), "delete_event",
  GTK_SIGNAL_FUNC(CB_exit), &window);
 sprintf(line, "GXedit %s - %s\n", VERSION, filename);
 gtk_window_set_title (GTK_WINDOW (window), line);
 gtk_widget_set_uposition (window, x_pos, y_pos);
 gtk_container_border_width (GTK_CONTAINER (window), 0);

 if(tooltips)
 {
  tips = gtk_tooltips_new();
  gtk_object_set_data (GTK_OBJECT (window), "GXedit", tips);
 }
 vbox = gtk_vbox_new (FALSE, 0);
#ifdef USE_GNOME
 gnome_app_set_contents(GNOME_APP (window), vbox);
#else
 gtk_container_add (GTK_CONTAINER (window), vbox);
#endif
 gtk_container_border_width (GTK_CONTAINER (vbox), 2);
 gtk_widget_show (vbox);

 menubar = gtk_menu_bar_new();
 gtk_box_pack_start (GTK_BOX (vbox), menubar, FALSE, TRUE, 0);
 if(!flat) gtk_widget_show (menubar);

 submenu = gtk_menu_new();

 menuitem = gtk_menu_item_new_with_label("Clear current text");
 gtk_menu_append(GTK_MENU(submenu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(CB_new), NULL);
 gtk_widget_show(menuitem);
 if(tooltips)
  gtk_tooltips_set_tip(tips, menuitem, "New text file", "");

 menuitem = gtk_menu_item_new_with_label("New window");
 gtk_menu_append(GTK_MENU(submenu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(CB_new_gxedit), GTK_OBJECT(window));
 gtk_widget_show(menuitem);
 if(tooltips)
  gtk_tooltips_set_tip(tips, menuitem, "Open a new GXedit", "");

 menubutton = gtk_menu_item_new_with_label("New");
 gtk_widget_show(menubutton);

 menu = gtk_menu_new();
  
 menuitem = gtk_menu_item_new_with_label("New");
 gtk_menu_item_set_submenu (GTK_MENU_ITEM (menuitem), submenu);
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_widget_show(menuitem);

 submenu = gtk_menu_new();

 menuitem = gtk_menu_item_new_with_label("Open file...");
 gtk_menu_append(GTK_MENU(submenu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(CB_open), NULL);
 gtk_widget_show(menuitem);
 if(tooltips)
  gtk_tooltips_set_tip(tips, menuitem, "Open a text file", "");

 menuitem = gtk_menu_item_new_with_label("Open in a new window");
 gtk_menu_append(GTK_MENU(submenu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",  
  GTK_SIGNAL_FUNC(CB_open_window), GTK_OBJECT(window));
 gtk_widget_show(menuitem);
 if(tooltips)
  gtk_tooltips_set_tip(tips, menuitem, "Open a text file in a new window", "");

 menuitem = gtk_menu_item_new_with_label("Open history");
 gtk_menu_append(GTK_MENU(submenu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(CB_open_last), GTK_OBJECT(window));
 gtk_widget_show(menuitem);
 if(tooltips)
  gtk_tooltips_set_tip(tips, menuitem, "Open last opened files", "");

 menuitem = gtk_menu_item_new();
 gtk_menu_append(GTK_MENU(submenu), menuitem);
 gtk_widget_show(menuitem);

 menuitem = gtk_menu_item_new_with_label("Open an e-mail");
 gtk_menu_append(GTK_MENU(submenu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(CB_open_mail), GTK_OBJECT(window));
 gtk_widget_show(menuitem);
 if(tooltips)
  gtk_tooltips_set_tip(tips, menuitem, "Open from your e-mail box", "");

#ifdef USE_NET
 menuitem = gtk_menu_item_new_with_label("Open a news article");
 gtk_menu_append(GTK_MENU(submenu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(CB_open_news), GTK_OBJECT(window));
 gtk_widget_show(menuitem);
 if(tooltips)
  gtk_tooltips_set_tip(tips, menuitem, "Open a newsgroup article", "");

 menuitem = gtk_menu_item_new_with_label("Open from the web");   
 gtk_menu_append(GTK_MENU(submenu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(CB_opennet), GTK_OBJECT(window));
 gtk_widget_show(menuitem);
 if(tooltips)
  gtk_tooltips_set_tip(tips, menuitem, "Open a text from the web", "");
#endif

 menuitem = gtk_menu_item_new_with_label("Open from the agenda");
 gtk_menu_append(GTK_MENU(submenu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(CB_agenda), (gpointer) 0);
 gtk_widget_show(menuitem);
 if(tooltips)
  gtk_tooltips_set_tip(tips, menuitem, "Open a date from the agenda", "");

 menuitem = gtk_menu_item_new_with_label("Decrypt file");
 gtk_menu_append(GTK_MENU(submenu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(CB_decrypt), (gpointer) 0);
 gtk_widget_show(menuitem);
 if(tooltips)
  gtk_tooltips_set_tip(tips, menuitem, "Decrypt file", "");

 menuitem = gtk_menu_item_new();
 gtk_menu_append(GTK_MENU(submenu), menuitem);
 gtk_widget_show(menuitem);

 submenu2 = gtk_menu_new();

 menuitem = gtk_menu_item_new_with_label("Import a man page");
 gtk_menu_append(GTK_MENU(submenu2), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(CB_import), (gpointer) 0);
 gtk_widget_show(menuitem);
 if(tooltips)
  gtk_tooltips_set_tip(tips, menuitem, "Open a man page", "");

 menuitem = gtk_menu_item_new_with_label("Import an RTF file");
 gtk_menu_append(GTK_MENU(submenu2), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(CB_import), (gpointer) 1);
 gtk_widget_show(menuitem);
 if(tooltips)
  gtk_tooltips_set_tip(tips, menuitem, "Open a .rtf file", "");

 menuitem = gtk_menu_item_new_with_label("Import a PostScript file");
 gtk_menu_append(GTK_MENU(submenu2), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(CB_import), (gpointer) 2);
 gtk_widget_show(menuitem);
 if(tooltips)
  gtk_tooltips_set_tip(tips, menuitem, "Open a .ps file", "");

 menuitem = gtk_menu_item_new_with_label("Import a rot13 file");
 gtk_menu_append(GTK_MENU(submenu2), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(CB_import), (gpointer) 3);
 gtk_widget_show(menuitem);
 if(tooltips)
  gtk_tooltips_set_tip(tips, menuitem, "Open a rot13 encoded file", "");

 menuitem = gtk_menu_item_new();
 gtk_menu_append(GTK_MENU(submenu2), menuitem);
 gtk_widget_show(menuitem);
   
 sprintf(temp, "%s/.gxedit", home);
 fd = fopen(temp, "r"); 
 while(fgets(line, 512, fd)!=NULL)
 {
  line[strlen(line)-1]=' ';
  if(!strcasecmp(lindex(line,0),"filter_title:"))  
  {
   strncpy(temp, lrange(line, 2), 1000);
   menuitem = gtk_menu_item_new_with_label(temp);
   gtk_menu_append(GTK_MENU(submenu2), menuitem);
   gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
   GTK_SIGNAL_FUNC(CB_filters), (gpointer) atoi(lindex(line,1)));
   gtk_widget_show(menuitem);
   fgets(line, 512, fd);
   line[strlen(line)-1]=' ';
   strncpy(temp, lrange(line, 1), 1000);
   if(tooltips)
    gtk_tooltips_set_tip(tips, menuitem, temp, "");
  }
 }
   
 menubutton = gtk_menu_item_new_with_label("Import file");
 gtk_widget_show(menubutton);
   
 menuitem = gtk_menu_item_new_with_label("Import file");
 gtk_menu_item_set_submenu (GTK_MENU_ITEM (menuitem), submenu2);
 gtk_menu_append(GTK_MENU(submenu), menuitem);
 gtk_widget_show(menuitem);

 menubutton = gtk_menu_item_new_with_label("Open");
 gtk_widget_show(menubutton);

 menuitem = gtk_menu_item_new_with_label("Open");
 gtk_menu_item_set_submenu (GTK_MENU_ITEM (menuitem), submenu);
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_widget_show(menuitem);

 submenu = gtk_menu_new();

 menuitem = gtk_menu_item_new_with_label("Save");
 gtk_menu_append(GTK_MENU(submenu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(CB_save), NULL);
 gtk_widget_show(menuitem);
 if(tooltips)
  gtk_tooltips_set_tip(tips, menuitem, "Save the current file", "");

 menuitem = gtk_menu_item_new_with_label("Save as...");
 gtk_menu_append(GTK_MENU(submenu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(CB_saveas), NULL);
 gtk_widget_show(menuitem);
 if(tooltips)
  gtk_tooltips_set_tip(tips, menuitem, "Save under an other name", "");

 menuitem = gtk_menu_item_new();
 gtk_menu_append(GTK_MENU(submenu), menuitem);
 gtk_widget_show(menuitem);

#ifdef USE_NET
 menuitem = gtk_menu_item_new_with_label("Send as e-mail");
 gtk_menu_append(GTK_MENU(submenu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",  
  GTK_SIGNAL_FUNC(CB_email), GTK_OBJECT(window));
 gtk_widget_show(menuitem);
 if(tooltips)
  gtk_tooltips_set_tip(tips, menuitem, "Send the current text as e-mail", "");

 menuitem = gtk_menu_item_new_with_label("Post in a newsgroup");
 gtk_menu_append(GTK_MENU(submenu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(CB_news_post), GTK_OBJECT(window));
 gtk_widget_show(menuitem);
 if(tooltips)
  gtk_tooltips_set_tip(tips, menuitem, "Send the current text as an article", "");
#endif

 menuitem = gtk_menu_item_new_with_label("Save in agenda");
 gtk_menu_append(GTK_MENU(submenu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(CB_agenda), (gpointer) 1);
 gtk_widget_show(menuitem);
 if(tooltips)
  gtk_tooltips_set_tip(tips, menuitem, "Save a date in the agenda","");

 menuitem = gtk_menu_item_new_with_label("Encrypt file");
 gtk_menu_append(GTK_MENU(submenu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(CB_encrypt), NULL);
 gtk_widget_show(menuitem);
 if(tooltips)
  gtk_tooltips_set_tip(tips, menuitem, "Encrypt file using des(1)","");

 menubutton = gtk_menu_item_new_with_label("Save");
 gtk_widget_show(menubutton);

 menuitem = gtk_menu_item_new_with_label("Save");
 gtk_menu_item_set_submenu (GTK_MENU_ITEM (menuitem), submenu);
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_widget_show(menuitem);

 menuitem = gtk_menu_item_new_with_label("Close");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(CB_new), GTK_OBJECT(window));
 gtk_widget_show(menuitem);
 if(tooltips)
  gtk_tooltips_set_tip(tips, menuitem, "Close and open a new text file", "");

 menuitem = gtk_menu_item_new_with_label("Reply");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(CB_reply), GTK_OBJECT(window));
 gtk_widget_show(menuitem);
 if(tooltips)
  gtk_tooltips_set_tip(tips, menuitem, "Reply to a mail or news article", "");

 menuitem = gtk_menu_item_new_with_label("Compile");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(CB_compile), GTK_OBJECT(window));   
 gtk_widget_show(menuitem);
 if(tooltips)
  gtk_tooltips_set_tip(tips, menuitem, "Use the compile command", "");

 menuitem = gtk_menu_item_new_with_label("Print");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(CB_print), GTK_OBJECT(window));
 gtk_widget_show(menuitem);
 if(tooltips)
  gtk_tooltips_set_tip(tips, menuitem, "Print file", "");

 menuitem = gtk_menu_item_new();
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_widget_show(menuitem);

 menuitem = gtk_menu_item_new_with_label("Exit");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(CB_exit), NULL);
 gtk_widget_show(menuitem);
 if(tooltips)
  gtk_tooltips_set_tip(tips, menuitem, "Close this window", "");

 menubutton = gtk_menu_item_new_with_label("File");
 gtk_widget_show(menubutton);
 
 gtk_menu_item_set_submenu(GTK_MENU_ITEM(menubutton), menu);
 gtk_menu_bar_append(GTK_MENU_BAR(menubar), menubutton);

 menu = gtk_menu_new();

 submenu = gtk_menu_new();

 menuitem = gtk_menu_item_new_with_label("Restore autosave file");
 gtk_menu_append(GTK_MENU(submenu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(CB_undo_as), (gpointer) 0);
 gtk_widget_show(menuitem);
 if(tooltips)
  gtk_tooltips_set_tip(tips, menuitem, "Restore autosave file", "");

 menuitem = gtk_menu_item_new_with_label("Restore last good text");
 gtk_menu_append(GTK_MENU(submenu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(CB_undo), (gpointer) 0);
 gtk_widget_show(menuitem);
 if(tooltips)
  gtk_tooltips_set_tip(tips, menuitem, "Restore UNDO file", "");

 menubutton = gtk_menu_item_new_with_label("Undo");
 gtk_widget_show(menubutton);

 menuitem = gtk_menu_item_new_with_label("Undo");
 gtk_menu_item_set_submenu (GTK_MENU_ITEM (menuitem), submenu);
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_widget_show(menuitem);

 menuitem = gtk_menu_item_new_with_label("Find...");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(CB_find), NULL);
 gtk_widget_show(menuitem);
 if(tooltips)
  gtk_tooltips_set_tip(tips, menuitem, "Find a string", "");

 menuitem = gtk_menu_item_new_with_label("Find again");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(CB_find_again), NULL);
 gtk_widget_show(menuitem);
 if(tooltips)
  gtk_tooltips_set_tip(tips, menuitem, "Continue the search", "");

 menuitem = gtk_menu_item_new_with_label("Goto line"); 
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",  
  GTK_SIGNAL_FUNC(CB_goto), NULL);
 gtk_widget_show(menuitem);
 if(tooltips)
  gtk_tooltips_set_tip(tips, menuitem, "Go to a line number", "");

 menuitem = gtk_menu_item_new_with_label("Copy");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(CB_copy), NULL);
 gtk_widget_show(menuitem);
 if(tooltips)
  gtk_tooltips_set_tip(tips, menuitem, "Copy selected text", "");

 menuitem = gtk_menu_item_new_with_label("Paste");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(CB_paste), NULL);
 gtk_widget_show(menuitem);
 if(tooltips)
  gtk_tooltips_set_tip(tips, menuitem, "Paste text", "");

 menuitem = gtk_menu_item_new();
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_widget_show(menuitem);

 submenu = gtk_menu_new();

 menuitem = gtk_menu_item_new_with_label("Insert date");
 gtk_menu_append(GTK_MENU(submenu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(CB_insert), (gpointer) 0);
 gtk_widget_show(menuitem);
 if(tooltips)
  gtk_tooltips_set_tip(tips, menuitem, "Add current date", "");

 menuitem = gtk_menu_item_new_with_label("Insert user info");
 gtk_menu_append(GTK_MENU(submenu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(CB_insert), (gpointer) 1);
 gtk_widget_show(menuitem);
 if(tooltips)
  gtk_tooltips_set_tip(tips, menuitem, "Add user info", "");

 menuitem = gtk_menu_item_new_with_label("Insert signature file");
 gtk_menu_append(GTK_MENU(submenu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(CB_insert), (gpointer) 2);
 gtk_widget_show(menuitem);
 if(tooltips)
  gtk_tooltips_set_tip(tips, menuitem, "Add signature info", "");

 menuitem = gtk_menu_item_new_with_label("Insert note");
 gtk_menu_append(GTK_MENU(submenu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(CB_insert_note), NULL);   
 gtk_widget_show(menuitem);
 if(tooltips)
  gtk_tooltips_set_tip(tips, menuitem, "Add a note to this file", "");

 menubutton = gtk_menu_item_new_with_label("Insert");
 gtk_widget_show(menubutton);

 menuitem = gtk_menu_item_new_with_label("Insert");
 gtk_menu_item_set_submenu (GTK_MENU_ITEM (menuitem), submenu);
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_widget_show(menuitem);

 submenu = gtk_menu_new();
  
 menuitem = gtk_menu_item_new_with_label("Header");
 gtk_menu_append(GTK_MENU(submenu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(CB_man), (gpointer) 0);
 gtk_widget_show(menuitem);
 if(tooltips)
  gtk_tooltips_set_tip(tips, menuitem, "Man page header", "");

 menuitem = gtk_menu_item_new_with_label("Comments");
 gtk_menu_append(GTK_MENU(submenu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(CB_man), (gpointer) 1);
 gtk_widget_show(menuitem);
 if(tooltips)
  gtk_tooltips_set_tip(tips, menuitem, "Man page comments", "");

 menuitem = gtk_menu_item_new_with_label("Synopsis");
 gtk_menu_append(GTK_MENU(submenu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(CB_man), (gpointer) 2);
 gtk_widget_show(menuitem);
 if(tooltips)
  gtk_tooltips_set_tip(tips, menuitem, "Add the synopsis section", "");

 menuitem = gtk_menu_item_new_with_label("Description");
 gtk_menu_append(GTK_MENU(submenu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(CB_man), (gpointer) 3);
 gtk_widget_show(menuitem);
 if(tooltips)
  gtk_tooltips_set_tip(tips, menuitem, "Add the description section", "");

 menuitem = gtk_menu_item_new_with_label("Options");
 gtk_menu_append(GTK_MENU(submenu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(CB_man), (gpointer) 4);
 gtk_widget_show(menuitem);
 if(tooltips)
  gtk_tooltips_set_tip(tips, menuitem, "Add the options section", "");

 menubutton = gtk_menu_item_new_with_label("Add man tags");
 gtk_widget_show(menubutton);

 menuitem = gtk_menu_item_new_with_label("Insert man tags");
 gtk_menu_item_set_submenu (GTK_MENU_ITEM (menuitem), submenu);
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_widget_show(menuitem);

 menubutton = gtk_menu_item_new_with_label("Edit");
 gtk_widget_show(menubutton);
 
 gtk_menu_item_set_submenu(GTK_MENU_ITEM(menubutton), menu);
 gtk_menu_bar_append(GTK_MENU_BAR(menubar), menubutton);

 menu = gtk_menu_new();

 menuitem = gtk_menu_item_new_with_label("Read a text file");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(CB_say_file), GTK_OBJECT(window));
 gtk_widget_show(menuitem);
 if(tooltips)
  gtk_tooltips_set_tip(tips, menuitem, "Open this text and say it", "");

 menuitem = gtk_menu_item_new_with_label("Read the current text");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(CB_say_current), GTK_OBJECT(window));
 gtk_widget_show(menuitem);
 if(tooltips)
  gtk_tooltips_set_tip(tips, menuitem, "Say the current text", "");

 menubutton = gtk_menu_item_new_with_label("Audio"); 
 gtk_widget_show(menubutton);

 gtk_menu_item_set_submenu(GTK_MENU_ITEM(menubutton), menu);
 gtk_menu_bar_append(GTK_MENU_BAR(menubar), menubutton);

 if(!audio) gtk_widget_set_sensitive (menubutton, FALSE);

 menu = gtk_menu_new();

 menuitem = gtk_menu_item_new_with_label("Open in Emacs");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(CB_emacs), GTK_OBJECT(window));
 gtk_widget_show(menuitem);
 if(tooltips)
  gtk_tooltips_set_tip(tips, menuitem, "Open this text in Emacs", "");

 menuitem = gtk_menu_item_new_with_label("Open in vi");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(CB_vi), GTK_OBJECT(window));
 gtk_widget_show(menuitem);
 if(tooltips)
  gtk_tooltips_set_tip(tips, menuitem, "Open this text in vi", "");

 menuitem = gtk_menu_item_new_with_label("Open in Netscape");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(CB_netscape), GTK_OBJECT(window));
 gtk_widget_show(menuitem);
 if(tooltips)
  gtk_tooltips_set_tip(tips, menuitem, "Open this text in netscape", "");

 menuitem = gtk_menu_item_new_with_label("Open in ...");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(CB_links_in), GTK_OBJECT(window));
 gtk_widget_show(menuitem);
 if(tooltips)
  gtk_tooltips_set_tip(tips, menuitem, "Open this text in something", "");

 menubutton = gtk_menu_item_new_with_label("Links");
 gtk_widget_show(menubutton);

 gtk_menu_item_set_submenu(GTK_MENU_ITEM(menubutton), menu);
 gtk_menu_bar_append(GTK_MENU_BAR(menubar), menubutton);

 menu = gtk_menu_new();

 submenu = gtk_menu_new();
 
 menuitem = gtk_menu_item_new_with_label("Header");
 gtk_menu_append(GTK_MENU(submenu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(CB_HTML), (gpointer) 0);
 gtk_widget_show(menuitem);
 if(tooltips)
  gtk_tooltips_set_tip(tips, menuitem, "HTML page header", "");

 menuitem = gtk_menu_item_new_with_label("Font");
 gtk_menu_append(GTK_MENU(submenu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(CB_HTML), (gpointer) 1);
 gtk_widget_show(menuitem);
 if(tooltips)
  gtk_tooltips_set_tip(tips, menuitem, "Font size and face", "");

 menuitem = gtk_menu_item_new_with_label("Center");
 gtk_menu_append(GTK_MENU(submenu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(CB_HTML), (gpointer) 2);
 gtk_widget_show(menuitem);
 if(tooltips)
  gtk_tooltips_set_tip(tips, menuitem, "Center text", "");

 menuitem = gtk_menu_item_new_with_label("Line");
 gtk_menu_append(GTK_MENU(submenu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(CB_HTML), (gpointer) 3);
 gtk_widget_show(menuitem);
 if(tooltips)
  gtk_tooltips_set_tip(tips, menuitem, "Line", "");

 menuitem = gtk_menu_item_new_with_label("Table");
 gtk_menu_append(GTK_MENU(submenu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(CB_HTML), (gpointer) 4);
 gtk_widget_show(menuitem);
 if(tooltips)
  gtk_tooltips_set_tip(tips, menuitem, "Table", "");

 menuitem = gtk_menu_item_new_with_label("Image");
 gtk_menu_append(GTK_MENU(submenu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(CB_HTML), (gpointer) 5);
 gtk_widget_show(menuitem);
 if(tooltips)
  gtk_tooltips_set_tip(tips, menuitem, "Insert image", "");

 menuitem = gtk_menu_item_new_with_label("Link");
 gtk_menu_append(GTK_MENU(submenu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(CB_HTML), (gpointer) 6);
 gtk_widget_show(menuitem);
 if(tooltips)
  gtk_tooltips_set_tip(tips, menuitem, "Add a link", "");

 menuitem = gtk_menu_item_new_with_label("Line break");
 gtk_menu_append(GTK_MENU(submenu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(CB_HTML), (gpointer) 7);
 gtk_widget_show(menuitem);
 if(tooltips)
  gtk_tooltips_set_tip(tips, menuitem, "Add a page br", "");

 menuitem = gtk_menu_item_new_with_label("List item");
 gtk_menu_append(GTK_MENU(submenu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(CB_HTML), (gpointer) 10);
 gtk_widget_show(menuitem);
 if(tooltips)
  gtk_tooltips_set_tip(tips, menuitem, "Add an LI", "");

 menubutton = gtk_menu_item_new_with_label("Insert common tags");
 gtk_widget_show(menubutton);
  
 menuitem = gtk_menu_item_new_with_label("Insert common tags");
 gtk_menu_item_set_submenu (GTK_MENU_ITEM (menuitem), submenu);
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_widget_show(menuitem);

 submenu = gtk_menu_new();

 menuitem = gtk_menu_item_new_with_label("Bold");
 gtk_menu_append(GTK_MENU(submenu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(CB_HTML), (gpointer) 8);
 gtk_widget_show(menuitem);
 if(tooltips)
  gtk_tooltips_set_tip(tips, menuitem, "Add a B", "");

 menuitem = gtk_menu_item_new_with_label("Italic");
 gtk_menu_append(GTK_MENU(submenu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(CB_HTML), (gpointer) 9);
 gtk_widget_show(menuitem);
 if(tooltips)
  gtk_tooltips_set_tip(tips, menuitem, "Add an I", "");

 menuitem = gtk_menu_item_new_with_label("Underline");
 gtk_menu_append(GTK_MENU(submenu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(CB_HTML), (gpointer) 11);
 gtk_widget_show(menuitem);
 if(tooltips)
  gtk_tooltips_set_tip(tips, menuitem, "Add an U", "");

 menuitem = gtk_menu_item_new_with_label("Superscript");
 gtk_menu_append(GTK_MENU(submenu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(CB_HTML), (gpointer) 12);
 gtk_widget_show(menuitem);
 if(tooltips)
  gtk_tooltips_set_tip(tips, menuitem, "Add an SUP", "");

 menuitem = gtk_menu_item_new_with_label("Subscript");
 gtk_menu_append(GTK_MENU(submenu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(CB_HTML), (gpointer) 13);
 gtk_widget_show(menuitem);
 if(tooltips)
  gtk_tooltips_set_tip(tips, menuitem, "Add an SUB", "");

 menubutton = gtk_menu_item_new_with_label("Add style");
 gtk_widget_show(menubutton);

 menuitem = gtk_menu_item_new_with_label("Add style");
 gtk_menu_item_set_submenu (GTK_MENU_ITEM (menuitem), submenu);
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_widget_show(menuitem);

 menuitem = gtk_menu_item_new();
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_widget_show(menuitem);

 menuitem = gtk_menu_item_new_with_label("Preview in Netscape");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(CB_netscape), NULL);
 gtk_widget_show(menuitem);
 if(tooltips)
  gtk_tooltips_set_tip(tips, menuitem, "Open file in Netscape", "");

 menuitem = gtk_menu_item_new_with_label("Launch images viewer");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(CB_xv), NULL);
 gtk_widget_show(menuitem);
 if(tooltips)
  gtk_tooltips_set_tip(tips, menuitem, "Launch images viewer", "");                                

 menubutton = gtk_menu_item_new_with_label("HTML");
 gtk_widget_show(menubutton);
 
 gtk_menu_item_set_submenu(GTK_MENU_ITEM(menubutton), menu);
 gtk_menu_bar_append(GTK_MENU_BAR(menubar), menubutton);

 BMmenu = gtk_menu_new();

 menuitem = gtk_menu_item_new_with_label("Add file to bookmarks");
 gtk_menu_append(GTK_MENU(BMmenu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(CB_bookmarks_add), NULL);
 gtk_widget_show(menuitem);
 if(tooltips)
  gtk_tooltips_set_tip(tips, menuitem, "Add this file name in the bookmarks", "");

 menuitem = gtk_menu_item_new_with_label("Remove file from bookmarks");
 gtk_menu_append(GTK_MENU(BMmenu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(CB_bookmarks_del), NULL);
 gtk_widget_show(menuitem);
 if(tooltips)
  gtk_tooltips_set_tip(tips, menuitem, "Remove this file name from the bookmarks", "");

 menuitem = gtk_menu_item_new();
 gtk_menu_append(GTK_MENU(BMmenu), menuitem);
 gtk_widget_show(menuitem);

 sprintf(temp, "%s/.gxedit.bookmarks", home);
 fd = fopen(temp, "r");
 if(fd!=NULL)
 {
  while(fgets(line, 500, fd)!=NULL)
  {
   menuitem = gtk_menu_item_new_with_label(lindex(line,0));
   gtk_menu_append(GTK_MENU(BMmenu), menuitem);
   gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
   GTK_SIGNAL_FUNC(CB_bookmarks), (gpointer)atoi(lindex(line,1)));
   gtk_widget_show(menuitem);
  }
  fclose(fd);
 }

 menubutton = gtk_menu_item_new_with_label("Bookmarks"); 
 gtk_widget_show(menubutton);

 gtk_menu_item_set_submenu(GTK_MENU_ITEM(menubutton), BMmenu);
 gtk_menu_bar_append(GTK_MENU_BAR(menubar), menubutton);

 menu = gtk_menu_new();

 menuitem = gtk_menu_item_new_with_label("Settings");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(CB_settings), NULL);
 gtk_widget_show(menuitem);
 if(tooltips)
  gtk_tooltips_set_tip(tips, menuitem, "Set options", "");

 menuitem = gtk_menu_item_new_with_label("Shell command");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(CB_run), NULL);
 gtk_widget_show(menuitem);
 if(tooltips)
  gtk_tooltips_set_tip(tips, menuitem, "Run a shell command", "");

 menuitem = gtk_menu_item_new_with_label("Check spelling");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(CB_spell), NULL);
 gtk_widget_show(menuitem);
 if(tooltips)
  gtk_tooltips_set_tip(tips, menuitem, "Check the spelling of words", "");

 menuitem = gtk_menu_item_new_with_label("Set indent level");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(CB_indent), NULL);
 gtk_widget_show(menuitem);
 if(tooltips)
  gtk_tooltips_set_tip(tips, menuitem, "Set line indent level", "");

 menuitem = gtk_menu_item_new_with_label("Send messages");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(CB_msg), NULL);
 gtk_widget_show(menuitem);
 if(tooltips)
  gtk_tooltips_set_tip(tips, menuitem, "Send messages to local users", "");

 menuitem = gtk_menu_item_new_with_label("Scripting command");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(CB_awk), NULL);
 gtk_widget_show(menuitem);  
 if(tooltips)
  gtk_tooltips_set_tip(tips, menuitem, "Apply an awk scripting command on the current text", "");

 submenu = gtk_menu_new();

 sprintf(temp, "%s/.gxedit", home);
 fd = fopen(temp, "r");
 while(fgets(line, 512, fd)!=NULL)
 {
  line[strlen(line)-1]=' ';
  if(!strcasecmp(lindex(line,0),"macro_title:"))
  {
   strncpy(temp, lrange(line, 2), 1000);
   menuitem = gtk_menu_item_new_with_label(temp);
   gtk_menu_append(GTK_MENU(submenu), menuitem);
   gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
   GTK_SIGNAL_FUNC(CB_macros), (gpointer) atoi(lindex(line,1)));
   gtk_widget_show(menuitem);
   fgets(line, 512, fd);
   line[strlen(line)-1]=' ';
   strncpy(temp, lrange(line, 1), 1000);
   if(tooltips)
    gtk_tooltips_set_tip(tips, menuitem, temp, "");
  }
  if(!strcasecmp(lindex(line,0),"awk_macro_title:"))
  {
   strncpy(temp, lrange(line, 2), 1000);
   menuitem = gtk_menu_item_new_with_label(temp);
   gtk_menu_append(GTK_MENU(submenu), menuitem);
   gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
   GTK_SIGNAL_FUNC(CB_macros), (gpointer) atoi(lindex(line,1)));
   gtk_widget_show(menuitem);
   fgets(line, 512, fd);
   line[strlen(line)-1]=' ';
   strncpy(temp, lrange(line, 1), 1000);
   if(tooltips)
    gtk_tooltips_set_tip(tips, menuitem, temp, "");
  }
  if(!strcasecmp(lindex(line,0),"sed_macro_title:"))
  {
   strncpy(temp, lrange(line, 2), 1000);
   menuitem = gtk_menu_item_new_with_label(temp);
   gtk_menu_append(GTK_MENU(submenu), menuitem);
   gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
   GTK_SIGNAL_FUNC(CB_macros), (gpointer) atoi(lindex(line,1)));
   gtk_widget_show(menuitem);
   fgets(line, 512, fd);
   line[strlen(line)-1]=' ';
   strncpy(temp, lrange(line, 1), 1000);
   if(tooltips)
    gtk_tooltips_set_tip(tips, menuitem, temp, "");
  }
 }

 menubutton = gtk_menu_item_new_with_label("User macros");
 gtk_widget_show(menubutton);
 
 menuitem = gtk_menu_item_new_with_label("User macros");
 gtk_menu_item_set_submenu (GTK_MENU_ITEM (menuitem), submenu);
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_widget_show(menuitem);

 submenu = gtk_menu_new();
  
 menuitem = gtk_menu_item_new_with_label("Compare files");
 gtk_menu_append(GTK_MENU(submenu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(CB_files_1), (gpointer) 0);
 gtk_widget_show(menuitem);
 if(tooltips)
  gtk_tooltips_set_tip(tips, menuitem, "Compare two files", "");

 menuitem = gtk_menu_item_new_with_label("Merge files");
 gtk_menu_append(GTK_MENU(submenu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(CB_files_1), (gpointer) 1);
 gtk_widget_show(menuitem);
 if(tooltips)
  gtk_tooltips_set_tip(tips, menuitem, "Compare two files", "");

 menuitem = gtk_menu_item_new_with_label("Sort files");
 gtk_menu_append(GTK_MENU(submenu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(CB_files_1), (gpointer) 2);
 gtk_widget_show(menuitem);
 if(tooltips)
  gtk_tooltips_set_tip(tips, menuitem, "Sort two files", "");

 menuitem = gtk_menu_item_new_with_label("Search files");
 gtk_menu_append(GTK_MENU(submenu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(CB_grep), GTK_OBJECT(window));
 gtk_widget_show(menuitem);
 if(tooltips)
  gtk_tooltips_set_tip(tips, menuitem, "Search text in file", "");

 menuitem = gtk_menu_item_new();
 gtk_menu_append(GTK_MENU(submenu), menuitem);
 gtk_widget_show(menuitem);

 menuitem = gtk_menu_item_new_with_label("Files manager");
 gtk_menu_append(GTK_MENU(submenu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(CB_files_xfm), GTK_OBJECT(window));
 gtk_widget_show(menuitem);
 if(tooltips)
  gtk_tooltips_set_tip(tips, menuitem, "Start XFM", "");

 menubutton = gtk_menu_item_new_with_label("Files operations");
 gtk_widget_show(menubutton);
  
 menuitem = gtk_menu_item_new_with_label("Files operations");
 gtk_menu_item_set_submenu (GTK_MENU_ITEM (menuitem), submenu);
 gtk_menu_append(GTK_MENU(menu), menuitem);   
 gtk_widget_show(menuitem);

 submenu = gtk_menu_new();

 menuitem = gtk_menu_item_new_with_label("Establish a server");
 gtk_menu_append(GTK_MENU(submenu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(CB_mirror_server), GTK_OBJECT(window));
 gtk_widget_show(menuitem);
 if(tooltips)
  gtk_tooltips_set_tip(tips, menuitem, "Open a mirror server", "");

 menuitem = gtk_menu_item_new_with_label("Establish a connection");
 gtk_menu_append(GTK_MENU(submenu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(CB_mirror_client), GTK_OBJECT(window));
 gtk_widget_show(menuitem);
 if(tooltips)
  gtk_tooltips_set_tip(tips, menuitem, "Open a connection to a remote host","");

 menuitem = gtk_menu_item_new_with_label("Close the connection");
 gtk_menu_append(GTK_MENU(submenu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(CB_mirror_close), GTK_OBJECT(window));
 gtk_widget_show(menuitem);
 if(tooltips)
  gtk_tooltips_set_tip(tips, menuitem, "Close the mirror connection", "");

 menubutton = gtk_menu_item_new_with_label("Mirror connections");
 gtk_widget_show(menubutton);

 menuitem = gtk_menu_item_new_with_label("Mirror connections");  
 gtk_menu_item_set_submenu (GTK_MENU_ITEM (menuitem), submenu);
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_widget_show(menuitem);

 menuitem = gtk_menu_item_new();
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_widget_show(menuitem);

 menuitem = gtk_menu_item_new_with_label("Words per minute");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(CB_mins), NULL);
 gtk_widget_show(menuitem);
 if(tooltips)
  gtk_tooltips_set_tip(tips, menuitem, "Count the number of words you can type in one minute", "");

 menuitem = gtk_menu_item_new_with_label("Lines count");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(CB_lines_count), NULL);
 gtk_widget_show(menuitem);
 if(tooltips)
  gtk_tooltips_set_tip(tips, menuitem, "Count the number of lines", "");

 menuitem = gtk_menu_item_new_with_label("Words count");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(CB_words_count), NULL);
 gtk_widget_show(menuitem);
 if(tooltips)
  gtk_tooltips_set_tip(tips, menuitem, "Count the number of words", "");

 menuitem = gtk_menu_item_new_with_label("Bytes count");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(CB_bytes_count), NULL);
 gtk_widget_show(menuitem);
 if(tooltips)
  gtk_tooltips_set_tip(tips, menuitem, "Count the number of bytes", "");

 menubutton = gtk_menu_item_new_with_label("Options");
 gtk_widget_show(menubutton);

 gtk_menu_item_set_submenu(GTK_MENU_ITEM(menubutton), menu);
 gtk_menu_bar_append(GTK_MENU_BAR(menubar), menubutton);

 menu = gtk_menu_new();

 menuitem = gtk_menu_item_new_with_label("User manual");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(CB_help), NULL);
 gtk_widget_show(menuitem);
 if(tooltips)
  gtk_tooltips_set_tip(tips, menuitem, "Help on GXedit", "");

 menuitem = gtk_menu_item_new_with_label("HTML reference");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(CB_ref), NULL);
 gtk_widget_show(menuitem);
 if(tooltips)
  gtk_tooltips_set_tip(tips, menuitem, "HTML reference", "");

 menuitem = gtk_menu_item_new_with_label("System information");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(CB_sysinfo), NULL);
 gtk_widget_show(menuitem);
 if(tooltips)
  gtk_tooltips_set_tip(tips, menuitem, "Run Xproc", "");

 menuitem = gtk_menu_item_new_with_label("About GXedit");
 gtk_menu_append(GTK_MENU(menu), menuitem);
 gtk_signal_connect_object(GTK_OBJECT(menuitem), "activate",
  GTK_SIGNAL_FUNC(CB_about), GTK_OBJECT(window));
 gtk_widget_show(menuitem);
 if(tooltips)
  gtk_tooltips_set_tip(tips, menuitem, "About GXedit", "");

 menubutton = gtk_menu_item_new_with_label("Help");
 gtk_widget_show(menubutton);
 
 gtk_menu_item_set_submenu(GTK_MENU_ITEM(menubutton), menu);
 gtk_menu_bar_append(GTK_MENU_BAR(menubar), menubutton);

#ifndef GTK_1_1
 get_main_menu(NULL, &accel);
 gtk_window_add_accelerator_table(GTK_WINDOW(window), accel);
#endif

#ifdef USE_GNOME
 if(toolbar)
 if(!netbar)
 {
  gnome_app_create_toolbar (GNOME_APP(window), toolbar_gnome);
  gnome_app_toolbar_set_position(GNOME_APP(window), GNOME_APP_POS_FLOATING);
  if(icons) gtk_toolbar_set_style(GTK_TOOLBAR(GNOME_APP(window)->toolbar), GTK_TOOLBAR_ICONS);
 }
 else
 {
  gnome_app_create_toolbar (GNOME_APP(window), netbar_gnome);
  gnome_app_toolbar_set_position(GNOME_APP(window), GNOME_APP_POS_FLOATING);
  if(icons) gtk_toolbar_set_style(GTK_TOOLBAR(GNOME_APP(window)->toolbar), GTK_TOOLBAR_ICONS);
 }
#else

 if(toolbar)
 {
  gtk_window_set_policy (GTK_WINDOW (window), FALSE, TRUE, TRUE);
  gtk_widget_realize (window);

  handle_box = gtk_handle_box_new ();
  gtk_box_pack_start (GTK_BOX (vbox), handle_box, FALSE, FALSE, 0);

  hbox = gtk_toolbar_new (GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_BOTH);
#ifdef GTK_1_1
  gtk_toolbar_set_button_relief (GTK_TOOLBAR (hbox), GTK_RELIEF_NONE);
  gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
#else
  gtk_container_add (GTK_CONTAINER (handle_box), hbox);
  gtk_widget_show (handle_box);
#endif

  if(tooltips)
  {
   if(icons)
   {
    gtk_toolbar_append_item (GTK_TOOLBAR (hbox), NULL, "Start a new text",
    "", new_pixmap (0, window->window, &color),
    GTK_SIGNAL_FUNC(CB_new_gxedit), GTK_OBJECT(window));

    if(!old_open)
    gtk_toolbar_append_item (GTK_TOOLBAR (hbox), NULL, "Open a text file",
    "", new_pixmap (1, window->window, &color),
    GTK_SIGNAL_FUNC(CB_open_window), GTK_OBJECT(window));
    else
    gtk_toolbar_append_item (GTK_TOOLBAR (hbox), NULL, "Open a text file",
    "", new_pixmap (1, window->window, &color),
    GTK_SIGNAL_FUNC(CB_open), GTK_OBJECT(window));
   
    gtk_toolbar_append_item (GTK_TOOLBAR (hbox), NULL, "Save to the current file",
    "", new_pixmap (2, window->window, &color),   
    GTK_SIGNAL_FUNC(CB_save), GTK_OBJECT(window));
   
    gtk_toolbar_append_space (GTK_TOOLBAR(hbox));
   
    if(full_tb)
    {
     gtk_toolbar_append_item (GTK_TOOLBAR (hbox), NULL, "Copy text",
     "", new_pixmap (5, window->window, &color),   
     GTK_SIGNAL_FUNC(CB_copy), GTK_OBJECT(window));
 
     gtk_toolbar_append_item (GTK_TOOLBAR (hbox), NULL, "Paste text",
     "", new_pixmap (6, window->window, &color),  
     GTK_SIGNAL_FUNC(CB_paste), GTK_OBJECT(window));
   
     gtk_toolbar_append_space (GTK_TOOLBAR(hbox));
    
     gtk_toolbar_append_item (GTK_TOOLBAR (hbox), NULL, "Change settings",
     "", new_pixmap (7, window->window, &color),
     GTK_SIGNAL_FUNC(CB_settings), GTK_OBJECT(window));
    }
   
    gtk_toolbar_append_item (GTK_TOOLBAR (hbox), NULL, "Getting started",
    "", new_pixmap (3, window->window, &color),   
    GTK_SIGNAL_FUNC(CB_help), GTK_OBJECT(window));  
   
    gtk_toolbar_append_item (GTK_TOOLBAR (hbox), NULL, "Close this window",
    "", new_pixmap (4, window->window, &color),
    GTK_SIGNAL_FUNC(CB_exit), GTK_OBJECT(window));
   }
   else /* icons */
   {
    gtk_toolbar_append_item (GTK_TOOLBAR (hbox), "New", "Start a new text", 
    "", new_pixmap (0, window->window, &color),
    GTK_SIGNAL_FUNC(CB_new_gxedit), GTK_OBJECT(window));

    if(!old_open) 
    gtk_toolbar_append_item (GTK_TOOLBAR (hbox), "Open", "Open a text file", 
    "", new_pixmap (1, window->window, &color),
    GTK_SIGNAL_FUNC(CB_open_window), GTK_OBJECT(window));
    else
    gtk_toolbar_append_item (GTK_TOOLBAR (hbox), "Open", "Open a text file",
    "", new_pixmap (1, window->window, &color),
    GTK_SIGNAL_FUNC(CB_open), GTK_OBJECT(window));

    gtk_toolbar_append_item (GTK_TOOLBAR (hbox), "Save", "Save to the current file",
    "", new_pixmap (2, window->window, &color),
    GTK_SIGNAL_FUNC(CB_save), GTK_OBJECT(window));
 
    gtk_toolbar_append_space (GTK_TOOLBAR(hbox));
 
    if(full_tb)
    {
     gtk_toolbar_append_item (GTK_TOOLBAR (hbox), "Copy", "Copy text",
     "", new_pixmap (5, window->window, &color),
     GTK_SIGNAL_FUNC(CB_copy), GTK_OBJECT(window)); 

     gtk_toolbar_append_item (GTK_TOOLBAR (hbox), "Paste", "Paste text",
     "", new_pixmap (6, window->window, &color),   
     GTK_SIGNAL_FUNC(CB_paste), GTK_OBJECT(window));
 
     gtk_toolbar_append_space (GTK_TOOLBAR(hbox)); 
 
     gtk_toolbar_append_item (GTK_TOOLBAR (hbox), "Print", "Print the current text",
     "", new_pixmap (10, window->window, &color),
     GTK_SIGNAL_FUNC(CB_print), GTK_OBJECT(window));

     gtk_toolbar_append_item (GTK_TOOLBAR (hbox), "Settings", "Change settings",
     "", new_pixmap (7, window->window, &color),   
     GTK_SIGNAL_FUNC(CB_settings), GTK_OBJECT(window));
    }
 
    gtk_toolbar_append_item (GTK_TOOLBAR (hbox), "Help", "Getting started",
    "", new_pixmap (3, window->window, &color),
    GTK_SIGNAL_FUNC(CB_help), GTK_OBJECT(window));
 
    gtk_toolbar_append_item (GTK_TOOLBAR (hbox), "Exit", "Close this window",
    "", new_pixmap (4, window->window, &color),
    GTK_SIGNAL_FUNC(CB_exit), GTK_OBJECT(window));
   }
  }
  else /* tooltips */
  {
   if(icons)
   {
    gtk_toolbar_append_item (GTK_TOOLBAR (hbox), NULL, NULL,
    "", new_pixmap (0, window->window, &color),
    GTK_SIGNAL_FUNC(CB_new_gxedit), GTK_OBJECT(window));

    if(!old_open)
    gtk_toolbar_append_item (GTK_TOOLBAR (hbox), NULL, NULL,
    "", new_pixmap (1, window->window, &color),
    GTK_SIGNAL_FUNC(CB_open_window), GTK_OBJECT(window));
    else
    gtk_toolbar_append_item (GTK_TOOLBAR (hbox), NULL, NULL,
    "", new_pixmap (1, window->window, &color),
    GTK_SIGNAL_FUNC(CB_open), GTK_OBJECT(window));
   
    gtk_toolbar_append_item (GTK_TOOLBAR (hbox), NULL, NULL,
    "", new_pixmap (2, window->window, &color),
    GTK_SIGNAL_FUNC(CB_save), GTK_OBJECT(window));
    
    gtk_toolbar_append_space (GTK_TOOLBAR(hbox));
 
    if(full_tb)
    {
     gtk_toolbar_append_item (GTK_TOOLBAR (hbox), NULL, NULL,
     "", new_pixmap (5, window->window, &color),  
     GTK_SIGNAL_FUNC(CB_copy), GTK_OBJECT(window));
    
     gtk_toolbar_append_item (GTK_TOOLBAR (hbox), NULL, NULL,
     "", new_pixmap (6, window->window, &color),  
     GTK_SIGNAL_FUNC(CB_paste), GTK_OBJECT(window));
    
     gtk_toolbar_append_space (GTK_TOOLBAR(hbox));
    
     gtk_toolbar_append_item (GTK_TOOLBAR (hbox), NULL, NULL,
     "", new_pixmap (7, window->window, &color),
     GTK_SIGNAL_FUNC(CB_settings), GTK_OBJECT(window));
    }
 
    gtk_toolbar_append_item (GTK_TOOLBAR (hbox), NULL, NULL,
    "", new_pixmap (3, window->window, &color),   
    GTK_SIGNAL_FUNC(CB_help), GTK_OBJECT(window));  
    
    gtk_toolbar_append_item (GTK_TOOLBAR (hbox), NULL, NULL,
    "", new_pixmap (4, window->window, &color),
    GTK_SIGNAL_FUNC(CB_exit), GTK_OBJECT(window));
   }
   else /* icons */
   {
    gtk_toolbar_append_item (GTK_TOOLBAR (hbox), "New", NULL,
    "", new_pixmap (0, window->window, &color),  
    GTK_SIGNAL_FUNC(CB_new_gxedit), GTK_OBJECT(window));

    if(!old_open)
    gtk_toolbar_append_item (GTK_TOOLBAR (hbox), "Open", NULL,
    "", new_pixmap (1, window->window, &color),   
    GTK_SIGNAL_FUNC(CB_open_window), GTK_OBJECT(window));
    else
    gtk_toolbar_append_item (GTK_TOOLBAR (hbox), "Open", NULL,
    "", new_pixmap (1, window->window, &color),   
    GTK_SIGNAL_FUNC(CB_open), GTK_OBJECT(window));
  
    gtk_toolbar_append_item (GTK_TOOLBAR (hbox), "Save", NULL,
    "", new_pixmap (2, window->window, &color),   
    GTK_SIGNAL_FUNC(CB_save), GTK_OBJECT(window));
  
    gtk_toolbar_append_space (GTK_TOOLBAR(hbox)); 
 
    if(full_tb)
    {
     gtk_toolbar_append_item (GTK_TOOLBAR (hbox), "Copy", NULL,
     "", new_pixmap (5, window->window, &color),
     GTK_SIGNAL_FUNC(CB_copy), GTK_OBJECT(window));
     
     gtk_toolbar_append_item (GTK_TOOLBAR (hbox), "Paste", NULL,
     "", new_pixmap (6, window->window, &color),
     GTK_SIGNAL_FUNC(CB_paste), GTK_OBJECT(window));
    
     gtk_toolbar_append_space (GTK_TOOLBAR(hbox));

     gtk_toolbar_append_item (GTK_TOOLBAR (hbox), "Print", NULL,
     "", new_pixmap (10, window->window, &color),
     GTK_SIGNAL_FUNC(CB_print), GTK_OBJECT(window));
    
     gtk_toolbar_append_item (GTK_TOOLBAR (hbox), "Settings", NULL,
     "", new_pixmap (7, window->window, &color),
     GTK_SIGNAL_FUNC(CB_settings), GTK_OBJECT(window));
    }
 
    gtk_toolbar_append_item (GTK_TOOLBAR (hbox), "Help", NULL,
    "", new_pixmap (3, window->window, &color),
    GTK_SIGNAL_FUNC(CB_help), GTK_OBJECT(window));
    
    gtk_toolbar_append_item (GTK_TOOLBAR (hbox), "Exit", NULL,
    "", new_pixmap (4, window->window, &color),
    GTK_SIGNAL_FUNC(CB_exit), GTK_OBJECT(window));
   }
  }
  if(!flat) gtk_widget_show (hbox);
 }
#endif

 hbox2 = gtk_hbox_new (FALSE, 0);
 gtk_box_pack_start (GTK_BOX (vbox), hbox2, TRUE, TRUE, 0);
 gtk_widget_show (hbox2);

#ifndef USE_GNOME
 if(netbar)
 {
  gtk_window_set_policy (GTK_WINDOW (window), FALSE, TRUE, TRUE);
  gtk_widget_realize (window);

  handle_box = gtk_handle_box_new ();
  gtk_box_pack_start (GTK_BOX (hbox2), handle_box, FALSE, FALSE, 0);
  
  hbox = gtk_toolbar_new (GTK_ORIENTATION_VERTICAL, GTK_TOOLBAR_BOTH);
#ifdef GTK_1_1
  gtk_toolbar_set_button_relief (GTK_TOOLBAR (hbox), GTK_RELIEF_NONE);
  gtk_box_pack_start (GTK_BOX (hbox2), hbox, FALSE, FALSE, 0);
#else
  gtk_container_add (GTK_CONTAINER (handle_box), hbox);
  gtk_widget_show (handle_box);
#endif

  if(icons) {
  if(tooltips)
  {
   gtk_toolbar_append_item (GTK_TOOLBAR (hbox), NULL, "Reply",
   "", new_pixmap (101, window->window, &color),
   GTK_SIGNAL_FUNC(CB_reply), GTK_OBJECT(window));

   gtk_toolbar_append_space (GTK_TOOLBAR(hbox));

   gtk_toolbar_append_item (GTK_TOOLBAR (hbox), NULL, "Open an e-mail",
   "", new_pixmap (102, window->window, &color),
   GTK_SIGNAL_FUNC(CB_open_mail), GTK_OBJECT(window));

   gtk_toolbar_append_item (GTK_TOOLBAR (hbox), NULL, "Send as e-mail",
   "", new_pixmap (103, window->window, &color),
   GTK_SIGNAL_FUNC(CB_email), GTK_OBJECT(window));

   gtk_toolbar_append_space (GTK_TOOLBAR(hbox));

   gtk_toolbar_append_item (GTK_TOOLBAR (hbox), NULL, "Fetch a news article",
   "", new_pixmap (104, window->window, &color),
   GTK_SIGNAL_FUNC(CB_open_news), GTK_OBJECT(window));

   gtk_toolbar_append_item (GTK_TOOLBAR (hbox), NULL, "Post text to a newsgroup",
   "", new_pixmap (105, window->window, &color),
   GTK_SIGNAL_FUNC(CB_news_post), GTK_OBJECT(window));

   gtk_toolbar_append_space (GTK_TOOLBAR(hbox));

   sprintf(temp, "%s/.gxedit.applications", home);
   fd = fopen(temp, "r");
   while(fgets(line, 512, fd)!=NULL)
   {
    if(!strcasecmp(lindex(line,0),"application:"))
    {
     strncpy(temp, lrange(line,5), 512);
     gtk_toolbar_append_item (GTK_TOOLBAR (hbox), NULL, temp,
     "", new_pixmap_from_file (lindex(line,3), window->window, &color),
     GTK_SIGNAL_FUNC(CB_application), (gpointer)atoi(lindex(line,1)));
    }
   }
   if(fd!=NULL) fclose(fd);
  }
  else
  {
   gtk_toolbar_append_item (GTK_TOOLBAR (hbox), NULL, NULL,
   "", new_pixmap (101, window->window, &color),
   GTK_SIGNAL_FUNC(CB_reply), GTK_OBJECT(window));
   
   gtk_toolbar_append_space (GTK_TOOLBAR(hbox));
   
   gtk_toolbar_append_item (GTK_TOOLBAR (hbox), NULL, NULL,
   "", new_pixmap (102, window->window, &color),
   GTK_SIGNAL_FUNC(CB_open_mail), GTK_OBJECT(window));
   
   gtk_toolbar_append_item (GTK_TOOLBAR (hbox), NULL, NULL,
   "", new_pixmap (103, window->window, &color),
   GTK_SIGNAL_FUNC(CB_email), GTK_OBJECT(window));
   
   gtk_toolbar_append_space (GTK_TOOLBAR(hbox));
   
   gtk_toolbar_append_item (GTK_TOOLBAR (hbox), NULL, NULL,
   "", new_pixmap (104, window->window, &color),
   GTK_SIGNAL_FUNC(CB_open_news), GTK_OBJECT(window));
  
   gtk_toolbar_append_item (GTK_TOOLBAR (hbox), NULL, NULL,
   "", new_pixmap (105, window->window, &color),
   GTK_SIGNAL_FUNC(CB_news_post), GTK_OBJECT(window));

   gtk_toolbar_append_space (GTK_TOOLBAR(hbox));

   sprintf(temp, "%s/.gxedit.applications", home);
   fd = fopen(temp, "r");
   while(fgets(line, 512, fd)!=NULL)
   {
    if(!strcasecmp(lindex(line,0),"application:"))
    {
     strncpy(temp, lrange(line,5), 512);
     gtk_toolbar_append_item (GTK_TOOLBAR (hbox), NULL, NULL,
     "", new_pixmap_from_file (lindex(line,3), window->window, &color),
     GTK_SIGNAL_FUNC(CB_application), (gpointer)atoi(lindex(line,1)));
    }
   } 
   if(fd!=NULL) fclose(fd);
  } }
  else {
  if(tooltips)
  {
   gtk_toolbar_append_item (GTK_TOOLBAR (hbox), "Reply", "Reply",
   "", new_pixmap (101, window->window, &color),
   GTK_SIGNAL_FUNC(CB_reply), GTK_OBJECT(window));
   
   gtk_toolbar_append_space (GTK_TOOLBAR(hbox));
   
   gtk_toolbar_append_item (GTK_TOOLBAR (hbox), "Inbox", "Open an e-mail",
   "", new_pixmap (102, window->window, &color),
   GTK_SIGNAL_FUNC(CB_open_mail), GTK_OBJECT(window));
   
   gtk_toolbar_append_item (GTK_TOOLBAR (hbox), "Send", "Send as e-mail",
   "", new_pixmap (103, window->window, &color),
   GTK_SIGNAL_FUNC(CB_email), GTK_OBJECT(window));
   
   gtk_toolbar_append_space (GTK_TOOLBAR(hbox));
  
   gtk_toolbar_append_item (GTK_TOOLBAR (hbox), "Fetch", "Fetch a news article",
   "", new_pixmap (104, window->window, &color),
   GTK_SIGNAL_FUNC(CB_open_news), GTK_OBJECT(window));
  
   gtk_toolbar_append_item (GTK_TOOLBAR (hbox), "Post", "Post text to a newsgroup",
   "", new_pixmap (105, window->window, &color),
   GTK_SIGNAL_FUNC(CB_news_post), GTK_OBJECT(window));

   gtk_toolbar_append_space (GTK_TOOLBAR(hbox));

   sprintf(temp, "%s/.gxedit.applications", home);
   fd = fopen(temp, "r");
   while(fgets(line, 512, fd)!=NULL)
   {
    if(!strcasecmp(lindex(line,0),"application:"))
    {
     strncpy(temp, lrange(line,5), 512);
     gtk_toolbar_append_item (GTK_TOOLBAR (hbox), lindex(line,2), temp,
     "", new_pixmap_from_file (lindex(line,3), window->window, &color),
     GTK_SIGNAL_FUNC(CB_application), (gpointer)atoi(lindex(line,1)));
    }
   } 
   if(fd!=NULL) fclose(fd);
  }
  else
  {
   gtk_toolbar_append_item (GTK_TOOLBAR (hbox), "Reply", NULL,
   "", new_pixmap (101, window->window, &color),
   GTK_SIGNAL_FUNC(CB_reply), GTK_OBJECT(window));
 
   gtk_toolbar_append_space (GTK_TOOLBAR(hbox));
   
   gtk_toolbar_append_item (GTK_TOOLBAR (hbox), "Inbox", NULL,
   "", new_pixmap (102, window->window, &color),
   GTK_SIGNAL_FUNC(CB_open_mail), GTK_OBJECT(window));
 
   gtk_toolbar_append_item (GTK_TOOLBAR (hbox), "Send", NULL,
   "", new_pixmap (103, window->window, &color),
   GTK_SIGNAL_FUNC(CB_email), GTK_OBJECT(window));
   
   gtk_toolbar_append_space (GTK_TOOLBAR(hbox));
  
   gtk_toolbar_append_item (GTK_TOOLBAR (hbox), "Fetch", NULL,
   "", new_pixmap (104, window->window, &color),
   GTK_SIGNAL_FUNC(CB_open_news), GTK_OBJECT(window));
   
   gtk_toolbar_append_item (GTK_TOOLBAR (hbox), "Post", NULL,
   "", new_pixmap (105, window->window, &color),
   GTK_SIGNAL_FUNC(CB_news_post), GTK_OBJECT(window));

   gtk_toolbar_append_space (GTK_TOOLBAR(hbox));

   sprintf(temp, "%s/.gxedit.applications", home);
   fd = fopen(temp, "r");
   while(fgets(line, 512, fd)!=NULL)
   {
    if(!strcasecmp(lindex(line,0),"application:"))
    {
     strncpy(temp, lrange(line,5), 512);
     gtk_toolbar_append_item (GTK_TOOLBAR (hbox), lindex(line,2), NULL,
     "", new_pixmap_from_file (lindex(line,3), window->window, &color),
     GTK_SIGNAL_FUNC(CB_application), (gpointer)atoi(lindex(line,1)));
    }
   } 
   if(fd!=NULL) fclose(fd);
  } }
  if(!flat) gtk_widget_show (hbox);
 }
#endif

 if(htmlbar)
 {
  gtk_window_set_policy (GTK_WINDOW (window), FALSE, TRUE, TRUE);
  gtk_widget_realize (window);

  handle_box = gtk_handle_box_new ();
  gtk_box_pack_start (GTK_BOX (hbox2), handle_box, FALSE, FALSE, 0);

  hbox = gtk_toolbar_new (GTK_ORIENTATION_VERTICAL, GTK_TOOLBAR_BOTH);
#ifdef GTK_1_1
  gtk_toolbar_set_button_relief (GTK_TOOLBAR (hbox), GTK_RELIEF_NONE);
  gtk_box_pack_start (GTK_BOX (hbox2), hbox, FALSE, FALSE, 0);
#else
  gtk_container_add (GTK_CONTAINER (handle_box), hbox);
  gtk_widget_show (handle_box);
#endif

  if(icons)
  {
   if(tooltips)
   {
    gtk_toolbar_append_item (GTK_TOOLBAR (hbox), NULL, "Header of the page",
    "", new_pixmap (303, window->window, &color),
    GTK_SIGNAL_FUNC(CB_HTML_0), NULL);

    gtk_toolbar_append_item (GTK_TOOLBAR (hbox), NULL, "Change the font",
    "", new_pixmap (302, window->window, &color),
    GTK_SIGNAL_FUNC(CB_HTML_1), NULL);

    gtk_toolbar_append_item (GTK_TOOLBAR (hbox), NULL, "Center text",
    "", new_pixmap (301, window->window, &color),
    GTK_SIGNAL_FUNC(CB_HTML_2), NULL);

    gtk_toolbar_append_item (GTK_TOOLBAR (hbox), NULL, "Link to URL",
    "", new_pixmap (310, window->window, &color),
    GTK_SIGNAL_FUNC(CB_HTML_6), NULL);

    gtk_toolbar_append_item (GTK_TOOLBAR (hbox), NULL, "Insert an image",
    "", new_pixmap (304, window->window, &color),
    GTK_SIGNAL_FUNC(CB_HTML_5), NULL);

    gtk_toolbar_append_item (GTK_TOOLBAR (hbox), NULL, "Put a list item",
    "", new_pixmap (305, window->window, &color),
    GTK_SIGNAL_FUNC(CB_HTML_10), NULL);

    gtk_toolbar_append_item (GTK_TOOLBAR (hbox), NULL, "Insert an horizontal line",
    "", new_pixmap (306, window->window, &color),
    GTK_SIGNAL_FUNC(CB_HTML_3), NULL);

    gtk_toolbar_append_item (GTK_TOOLBAR (hbox), NULL, "Change style",
    "", new_pixmap (307, window->window, &color),
    GTK_SIGNAL_FUNC(CB_HTML_styles), NULL);

    gtk_toolbar_append_item (GTK_TOOLBAR (hbox), NULL, "Add a table",
    "", new_pixmap (308, window->window, &color),
    GTK_SIGNAL_FUNC(CB_HTML_4), NULL);

    gtk_toolbar_append_item (GTK_TOOLBAR (hbox), NULL, "Add a line break",
    "", new_pixmap (309, window->window, &color),
    GTK_SIGNAL_FUNC(CB_HTML_7), NULL);

    gtk_toolbar_append_item (GTK_TOOLBAR (hbox), NULL, "HTML reference",
    "", new_pixmap (3, window->window, &color),
    GTK_SIGNAL_FUNC(CB_ref), NULL);
   } 
   else /* tooltips */
   {
    gtk_toolbar_append_item (GTK_TOOLBAR (hbox), NULL, NULL,
    "", new_pixmap (303, window->window, &color),
    GTK_SIGNAL_FUNC(CB_HTML_0), NULL);

    gtk_toolbar_append_item (GTK_TOOLBAR (hbox), NULL, NULL,
    "", new_pixmap (302, window->window, &color),
    GTK_SIGNAL_FUNC(CB_HTML_1), NULL);

    gtk_toolbar_append_item (GTK_TOOLBAR (hbox), NULL, NULL,
    "", new_pixmap (301, window->window, &color),
    GTK_SIGNAL_FUNC(CB_HTML_2), NULL);

    gtk_toolbar_append_item (GTK_TOOLBAR (hbox), NULL, NULL,
    "", new_pixmap (310, window->window, &color),
    GTK_SIGNAL_FUNC(CB_HTML_6), NULL);

    gtk_toolbar_append_item (GTK_TOOLBAR (hbox), NULL, NULL,
    "", new_pixmap (304, window->window, &color),
    GTK_SIGNAL_FUNC(CB_HTML_5), NULL);

    gtk_toolbar_append_item (GTK_TOOLBAR (hbox), NULL, NULL,
    "", new_pixmap (305, window->window, &color),
    GTK_SIGNAL_FUNC(CB_HTML_10), NULL);

    gtk_toolbar_append_item (GTK_TOOLBAR (hbox), NULL, NULL,
    "", new_pixmap (306, window->window, &color),
    GTK_SIGNAL_FUNC(CB_HTML_3), NULL);

    gtk_toolbar_append_item (GTK_TOOLBAR (hbox), NULL, NULL,
    "", new_pixmap (307, window->window, &color),
    GTK_SIGNAL_FUNC(CB_HTML_styles), NULL);

    gtk_toolbar_append_item (GTK_TOOLBAR (hbox), NULL, NULL,
    "", new_pixmap (308, window->window, &color),
    GTK_SIGNAL_FUNC(CB_HTML_4), NULL);

    gtk_toolbar_append_item (GTK_TOOLBAR (hbox), NULL, NULL,
    "", new_pixmap (309, window->window, &color),
    GTK_SIGNAL_FUNC(CB_HTML_7), NULL);

    gtk_toolbar_append_item (GTK_TOOLBAR (hbox), NULL, NULL,  
    "", new_pixmap (3, window->window, &color),
    GTK_SIGNAL_FUNC(CB_ref), NULL);
   }
  }
  else /* icons */
  {
   if(tooltips)
   {
    gtk_toolbar_append_item (GTK_TOOLBAR (hbox), "Header", "Header of the page",
    "", new_pixmap (303, window->window, &color),
    GTK_SIGNAL_FUNC(CB_HTML_0), NULL);

    gtk_toolbar_append_item (GTK_TOOLBAR (hbox), "Fonts", "Change the font",
    "", new_pixmap (302, window->window, &color),
    GTK_SIGNAL_FUNC(CB_HTML_1), NULL);

    gtk_toolbar_append_item (GTK_TOOLBAR (hbox), "Center", "Center text",
    "", new_pixmap (301, window->window, &color),
    GTK_SIGNAL_FUNC(CB_HTML_2), NULL);

    gtk_toolbar_append_item (GTK_TOOLBAR (hbox), "Link", "Link to URL",
    "", new_pixmap (310, window->window, &color),
    GTK_SIGNAL_FUNC(CB_HTML_6), NULL);

    gtk_toolbar_append_item (GTK_TOOLBAR (hbox), "Image", "Insert an image",
    "", new_pixmap (304, window->window, &color),
    GTK_SIGNAL_FUNC(CB_HTML_5), NULL);

    gtk_toolbar_append_item (GTK_TOOLBAR (hbox), "List", "Put a list item",
    "", new_pixmap (305, window->window, &color),
    GTK_SIGNAL_FUNC(CB_HTML_10), NULL);

    gtk_toolbar_append_item (GTK_TOOLBAR (hbox), "Line", "Insert an horizontal line",
    "", new_pixmap (306, window->window, &color),
    GTK_SIGNAL_FUNC(CB_HTML_3), NULL);

    gtk_toolbar_append_item (GTK_TOOLBAR (hbox), "Styles", "Change style",
    "", new_pixmap (307, window->window, &color),
    GTK_SIGNAL_FUNC(CB_HTML_styles), NULL);

    gtk_toolbar_append_item (GTK_TOOLBAR (hbox), "Table", "Add a table",
    "", new_pixmap (308, window->window, &color),
    GTK_SIGNAL_FUNC(CB_HTML_4), NULL);

    gtk_toolbar_append_item (GTK_TOOLBAR (hbox), "Break", "Add a line break",
    "", new_pixmap (309, window->window, &color),
    GTK_SIGNAL_FUNC(CB_HTML_7), NULL);

    gtk_toolbar_append_item (GTK_TOOLBAR (hbox), "Reference", "HTML reference",  
    "", new_pixmap (3, window->window, &color),
    GTK_SIGNAL_FUNC(CB_ref), NULL);
   }
   else /* tooltips */
   {
    gtk_toolbar_append_item (GTK_TOOLBAR (hbox), "Header", NULL,
    "", new_pixmap (303, window->window, &color),        
    GTK_SIGNAL_FUNC(CB_HTML_0), NULL);

    gtk_toolbar_append_item (GTK_TOOLBAR (hbox), "Fonts", NULL,
    "", new_pixmap (302, window->window, &color),
    GTK_SIGNAL_FUNC(CB_HTML_1), NULL);

    gtk_toolbar_append_item (GTK_TOOLBAR (hbox), "Center", NULL,
    "", new_pixmap (301, window->window, &color),
    GTK_SIGNAL_FUNC(CB_HTML_2), NULL);

    gtk_toolbar_append_item (GTK_TOOLBAR (hbox), "Link", NULL,
    "", new_pixmap (310, window->window, &color),
    GTK_SIGNAL_FUNC(CB_HTML_6), NULL);

    gtk_toolbar_append_item (GTK_TOOLBAR (hbox), "Image", NULL,
    "", new_pixmap (304, window->window, &color),
    GTK_SIGNAL_FUNC(CB_HTML_5), NULL);

    gtk_toolbar_append_item (GTK_TOOLBAR (hbox), "List", NULL,
    "", new_pixmap (305, window->window, &color),
    GTK_SIGNAL_FUNC(CB_HTML_10), NULL);

    gtk_toolbar_append_item (GTK_TOOLBAR (hbox), "Line", NULL,
    "", new_pixmap (306, window->window, &color),
    GTK_SIGNAL_FUNC(CB_HTML_3), NULL);

    gtk_toolbar_append_item (GTK_TOOLBAR (hbox), "Styles", NULL,
    "", new_pixmap (307, window->window, &color),
    GTK_SIGNAL_FUNC(CB_HTML_styles), NULL);

    gtk_toolbar_append_item (GTK_TOOLBAR (hbox), "Table", NULL,
    "", new_pixmap (308, window->window, &color),
    GTK_SIGNAL_FUNC(CB_HTML_4), NULL);

    gtk_toolbar_append_item (GTK_TOOLBAR (hbox), "Break", NULL,
    "", new_pixmap (309, window->window, &color),
    GTK_SIGNAL_FUNC(CB_HTML_7), NULL);

    gtk_toolbar_append_item (GTK_TOOLBAR (hbox), "Reference", NULL,  
    "", new_pixmap (3, window->window, &color),
    GTK_SIGNAL_FUNC(CB_ref), NULL);
   } /* tooltips */
  } /* icons */
  if(!flat) gtk_widget_show (hbox);
 } /* htmlbar */

 table = gtk_table_new (2, 2, FALSE);
 gtk_table_set_row_spacing (GTK_TABLE (table), 0, 2);
 gtk_table_set_col_spacing (GTK_TABLE (table), 0, 2);
 gtk_box_pack_start (GTK_BOX (hbox2), table, TRUE, TRUE, 0);
 gtk_widget_show (table);

#ifdef GTKEDITOR_PATCH
 if(syntax_h)
 text = gtk_editor_new(NULL, NULL);
 else
 text = gtk_text_new(NULL, NULL);
#else
 text = gtk_text_new(NULL, NULL);
#endif
 if(set_edit) gtk_text_set_editable (GTK_TEXT (text), TRUE);
 if(line_wrap) gtk_text_set_word_wrap(GTK_TEXT (text), TRUE);
 else gtk_text_set_word_wrap(GTK_TEXT (text), FALSE); 
 gtk_signal_connect (GTK_OBJECT (text), "changed",
 GTK_SIGNAL_FUNC(CB_autosave), &window);
 if(!scroll_loc)
 gtk_table_attach_defaults (GTK_TABLE (table), text, 0, 1, 0, 1);
 else
 gtk_table_attach_defaults (GTK_TABLE (table), text, 1, 2, 0, 1);
 gtk_widget_show (text);

 vscrollbar = gtk_vscrollbar_new (GTK_TEXT (text)->vadj);   
 if(!scroll_loc)
 {
  gtk_table_attach (GTK_TABLE (table), vscrollbar, 1, 2, 0, 1,
  GTK_FILL, GTK_EXPAND | GTK_FILL, 0, 0);
 }
 else
 {   
  gtk_table_attach (GTK_TABLE (table), vscrollbar, 0, 1, 0, 1,   
  GTK_FILL, GTK_EXPAND | GTK_FILL, 0, 0);
 }
 gtk_widget_show (vscrollbar);
 gtk_text_freeze (GTK_TEXT (text));
 gtk_widget_realize (text);

 gtk_widget_show (window);
 gtk_widget_grab_focus(text);

 if(debug)
 {
  dw = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_usize (GTK_WIDGET (dw), 500, 150);
  gtk_signal_connect (GTK_OBJECT (dw), "destroy",
   GTK_SIGNAL_FUNC(CB_close_debug), &dw);
  gtk_signal_connect (GTK_OBJECT (dw), "delete_event",
   GTK_SIGNAL_FUNC(CB_close_debug), &dw);
  gtk_window_set_title (GTK_WINDOW (dw), "Debug messages:");
  gtk_widget_set_uposition (dw, (x_pos+100), (y_pos+200));
  gtk_container_border_width (GTK_CONTAINER (dw), 0);

  hbox = gtk_vbox_new (FALSE, 10);
  gtk_container_border_width (GTK_CONTAINER (hbox), 0);
  gtk_container_add (GTK_CONTAINER (dw), hbox);
  gtk_widget_show (hbox);

  table = gtk_table_new (2, 2, FALSE);
  gtk_table_set_row_spacing (GTK_TABLE (table), 0, 2);
  gtk_table_set_col_spacing (GTK_TABLE (table), 0, 2);
  gtk_box_pack_start (GTK_BOX (hbox), table, TRUE, TRUE, 0);
  gtk_widget_show (table);

  text_debug = gtk_text_new (NULL, NULL);
  gtk_text_set_word_wrap(GTK_TEXT (text_debug), TRUE);  
  if(!scroll_loc)
  gtk_table_attach_defaults (GTK_TABLE (table), text_debug, 0, 1, 0, 1);
  else
  gtk_table_attach_defaults (GTK_TABLE (table), text_debug, 1, 2, 0, 1);
  gtk_widget_show (text_debug);

  vscrollbar = gtk_vscrollbar_new (GTK_TEXT (text_debug)->vadj);
  if(!scroll_loc)
  gtk_table_attach (GTK_TABLE (table), vscrollbar, 1, 2, 0, 1,
   GTK_FILL, GTK_EXPAND | GTK_FILL, 0, 0);
  else
  gtk_table_attach (GTK_TABLE (table), vscrollbar, 0, 1, 0, 1,
   GTK_FILL, GTK_EXPAND | GTK_FILL, 0, 0);
  gtk_widget_show (vscrollbar);
  gtk_text_freeze (GTK_TEXT (text_debug));
  gtk_widget_realize (text_debug);
  gtk_text_thaw (GTK_TEXT (text_debug));
  gtk_widget_show (dw);
 }
}
