#!/usr/bin/perl -w

# Copyright (c) 1998 by Marco Budde (Budde@tu-harburg.de)
# GNU General Public License

##################################################
#  converts a .dhelp file to a .dwww-index file  #
#                                                #
#      usage:  dhelp2dwww <dwww section>         #      
##################################################


##############
#    main    #
##############

print ".dhelp -> .dwww-index\n";

$pwd = `pwd`;
$pwd =~ /.*?\/usr\/doc\/(.*)/;
$pwd = $1;

open (IN, "< .dhelp") or die "can't open .dhelp!\n";
open (OUT, "> .dwww-index") or die "can't open .dwww-index!\n";

while ($zw = <IN>)
{
  $descrip = '';
  while ($zw !~ /<\/item>/)
  {
    $linkname = $1 if ($zw =~ /<linkname>(.*)/);
    $filename = $1 if ($zw =~ /<filename>(.*)/);
    if ($zw =~ /<description>/)
    {
      while ($zw !~ /<\/description>/)
      { 
        $zw = <IN>;
        $descrip = $descrip . $zw if ($zw !~ /<\/description>/);
      }
    }
    $zw = <IN>;
  }
  print OUT "#section $ARGV[0]\n";
  print OUT "<dt><a href=\"$pwd/$filename\">$linkname</a>\n";  
  print OUT "<dd>$descrip\n";
}

close (IN);
close (OUT);
