#|
(define (string->c-text str)
  (make <curly-braced>
	text: str))
|#

(define-rewriter (define-safe-glue* form)
  (define known-types
    ;;
    ;; [0] recognized type name
    ;; [1] format string for var decl
    ;; [2] type-checking method ((primitive predicate required-class), 
    ;;                           (class-eq? class), or 
    ;;                           (instance? class))
    ;; [3] conversion format expr
    ;;
    '((<raw-int> (primitive "OBJ_ISA_FIXNUM" <fixnum>)
		 ("int ~a" "fx2int(~a)"))
      (<fixnum> (primitive "OBJ_ISA_FIXNUM" <fixnum>))
      (<string> (primitive "STRING_P" <string>))
      (<ascii-char> (primitive "OBJ_ISA_ASCII_CHAR" <ascii-char>))
      (<raw-ascii-char> (primitive "OBJ_ISA_ASCII_CHAR" <ascii-char>)
			("UINT_8 ~a" "ASCII_CHAR_VALUE(~a)"))
      (<raw-string> (primitive "STRING_P" <string>)
		    ("char *~a" "(char *)string_text(~a)"))))
  ;;
  (if (and (pair? (cadr form))
	   (eq? (caadr form) 'extend-known-types))
      (begin
	;(format #t "EXTEND-KNOWN-TYPES: ~s\n" (cadr form))
	;(for-each (lambda (t) (format #t "\tIE: ~s\n" t)) (cdadr form))
	(set! known-types (append (cdadr form) known-types))
	;(format #t "introducing extended types: (NEW LIST)\n")
	;(for-each (lambda (t) (format #t "\t~s\n" t)) known-types)
	(set! form (cdr form))))
  ;;
  ;;
  (let ((name (caadr form))
	(args (cdadr form))
	(body (cddr form))
	(literals '())
	(template #f))
    ;;
    ;;
    (define (alloc-literal lit)
      (let ((i (length literals)))
	;(format #t "alloc-literal(~d) = ~s\n" i lit)
	(set! literals
	      (append literals (list lit)))
	i))
    ;;
    (define (expand-view view)
      ;(format #t "expanding view: ~s\n" view)
      (if (symbol? view)
	  (let ((a (assq view known-types)))
	    (if a
		(cdr a)
		(syntax-error "view macro `~a' undefined" view)))
	  view))
    ;;
    (define (render-isa-check raw-arg arg check-expr expect)
      (format #t "if (!~a)\n" check-expr)
      (format #t "   scheme_error( string_text(LITERAL(~d)), 1, ~a );\n"
		  (alloc-literal 
		   (format #f "~a: bad arg ~s == ~~s (expected ~a)"
			   name
			   arg
			   expect))
		  raw-arg))
    ;;
    (define (get-type-methods type-name)
      (let ((m (assq type-name known-types)))
	(or m (list type-name (list 'instance? type-name)))))
    ;;
    (define (view-name base-name view)
      (if (> (length view) 2)
	  (format #f (caddr view) base-name)
	  base-name))
    ;;
    (define (render-var-decl name views)
      (if (null? views)
	  (format #t "obj ~a;\n" name)
	  (for-each (lambda (v)
		      (format #t (car v) (view-name name v))
		      (format #t ";\n"))
		    views)))
    ;;
    (define (render-type-check raw-name new-name type-methods)
      (let ((guard (cadr type-methods))
	    (views (map expand-view (cddr type-methods))))
	;;
	;(format #t "views: ~s\n" views)
	;;
	(case (car guard)
	  ((primitive)
	   (render-isa-check
	    raw-name 
	    new-name
	    (format #f "~a(~a)" (cadr guard) raw-name)
	    (caddr guard)))
	  ((instance?)
	   (render-isa-check
	    raw-name
	    new-name
	    (format #f "instance_p(~a,TLREF(~d))"
		    raw-name
		    (alloc-literal (list '& (cadr guard))))
	    (cadr guard)))
	  ((class-eq?)
	   (render-isa-check 
	    raw-name
	    new-name
	    (format #f "OBJ_ISA_PTR_OF_CLASS(~a,TLREF(~d))"
		    raw-name
		    (alloc-literal (list '& (cadr guard))))
	    (cadr guard)))
	  (else
	   (syntax-error "invalid type method (guard): ~s" guard)))
	;;
	(if (null? views)
	    (format #t "~a = ~a;\n" new-name raw-name)
	    (for-each (lambda (v)
			(format #t "~a = " (view-name new-name v))
			(format #t (cadr v) raw-name)
			(format #t ";\n"))
		      views))))
    ;;
    ;; parse a `:template' flag
    ;;
    (if (eq? (car body) ':template)
	(begin
	  (set! body (cdr body))
	  (set! template #t)))
    ;;
    ;; strip off any literals used
    ;;
    (if (eq? (car body) 'literals:)
	(begin
	  (set! literals (cadr body))
	  (set! body (caddr body)))
	(set! body (car body)))
    ;;
    (format #t "base literals: ~s\n" literals)
    (let ((raw-args (map (lambda (a)
			   (if (pair? a)
			       (string->symbol
				(string-append "raw_"
					       (symbol->string (car a))))
			       a))
			 args)))
      (format #t "raw args: ~s\n" raw-args)
      
      (let ((p (open-output-string)))
	(format #t "extended literals: ~s\n" literals)
	(with-output-to-port p
	  (lambda ()
	    (for-each (lambda (a ra)
			(if (pair? a)
			    (render-var-decl 
			     (car a) 
			     (map expand-view
				  (cddr (get-type-methods (cadr a)))))))
		      args
		      raw-args)
	    (format #t "COUNT_ARGS(~d);\n" (length args))
	    (for-each (lambda (a ra)
			(if (pair? a)
			    (render-type-check ra
					       (car a)
					       (get-type-methods (cadr a)))))
		      args
		      raw-args)
	    (write-char #\{)
	    (display body)
	    (write-char #\})))
	(append '(define-glue)
		(list (cons name raw-args))
		(if template
		    '(:template)
		    '())
		(list 'literals: literals)
		(list (string->c-text (close-output-port p))))))))
;
;---------------------------------------------------------------------------
;
(define-rewriter (define-X-glue form)
  (cons 
   'define-safe-glue*
   (cons 
    '(extend-known-types
      ;;
      ;; types
      ;;
      (<color> (primitive "OBJ_ISA_FIXNUM" <fixnum>)
	       ("color_t ~a"
		"(color_t)fx2int(~a)"))
      ;;
      (<X-display> (class-eq? <X-display>)
		   ("Display *~a" 
		    "OBJ_TO_DISPLAY( gvec_read(~a,SLOT(0)) )"))
      ;;
      (<X-font> (class-eq? <X-font>)
		("XFontStruct *~a"
		 "(XFontStruct *)OBJ_TO_RAW_PTR( gvec_read(~a,SLOT(0)) )"))
      ;;
      (<X-drawable> (instance? <X-drawable>) display/0 xid/1)
      ;;
      (<X-window> (class-eq? <X-window>) display/0 xid/1)
      ;;
      (<X-pixmap> (class-eq? <X-pixmap>) display/0 xid/1)
      ;;
      (<X-drawing-context>
       (class-eq? <X-drawing-context>)
       display/0
       win/1
       ("GC ~a" "FX_TO_GC( gvec_read(~a,SLOT(2)) )" "~a_gc")
       ("int ~a" "fx2int( gvec_read(~a,SLOT(3)) )" "~a_origin_x")
       ("int ~a" "fx2int( gvec_read(~a,SLOT(4)) )" "~a_origin_y"))
      ;;
      (<X-atom>
       (class-eq? <X-atom>)
       ("Atom ~a" "(Atom)fx2int( gvec_read( ~a, SLOT(0) ) )"))
      ;;
      (<X-event>
       (class-eq? <X-event>)
       ("XEvent *~a" "(XEvent *)PTR_TO_DATAPTR(~a)"))
      ;;
      (<X-image>
       (class-eq? <X-image>)
       ("XImage *~a" "(XImage *)OBJ_TO_RAW_PTR( gvec_read(~a,SLOT(0)) )"))
      ;;
      (<gd-image>
       (class-eq? <gd-image>)
       ("gdImage *~a" "(gdImage *)OBJ_TO_RAW_PTR( gvec_read(~a,SLOT(0)) )"))
      ;;
      ;; view macros
      ;;
      (display/0
       "Display *~a" 
       "OBJ_TO_DISPLAY( gvec_read(~a,SLOT(0)) )"
       "~a_dsp")
      ;
      (xid/1 
       "XID ~a"
       "FX_TO_XID( gvec_read(~a,SLOT(1)) )"
       "~a_xid")
      ;
      (win/1 
       "XID ~a"
       "FX_TO_XID( gvec_read(~a,SLOT(1)) )"
       "~a_win"))
    (cdr form))))
