#|------------------------------------------------------------*-Scheme-*--|
 | File:    modules/mlink/mpath.scm
 |
 |          Copyright (C)1997 Donovan Kolbly <d.kolbly@rscheme.org>
 |          as part of the RScheme project, licensed for free use.
 |          See <http://www.rscheme.org/> for the latest information.
 |
 | File version:     1.5
 | File mod date:    1997.12.12 23:19:17
 | System build:     v0.7.2, 97.12.21
 | Owned by module:  mlink
 |
 `------------------------------------------------------------------------|#

(define *module-search-path* #f)

(set! *module-search-path* #f)  ;; reset to #f on startup

(define (init-module-search-path)
  (let ((p (getenv "RS_MODULE_PATH")))
    (if p
        (map string->dir (string-split p #\:))
	(map string->dir '("~/lib/rs/modules"
			   "[resource]/modules")))))

(define (module-search-path)
  (or *module-search-path*
      (let ((p (init-module-search-path)))
       (set! *module-search-path* p)
       p)))

(define-method push-module-search-path! ((p <directory-name>))
  (set! *module-search-path* (cons p (module-search-path))))

(define-method push-module-search-path! ((p <string>))
  (push-module-search-path (string->dir p)))

;;;;

(define (get-loaded-module name)
  (let ((m (assq name (installed-modules))))
    (if m
        (cdr m)
        #f)))

;;;;

(define (load-compiled-module name)
  (let ((rel (make <file-name>
		   file-directory: #f
		   filename: (symbol->string name)
		   extension: "mif")))
    (let loop ((lst (module-search-path)))
      (if (null? lst)
	  #f
          (let ((p (append-path (car lst) rel)))
            (if (file-exists? p)
                (link-load-module name p)
                (loop (cdr lst))))))))

;;;;

(define *module-finders* '())

(define (add-module-finder! proc)
  (set! *module-finders* (append *module-finders* (list proc))))

(%early-once-only
  (add-module-finder! get-loaded-module)
  (add-module-finder! load-compiled-module))

;;;

(define (get-module (n <symbol>))
  (let loop ((mf *module-finders*))
    (if (null? mf)
        (error "~s: couldn't locate module" n)
        (let ((m ((car mf) n)))
	  (if m
	      m
	      (loop (cdr mf)))))))
