#|------------------------------------------------------------*-Scheme-*--|
 | File:    modules/iolib/output.scm
 |
 |          Copyright (C)1997 Donovan Kolbly <d.kolbly@rscheme.org>
 |          as part of the RScheme project, licensed for free use.
 |          See <http://www.rscheme.org/> for the latest information.
 |
 | File version:     1.5
 | File mod date:    1997.11.29 23:10:41
 | System build:     v0.7.2, 97.12.21
 | Owned by module:  iolib
 |
 | Purpose:          general <output-port> interface
 `------------------------------------------------------------------------|#

;;
;;  generic output stuff
;;

(define-class <output-port> (<object>))

(define (output-port? x)
  (instance? x <output-port>))

;; idea for a trick:
;;   have a class <closed-output-port> which we
;;   reset the class of a port to when it gets closed
;;   that way, subclasses don't have to continually be
;;   checking for whether or not they're closed
;;   (may fail in the case where we cache, either explicitly
;;   with find-method, or implicitly in the compiler's decision
;;   tree, the class of an instance.  may not be worth
;;   violating the maxim that the class of an object is constant)
;;

(define-generic-function output-port-write-char)
(define-generic-function close-output-port)
(define-generic-function flush-output-port)

(define-generic-function print)

;; suitable defaults..

(define-generic-function write-string)
(define-generic-function write-int)

(define-method close-output-port ((self <output-port>))
  (values))

(define-method flush-output-port ((self <output-port>))
  (values))

(define-method write-string ((self <output-port>) (str <string>))
  (let (((n <fixnum>) (string-length str)))
    (let loop (((i <fixnum>) 0))
      (if (fixnum<? i n)
	  (begin
	    (output-port-write-char self (string-ref str i))
	    (loop (add1 i)))))))

(define-method write-int ((self <output-port>) (int <fixnum>))
  (write-string self (number->string int)))

;;
;; optional-arg'd functions
;;

(define-syntax (extra->output-port fn extra)
  (if (pair? extra)
      (if (null? (cdr extra))
	  (let ((p (car extra)))
	    (if (instance? p <output-port>)
		p
		(type-error fn 1 p "not an output-port")))
	  (error "wrong number arguments to ~s" fn))
      (current-output-port)))

  
(define (write-char (ch <ascii-char>) . extra)
  (output-port-write-char (extra->output-port write-char extra)
			  ch))

(define (newline . extra)
  (output-port-write-char (extra->output-port newline extra)
			  #\newline))

(define (write item . extra)
  (write-object item (extra->output-port write extra)))

(define (display item . extra)
  (display-object item (extra->output-port display extra)))
