/*-----------------------------------------------------------------*-C-*---
 * File:    modules/iolib/op_str.c
 *
 *          Copyright (C)1997 Donovan Kolbly <d.kolbly@rscheme.org>
 *          as part of the RScheme project, licensed for free use.
 *          See <http://www.rscheme.org/> for the latest information.
 *
 * File version:     1.6
 * File mod date:    1997.11.29 23:10:52
 * System build:     v0.7.2, 97.12.21
 * Owned by module:  iolib
 *
 * Purpose:          <string-output-port> low-level implementation
 *------------------------------------------------------------------------*/

#include <rscheme/scheme.h>
#include <rscheme/smemory.h>
#include <stdio.h>
#include "cports.h"

/*------------------------------------------------------------------------*
 * Macro:	SOP_BLOCK_SIZE
 * Purpose:	define how large buffered output blocks should be
 *------------------------------------------------------------------------*/

#define SOP_BLOCK_SIZE (128-16)

obj SOP_close( obj port )
{
int len;
obj dst, overflow;
char *endptr;
const char *src;

    len = fx2int( gvec_read( port, SOP_INDEX ) );
    overflow = gvec_read( port, SOP_OVERFLOW );
    
    while (!EQ(overflow,NIL_OBJ))
    {
	len += SIZEOF_PTR(pair_car(overflow));
	overflow = pair_cdr(overflow);
    }

    dst = bvec_alloc( len+1, string_class );
    endptr = ((char *)string_text(dst)) + len;
    *endptr = 0;

    src = (const char *)PTR_TO_DATAPTR( gvec_read( port, SOP_BUFFER ) );
    len = fx2int( gvec_read( port, SOP_INDEX ) );
    overflow = gvec_read( port, SOP_OVERFLOW );
    
    while (1)
    {
	endptr -= len;
	memcpy( endptr, src, len );
	if (EQ(overflow,NIL_OBJ))
	    break;

	src = (const char *)PTR_TO_DATAPTR(pair_car(overflow));
	len = SIZEOF_PTR(pair_car(overflow));
	overflow = pair_cdr(overflow);
    }
    return dst;
}

void SOP_write( obj port, const char *src, UINT_32 len )
{
obj buf, fxpos;
char *ptr;
UINT_32 n, max, pos;

    buf = gvec_read( port, SOP_BUFFER );
    fxpos = gvec_read( port, SOP_INDEX );

    assert( BYTE_VECTOR_P(buf) );
    assert( OBJ_ISA_FIXNUM(fxpos) );

    max = SIZEOF_PTR( buf );
    pos = fx2int(fxpos);
    
    ptr = (char *)PTR_TO_DATAPTR(buf);

    while (pos + len > max)
    {
	n = max - pos;
	memcpy( ptr + pos, src, n );
	src += n;
	len -= n;
	gvec_write( port, 
		    SOP_OVERFLOW, 
		    cons( buf, gvec_read( port, SOP_OVERFLOW ) ) );
	max = SOP_BLOCK_SIZE;
	buf = alloc( max, byte_vector_class );
	gvec_write( port, SOP_BUFFER, buf );
	pos = 0;
	ptr = (char *)PTR_TO_DATAPTR(buf);
    }

    memcpy( ptr + pos, src, len );
    pos += len;

    gvec_write_non_ptr( port, SOP_INDEX, int2fx(pos) );
}
