/* Quinn Diff, Compares two Packages files looking for differences between Archs */
/* Copyright (C) 1997, 1998, James Troup <james@nocrew.org> */

/* This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "list.h"

void parse_package (const char *buffer, int buffer_position, const int buffer_length, 
		    Qlist *want_list, const char *package_name);
void get_blah (const char *buffer, int buffer_position, char *output, const char *input, 
	       const int length, const char *package_name);
void skip_line (const char *buffer, int *counter, const long buffer_length);
void skip_to_next_package (const char *buffer, int *buffer_position, const long buffer_length);
void read_line (const char *buffer, int *counter, char *string);
void workout_padding (const char *priority, const char *section, char *blank1, char *blank2);
void determine_needsx (const char *suggests, const char *recommends, const char *depends, 
		       const char *predepends, int *needs_x);
int priority_to_int (const char *priority);
void read_file (const char *filename, FILE *fp, char **buffer_p, long *file_length);

#define MIN_PRIORITY_LENGTH 10
#define MIN_SECTION_LENGTH  15

#define PRIORITY_UNKNOWN   10
#define PRIORITY_EXTRA     20
#define PRIORITY_OPTIONAL  30
#define PRIORITY_STANDARD  40
#define PRIORITY_IMPORTANT 50
#define PRIORITY_REQUIRED  60

