/* Quinn Diff, Compares two Packages files looking for differences between Archs */
/* Copyright (C) 1997, 1998, James Troup <james@nocrew.org> */

/* This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <limits.h>
#include <fcntl.h>
#include <string.h>
#include <db.h>
#include "common.h"
#include "error.h"
#include "xmalloc.h"
#include "hash.h"
#include "main.h"

HASHINFO *secondary_hash_info;
DB *secondary_table = NULL;
DBT *package_dbt, *secondary_key;
char package_key[PACKAGE_NAME_LENGTH];

/* Functions for the secondary architecture's hash table */

void
secondary_hash_create(void)
{

  secondary_hash_info = xmalloc (sizeof(*secondary_hash_info));

  secondary_hash_info->bsize = 256;
  secondary_hash_info->cachesize = 1048576;
  secondary_hash_info->ffactor = 8;
  secondary_hash_info->hash = NULL; /* I checked the default hash
			        * functions, they are much better than
			        * any of my efforts and showed no
			        * collisions with a normal Packages
			        * file (March 15th, 1997)
			        */
  secondary_hash_info->lorder = 0;
  secondary_hash_info->nelem = 1;

  secondary_table = dbopen (NULL, O_RDWR, 0, DB_HASH, secondary_hash_info);

  if (secondary_table == NULL)
    fubar (SYSERR, "Unable to create hash table for secondary architectures' packages");

  package_dbt = xmalloc (sizeof(*package_dbt));
  package_dbt->size = sizeof (struct package_info);

  secondary_key = xmalloc (sizeof(*secondary_key));
  secondary_key->data = package_key;

}

void 
secondary_hash_add (const char *package, const char *version)
{

  struct package_info package_to_hash;
  int i;

  debug(debug_secondary, "Adding \"%s\" [Version %s] to secondary architecture's Packages hash table", package, version);

  strncpy (package_to_hash.package_name, package, PACKAGE_STR_LENGTH);
  strncpy (package_to_hash.version, version, VERSION_STR_LENGTH);

  package_dbt->data = (void *) &package_to_hash;

  strcpy (package_key, package);
  secondary_key->size = strlen (package);
  
  i = secondary_table->put (secondary_table, secondary_key, package_dbt, R_NOOVERWRITE);

  if (i == 1)
    debug(debug_warn, "Warning: %s is already in the secondary architecture's Packages hash table, skipping duplicate", package);
  else if (i != 0)
    fubar (NONSYS, "couldn't add \"%s\" to secondary architecture's Packages hash table (put returned %d).", package, i);

}

int
secondary_hash_retrieve (const char *package, secondary_package_info *secondary)
{

  struct package_info *package_details;

  strcpy (package_key, package);
  secondary_key->size = strlen (package);

  /* RQ: WTF do I do with flags?  Presently set to 0. */

  if (secondary_table->get (secondary_table, secondary_key, package_dbt, 0) != 0)
    return 0;

  package_details = (struct package_info *) package_dbt->data; 
  strcpy (secondary->name, package_details->package_name);
  strcpy (secondary->version, package_details->version);

  return 1;
}

void
secondary_hash_destroy(void)
{

 if (secondary_table)
   { 
     if (secondary_table->close(secondary_table))
       fubar (SYSERR, "Couldn't destroy secondary archtecture packages hash table");
     
     free (secondary_key);
     free (package_dbt);
     free (secondary_hash_info);
   }
 else
   error ("secondary_hash_destroy: secondary_table is NULL!  Tell James");
  
}

