/*
 * GSEVTS.C - test of event handling graphics library
 *
 * Source Version: 2.0
 * Software Release #92-0043
 *
 */

#include "cpyright.h"

#include "pgs.h"

static double
 phi = 30.0,
 theta = 30.0;

static int
 ps_flag = TRUE;

static char
 *direction;

void
 SC_DECLARE(register_to,
	 (PG_device *dev, double xmn, double xmx,
	  double ymn, double ymx, char *s)),
 SC_DECLARE(return_text, (PG_interface_object *iob, PG_event *ev)),
 SC_DECLARE(return_child_text, 
            (PG_interface_object *iob, PG_event *ev)),
 SC_DECLARE(end_prog, (void *d, PG_event *ev)),
 SC_DECLARE(clear_window, (void *d, PG_event *ev)),
 SC_DECLARE(redraw, (void *d, PG_event *ev)),
 SC_DECLARE(get_input, (void *d, PG_event *ev)),
 SC_DECLARE(set_edit_mode, (void *d, PG_event *ev)),
 SC_DECLARE(unspecified_event_handler, 
            (PG_device *dev, PG_event *ev)),
 SC_DECLARE(mouse_event_handler, (PG_device *dev, PG_event *ev));

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

int main(argc, argv)
   int argc;
   char *argv[];
   {int i;
    double phimn, phimx, thetamn, thetamx;
    PG_device *SCR_dev;

/* process the command line arguments */
    PG_IO_INTERRUPTS(TRUE);
    for (i = 1; i < argc; i++)
        {if (argv[i][0] == '-')
            {switch (argv[i][1])
                {case 'i' :
                      PG_IO_INTERRUPTS(FALSE);
		      break;};};};

    SC_setbuf(STDOUT, NULL);

/* connect the I/O functions */
    PG_open_console("PGS Test", "COLOR", TRUE, 0.1, 0.7, 0.5, 0.3);

    SCR_dev = PG_make_device("WINDOW", "COLOR", "PGS Test");
    PG_open_device(SCR_dev, 0.1, 0.1, 0.5, 0.6);
    PG_set_viewport(SCR_dev, 0.05, 0.45, 0.2, 0.8);
    PG_set_window(SCR_dev, 0.0, 1.0, 0.0, 1.0);
    PG_draw_box(SCR_dev, -0.02, 1.02, -0.02, 1.02);

    PG_set_default_event_handler(SCR_dev, unspecified_event_handler);
    PG_set_mouse_down_event_handler(SCR_dev, mouse_event_handler);

    PG_register_variable("PS-Flag", SC_INTEGER_S, &ps_flag, NULL, NULL);
    PG_register_variable("Direction", SC_STRING_S, &direction, NULL, NULL);
    phimn = -180.0;
    phimx =  180.0;
    PG_register_variable("Phi", SC_DOUBLE_S, &phi, &phimn, &phimx);
    thetamn = 0.0;
    thetamx = 90.0;
    PG_register_variable("Theta", SC_DOUBLE_S, &theta, &thetamn, &thetamx);

    if (SC_isfile("gsevts.pui"))
       {PG_register_callback("End", end_prog);
        PG_register_callback("Clear", clear_window);
        PG_register_callback("ReDraw", redraw);
        PG_register_callback("Input", get_input);
        PG_register_callback("Edit", set_edit_mode);
	PG_read_interface(SCR_dev, "gsevts.pui");}
    else
       {register_to(SCR_dev, 0.55, 0.90, 0.2, 0.8, "Hello World!");
        PG_add_button(SCR_dev, 0.10, 0.20, 0.90, 0.95, "End", end_prog);
        PG_add_button(SCR_dev, 0.20, 0.30, 0.90, 0.95, "Clear", clear_window);
        PG_add_button(SCR_dev, 0.30, 0.40, 0.90, 0.95, "ReDraw", redraw);
        PG_add_button(SCR_dev, 0.40, 0.50, 0.90, 0.95, "Input", get_input);
        PG_add_button(SCR_dev, 0.50, 0.60, 0.90, 0.95, "Edit", set_edit_mode);};

    PG_expose_device(PG_console_device);
    clear_window(SCR_dev, NULL);

    PG_update_vs(SCR_dev);

    PG_make_device_current(SCR_dev);
    while (TRUE)
       get_input(SCR_dev, NULL);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* REGISTER_TO - register a TEXT interface object with the device */

void register_to(dev, xmn, xmx, ymn, ymx, s)
   PG_device *dev;
   double xmn, xmx, ymn, ymx;
   char *s;
   {PG_interface_object *iob;
    PG_curve *crv;
    PG_text_box *b;
    double xo, yo;
    int flags[3];

    flags[0] = TRUE;
    flags[1] = FALSE;
    flags[2] = FALSE;

    xo  = xmn;
    yo  = ymn;
    crv = PG_make_box_curve(dev, NORMC, xo, yo, xmn, xmx, ymn, ymx);

    iob = PG_make_interface_object(dev, "TEXT", PG_TEXT_OBJECT_S, s, CENTER,
				   0.0, crv, flags, dev->WHITE, dev->CYAN,
                                   NULL, "draw-text", "return-text",
                                   NULL, NULL);

    PG_register_interface_object(dev, iob);

    b = (PG_text_box *) iob->obj;
    b->border = 0.2;

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* RETURN_TEXT - TEXT interface object action */

void return_text(iob, ev)
   PG_interface_object *iob;
   PG_event *ev;
   {

/*    PRINT(STDOUT, "Detected %s event\n", X_event_name[ev->type]); */

    PRINT(STDOUT, "\nClicked on TEXT object: %s\n", (char *) iob->obj);
/*
    strcpy(_PG_input_bf, iob->text);
    SC_str_lower(_PG_input_bf);
*/
    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* RETURN_CHILD_TEXT - TEXT interface object action */

void return_child_text(iob, ev)
   PG_interface_object *iob;
   PG_event *ev;
   {int n;
    PG_interface_object *ch;

    n = iob->n_children;
    if (n >= 0)
       {ch = (iob->children)[0];
        PRINT(STDOUT,
              "\nClicked on BUTTON object: %s\n",
              (char *) ch->obj);};

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* CLEAR_WINDOW - clear the screen */

void clear_window(d, ev)
   void *d;
   PG_event *ev;
   {PG_device *dev;

    dev = PG_handle_button_press(d, ev);
    if (dev != NULL)
       {PG_clear_window(dev);
        PG_set_line_color(dev, dev->WHITE);
        PG_draw_box(dev, 0.0, 1.0, 0.0, 1.0);
        PG_draw_interface_objects(dev);};

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* REDRAW - redraw the interface objects */

void redraw(d, ev)
   void *d;
   PG_event *ev;
   {PG_device *dev;

    dev = PG_handle_button_press(d, ev);
    if (dev != NULL)
       PG_draw_interface_objects(dev);

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* END_PROG - end the program */

void end_prog(d, ev)
   void *d;
   PG_event *ev;
   {PG_device *dev;

    dev = PG_handle_button_press(d, ev);
    if (dev != NULL)
       {PG_write_interface(dev, "gsevts.pui");
        PG_close_device(dev);
        printf("\n");

        exit(0);};

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* GET_INPUT - get input */

void get_input(d, ev)
   void *d;
   PG_event *ev;
   {PG_device *dev;
    char s[MAXLINE], *token, *t;
    REAL x1, y1, x2, y2, dx, dy;
    char *face, *style;
    int size;

    dev = PG_handle_button_press(d, ev);
    if (dev != NULL)
       {if (ev != NULL)
           PRINT(STDOUT, "\nENTER x1, y1, face, style, size: ");

        s[0] = '\0';
        GETLN(s, MAXLINE, stdin);
        if (strcmp(s, "end\n") == 0)
           end_prog(dev, NULL);

        face = NULL;
        if ((token = SC_strtok(s, " ,\r\n", t)) != NULL)
           {x1 = ATOF(token);
            if ((token = SC_strtok(NULL, " ,\r\n", t)) != NULL)
               {y1 = ATOF(token);
                if ((face = SC_strtok(NULL, " ,\r\n", t)) != NULL)
                   {if ((style = SC_strtok(NULL, " ,\r\n", t)) != NULL)
                       {if ((token = SC_strtok(NULL, " ,\r\n", t)) != NULL)
			   size = ATOF(token);
		        else
			   size = 12;}
		    else
		       {style = "medium";
			size  = 12;};}
		 else
		    {face  = "times";
		     style = "medium";
		     size  = 12;};};}
	else
	   return;

	PG_set_font(dev, face, style, size);

	PG_get_text_ext(dev, "foo", &dx, &dy);
	x2 = x1 + dx;
	y2 = y1 + dy;

/* write some text and draw a box around it */
	PG_write_WC(dev, x1, y1, "%s", "foo");
	PG_draw_box(dev, x1, x2, y1, y2);

	PG_update_vs(dev);};

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SET_EDIT_MODE - turn on editing of interface objects */

void set_edit_mode(d, ev)
   void *d;
   PG_event *ev;
   {PG_device *dev;

    dev = PG_handle_button_press(d, ev);
    if (dev != NULL)
       PG_edit_mode = TRUE;

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* UNSPECIFIED_EVENT_HANDLER - handle random events */

void unspecified_event_handler(dev, ev)
   PG_device *dev;
   PG_event *ev;
   {

/*    PRINT(STDOUT, "Detected %s event\n", X_event_name[ev->type]); */

    PG_print_pointer_location(dev, 0.0, 0.98, TRUE);

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* MOUSE_EVENT_HANDLER - handle mouse down events */

void mouse_event_handler(dev, ev)
   PG_device *dev;
   PG_event *ev;
   {int wx, wy, btn, mod;
    REAL x1, y1, x2, y2, dx, dy;
    char bf[80];
    PG_interface_object *iob;

    iob = PG_get_object_event(dev, ev);
    if (iob != NULL)
       {PRINT(STDOUT, "\n%s\n", (char *) iob->obj);}

    else
       {PG_MOUSE_EVENT_INFO(dev, ev, wx, wy, btn, mod);

        PtoS(dev, wx, wy, x1, y1);
        StoW(dev, x1, y1);

        bf[0] = '\0';

        if (mod & KEY_SHIFT)
           strcat(bf, "Shift ");

        if (mod & KEY_CNTL)
           strcat(bf, "Control ");

        if (mod & KEY_ALT)
           strcat(bf, "Alt ");

        switch (btn)
           {case MOUSE_LEFT   :
                 strcat(bf, "Left");
                 break;
            case MOUSE_MIDDLE :
                 strcat(bf, "Middle");
                 break;
            case MOUSE_RIGHT  :
                 strcat(bf, "Right");
                 break;};

        if (bf[0] != '\0')
           {PG_get_text_ext(dev, bf, &dx, &dy);
            x2 = x1 + dx;
            y2 = y1 + dy;

/* write some text and draw a box around it */
            PG_write_WC(dev, x1, y1, "%s", bf);
            PG_draw_box(dev, x1, x2, y1, y2);

            PG_update_vs(dev);};};

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
