/* low level interface to the type descriptor mechanism. */
#include "Types.h"
#include "__StdTypes.h"
#include "__Descr.h"
#include "__config.h"
#include "__libc.h"


/* number of bytes between start of memory block and start of user defined
   data: */
#define OFFSET_PTR 8


static _ModId _mid;

/* module descriptor */
static const struct {
  int length;
  void* pad;
  const char name[6];
} _n0 = {6, NULL, {"Types"}};
static struct _MD Types__md = {
  NULL, 
  &Kernel_ModuleDesc__td.td, 
  {
    NULL, 
    (const unsigned char*)_n0.name, 
    -1, 
    NULL
  }
};


Types_Type Types_BaseOf (Types_Type t, INTEGER level) {
  if ((0 <= level) && (level <= t->level)) {
    return t->btypes[level];
  } else {
    return NULL;
  }
}

INTEGER Types_LevelOf (Types_Type t) {
  return t->level;
}

void Types_NewObj (PTR (* o), Types_Type t) {
  char* mem = GC_malloc(t->size+OFFSET_PTR);
  char* var = mem+OFFSET_PTR;

#if !USE_GC
  (void)memset((void*)mem, 0, t->size+OFFSET_PTR);
#endif
  ((Types_Type*)var)[-1] = t;
  *o = var;
}

Types_Type Types_This (Kernel_Module mod, const CHAR *name) {
  Types_Type td = (Types_Type)mod->tdescs;
  while (td) {
    if (!strcmp((const char*)name, (const char*)td->name)) {
      return td;
    }
    td = td->next;
  };
  return NULL;
}

Types_Type Types_TypeOf (PTR o) {
  return ((Types_Type*)o)[-1];
}

void Types__init (void) {
  _mid = _register_module (&Types__md.md, NULL);
}


