/* $Id: Signal.c,v 1.5 1998/10/03 12:47:51 acken Exp $ */
/*  Signal handling facilities.
    Copyright (C) 1997, 1998  Michael van Acken

    This file is part of OOC.

    OOC is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.  

    OOC is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
    or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
    License for more details. 

    You should have received a copy of the GNU General Public License
    along with OOC. If not, write to the Free Software Foundation, 59
    Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/
#include <signal.h>
#include <string.h>
#include <unistd.h>
#include <stdio.h>
#include <sys/types.h>

#include "__oo2c.h"
#include "Signal.h"


Exception_Source Signal_exception;
Signal_SigHandler Signal_handlerDefault;
Signal_SigHandler Signal_handlerIgnore;
Signal_SigHandler Signal_handlerException;
Signal_SigHandler Signal_handlerError;


Signal_SigNumber Signal_Map (Signal_SigNumber signum) {
  switch (signum) {
  case Signal_sigfpe:
#ifdef SIGFPE
    return SIGFPE;
#else
    return Signal_unknownSignal;
#endif
  case Signal_sigill:
#ifdef SIGILL
    return SIGILL;
#else
    return Signal_unknownSignal;
#endif
  case Signal_sigsegv:
#ifdef SIGSEGV
    return SIGSEGV;
#else
    return Signal_unknownSignal;
#endif
  case Signal_sigbus:
#ifdef SIGBUS
    return SIGBUS;
#else
    return Signal_unknownSignal;
#endif
  case Signal_sigabrt:
#ifdef SIGABRT
    return SIGABRT;
#else
    return Signal_unknownSignal;
#endif
  case Signal_sigiot:
#ifdef SIGIOT
    return SIGIOT;
#else
    return Signal_unknownSignal;
#endif
  case Signal_sigtrap:
#ifdef SIGTRAP
    return SIGTRAP;
#else
    return Signal_unknownSignal;
#endif
  case Signal_sigemt:
#ifdef SIGEMT
    return SIGEMT;
#else
    return Signal_unknownSignal;
#endif
  case Signal_sigsys:
#ifdef SIGSYS
    return SIGSYS;
#else
    return Signal_unknownSignal;
#endif
  case Signal_sigstkflt:
#ifdef SIGSTKFLT
    return SIGSTKFLT;
#else
    return Signal_unknownSignal;
#endif
  case Signal_sigterm:
#ifdef SIGTERM
    return SIGTERM;
#else
    return Signal_unknownSignal;
#endif
  case Signal_sigint:
#ifdef SIGINT
    return SIGINT;
#else
    return Signal_unknownSignal;
#endif
  case Signal_sigquit:
#ifdef SIGQUIT
    return SIGQUIT;
#else
    return Signal_unknownSignal;
#endif
  case Signal_sigkill:
#ifdef SIGKILL
    return SIGKILL;
#else
    return Signal_unknownSignal;
#endif
  case Signal_sighup:
#ifdef SIGHUP
    return SIGHUP;
#else
    return Signal_unknownSignal;
#endif
  case Signal_sigalrm:
#ifdef SIGALRM
    return SIGALRM;
#else
    return Signal_unknownSignal;
#endif
  case Signal_sigvtalrm:
#ifdef SIGVTALRM
    return SIGVTALRM;
#else
    return Signal_unknownSignal;
#endif
  case Signal_sigurg:
#ifdef SIGURG
    return SIGURG;
#else
    return Signal_unknownSignal;
#endif
  case Signal_sigpoll:
#ifdef SIGPOLL
    return SIGPOLL;
#else
    return Signal_unknownSignal;
#endif
  case Signal_sigchld:
#ifdef SIGCHLD
    return SIGCHLD;
#else
    return Signal_unknownSignal;
#endif
  case Signal_sigcld:
#ifdef SIGCLD
    return SIGCLD;
#else
    return Signal_unknownSignal;
#endif
  case Signal_sigcont:
#ifdef SIGCONT
    return SIGCONT;
#else
    return Signal_unknownSignal;
#endif
  case Signal_sigstop:
#ifdef SIGSTOP
    return SIGSTOP;
#else
    return Signal_unknownSignal;
#endif
  case Signal_sigtstp:
#ifdef SIGTSTP
    return SIGTSTP;
#else
    return Signal_unknownSignal;
#endif
  case Signal_sigttin:
#ifdef SIGTTIN
    return SIGTTIN;
#else
    return Signal_unknownSignal;
#endif
  case Signal_sigttou:
#ifdef SIGTTOU
    return SIGTTOU;
#else
    return Signal_unknownSignal;
#endif
  case Signal_sigpipe:
#ifdef SIGPIPE
    return SIGPIPE;
#else
    return Signal_unknownSignal;
#endif
  case Signal_siglost:
#ifdef SIGLOST
    return SIGLOST;
#else
    return Signal_unknownSignal;
#endif
  case Signal_sigxcpu:
#ifdef SIGXCPU
    return SIGXCPU;
#else
    return Signal_unknownSignal;
#endif
  case Signal_sigxfsz:
#ifdef SIGXFSZ
    return SIGXFSZ;
#else
    return Signal_unknownSignal;
#endif
  case Signal_sigpwr:
#ifdef SIGPWR
    return SIGPWR;
#else
    return Signal_unknownSignal;
#endif
  case Signal_sigusr1:
#ifdef SIGUSR1
    return SIGUSR1;
#else
    return Signal_unknownSignal;
#endif
  case Signal_sigusr2:
#ifdef SIGUSR2
    return SIGUSR2;
#else
    return Signal_unknownSignal;
#endif
  case Signal_sigwinch:
#ifdef SIGWINCH
    return SIGWINCH;
#else
    return Signal_unknownSignal;
#endif
  case Signal_siginfo:
#ifdef SIGINFO
    return SIGINFO;
#else
    return Signal_unknownSignal;
#endif
  case Signal_sigdil:
#ifdef SIGDIL
    return SIGDIL;
#else
    return Signal_unknownSignal;
#endif
  default:
    return Signal_unknownSignal;
  }
}

Signal_SigHandler Signal_SetHandler (Signal_SigNumber signum, Signal_SigHandler action) {
  if (action) {
    return (Signal_SigHandler) signal((int)signum, action);
  } else {
    return (Signal_SigHandler) signal((int)signum, SIG_DFL);
  }
}

static void handle_exception(Signal_SigNumber signum) {
  char str[64];

  (void)signal((int)signum, handle_exception);
  sprintf(str, "[Signal] Caught signal number %i", signum);
  Exception_RAISE(Signal_exception, signum, (CHAR*)str, strlen(str));
}

void Signal_Raise(Signal_SigNumber signum) {
  (void)kill(getpid(), (int)signum);
}

void Signal__init(void) {
  Exception_AllocateSource(&Signal_exception);
  _exception_signal = Signal_exception;
  Signal_handlerDefault = (Signal_SigHandler)SIG_DFL;
  Signal_handlerIgnore = (Signal_SigHandler)SIG_IGN;
  Signal_handlerException = (Signal_SigHandler)(&handle_exception);
  Signal_handlerError = (Signal_SigHandler)SIG_ERR;
}
