/*	$Id: Locales.c,v 1.3 1997/09/05 09:50:32 acken Exp $	*/
#include <limits.h>
#include <locale.h>
#include <time.h>

#include "__oo2c.h"

/* --- begin #include "Locales.d" */
#include "Locales.h"
#include "Strings.h"

/* local definitions */
LONGINT Locales_ALL;
LONGINT Locales_COLLATE;
LONGINT Locales_CTYPE;
LONGINT Locales_MONETARY;
LONGINT Locales_NUMERIC;
LONGINT Locales_TIME;

Locales_ErrorProc Locales_GetText;

/* function prototypes */

/* module and type descriptors */
static const struct {
  int length;
  void* pad;
  const char name[8];
} _n0 = {8, NULL, {"Locales"}};
static struct _MD Locales__md = {
  NULL, 
  &Kernel_ModuleDesc__td.td, 
  {
    NULL, 
    (const unsigned char*)_n0.name, 
    -1, 
    NULL
  }
};
/* --- end #include "Locales.d" */

static _ModId _mid;
static struct tm Locales_base;


void Locales_RecoverPattern_ReplacePattern(const CHAR* pattern, LONGINT pattern_0d,
                                           CHAR* str, LONGINT str_0d) {
  int i;
  BOOLEAN found;
  INTEGER pos;
  CHAR src[132];

  i = strftime((char*)src, 132, (const char*)pattern, &Locales_base);
  Strings_FindNext((const CHAR*)src, 132, (const CHAR*)(int)str, str_0d, 
		   0, &found, &pos);
  if (found) {
    i = Strings_Length(src, 132);
    Strings_Delete(str, str_0d, pos, (short int)i);
    Strings_Insert(pattern, pattern_0d, pos, str, str_0d);
  }
}

void Locales_RecoverPattern(CHAR* str, LONGINT str_0d) {
  Locales_RecoverPattern_ReplacePattern((const CHAR*)"%A", 3, str, str_0d);
  Locales_RecoverPattern_ReplacePattern((const CHAR*)"%a", 3, str, str_0d);
  Locales_RecoverPattern_ReplacePattern((const CHAR*)"%B", 3, str, str_0d);
  Locales_RecoverPattern_ReplacePattern((const CHAR*)"%b", 3, str, str_0d);
  Locales_RecoverPattern_ReplacePattern((const CHAR*)"%d", 3, str, str_0d);
  Locales_RecoverPattern_ReplacePattern((const CHAR*)"%H", 3, str, str_0d);
  Locales_RecoverPattern_ReplacePattern((const CHAR*)"%I", 3, str, str_0d);
  Locales_RecoverPattern_ReplacePattern((const CHAR*)"%j", 3, str, str_0d);
  Locales_RecoverPattern_ReplacePattern((const CHAR*)"%m", 3, str, str_0d);
  Locales_RecoverPattern_ReplacePattern((const CHAR*)"%M", 3, str, str_0d);
  Locales_RecoverPattern_ReplacePattern((const CHAR*)"%p", 3, str, str_0d);
  Locales_RecoverPattern_ReplacePattern((const CHAR*)"%S", 3, str, str_0d);
  Locales_RecoverPattern_ReplacePattern((const CHAR*)"%U", 3, str, str_0d);
  Locales_RecoverPattern_ReplacePattern((const CHAR*)"%W", 3, str, str_0d);
  Locales_RecoverPattern_ReplacePattern((const CHAR*)"%w", 3, str, str_0d);
  Locales_RecoverPattern_ReplacePattern((const CHAR*)"%Y", 3, str, str_0d);
  Locales_RecoverPattern_ReplacePattern((const CHAR*)"%y", 3, str, str_0d);
}

BOOLEAN Locales_GetStr(LONGINT id, CHAR* ls, LONGINT ls_0d) {
  CHAR* str;
  struct tm tp;
  struct lconv *loc;
  LONGINT ret;

  if (id<Locales_daysOfWeek) {
    /* use the C localization information */
    loc=localeconv();
    switch (id) {
      case (Locales_decimalPoint):      str=(CHAR*)loc->decimal_point; break;
      case (Locales_thousandsSep):      str=(CHAR*)loc->thousands_sep; break;
      case (Locales_grouping):          str=(CHAR*)loc->grouping; break;
      case (Locales_intCurrencySymbol): str=(CHAR*)loc->int_curr_symbol; break;
      case (Locales_currencySymbol):    str=(CHAR*)loc->currency_symbol; break;
      case (Locales_monDecimalPoint):   str=(CHAR*)loc->mon_decimal_point; break;
      case (Locales_monThousandsSep):   str=(CHAR*)loc->mon_thousands_sep; break;
      case (Locales_monGrouping):       str=(CHAR*)loc->mon_grouping; break;
      case (Locales_positiveSign):      str=(CHAR*)loc->positive_sign; break;
      case (Locales_negativeSign):      str=(CHAR*)loc->negative_sign; break;
      default:                          return 0; break;
    }
    _string_copy((int)ls, str, ls_0d);
  } else if (id<Locales_months) {
    /* use the strftime routine to get the day strings */
    tp = Locales_base;
    tp.tm_wday=id-Locales_daysOfWeek;
    tp.tm_mday+=tp.tm_wday;
    ret=strftime((char*)ls, ls_0d, "%A", &tp);
  } else if (id<Locales_defTimeFormat) {
    /* use the strftime routine to get the month strings */
    tp = Locales_base;
    tp.tm_mon=id-Locales_months;
    ret=strftime((char*)ls, ls_0d, "%B", &tp);
  } else if (id==Locales_defTimeFormat) {
    tp = Locales_base;
    ret=strftime((char*)ls, ls_0d, "%X", &tp);
    Locales_RecoverPattern(ls, ls_0d);        
  } else if (id==Locales_defDateFormat) {
    tp = Locales_base;
    ret=strftime((char*)ls, ls_0d, "%x", &tp);
    Locales_RecoverPattern(ls, ls_0d); 
  } else if (id==Locales_defBothFormat) {
    tp = Locales_base;
    ret=strftime((char*)ls, ls_0d, "%c", &tp);
    Locales_RecoverPattern(ls, ls_0d); 
  } else {
    return 0;
  };
  return 1;
}

LONGINT Locales_GetInt(LONGINT id) {
  struct lconv *loc;

  loc=localeconv();
  switch (id) {
    case (Locales_intFracDigits): return loc->int_frac_digits; break;
    case (Locales_fracDigits):    return loc->frac_digits; break;
    case (Locales_pCSPrecedes):   return loc->p_cs_precedes; break;
    case (Locales_pSepBySpace):   return loc->p_sep_by_space; break;
    case (Locales_nCSPrecedes):   return loc->n_cs_precedes; break;
    case (Locales_nSepBySpace):   return loc->n_sep_by_space; break;
    case (Locales_pSignPosn):     return loc->p_sign_posn; break;
    case (Locales_nSignPosn):     return loc->n_sign_posn; break;
    default:                      return (-2147483647-1); break;
  }
}

void Locales_Set(LONGINT category, const CHAR* name, LONGINT name_0d, 
		 CHAR* old, LONGINT old_0d) {
  char* oloc;

  oloc = setlocale(category, (const char*)name);
  if (oloc) {
    _string_copy(old, oloc, old_0d);
  } else {
    _string_copy(old, "", old_0d);
  }
}

void Locales__init(void) {
  _mid = _register_module(&Locales__md.md, NULL);

  /* initialize a base date = Sunday, 22 Dec 1996, 16:02:03 */
  Locales_base.tm_sec=3; Locales_base.tm_min=2; Locales_base.tm_hour=16;
  Locales_base.tm_mday=22; Locales_base.tm_mon=11; Locales_base.tm_year=96;
  Locales_base.tm_wday=0;

  /* valid definitions for all OSes */
  Locales_ALL = LC_ALL;
  Locales_COLLATE = LC_COLLATE;
  Locales_CTYPE = LC_CTYPE;
  Locales_MONETARY = LC_MONETARY;
  Locales_NUMERIC = LC_NUMERIC;
  Locales_TIME = LC_TIME;

  /* initialize the error procedure pointer */
  Locales_GetText = NULL;
}
