// -*- Mode: C++; -*-
//                            Package   : omniORB2
// t_string.cc                Created on: 06/12/96
//                            Author    : Sai Lai Lo (sll)
//
// Copyright (C) Olivetti Research Limited, 1996
//
// Description:
 
/*
  $Log$
  */

#include <omniORB2/CORBA.h>
#include <iostream.h>

// test_string_f
//	This function's signature corresponds to the mapping of this
//	OMG IDL operatoin:
//		string test_string_f(in string a1,
//				     inout string a2,
//				     out string a3);
//
static
char *
test_string_f(const char* in, char*& inout, char*& out)
{
  assert(strcmp(in,inout)==0);
  out = CORBA::string_dup(in);
  char* result = CORBA::string_dup(in);
  return result;
}


// Real signature used.
static
char *
___test_string_f(const char* in,
		 CORBA::String_INOUT_arg inout,
		 CORBA::String_OUT_arg out)
{
  return test_string_f(in,inout._data,out._data);
}

static
void
test_string_1()
{
  const char * constp = "test string 0";
  CORBA::ULong len = strlen(constp);

  CORBA::String_var s1(constp);
  assert(strcmp(s1,constp) == 0);
  s1[len-1] = '1';
  assert(strcmp(s1,constp) != 0); // (char *)s1 != constp

  char * varp = CORBA::string_alloc(strlen(constp)+1);
  strcpy(varp,constp);

  CORBA::String_var s2(varp);
  assert(strcmp(s2,varp) == 0);
  s2[len-1] = '2';
  assert(strcmp(s2,varp) == 0); // (char *)s2 == varp

  CORBA::String_var s3(s2);
  assert(strcmp(s2,s3) == 0);
  s3[len-1] = '3';
  assert(strcmp(s2,s3) != 0);

  CORBA::String_var s4;
  s4 = constp;
  assert(strcmp(constp,s4) == 0);
  s4[len-1] = '4';
  assert(strcmp(s4,constp) != 0); // (char *)s4 != constp

  varp = CORBA::string_alloc(strlen(constp)+1);
  strcpy(varp,constp);

  CORBA::String_var s5;
  s5 = varp;
  assert(strcmp(varp,s5) == 0);
  s5[len-1] = '5';
  assert(strcmp(s5,varp) == 0); // (char *)s5 == varp

  CORBA::String_var s6 = s1;
  CORBA::String_var s7;
  CORBA::String_var s8;

  s8 = ___test_string_f(s1,s6,s7);
  assert(strcmp(s1,s7) == 0);
  assert(strcmp(s1,s8) == 0);
}


struct Variable {
  CORBA::String_member name;
};

typedef _CORBA_ConstrType_Variable_Var<Variable> Variable_var;

static
void
test_string_2()
{
  // Test all the cases as listed in CORBA 2 spec section 16.9
  Variable str1;			// str1.name is initially 0
  assert((char*)str1.name == 0);
  Variable_var str2 = new Variable; // str2->name is initially 0
  assert((char*)str2->name == 0);
  char* non_const;
  const char* const2;
  CORBA::String_var string_var;
  const char* const3 = "string 1";
  const char* const4 = "string 2";

  str1.name = const3;	// free old storage, copy
  assert((char*)str1.name != 0);
  assert(strcmp((const char*)str1.name,const3) == 0);
  ((char*)str1.name)[0] = '1';
  assert(strcmp((const char*)str1.name,const3) != 0);	// (char *)str1.name != const3
  
  str2->name = const4; 	// free old storage, copy
  assert((char *)(str2->name) != 0);
  assert(strcmp((const char*)(str2->name),const4)== 0);
  ((char*)(str2->name))[0] = '1';
  assert(strcmp((const char*)(str2->name),const4) != 0);

  non_const = str1.name;	// no free, no copy
  assert(non_const == (char *)str1.name);
  
  const2 = str2->name; 		// no free, no copy
  assert(const2 == (const char*)(str2->name));
  
  char* non_const2 = CORBA::string_dup(non_const);
  str1.name = non_const2;	// free, no copy
  assert(non_const2 == (char*)(str1.name));

  str1.name = const2;		// free, copy
  assert(strcmp((const char*)str1.name,const2) == 0);
  assert((const char*)str1.name != const2);

  assert(const2 == (const char*)(str2->name));
  str2->name = str1.name;      // free, copy
  assert((char*)(str2->name) != (char*)str1.name);
  assert(strcmp((const char*)(str2->name),(const char*)str1.name)== 0);

  assert((char *)string_var == 0);
  str1.name = string_var;	// free, copy
  assert((char *)str1.name == 0);

  string_var = str2->name;	// free, copy
  assert(((char*)string_var != 0) && ((char*)string_var != (char*)str2->name));
  assert(strcmp((const char*)string_var,(const char*)(str2->name)) == 0);

  assert(str1.name._ptr == 0);
  str1.name._ptr = str2->name;	// no free, no copy
  assert(str1.name._ptr == (char *)(str2->name));
  str1.name._ptr = 0;
}

int
main(int argc, char **argv)
{
  int loopcount = 1;

  while (loopcount--) {
    cerr << "Testing string...";
    test_string_1();
    test_string_2();
    cerr << "PASSED." << endl;
  }

  return 0;
}
