CXXSRCS = t_string.cc t_seq_long.cc t_seq_string.cc \
          t_objref.cc t_seq_objref.cc \
          client.cc server.cc 

DIR_CPPFLAGS = $(CORBA_CPPFLAGS) -I.. $(patsubst %,-I%/..,$(VPATH))

ifdef EgcsMajorVersion
ifeq ($(EgcsMajorVersion),1)
ifeq ($(EgcsMinorVersion),0)
endif
# There is a bug in egcs-1.0 and it fails to compile idl stubs with
# sequence of sequence. Flag this compiler so that the use of sequence sequence
# is excluded.
OMNIORB2_IDL += -DTEST_EGCS10
DIR_CPPFLAGS += -DTEST_EGCS10
endif
endif


# The stub of seq1 takes a long time and lots of resources to compile with
# optimisation. Set CXXDEBUGFLAGS to null to remove the optimisation flag.
CXXDEBUGFLAGS =

CORBA_INTERFACES = echo seq2 seq3 seq4 seq5 seq6 seq7 seq8 seq9 seq10 \
                   seq1 shutdown

COMMON_OBJS = ../common/$(patsubst %,$(LibPattern),common)

t_string       = $(patsubst %,$(BinPattern),t_string)
t_seq_long     = $(patsubst %,$(BinPattern),t_seq_long)
t_seq_string   = $(patsubst %,$(BinPattern),t_seq_string)
t_objref       = $(patsubst %,$(BinPattern),t_objref)
t_seq_objref   = $(patsubst %,$(BinPattern),t_seq_objref)
client        = $(patsubst %,$(BinPattern),client)
server        = $(patsubst %,$(BinPattern),server)


all:: $(client) $(server)

all:: $(t_string) $(t_seq_long) $(t_seq_string) $(t_objref) $(t_seq_objref)

$(t_string): t_string.o $(CORBA_STUB_OBJS) $(CORBA_LIB_DEPEND)
	@(libs="$(CORBA_LIB)"; $(CXXExecutable))

$(t_seq_long): t_seq_long.o $(CORBA_STUB_OBJS) $(CORBA_LIB_DEPEND)
	@(libs="$(CORBA_LIB)"; $(CXXExecutable))

$(t_seq_string): t_seq_string.o $(CORBA_STUB_OBJS) $(CORBA_LIB_DEPEND)
	@(libs="$(CORBA_LIB)"; $(CXXExecutable))

$(t_objref): t_objref.o $(CORBA_STUB_OBJS) $(CORBA_LIB_DEPEND)
	@(libs="$(CORBA_LIB)"; $(CXXExecutable))

$(t_seq_objref): t_seq_objref.o $(CORBA_STUB_OBJS) $(CORBA_LIB_DEPEND)
	@(libs="$(CORBA_LIB)"; $(CXXExecutable))

$(client): client.o $(CORBA_STUB_OBJS) $(CORBA_LIB_DEPEND) $(COMMON_OBJS)
	@(libs="$(COMMON_OBJS) $(CORBA_LIB)"; $(CXXExecutable))

$(server): server.o $(CORBA_STUB_OBJS) $(CORBA_LIB_DEPEND) $(COMMON_OBJS)
	@(libs="$(COMMON_OBJS) $(CORBA_LIB)"; $(CXXExecutable))

clean::
	$(RM) $(client) $(server)
	$(RM) $(t_string) $(t_seq_long) $(t_seq_string) $(t_objref) $(t_seq_objref)
