// usage: client -i <object reference>\n"
//        client <COSNaming compound name (e.g. x/y/echo.obj)>
#include <iostream.h>
#include <inheritance_1.hh>
#include <common/common.h>

CORBA::ORB_ptr orb;

void
test_inheritance(CORBA::Object_ptr obj)
{
  G_ptr g = G::_narrow(obj);
  if (CORBA::is_nil(g)) {
    cerr << "Error: object is nil.";
    return;
  }
  cerr << "  Checking _is_a(\"IDL:omg.org/CORBA/Object:1.0\") - ";
  if (g->_is_a("IDL:omg.org/CORBA/Object:1.0")) {
    cerr << "OK." << endl;
  }
  else {
    cerr << "Failed (Error)." << endl;
  }

  {
    cerr << "\nG::get_b() - ";
    B_var b = g->get_b();
    if (CORBA::is_nil(b)) {
      cerr << "Error: b is nil.";
      return;
    }
    cerr << " OK. Return value is of type B" << endl;
    cerr << "   B::b() = ";
    CORBA::Long bv = b->b();
    cerr << bv << endl;
    cerr << "   B::a() = ";
    CORBA::Long av = b->a();
    cerr << av << endl;

    cerr << "   narrow to A";
    A_var a = A::_narrow(b);
    if (CORBA::is_nil(a)) {
      cerr << "Error: b cannot be narrowed to A";
      return;
    }
    cerr << " OK" << endl;
    cerr << "    A::a() = ";
    av = a->a();
    cerr << av << endl;

    cerr << "  Checking _is_a(\"IDL:omg.org/CORBA/Object:1.0\") - ";
    if (b->_is_a("IDL:omg.org/CORBA/Object:1.0")) {
      cerr << "OK." << endl;
    }
    else {
      cerr << "Failed (Error)." << endl;
    }
  }
  {
    cerr << "G::get_a() - ";
    A_var a = g->get_a();
    if (CORBA::is_nil(a)) {
      cerr << "Error: a is nil.";
      return;
    }
    cerr << " OK. Return value is of type A" << endl;
    cerr << "   A::a() = ";
    CORBA::Long av = a->a();
    cerr << av << endl;

    cerr << "  narrow to B";
    B_var b = B::_narrow(a);
    if (CORBA::is_nil(b)) {
      cerr << "Error: a cannot be narrowed to B";
      return;
    }
    cerr << " OK" << endl;
    cerr << "   B::b() = ";
    CORBA::Long bv = b->b();
    cerr << bv << endl;
    cerr << "   B::a() = ";
    av = b->a();
    cerr << av << endl;
  }
  {
    cerr << "G::o() - ";
    CORBA::Object_var o = g->o();
    if (CORBA::is_nil(o)) {
      cerr << "Error: o is nil.";
      return;
    }
    cerr << " OK. Return value is of type CORBA::Object" << endl;
    cerr << "  narrow to A";
    A_var a = A::_narrow(o);
    if (CORBA::is_nil(a)) {
      cerr << "Error: o cannot be narrowed to A";
      return;
    }
    cerr << " OK" << endl;
    cerr << "   A::a() = ";
    CORBA::Long av = a->a();
    cerr << av << endl;
    cerr << "  narrow to B";
    B_var b = B::_narrow(a);
    if (CORBA::is_nil(b)) {
      cerr << "Error: a cannot be narrowed to B";
      return;
    }
    cerr << " OK" << endl;
    cerr << "   B::b() = ";
    CORBA::Long bv = b->b();
    cerr << bv << endl;
    cerr << "   B::a() = ";
    av = b->a();
    cerr << av << endl;
  }
  cerr << "PASSED.";
}


int
main (int argc, char **argv) 
{
  orb = CORBA::ORB_init(argc,argv,"omniORB2");
  GIOP_Basetypes::max_giop_message_size = 1024*2048;

  CORBA::Object_var obj;

  switch (argc) {
  case 2:
    {
      try {
	CosNaming::Name use_name = string_to_name(argv[1]);
	obj = getObjectReference(orb,use_name);
      }
      catch (...) {
	obj = CORBA::Object::_nil();
      }
      if (CORBA::is_nil(obj)) {
	cerr << "Cannot resolve compound name to an object reference."
	     << endl;
	return 1; 
      }
      break;
    }
  case 3:
    if (strcmp(argv[1],"-i") == 0) {
      obj = orb->string_to_object(argv[2]);
      if (CORBA::is_nil(obj)) {
	cerr << "Cannot convert stringified IOR to an object reference."
	     << endl;
	return 1;
      }
      break;
    }
  default:
    cerr << "usage: client -i <stringified IOR>\n" 
	 << "       client <COSNaming compound name (e.g. x/y/echo.obj)>"
	 << endl;
    return 1;
  }

  try {
    cerr << "Testing inheritance...." << endl;
    test_inheritance(obj);
    cerr << endl;
  }
  catch(CORBA::COMM_FAILURE& ex) {
    cerr << "Caught system exception COMM_FAILURE, unable to contact the "
         << "object." << endl;
  }
  catch(omniORB::fatalException& ex) {
    cerr << "Caught omniORB2 fatalException. This indicates a bug is caught "
         << "within omniORB2.\nPlease send a bug report.\n"
         << "The exception was thrown in file: " << ex.file() << "\n"
         << "                            line: " << ex.line() << "\n"
         << "The error message is: " << ex.errmsg() << endl;
  }
  //  catch(...) {
  //    cerr << "Caught a system exception." << endl;
  //}

    return 0;
}
