// usage: server <COSNaming compound name (e.g. x/y/test.obj)>

#include <iostream.h>
#include "omnithread.h"
#include <common/common.h>
#include <echo.hh>

class Echo_i : public virtual _sk_Echo {
public:
  Echo_i() {}
  virtual ~Echo_i() {}
  virtual char * echoString(const char *mesg);
};

char *
Echo_i::echoString(const char *mesg) {
  char *p = CORBA::string_dup(mesg);
  return p;
}


int
main(int argc, char **argv)
{
  omniORB::traceLevel = 15;

  CORBA::ORB_ptr orb = CORBA::ORB_init(argc,argv,"omniORB2");
  CORBA::BOA_ptr boa = orb->BOA_init(argc,argv,"omniORB2_BOA");

  CosNaming::Name use_name;

  if (argc == 2) {
    try {
      use_name = CosNaming::Name(string_to_name(argv[1]));
    }
    catch (...) {
      cerr << argv[1] << " is not a valid COS Naming compound name." << endl;
    }
  }

  if (use_name.length() == 0) {
    cerr << "Usage: server  <COSNaming compound name (e.g. x/y/test.obj)>"
	 << endl;
    return 1;
  }

  Echo_i *myobj = new Echo_i();
  myobj->_obj_is_ready(boa);

  {
    Echo_var myobjRef = myobj->_this();
    if (!bindObjectToName(orb,myobjRef,use_name)) {
      return 1;
    }
  }

  boa->impl_is_ready();
  // Tell the BOA we are ready. The BOA's default behaviour is to block
  // on this call indefinitely.

  return 0;
}


