// Usage: client2 <COSNaming compound name (e.g. x/y/test.obj)>

#include <stdlib.h>
#include <iostream.h>
#include <common/common.h>
#include <echo.hh>

static CORBA::ORB_ptr               orb;
static void                         hello(CORBA::Object_ptr obj);

CORBA::Boolean
trans_exc(void*, CORBA::ULong retries,const CORBA::TRANSIENT&)
{
  cerr << ">>> Transient exception handler (" 
       << retries 
       << " retries)" 
       << endl;
  unsigned long secs = retries;
  if (secs > 30) {
    secs = 30;
  }
  if (secs)
    omni_thread::sleep(secs,0);
  return 1;
}

CORBA::Boolean
comm_exc(void*, CORBA::ULong retries,const CORBA::COMM_FAILURE& ex)
{
  cerr << ">>> Comm Failure exception handler (" 
       << retries 
       << " retries)" 
       << endl;
  throw ex;
#ifdef NEED_DUMMY_RETURN
  return 0;
#endif
}

CORBA::Boolean
sys_exc(void*,CORBA::ULong retries,const CORBA::SystemException& ex)
{
  cerr << ">>> System exception handler (" 
       << retries 
       << " retries)" 
       << endl;
  throw ex;
#ifdef NEED_DUMMY_RETURN
  return 0;
#endif
}


int
main (int argc, char **argv) 
{
  orb = CORBA::ORB_init(argc,argv,"omniORB2");

  omniORB::traceLevel = 15;
  omniORB::installTransientExceptionHandler(0,trans_exc);
  omniORB::installCommFailureExceptionHandler(0,comm_exc);
  omniORB::installSystemExceptionHandler(0,sys_exc);
  omniORB::idleConnectionScanPeriod(omniORB::idleOutgoing,3);

  CosNaming::Name use_name;

  if (argc == 2) {
      try {
	use_name = string_to_name(argv[1]);
      }
      catch (...) {  }
    }

  if (use_name.length() == 0) {
    cerr << "Usage: client2  <COSNaming compound name (e.g. x/y/test.obj)>"
	 << endl;
    return 1;
  }

  try {
    while (1) {
      cerr << ">>>>>>>>>>>>>Contact naming service" << endl;
      CORBA::Object_var obj = getObjectReference(orb,use_name);

      if (CORBA::is_nil(obj)) {
	cerr << ">>>>> Object is nil. Exit." << endl;
	break;
      }

      CORBA::ULong loopcount = 10;
      cerr << ">>>>>>>>>>>>>Send greetings to echo Object" << endl;
      while (--loopcount) {
	hello(obj);
	omni_thread::sleep(rand()%15);
      }
    }
  }
  catch (CORBA::COMM_FAILURE& ex) {
    cerr << ">>>>> Caught Comm Failure in the outer loop. Exit." << endl;
  }
  catch (CORBA::SystemException& ex) {
    cerr << ">>>>> Caught System Exception in the outer loop. Exit." << endl;
  }
  catch (...) {
    cerr << ">>>>> Caught an exception in the outer loop. Exit." << endl;
  }
  return 0;
}

void
hello(CORBA::Object_ptr obj)
{
  Echo_var e = Echo::_narrow(obj);

  if (CORBA::is_nil(e)) {
    cerr << "hello: cannot invoke on a nil object reference.\n" << endl;
    return;
  }

  CORBA::String_var src = (const char*) "Hello!"; // String literals are not
                                                  // const char*. Must do
                                                  // explicit casting to 
                                                  // force the use of the copy
                                                  // operator=(). 
  CORBA::String_var dest;

  dest = e->echoString(src);

  cerr << "I said,\"" << (char*)src << "\"."
       << " The Object said,\"" << (char*)dest <<"\"" << endl;
}


