// Testing code for the DynSequence interface

#include <iostream.h>
#include "t_Type.hh"

#define TR(x) //x

static CORBA::ORB_ptr orb;

struct TestDataT {

  SeqOctetT     t1;
  CORBA::Any*   t1any;

  SeqDoubleT    t2;
  CORBA::Any*   t2any;

  SeqSeqOctetT  t3;
  CORBA::Any*   t3any;

  SeqSeqDoubleT t4;
  CORBA::Any*   t4any;

  TestDataT() {
    t1any = 0;   
    t2any = 0;  
    t3any = 0;  
    t4any = 0;  
 }

  ~TestDataT() {
    if (t1any) delete t1any;
    if (t2any) delete t2any;
    if (t3any) delete t3any;
    if (t4any) delete t4any;
  }
};

void
writeErrmsg(const char* f, int l, const char* msg) {
  cerr << "Error: " << f << ", line " << l << " " << msg << endl;
}

void
initialise_testdata(TestDataT& testData)
{
  testData.t1.length(3);
  testData.t1[0] = 0;
  testData.t1[1] = 1;
  testData.t1[2] = 2;
  testData.t1any = new CORBA::Any;
  (*testData.t1any) <<= testData.t1;

  testData.t2.length(4);
  testData.t2[0] = 0;
  testData.t2[1] = 1.1;
  testData.t2[2] = 2.2;
  testData.t2[3] = 3.3;
  testData.t2any = new CORBA::Any;
  (*testData.t2any) <<= testData.t2;

  testData.t3.length(3);
  testData.t3[0] = testData.t1;
  testData.t3[1].length(0);
  testData.t3[2] = testData.t1;
  testData.t3any = new CORBA::Any;
  (*testData.t3any) <<= testData.t3;

  testData.t4.length(3);
  testData.t4[0] = testData.t2;
  testData.t4[1].length(0);
  testData.t4[2] = testData.t2;
  testData.t4any = new CORBA::Any;
  (*testData.t4any) <<= testData.t4;

}

int
test_read_SeqOctetT(CORBA::DynAny_ptr dp,SeqOctetT& val)
{
  try {
    CORBA::DynSequence_var ds = CORBA::DynSequence::_narrow(dp);
    if (CORBA::is_nil(ds)) {
      writeErrmsg(__FILE__,__LINE__,"failed DynSequence::_narrow.");
      return -1;
    }
    CORBA::ULong len = ds->length();
    if (len != val.length()) {
      writeErrmsg(__FILE__,__LINE__,"wrong length");
      return -1;
    }
    ds->rewind();
    CORBA::ULong index;
    for (index = 0; index < len; index++) {
      CORBA::Octet v = ds->get_octet();
      TR(cerr << "[" << (int)v << " == " << (int)val[index] << "]");
      if (v != val[index]) {
	writeErrmsg(__FILE__,__LINE__,"extracted a wrong value.");
	return -1;
      }
    }

    cerr << "get_elements()";
    CORBA::AnySeq* s;
    s = ds->get_elements();
    if (len != s->length()) {
      writeErrmsg(__FILE__,__LINE__,"wrong length");
      return -1;
    }
    for (index = 0; index < len; index++) {
      CORBA::Octet v;
      (*s)[index] >>= CORBA::Any::to_octet(v);
      TR(cerr << "[" << (int)v << " == " << (int)val[index] << "]");
      if (v != val[index]) {
	writeErrmsg(__FILE__,__LINE__,"extracted a wrong value.");
	return -1;
      }
    }
    delete s;
  }
  catch (...) {
    writeErrmsg(__FILE__,__LINE__,"failed.");
    return -1;
  }
  return 0;
}

int
test_read_SeqDoubleT(CORBA::DynAny_ptr dp,SeqDoubleT& val)
{
  try {
    CORBA::DynSequence_var ds = CORBA::DynSequence::_narrow(dp);
    if (CORBA::is_nil(ds)) {
      writeErrmsg(__FILE__,__LINE__,"failed DynSequence::_narrow.");
      return -1;
    }
    CORBA::ULong len = ds->length();
    if (len != val.length()) {
      writeErrmsg(__FILE__,__LINE__,"wrong length");
      return -1;
    }
    ds->rewind();
    CORBA::ULong index;
    for (index = 0; index < len; index++) {
      CORBA::Double v = ds->get_double();
      TR(cerr << "[" << v << " == " << val[index] << "]");
      if (v != val[index]) {
	writeErrmsg(__FILE__,__LINE__,"extracted a wrong value.");
	return -1;
      }
    }

    cerr << "get_elements()";
    CORBA::AnySeq* s;
    s = ds->get_elements();
    if (len != s->length()) {
      writeErrmsg(__FILE__,__LINE__,"wrong length");
      return -1;
    }
    for (index = 0; index < len; index++) {
      CORBA::Double v;
      (*s)[index] >>= v;
      TR(cerr << "[" << v << " == " << val[index] << "]");
      if (v != val[index]) {
	writeErrmsg(__FILE__,__LINE__,"extracted a wrong value.");
	return -1;
      }
    }
    delete s;
  }
  catch (...) {
    writeErrmsg(__FILE__,__LINE__,"failed.");
    return -1;
  }
  return 0;
}

int
test_read_SeqSeqOctetT(CORBA::DynAny_ptr dp,SeqSeqOctetT& val)
{
  try {
    CORBA::DynSequence_var ds = CORBA::DynSequence::_narrow(dp);
    if (CORBA::is_nil(ds)) {
      writeErrmsg(__FILE__,__LINE__,"failed DynSequence::_narrow.");
      return -1;
    }
    CORBA::ULong len = ds->length();
    if (len != val.length()) {
      writeErrmsg(__FILE__,__LINE__,"wrong length");
      return -1;
    }
    ds->rewind();
    CORBA::ULong index;
    for (index = 0; index < len; index++, ds->next()) {
      cerr << "[";
      CORBA::DynAny_var dm = ds->current_component();
      if (CORBA::is_nil(dm)) {
	writeErrmsg(__FILE__,__LINE__,"unexpected nil object.");
	return -1;
      }
      if (test_read_SeqOctetT(dm,val[index]) < 0) {
	return -1;
      }
      cerr << "]";
    }

    cerr << "get_elements()";
    CORBA::AnySeq* s;
    s = ds->get_elements();
    if (len != s->length()) {
      writeErrmsg(__FILE__,__LINE__,"wrong length");
      return -1;
    }
    for (index = 0; index < len; index++) {
      cerr << "[";
      CORBA::DynAny_var dm = orb->create_dyn_any((*s)[index]);
      if (CORBA::is_nil(dm)) {
	writeErrmsg(__FILE__,__LINE__,"unexpected nil object.");
	return -1;
      }
      if (test_read_SeqOctetT(dm,val[index]) < 0) {
	return -1;
      }
      dm->destroy();
      cerr << "]";
    }
    delete s;
  }
  catch (...) {
    writeErrmsg(__FILE__,__LINE__,"failed.");
    return -1;
  }
  return 0;
}

int
test_read_SeqSeqDoubleT(CORBA::DynAny_ptr dp,SeqSeqDoubleT& val)
{
  try {
    CORBA::DynSequence_var ds = CORBA::DynSequence::_narrow(dp);
    if (CORBA::is_nil(ds)) {
      writeErrmsg(__FILE__,__LINE__,"failed DynSequence::_narrow.");
      return -1;
    }
    CORBA::ULong len = ds->length();
    if (len != val.length()) {
      writeErrmsg(__FILE__,__LINE__,"wrong length");
      return -1;
    }
    ds->rewind();
    CORBA::ULong index;
    for (index = 0; index < len; index++, ds->next()) {
      cerr << "[";
      CORBA::DynAny_var dm = ds->current_component();
      if (CORBA::is_nil(dm)) {
	writeErrmsg(__FILE__,__LINE__,"unexpected nil object.");
	return -1;
      }
      if (test_read_SeqDoubleT(dm,val[index]) < 0) {
	return -1;
      }
      cerr << "]";
    }

    cerr << "get_elements()";
    CORBA::AnySeq* s;
    s = ds->get_elements();
    if (len != s->length()) {
      writeErrmsg(__FILE__,__LINE__,"wrong length");
      return -1;
    }
    for (index = 0; index < len; index++) {
      cerr << "[";
      CORBA::DynAny_var dm = orb->create_dyn_any((*s)[index]);
      if (CORBA::is_nil(dm)) {
	writeErrmsg(__FILE__,__LINE__,"unexpected nil object.");
	return -1;
      }
      if (test_read_SeqDoubleT(dm,val[index]) < 0) {
	return -1;
      }
      dm->destroy();
      cerr << "]";
    }
    delete s;
  }
  catch (...) {
    writeErrmsg(__FILE__,__LINE__,"failed.");
    return -1;
  }
  return 0;
}




int
test_read(TestDataT& testData)
{
  // The tests do the following:
  //    1. Create a dynany using create_dyn_any(Any) with an any argument.
  //    2. Read back the value from the dynany directly and compare with
  //       the value that has been packed into the any argument.
  {
    CORBA::DynAny_var d = orb->create_dyn_any(*testData.t1any);
    cerr << "TR: reading SeqOctetT...";
    if (test_read_SeqOctetT(d,testData.t1) == 0) {
      cerr << "PASSED." << endl;
    }
    else {
      return -1;
    }
    d->destroy();
  }
  {
    CORBA::DynAny_var d = orb->create_dyn_any(*testData.t2any);
    cerr << "TR: reading SeqDoubleT...";
    if (test_read_SeqDoubleT(d,testData.t2) == 0) {
      cerr << "PASSED." << endl;
    }
    else {
      return -1;
    }
    d->destroy();
  }
  {
    CORBA::DynAny_var d = orb->create_dyn_any(*testData.t3any);
    cerr << "TR: reading SeqSeqOctetT...";
    if (test_read_SeqSeqOctetT(d,testData.t3) == 0) {
      cerr << "PASSED." << endl;
    }
    else {
      return -1;
    }
    d->destroy();
  }
  {
    CORBA::DynAny_var d = orb->create_dyn_any(*testData.t4any);
    cerr << "TR: reading SeqSeqDoubleT...";
    if (test_read_SeqSeqDoubleT(d,testData.t4) == 0) {
      cerr << "PASSED." << endl;
    }
    else {
      return -1;
    }
    d->destroy();
  }

  return 0;
}

int
test_create_write(TestDataT& testData)
{
  // The tests do the following:
  //    1. Create a dynany using create_dyn_union.
  //    2. Insert a value into the dynany
  //    3. Read back the value from the dynany directly and compare to
  //       the inserted value.
  //    4. Convert the dynany to an any.
  //    5. Read back the value in the any by creating a dynany with the
  //       any as the initial parameter and compare to the original value.
  {
    CORBA::DynSequence_var d = orb->create_dyn_sequence(_tc_SeqOctetT);
    cerr << "TCW: create SeqOctetT..";
    try {
      CORBA::ULong len = testData.t1.length();
      d->length(len);
      CORBA::ULong index;
      for (index = 0; index < len; index++) {
	d->insert_octet(testData.t1[index]);
      }
      cerr << "reading back..";
      if (test_read_SeqOctetT(d,testData.t1) < 0)
	return -1;
      cerr << "to any..";
      CORBA::Any_var av = d->to_any();
      cerr << "read from any..";
      CORBA::DynAny_var d2 = orb->create_dyn_any(av);
      if (test_read_SeqOctetT(d2,testData.t1) < 0)
	return -1;
      cerr << "PASSED." << endl;
      d->destroy();
      d2->destroy();
    }
    catch (...) {
      writeErrmsg(__FILE__,__LINE__,"failed to write member.");
      return -1;
    }
  }
  {
    CORBA::DynSequence_var d = orb->create_dyn_sequence(_tc_SeqDoubleT);
    cerr << "TCW: create SeqDoubleT..";
    try {
      CORBA::ULong len = testData.t2.length();
      d->length(len);
      CORBA::ULong index;
      for (index = 0; index < len; index++) {
	d->insert_double(testData.t2[index]);
      }
      cerr << "reading back..";
      if (test_read_SeqDoubleT(d,testData.t2) < 0)
	return -1;
      cerr << "to any..";
      CORBA::Any_var av = d->to_any();
      cerr << "read from any..";
      CORBA::DynAny_var d2 = orb->create_dyn_any(av);
      if (test_read_SeqDoubleT(d2,testData.t2) < 0)
	return -1;
      cerr << "PASSED." << endl;
      d->destroy();
      d2->destroy();
    }
    catch (...) {
      writeErrmsg(__FILE__,__LINE__,"failed to write member.");
      return -1;
    }
  }
  {
    CORBA::DynSequence_var d = orb->create_dyn_sequence(_tc_SeqSeqOctetT);
    cerr << "TCW: create SeqSeqOctetT..";
    try {
      CORBA::ULong len = testData.t3.length();
      d->length(len);
      CORBA::ULong index;
      for (index = 0; index < len; index++, d->next()) {
	CORBA::DynAny_var dm = d->current_component();
	CORBA::DynSequence_var dms = CORBA::DynSequence::_narrow(dm);
	if (CORBA::is_nil(dms)) {
	  writeErrmsg(__FILE__,__LINE__,"unexpected nil object.");
	  return -1;
	}
	CORBA::ULong elen = testData.t3[index].length();
	dms->length(elen);
	for (CORBA::ULong eindex = 0; eindex < elen; eindex++) {
	  dms->insert_octet(testData.t3[index][eindex]);
	}
      }
      cerr << "reading back..";
      if (test_read_SeqSeqOctetT(d,testData.t3) < 0)
	return -1;
      cerr << "to any..";
      CORBA::Any_var av = d->to_any();
      cerr << "read from any..";
      CORBA::DynAny_var d2 = orb->create_dyn_any(av);
      if (test_read_SeqSeqOctetT(d2,testData.t3) < 0)
	return -1;
      cerr << "PASSED." << endl;
      d->destroy();
      d2->destroy();
    }
    catch (...) {
      writeErrmsg(__FILE__,__LINE__,"failed to write member.");
      return -1;
    }
  }
  {
    CORBA::DynSequence_var d = orb->create_dyn_sequence(_tc_SeqSeqDoubleT);
    cerr << "TCW: create SeqSeqDoubleT..";
    try {
      CORBA::ULong len = testData.t4.length();
      d->length(len);
      CORBA::ULong index;
      for (index = 0; index < len; index++, d->next()) {
	CORBA::DynAny_var dm = d->current_component();
	CORBA::DynSequence_var dms = CORBA::DynSequence::_narrow(dm);
	if (CORBA::is_nil(dms)) {
	  writeErrmsg(__FILE__,__LINE__,"unexpected nil object.");
	  return -1;
	}
	CORBA::ULong elen = testData.t4[index].length();
	dms->length(elen);
	for (CORBA::ULong eindex = 0; eindex < elen; eindex++) {
	  dms->insert_double(testData.t4[index][eindex]);
	}
      }
      cerr << "reading back..";
      if (test_read_SeqSeqDoubleT(d,testData.t4) < 0)
	return -1;
      cerr << "to any..";
      CORBA::Any_var av = d->to_any();
      cerr << "read from any..";
      CORBA::DynAny_var d2 = orb->create_dyn_any(av);
      if (test_read_SeqSeqDoubleT(d2,testData.t4) < 0)
	return -1;
      cerr << "PASSED." << endl;
      d->destroy();
      d2->destroy();
    }
    catch (...) {
      writeErrmsg(__FILE__,__LINE__,"failed to write member.");
      return -1;
    }
  }
  return 0;
}

int
test_read_modify_write(TestDataT& testData)
{
  // The tests do the following:
  //    1. Create a dynany using create_dyn_any(Any) with an any argument.
  //    2. Modify the value using the dynany
  //    3. Read back the value from the dynany directly and compare to
  //       the modified value.
  //    4. Convert the dynany to an any.
  {
    CORBA::DynAny_var d = orb->create_dyn_any(*testData.t1any);

    cerr << "TRMW: SeqOctetT modify in place..";
    try {
      testData.t1[1] += 10;
      d->seek(1);
      d->insert_octet(testData.t1[1]);

      cerr << "reading back..";
      if (test_read_SeqOctetT(d,testData.t1) < 0)
	return -1;

      cerr << "to any..";

      delete testData.t1any;
      testData.t1any = d->to_any();

      cerr << "PASSED." << endl;
      d->destroy();
    }
    catch (...) {
      writeErrmsg(__FILE__,__LINE__,"failed to modify member.");
      return -1;
    }
  }
  {
    CORBA::DynAny_var d = orb->create_dyn_any(*testData.t2any);

    cerr << "TRMW: SeqDoubleT modify in place..";
    try {
      testData.t2[1] = testData.t2[1] + 10;
      d->seek(1);
      d->insert_double(testData.t2[1]);

      cerr << "reading back..";
      if (test_read_SeqDoubleT(d,testData.t2) < 0)
	return -1;

      cerr << "to any..";

      delete testData.t2any;
      testData.t2any = d->to_any();

      cerr << "PASSED." << endl;
      d->destroy();
    }
    catch (...) {
      writeErrmsg(__FILE__,__LINE__,"failed to modify member.");
      return -1;
    }
  }
  {
    CORBA::DynAny_var d = orb->create_dyn_any(*testData.t3any);

    cerr << "TRMW: SeqSeqOctetT modify in place..";
    try {
      testData.t3[2][1] = testData.t3[2][1] + 10;
      d->seek(2);
      CORBA::DynAny_var dm = d->current_component();
      dm->seek(1);
      dm->insert_octet(testData.t3[2][1]);
      cerr << "reading back..";
      if (test_read_SeqSeqOctetT(d,testData.t3) < 0)
	return -1;

      cerr << "to any..";

      delete testData.t3any;
      testData.t3any = d->to_any();

      cerr << "PASSED." << endl;
      d->destroy();
    }
    catch (...) {
      writeErrmsg(__FILE__,__LINE__,"failed to modify member.");
      return -1;
    }
  }
  {
    CORBA::DynAny_var d = orb->create_dyn_any(*testData.t4any);

    cerr << "TRMW: SeqSeqDoubleT modify in place..";
    try {
      testData.t4[2][1] = testData.t4[2][1] + 10;
      d->seek(2);
      CORBA::DynAny_var dm = d->current_component();
      dm->seek(1);
      dm->insert_double(testData.t4[2][1]);
      cerr << "reading back..";
      if (test_read_SeqSeqDoubleT(d,testData.t4) < 0)
	return -1;

      cerr << "to any..";

      delete testData.t4any;
      testData.t4any = d->to_any();

      cerr << "PASSED." << endl;
      d->destroy();
    }
    catch (...) {
      writeErrmsg(__FILE__,__LINE__,"failed to modify member.");
      return -1;
    }
  }
  cerr << "TRMW: Redo TR with the modified values..." << endl;
  if (test_read(testData) < 0) return -1;

  {
    CORBA::DynAny_var d = orb->create_dyn_any(*testData.t1any);

    cerr << "TRMW: SeqOctetT truncate sequence..";
    try {
      CORBA::ULong len = testData.t1.length();
      if (len == 0) {
	cerr << "already truncated. Test skipped.";
      }
      else {
	len -= 1;
	testData.t1.length(len);
	CORBA::DynSequence_var ds = CORBA::DynSequence::_narrow(d);
	ds->length(len);
      }
      cerr << "reading back..";
      if (test_read_SeqOctetT(d,testData.t1) < 0)
	return -1;

      cerr << "to any..";

      delete testData.t1any;
      testData.t1any = d->to_any();

      cerr << "PASSED." << endl;
      d->destroy();
    }
    catch (...) {
      writeErrmsg(__FILE__,__LINE__,"failed to modify member.");
      return -1;
    }
  }
  {
    CORBA::DynAny_var d = orb->create_dyn_any(*testData.t2any);

    cerr << "TRMW: SeqDoubleT truncate sequence..";
    try {
      CORBA::ULong len = testData.t2.length();
      if (len == 0) {
	cerr << "already truncated. Test skipped.";
      }
      else {
	len -= 1;
	testData.t2.length(len);
	CORBA::DynSequence_var ds = CORBA::DynSequence::_narrow(d);
	ds->length(len);
      }
      cerr << "reading back..";
      if (test_read_SeqDoubleT(d,testData.t2) < 0)
	return -1;

      cerr << "to any..";

      delete testData.t2any;
      testData.t2any = d->to_any();

      cerr << "PASSED." << endl;
      d->destroy();
    }
    catch (...) {
      writeErrmsg(__FILE__,__LINE__,"failed to modify member.");
      return -1;
    }
  }
  {
    CORBA::DynAny_var d = orb->create_dyn_any(*testData.t3any);

    cerr << "TRMW: SeqSeqOctetT truncate sequence..";
    try {
      CORBA::ULong len = testData.t3.length();
      if (len == 0) {
	cerr << "already truncated. Test skipped.";
      }
      else {
	len -= 1;
	testData.t3.length(len);
	CORBA::DynSequence_var ds = CORBA::DynSequence::_narrow(d);
	ds->length(len);
      }
      cerr << "reading back..";
      if (test_read_SeqSeqOctetT(d,testData.t3) < 0)
	return -1;

      cerr << "to any..";

      delete testData.t3any;
      testData.t3any = d->to_any();

      cerr << "PASSED." << endl;
      d->destroy();
    }
    catch (...) {
      writeErrmsg(__FILE__,__LINE__,"failed to modify member.");
      return -1;
    }
  }
  {
    CORBA::DynAny_var d = orb->create_dyn_any(*testData.t4any);

    cerr << "TRMW: SeqSeqDoubleT truncate sequence..";
    try {
      CORBA::ULong len = testData.t4.length();
      if (len == 0) {
	cerr << "already truncated. Test skipped.";
      }
      else {
	len -= 1;
	testData.t4.length(len);
	CORBA::DynSequence_var ds = CORBA::DynSequence::_narrow(d);
	ds->length(len);
      }
      cerr << "reading back..";
      if (test_read_SeqSeqDoubleT(d,testData.t4) < 0)
	return -1;

      cerr << "to any..";

      delete testData.t4any;
      testData.t4any = d->to_any();

      cerr << "PASSED." << endl;
      d->destroy();
    }
    catch (...) {
      writeErrmsg(__FILE__,__LINE__,"failed to modify member.");
      return -1;
    }
  }
  cerr << "TRMW: Redo TR with the modified values..." << endl;
  if (test_read(testData) < 0) return -1;

  {
    CORBA::DynAny_var d = orb->create_dyn_any(*testData.t1any);

    cerr << "TRMW: SeqOctetT extend sequence..";
    try {
      CORBA::ULong len = testData.t1.length();
      len += 1;
      testData.t1.length(len);
      testData.t1[len-1] = testData.t1[0] + 100;

      CORBA::DynSequence_var ds = CORBA::DynSequence::_narrow(d);
      ds->length(len);
      d->seek(len-1);
      d->insert_octet(testData.t1[len-1]);

      cerr << "reading back..";
      if (test_read_SeqOctetT(d,testData.t1) < 0)
	return -1;

      cerr << "to any..";

      delete testData.t1any;
      testData.t1any = d->to_any();

      cerr << "PASSED." << endl;
      d->destroy();
    }
    catch (...) {
      writeErrmsg(__FILE__,__LINE__,"failed to modify member.");
      return -1;
    }
  }
  {
    CORBA::DynAny_var d = orb->create_dyn_any(*testData.t2any);

    cerr << "TRMW: SeqDoubleT extend sequence..";
    try {
      CORBA::ULong len = testData.t2.length();
      len += 1;
      testData.t2.length(len);
      testData.t2[len-1] = testData.t2[0] + 100;

      CORBA::DynSequence_var ds = CORBA::DynSequence::_narrow(d);
      ds->length(len);
      d->seek(len-1);
      d->insert_double(testData.t2[len-1]);

      cerr << "reading back..";
      if (test_read_SeqDoubleT(d,testData.t2) < 0)
	return -1;

      cerr << "to any..";

      delete testData.t2any;
      testData.t2any = d->to_any();

      cerr << "PASSED." << endl;
      d->destroy();
    }
    catch (...) {
      writeErrmsg(__FILE__,__LINE__,"failed to modify member.");
      return -1;
    }
  }
  {
    CORBA::DynAny_var d = orb->create_dyn_any(*testData.t3any);

    cerr << "TRMW: SeqSeqOctetT extend sequence..";
    try {
      CORBA::ULong len = testData.t3.length();
      len += 1;
      testData.t3.length(len);
      testData.t3[len-1] = testData.t1;

      CORBA::DynSequence_var ds = CORBA::DynSequence::_narrow(d);
      ds->length(len);
      d->seek(len-1);
      CORBA::DynAny_var dm = d->current_component();
      CORBA::DynSequence_var dms = CORBA::DynSequence::_narrow(dm);
      CORBA::ULong elen = testData.t3[len-1].length();
      dms->length(elen);
      for (CORBA::ULong eindex = 0; eindex < elen; eindex++) {
	dms->insert_octet(testData.t3[len-1][eindex]);
      }
      cerr << "reading back..";
      if (test_read_SeqSeqOctetT(d,testData.t3) < 0)
	return -1;

      cerr << "to any..";

      delete testData.t3any;
      testData.t3any = d->to_any();

      cerr << "PASSED." << endl;
      d->destroy();
    }
    catch (...) {
      writeErrmsg(__FILE__,__LINE__,"failed to modify member.");
      return -1;
    }
  }
  {
    CORBA::DynAny_var d = orb->create_dyn_any(*testData.t4any);

    cerr << "TRMW: SeqSeqDoubleT extend sequence..";
    try {
      CORBA::ULong len = testData.t4.length();
      len += 1;
      testData.t4.length(len);
      testData.t4[len-1] = testData.t2;

      CORBA::DynSequence_var ds = CORBA::DynSequence::_narrow(d);
      ds->length(len);
      d->seek(len-1);
      CORBA::DynAny_var dm = d->current_component();
      CORBA::DynSequence_var dms = CORBA::DynSequence::_narrow(dm);
      CORBA::ULong elen = testData.t4[len-1].length();
      dms->length(elen);
      for (CORBA::ULong eindex = 0; eindex < elen; eindex++) {
	dms->insert_double(testData.t4[len-1][eindex]);
      }
      cerr << "reading back..";
      if (test_read_SeqSeqDoubleT(d,testData.t4) < 0)
	return -1;

      cerr << "to any..";

      delete testData.t4any;
      testData.t4any = d->to_any();

      cerr << "PASSED." << endl;
      d->destroy();
    }
    catch (...) {
      writeErrmsg(__FILE__,__LINE__,"failed to modify member.");
      return -1;
    }
  }
  cerr << "TRMW: Redo TR with the modified values..." << endl;
  if (test_read(testData) < 0) return -1;

  {
    cerr << "TRMW: SeqOctetT truncate sequence with set_elements..";

    CORBA::DynAny_var d = orb->create_dyn_any(*testData.t1any);
    CORBA::DynSequence_var ds = CORBA::DynSequence::_narrow(d);

    try {
      CORBA::AnySeq* as = ds->get_elements();
      CORBA::ULong len = testData.t1.length();
      if (len != as->length()) {
	writeErrmsg(__FILE__,__LINE__,"unexpected discrepency.");
	return -1;
      }
      if (len == 0) {
	cerr << "already truncated. Test skipped.";
      }
      else {
	len -= 1;
	testData.t1.length(len);
	as->length(len);
	ds->set_elements(*as);
      }
      delete as;
      cerr << "reading back..";
      if (test_read_SeqOctetT(d,testData.t1) < 0)
	return -1;

      cerr << "to any..";

      delete testData.t1any;
      testData.t1any = d->to_any();

      cerr << "PASSED." << endl;
      d->destroy();
    }
    catch (...) {
      writeErrmsg(__FILE__,__LINE__,"failed to modify member.");
      return -1;
    }
  }
  {
    cerr << "TRMW: SeqDoubleT truncate sequence with set_elements..";

    CORBA::DynAny_var d = orb->create_dyn_any(*testData.t2any);
    CORBA::DynSequence_var ds = CORBA::DynSequence::_narrow(d);

    try {
      CORBA::AnySeq* as = ds->get_elements();
      CORBA::ULong len = testData.t2.length();
      if (len != as->length()) {
	writeErrmsg(__FILE__,__LINE__,"unexpected discrepency.");
	return -1;
      }
      if (len == 0) {
	cerr << "already truncated. Test skipped.";
      }
      else {
	len -= 1;
	testData.t2.length(len);
	as->length(len);
	ds->set_elements(*as);
      }
      delete as;
      cerr << "reading back..";
      if (test_read_SeqDoubleT(d,testData.t2) < 0)
	return -1;

      cerr << "to any..";

      delete testData.t2any;
      testData.t2any = d->to_any();

      cerr << "PASSED." << endl;
      d->destroy();
    }
    catch (...) {
      writeErrmsg(__FILE__,__LINE__,"failed to modify member.");
      return -1;
    }
  }
  {
    cerr << "TRMW: SeqSeqOctetT truncate sequence with set_elements..";

    CORBA::DynAny_var d = orb->create_dyn_any(*testData.t3any);
    CORBA::DynSequence_var ds = CORBA::DynSequence::_narrow(d);

    try {
      CORBA::AnySeq* as = ds->get_elements();
      CORBA::ULong len = testData.t3.length();
      if (len != as->length()) {
	writeErrmsg(__FILE__,__LINE__,"unexpected discrepency.");
	return -1;
      }
      if (len == 0) {
	cerr << "already truncated. Test skipped.";
      }
      else {
	len -= 1;
	testData.t3.length(len);
	as->length(len);
	ds->set_elements(*as);
      }
      delete as;
      cerr << "reading back..";
      if (test_read_SeqSeqOctetT(d,testData.t3) < 0)
	return -1;

      cerr << "to any..";

      delete testData.t3any;
      testData.t3any = d->to_any();

      cerr << "PASSED." << endl;
      d->destroy();
    }
    catch (...) {
      writeErrmsg(__FILE__,__LINE__,"failed to modify member.");
      return -1;
    }
  }
  {
    cerr << "TRMW: SeqSeqDoubleT truncate sequence with set_elements..";

    CORBA::DynAny_var d = orb->create_dyn_any(*testData.t4any);
    CORBA::DynSequence_var ds = CORBA::DynSequence::_narrow(d);

    try {
      CORBA::AnySeq* as = ds->get_elements();
      CORBA::ULong len = testData.t4.length();
      if (len != as->length()) {
	writeErrmsg(__FILE__,__LINE__,"unexpected discrepency.");
	return -1;
      }
      if (len == 0) {
	cerr << "already truncated. Test skipped.";
      }
      else {
	len -= 1;
	testData.t4.length(len);
	as->length(len);
	ds->set_elements(*as);
      }
      delete as;
      cerr << "reading back..";
      if (test_read_SeqSeqDoubleT(d,testData.t4) < 0)
	return -1;

      cerr << "to any..";

      delete testData.t4any;
      testData.t4any = d->to_any();

      cerr << "PASSED." << endl;
      d->destroy();
    }
    catch (...) {
      writeErrmsg(__FILE__,__LINE__,"failed to modify member.");
      return -1;
    }
  }
  cerr << "TRMW: Redo TR with the modified values..." << endl;
  if (test_read(testData) < 0) return -1;

  {
    cerr << "TRMW: SeqOctetT extend sequence with set_elements..";

    CORBA::DynAny_var d = orb->create_dyn_any(*testData.t1any);
    CORBA::DynSequence_var ds = CORBA::DynSequence::_narrow(d);

    try {
      CORBA::AnySeq* as = ds->get_elements();
      CORBA::ULong len = testData.t1.length();
      if (len != as->length()) {
	writeErrmsg(__FILE__,__LINE__,"unexpected discrepency.");
	return -1;
      }
      len += 1;
      testData.t1.length(len);
      testData.t1[len-1] = 200;
      as->length(len);
      (*as)[len-1] <<= CORBA::Any::from_octet(testData.t1[len-1]);
      ds->set_elements(*as);

      delete as;
      cerr << "reading back..";
      if (test_read_SeqOctetT(d,testData.t1) < 0)
	return -1;

      cerr << "to any..";

      delete testData.t1any;
      testData.t1any = d->to_any();

      cerr << "PASSED." << endl;
      d->destroy();
    }
    catch (...) {
      writeErrmsg(__FILE__,__LINE__,"failed to modify member.");
      return -1;
    }
  }
  {
    cerr << "TRMW: SeqDoubleT extend sequence with set_elements..";

    CORBA::DynAny_var d = orb->create_dyn_any(*testData.t2any);
    CORBA::DynSequence_var ds = CORBA::DynSequence::_narrow(d);

    try {
      CORBA::AnySeq* as = ds->get_elements();
      CORBA::ULong len = testData.t2.length();
      if (len != as->length()) {
	writeErrmsg(__FILE__,__LINE__,"unexpected discrepency.");
	return -1;
      }
      len += 1;
      testData.t2.length(len);
      testData.t2[len-1] = 2000;
      as->length(len);
      (*as)[len-1] <<= testData.t2[len-1];
      ds->set_elements(*as);

      delete as;
      cerr << "reading back..";
      if (test_read_SeqDoubleT(d,testData.t2) < 0)
	return -1;

      cerr << "to any..";

      delete testData.t2any;
      testData.t2any = d->to_any();

      cerr << "PASSED." << endl;
      d->destroy();
    }
    catch (...) {
      writeErrmsg(__FILE__,__LINE__,"failed to modify member.");
      return -1;
    }
  }
  {
    cerr << "TRMW: SeqSeqOctetT extend sequence with set_elements..";

    CORBA::DynAny_var d = orb->create_dyn_any(*testData.t3any);
    CORBA::DynSequence_var ds = CORBA::DynSequence::_narrow(d);

    try {
      CORBA::AnySeq* as = ds->get_elements();
      CORBA::ULong len = testData.t3.length();
      if (len != as->length()) {
	writeErrmsg(__FILE__,__LINE__,"unexpected discrepency.");
	return -1;
      }
      len += 1;
      testData.t3.length(len);
      testData.t3[len-1] = testData.t1;

      as->length(len);
      (*as)[len-1] <<= testData.t1;

      ds->set_elements(*as);

      delete as;
      cerr << "reading back..";
      if (test_read_SeqSeqOctetT(d,testData.t3) < 0)
	return -1;

      cerr << "to any..";

      delete testData.t3any;
      testData.t3any = d->to_any();

      cerr << "PASSED." << endl;
      d->destroy();
    }
    catch (...) {
      writeErrmsg(__FILE__,__LINE__,"failed to modify member.");
      return -1;
    }
  }
  {
    cerr << "TRMW: SeqSeqDoubleT extend sequence with set_elements..";

    CORBA::DynAny_var d = orb->create_dyn_any(*testData.t4any);
    CORBA::DynSequence_var ds = CORBA::DynSequence::_narrow(d);

    try {
      CORBA::AnySeq* as = ds->get_elements();
      CORBA::ULong len = testData.t4.length();
      if (len != as->length()) {
	writeErrmsg(__FILE__,__LINE__,"unexpected discrepency.");
	return -1;
      }
      len += 1;
      testData.t4.length(len);
      testData.t4[len-1] = testData.t2;

      as->length(len);
      (*as)[len-1] <<= testData.t2;

      ds->set_elements(*as);

      delete as;
      cerr << "reading back..";
      if (test_read_SeqSeqDoubleT(d,testData.t4) < 0)
	return -1;

      cerr << "to any..";

      delete testData.t4any;
      testData.t4any = d->to_any();

      cerr << "PASSED." << endl;
      d->destroy();
    }
    catch (...) {
      writeErrmsg(__FILE__,__LINE__,"failed to modify member.");
      return -1;
    }
  }
  cerr << "TRMW: Redo TR with the modified values..." << endl;
  if (test_read(testData) < 0) return -1;
  return 0;
}

int
test_import_export(TestDataT& testData)
{
  // The tests exercise the import and export operations from/to any.
 {
    CORBA::DynSequence_var d = orb->create_dyn_sequence(_tc_SeqOctetT);
    cerr << "TIE: from_any..";
    try {
      d->from_any(*testData.t1any);
      cerr << "reading back..";
      if (test_read_SeqOctetT(d,testData.t1) < 0)
	return -1;
      cerr << "PASSED." << endl;
      d->destroy();
    }
    catch (...) {
      writeErrmsg(__FILE__,__LINE__,"failed to write member.");
      return -1;
    }
  }
  {
    try {
      CORBA::DynAny_var d1 = orb->create_dyn_sequence(_tc_SeqOctetT);
      CORBA::DynAny_var d2 = orb->create_dyn_any(*testData.t1any);

      cerr << "TIE: test assign..";
      d1->assign(d2);
      cerr << "reading back..";
      if (test_read_SeqOctetT(d1,testData.t1) < 0)
	return -1;
      cerr << "PASSED." << endl;

      cerr << "TIE: test copy..";
      CORBA::DynAny_var d3 = d2->copy();
      cerr << "reading back..";
      if (test_read_SeqOctetT(d3,testData.t1) < 0)
	return -1;
      cerr << "PASSED." << endl;
      d1->destroy();
      d2->destroy();
      d3->destroy();
    }
    catch(...) {
      writeErrmsg(__FILE__,__LINE__,"unexpected exception.");
      return -1;
    }
  }
 return 0;
}

int
test_iteration(TestDataT& testData)
{
  // The tests execise the iteration operations: next(), seek(), rewind(),
  // current_component() and type().
  //
  // Normal usage of next(), seek() and current_component() has already
  // been tested in other cases. Just test for the detection of error
  // conditions.

  try {
    cerr << "TI: ";
    CORBA::DynAny_var d = orb->create_dyn_any(*testData.t1any);
    CORBA::DynSequence_var ds = CORBA::DynSequence::_narrow(d);
    CORBA::ULong len = ds->length();
    cerr << "seek beyond the last element..";
    if (d->seek(len) == 1) {
      writeErrmsg(__FILE__,__LINE__,"seek() wrongly returns True");
      return -1;
    }
    if (len) {
      cerr << "seek to the last element..";
      if (d->seek(len-1) == 0) {
	writeErrmsg(__FILE__,__LINE__,"seek() wrongly returns False");
	return -1;
      }
    }
    cerr << "next()..";
    if (d->next() == 1) {
      writeErrmsg(__FILE__,__LINE__,"next() wrongly returns True");
      return -1;
    }
    cerr << "type()..";
    CORBA::TypeCode_var tc = d->type();
    if (CORBA::is_nil(tc)) {
      writeErrmsg(__FILE__,__LINE__,"type() returns a nil object");
      return -1;
    }
    if (tc->kind() != CORBA::tk_sequence) {
      writeErrmsg(__FILE__,__LINE__,"type() returns wrong typecode");
      return -1;
    }
    cerr << "PASSED." << endl;
    d->destroy();
  }
  catch (...) {
    writeErrmsg(__FILE__,__LINE__,"failed.");
    return -1;
  }


  return 0;
}

int
test_error_insert_invalid_value(CORBA::DynAny_ptr d,CORBA::TCKind k)
{
  try {
    if (k != CORBA::tk_boolean) {
      try {
	d->insert_boolean(1);
	// reach here only if the dynany fail to catch this error
	writeErrmsg(__FILE__,__LINE__,"error not caught.");
	return -1;
      }
      catch(const CORBA::DynAny::InvalidValue&) { /* expected response */ }
    }
    if (k != CORBA::tk_octet) {
      try {
	d->insert_octet(1);
	// reach here only if the dynany fail to catch this error
	writeErrmsg(__FILE__,__LINE__,"error not caught.");
	return -1;
      }
      catch(const CORBA::DynAny::InvalidValue&) { /* expected response */ }
    }
    if (k != CORBA::tk_char) {
      try {
	d->insert_char(1);
	// reach here only if the dynany fail to catch this error
	writeErrmsg(__FILE__,__LINE__,"error not caught.");
	return -1;
      }
      catch(const CORBA::DynAny::InvalidValue&) { /* expected response */ }
    }
    if (k != CORBA::tk_short) {
      try {
	d->insert_short(1);
	// reach here only if the dynany fail to catch this error
	writeErrmsg(__FILE__,__LINE__,"error not caught.");
	return -1;
      }
      catch(const CORBA::DynAny::InvalidValue&) { /* expected response */ }
    }
    if (k != CORBA::tk_ushort) {
      try {
	d->insert_ushort(1);
	// reach here only if the dynany fail to catch this error
	writeErrmsg(__FILE__,__LINE__,"error not caught.");
	return -1;
      }
      catch(const CORBA::DynAny::InvalidValue&) { /* expected response */ }
    }
    if (k != CORBA::tk_long) {
      try {
	d->insert_long(1);
	// reach here only if the dynany fail to catch this error
	writeErrmsg(__FILE__,__LINE__,"error not caught.");
	return -1;
      }
      catch(const CORBA::DynAny::InvalidValue&) { /* expected response */ }
    }
    if (k != CORBA::tk_ulong) {
      try {
	d->insert_ulong(1);
	// reach here only if the dynany fail to catch this error
	writeErrmsg(__FILE__,__LINE__,"error not caught.");
	return -1;
      }
      catch(const CORBA::DynAny::InvalidValue&) { /* expected response */ }
    }
    if (k != CORBA::tk_float) {
      try {
	d->insert_float(1);
	// reach here only if the dynany fail to catch this error
	writeErrmsg(__FILE__,__LINE__,"error not caught.");
	return -1;
      }
      catch(const CORBA::DynAny::InvalidValue&) { /* expected response */ }
    }
    if (k != CORBA::tk_double) {
      try {
	d->insert_double(1);
	// reach here only if the dynany fail to catch this error
	writeErrmsg(__FILE__,__LINE__,"error not caught.");
	return -1;
      }
      catch(const CORBA::DynAny::InvalidValue&) { /* expected response */ }
    }
    if (k != CORBA::tk_string) {
      try {
	d->insert_string("Hello");
	// reach here only if the dynany fail to catch this error
	writeErrmsg(__FILE__,__LINE__,"error not caught.");
	return -1;
      }
      catch(const CORBA::DynAny::InvalidValue&) { /* expected response */ }
    }
    if (k != CORBA::tk_objref) {
      try {
	d->insert_reference(CORBA::Object::_nil());
	// reach here only if the dynany fail to catch this error
	writeErrmsg(__FILE__,__LINE__,"error not caught.");
	return -1;
      }
      catch(const CORBA::DynAny::InvalidValue&) { /* expected response */ }
    }
    if (k != CORBA::tk_TypeCode) {
      try {
	d->insert_typecode(CORBA::TypeCode::_nil());
	// reach here only if the dynany fail to catch this error
	writeErrmsg(__FILE__,__LINE__,"error not caught.");
	return -1;
      }
      catch(const CORBA::DynAny::InvalidValue&) { /* expected response */ }
    }
    if (k != CORBA::tk_any) {
      try {
	CORBA::Any v;
	d->insert_any(v);
	// reach here only if the dynany fail to catch this error
	writeErrmsg(__FILE__,__LINE__,"error not caught.");
	return -1;
      }
      catch(const CORBA::DynAny::InvalidValue&) { /* expected response */ }
    }
  }
  catch (...) {
    writeErrmsg(__FILE__,__LINE__,"unexpected exception.");
    return -1;
  }
  return 0;
}

int
test_error_get_type_mismatch(CORBA::DynAny_ptr d,CORBA::TCKind k)
{
  try {
    if (k != CORBA::tk_boolean) {
      try {
	CORBA::Boolean v = d->get_boolean();
	// reach here only if the dynany fail to catch this error
	writeErrmsg(__FILE__,__LINE__,"error not caught.");
	return -1;
      }
      catch(const CORBA::DynAny::TypeMismatch&) { /* expected response */ }
    }
    if (k != CORBA::tk_octet) {
      try {
	CORBA::Octet v = d->get_octet();
	// reach here only if the dynany fail to catch this error
	writeErrmsg(__FILE__,__LINE__,"error not caught.");
	return -1;
      }
      catch(const CORBA::DynAny::TypeMismatch&) { /* expected response */ }
    }
    if (k != CORBA::tk_char) {
      try {
	CORBA::Char v = d->get_char();
	// reach here only if the dynany fail to catch this error
	writeErrmsg(__FILE__,__LINE__,"error not caught.");
	return -1;
      }
      catch(const CORBA::DynAny::TypeMismatch&) { /* expected response */ }
    }
    if (k != CORBA::tk_short) {
      try {
	CORBA::Short v = d->get_short();
	// reach here only if the dynany fail to catch this error
	writeErrmsg(__FILE__,__LINE__,"error not caught.");
	return -1;
      }
      catch(const CORBA::DynAny::TypeMismatch&) { /* expected response */ }
    }
    if (k != CORBA::tk_ushort) {
      try {
	CORBA::UShort v = d->get_ushort();
	// reach here only if the dynany fail to catch this error
	writeErrmsg(__FILE__,__LINE__,"error not caught.");
	return -1;
      }
      catch(const CORBA::DynAny::TypeMismatch&) { /* expected response */ }
    }
    if (k != CORBA::tk_long) {
      try {
	CORBA::Long v = d->get_long();
	// reach here only if the dynany fail to catch this error
	writeErrmsg(__FILE__,__LINE__,"error not caught.");
	return -1;
      }
      catch(const CORBA::DynAny::TypeMismatch&) { /* expected response */ }
    }
    if (k != CORBA::tk_ulong) {
      try {
	CORBA::ULong v = d->get_ulong();
	// reach here only if the dynany fail to catch this error
	writeErrmsg(__FILE__,__LINE__,"error not caught.");
	return -1;
      }
      catch(const CORBA::DynAny::TypeMismatch&) { /* expected response */ }
    }
    if (k != CORBA::tk_float) {
      try {
	CORBA::Float v = d->get_float();
	// reach here only if the dynany fail to catch this error
	writeErrmsg(__FILE__,__LINE__,"error not caught.");
	return -1;
      }
      catch(const CORBA::DynAny::TypeMismatch&) { /* expected response */ }
    }
    if (k != CORBA::tk_double) {
      try {
	CORBA::Double v = d->get_double();
	// reach here only if the dynany fail to catch this error
	writeErrmsg(__FILE__,__LINE__,"error not caught.");
	return -1;
      }
      catch(const CORBA::DynAny::TypeMismatch&) { /* expected response */ }
    }
    if (k != CORBA::tk_string) {
      try {
	CORBA::String_var v = d->get_string();
	// reach here only if the dynany fail to catch this error
	writeErrmsg(__FILE__,__LINE__,"error not caught.");
	return -1;
      }
      catch(const CORBA::DynAny::TypeMismatch&) { /* expected response */ }
    }
    if (k != CORBA::tk_objref) {
      try {
	CORBA::Object_var v = d->get_reference();
	// reach here only if the dynany fail to catch this error
	writeErrmsg(__FILE__,__LINE__,"error not caught.");
	return -1;
      }
      catch(const CORBA::DynAny::TypeMismatch&) { /* expected response */ }
    }
    if (k != CORBA::tk_TypeCode) {
      try {
	CORBA::TypeCode_var v = d->get_typecode();
	// reach here only if the dynany fail to catch this error
	writeErrmsg(__FILE__,__LINE__,"error not caught.");
	return -1;
      }
      catch(const CORBA::DynAny::TypeMismatch&) { /* expected response */ }
    }
    if (k != CORBA::tk_any) {
      try {
	CORBA::Any_var v = d->get_any();
	// reach here only if the dynany fail to catch this error
	writeErrmsg(__FILE__,__LINE__,"error not caught.");
	return -1;
      }
      catch(const CORBA::DynAny::TypeMismatch&) { /* expected response */ }
    }
  }
  catch (...) {
    writeErrmsg(__FILE__,__LINE__,"unexpected exception.");
    return -1;
  }
  return 0;
}

int
test_error_handling(TestDataT& testData)
{
  {
    CORBA::DynAny_var d = orb->create_dyn_sequence(_tc_SeqOctetT);
    cerr << "TEH: reject invalid value..";
    // Only insert_octet() can succeed.
    if (test_error_insert_invalid_value(d,CORBA::tk_octet) < 0)
      return -1;
    cerr << "PASSED." << endl;
    d->destroy();
  }
  {
    cerr << "TEH: reject mismatch extraction..";
    CORBA::DynAny_var d = orb->create_dyn_any(*testData.t1any);
    // Only get_octet() can succeed.
    if (test_error_get_type_mismatch(d,CORBA::tk_octet) < 0)
      return -1;
    cerr << "PASSED." << endl;
    d->destroy();
  }
  return 0;
}

int
main(int argc, char**argv)
{
  orb = CORBA::ORB_init(argc,argv,"omniORB2");

  TestDataT t;
  initialise_testdata(t);
  if (test_read(t) < 0) {
    cerr << "Abort." << endl;
    return 1;
  }
  if (test_create_write(t) < 0) {
    cerr << "Abort." << endl;
    return 1;
  }
  if (test_read_modify_write(t) < 0) {
    cerr << "Abort." << endl;
    return 1;
  }
  if (test_import_export(t) < 0) {
    cerr << "Abort." << endl;
    return 1;
  }
  if (test_error_handling(t) < 0) {
    cerr << "Abort." << endl;
    return 1;
  }  
  if (test_iteration(t) < 0) {
    cerr << "Abort." << endl;
    return 1;
  }
  return 0;
}
