// Testing code: implementation of seqEcho objects
//

#include <iostream.h>
#include <string.h>
#include <seqEcho.hh>
#include <common/common.h>

// implementation using inheritance skeleton
class seqEcho_i : public virtual seqEcho::_sk_echo {
public:
  seqEcho_i() {}
  virtual seqEcho::seqdouble* op1(const seqEcho::seqchar& a1,
				 const seqEcho::seqdouble& a2);

};

seqEcho::seqdouble*
seqEcho_i::op1(const seqEcho::seqchar& a1,
	       const seqEcho::seqdouble& a2)
{
  for (CORBA::ULong i=0; i < a2.length(); i++) {
    cerr << a2[i] << " ";
  }
  cerr << endl;
  return new seqEcho::seqdouble(a2);
}


int
main(int argc, char **argv) {

  try {
    CORBA::ORB_ptr orb = CORBA::ORB_init(argc,argv,"omniORB2");
    CORBA::BOA_ptr boa = orb->BOA_init(argc,argv,"omniORB2_BOA");

    CosNaming::Name use_name;
  
    if (argc > 1) {
      if (argc != 2) {
	cerr << "Usage: seqEchosrv [<COSNaming compound name (e.g. x/y/echo.obj)>]"	
	     << endl;
      }
      try {
	use_name = string_to_name(argv[1]);
      }
      catch (...) {
	cerr << argv[1] << " is not a valid COS Naming compound name." << endl;
	return 1;
      }
    }

    seqEcho_i *myobj = new seqEcho_i;
    myobj->_obj_is_ready(boa);

    {
      seqEcho::echo_var myobjRef = myobj->_this();
      if (use_name.length()) {
	if (!bindObjectToName(orb,myobjRef,use_name)) {
	  return 1;
	}
      }
      else {
	CORBA::String_var p = orb->object_to_string(myobjRef);
	cerr << (char*)p << endl;
      }    
    }

    boa->impl_is_ready();
  }
  catch (const omniORB::fatalException &ex) {
      cerr << "#### You have caught an omniORB2 bug, details are as follows:" << endl;
      cerr << ex.file() << " " << ex.line() << ":" << ex.errmsg() << endl; 
      cerr << "main thread exited." << endl;
      return 1;
    }
  return 0;
}
