// refp_i.cc
//
// -- written by Eoin Carroll

// OmniORB 2 version


#include <iostream.h>
#include <stdlib.h>
#include <refp.hh>
#include <common/common.h>

class refp_i : public virtual _sk_refp
{
private:

  char* m_ref;
  CORBA::ORB* m_orb;

public:
  refp_i() { }
  void setorb(CORBA::ORB* orb);

  refp_ptr refpass(refp_ptr a_ref);
  
  refp_ptr getref();

};

void
refp_i::setorb(CORBA::ORB* orb)
{
  m_orb = orb;
}

refp_ptr
refp_i::refpass(refp_ptr a_ref)
{
  cout << "Received reference.\n";

  cout << "IIOP: '";
  m_ref = m_orb->object_to_string(a_ref); 
  cout << m_ref << "'" << endl;

  cout << "\nSending reference back..." << endl;
  return refp::_narrow(m_orb->string_to_object(m_ref));
}


refp_ptr
refp_i::getref()
{
  cout << "Reference request received. Sending reference." << endl;
  return refp::_narrow(m_orb->string_to_object(m_ref));
}


int main(int argc, char* argv[])
{

  CORBA::ORB* orb;
  CORBA::BOA* boa;

  // CORBA Initialization:

  try {
    orb = CORBA::ORB_init(argc,argv,"omniORB2");
    boa = orb->BOA_init(argc,argv,"omniORB2_BOA");

    CosNaming::Name use_name;
  
    if (argc > 1) {
      if (argc != 2) {
	cerr << "Usage: refpsrv [<COSNaming compound name (e.g. x/y/echo.obj)>]"	
	     << endl;
      }
      try {
	use_name = string_to_name(argv[1]);
      }
      catch (...) {
	cerr << argv[1] << " is not a valid COS Naming compound name." << endl;
	return 1;
      }
    }

    refp_i *myobj = new refp_i();
    myobj->setorb(orb);
    myobj->_obj_is_ready(boa);

    {
      refp_var myobjRef = myobj->_this();
      if (use_name.length()) {
	if (!bindObjectToName(orb,myobjRef,use_name)) {
	  return 1;
	}
      }
      else {
	CORBA::String_var p = orb->object_to_string(myobjRef);
	cerr << (char*)p << endl;
      }
    }
     
    boa->impl_is_ready();
  }
  catch (const omniORB::fatalException &ex) 
    {
      cerr << "#### You have caught an omniORB2 bug, details are as follows:" 
	   <<  endl;
      cerr << ex.file() << " " << ex.line() << ":" << ex.errmsg() << endl; 
      cerr << "main thread exited." << endl;
      return 1;
    }


  return 0;
}
