// Testing code: client of echo objects
//
//   interface Echo {
//        string echoString(in string mesg);
//   };
//

#include <iostream.h>
#include <echo.hh>
#include <common/common.h>

omni_mutex cerr_sync;

static
void
contact(char* id, Echo_ptr e)
{
  int loopcount = 10;
  while (loopcount--) {
    try {
      char * echostr;
      echostr = e->echoString((char *)"abcde");
      {
	omni_mutex_lock s(cerr_sync);
	cerr << id << ": reply " << echostr << endl;
      }
      if (strcmp((const char *)echostr,"abcde")) {
	cerr << loopcount << " : echo string differs ('" << "abcde', '" 
	     << (char *)echostr << "')" << endl;
	break;
      }
      CORBA::string_free(echostr);
    }
    catch (...) {
      cerr << "Caught system exception. Abort" << endl;
      return;
    }
  }
}

class worker : public omni_thread {
public:
  worker(char* id,Echo_ptr e) : omni_thread(id) {
    pd_e = e;
    start_undetached();
    return;
  }
  virtual void* run_undetached(void*id) {
    contact((char*)id,pd_e);
    return 0;
  };
  virtual ~worker() {}
private:
  Echo_var pd_e;
};


int
main (int argc, char **argv) {

  CORBA::ORB_ptr orb = CORBA::ORB_init(argc,argv,"omniORB2");

  CORBA::Object_var obj;

  switch (argc) {
  case 2:
    {
      try {
	CosNaming::Name use_name = string_to_name(argv[1]);
	obj = getObjectReference(orb,use_name);
      }
      catch (...) {
	obj = CORBA::Object::_nil();
      }
      if (CORBA::is_nil(obj)) {
	cerr << "Cannot resolve compound name to an object reference."
	     << endl;
	return 1; 
      }
      break;
    }
  case 3:
    if (strcmp(argv[1],"-i") == 0) {
      obj = orb->string_to_object(argv[2]);
      if (CORBA::is_nil(obj)) {
	cerr << "Cannot convert stringified IOR to an object reference."
	     << endl;
	return 1;
      }
      break;
    }
  default:
    cerr << "usage: conclt -i <stringified IOR>" << endl;
    cerr << "       conclt <COSNaming compound name (e.g. x/y/echo.obj)>"
	 << endl;
    return 1;
  }

  Echo_var e = Echo::_narrow(obj);

  if (CORBA::is_nil(e))
    {
      cerr << "Can't create proxy.\n" << endl;
      return 1;
    }

  if (e->_non_existent())
    {
      cerr << "Object does not exist.\n" << endl;
      return 1;
    }

  worker* worker1 =  new worker("worker 1:",Echo::_duplicate(e));
  worker* worker2 =  new worker("worker 2:",Echo::_duplicate(e));
  worker* worker3 =  new worker("worker 3:",Echo::_duplicate(e));
  worker* worker4 =  new worker("worker 4:",Echo::_duplicate(e));
  worker* worker5 =  new worker("worker 5:",Echo::_duplicate(e));
  worker* worker6 =  new worker("worker 6:",Echo::_duplicate(e));
  worker* worker7 =  new worker("worker 7:",Echo::_duplicate(e));
  worker* worker8 =  new worker("worker 8:",Echo::_duplicate(e));
  worker* worker9 =  new worker("worker 9:",Echo::_duplicate(e));
  worker* worker10 =  new worker("worker 10:",Echo::_duplicate(e));
  contact("main",e);
  worker1->join(0);
  worker2->join(0);
  worker3->join(0);
  worker4->join(0);
  worker5->join(0);
  worker6->join(0);
  worker7->join(0);
  worker8->join(0);
  worker9->join(0);
  worker10->join(0);

  return 0;
}
