/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	GDB/RBD
 *
 *	$Id: hcc.c,v 6.1 96/11/23 19:36:59 nevin Rel $
 *
 *	Function:	- wrapper for C program compilation
 */

#include <stdio.h>
#include <string.h>
#include <limits.h>
#include <errno.h>

#include <args.h>
#include <boot.h>
#include <portable.h>

#ifndef DEFTCC
#define DEFTCC "cc"
#endif

/*
 * external functions
 */
extern int		cnfexec();
extern char		*getenv();

/*
 * local variables
 */
static char		ph[LAM_PATH_MAX];
static char		plib[LAM_PATH_MAX];

int
main(argc, argv)

int			argc;
char			*argv[];

{
	int		ac;		/* cc # args */
	int		status;		/* cc return code */
	int		i;		/* favourite index */
	int		fl_libs;	/* add libs to command line */
	int		fl_show;	/* show what would be done */
	char		**av;		/* cc arg vector */
	char		**sys;		/* system libraries arg vector */
	char		*phome;		/* installation dir */
	char		*tcc;		/* cc tool */

	phome = getenv("LAMHOME");
	if (phome == 0) phome = getenv("TROLLIUSHOME");
	if (phome == 0) phome = DEFP;

	if ((strlen(phome) + 32) >= LAM_PATH_MAX) {
		fprintf(stderr, "hcc: LAM home pathname too long\n");
		exit(1);
	}
/*
 * Form include directory pathname.
 */
	strcpy(ph, "-I");
	strcat(ph, phome);
	strcat(ph, STRSDIR);
	strcat(ph, "h");
/*
 * Form library directory pathname.
 */
	strcpy(plib, "-L");
	strcat(plib, phome);
	strcat(plib, STRSDIR);
	strcat(plib, "lib");

	tcc = getenv("LAMHCC");
	if (tcc == 0) tcc = getenv("TROLLIUSHCC");
	if (tcc == 0) tcc = DEFTCC;

	av = argvbreak(tcc, ' ');
	if (av == 0) {
		perror("hcc");
		exit(errno);
	}

	ac = argvcount(av);
/*
 * Add system dependent defines.
 */
	argvadd(&ac, &av, OS);
	argvadd(&ac, &av, CPU);

	fl_show = 0;
	fl_libs = 1;

	for (i = 1; i < argc; ++i) {
		if (strcmp(argv[i], "-showme") == 0) {
			fl_show = 1;
		} else if (strcmp(argv[i], "-c") == 0) {
			fl_libs = 0;
		}
	}

	argvadd(&ac, &av, ph);
	if (fl_libs) {
		argvadd(&ac, &av, plib);
	}

	for (i = 1; i < argc; ++i) {
		if (strcmp(argv[i], "-showme")) {
			argvadd(&ac, &av, argv[i]);
		}
	}

	if (fl_libs) {
		argvadd(&ac, &av, "-ltstdio");
		argvadd(&ac, &av, "-ltrillium");
		argvadd(&ac, &av, "-largs");
		argvadd(&ac, &av, "-lt");
/*
 * Add system dependent libraries.
 */
		if (strlen(SYSLIBS) > 0) {
			if ((sys = argvbreak(SYSLIBS, ' ')) == 0) {
				perror("hcc");
				exit(errno);
			}

			for ( ; *sys; sys++) {
				argvadd(&ac, &av, *sys);
			}
		}
	}

	if (fl_show) {
		for (i = 0; i < ac; i++) {
			printf("%s ", av[i]);
		}
		printf("\n");
	} else {
		status = cnfexec(av);

		if (status != 0) {
			perror(tcc);
			exit(status);
		}
	}

	return(0);
}
