/*
 *	Ohio Trollius
 *	Copyright 1994 The Ohio State University
 *	GDB
 *
 *	$Log:	lpdetach.c,v $
 * Revision 6.1  96/11/24  00:25:48  nevin
 * Ohio Release
 * 
 * Revision 6.0  96/02/29  14:04:44  gdburns
 * Ohio Release
 * 
 * Revision 5.2  94/08/22  14:13:25  gdburns
 * Ohio Release
 * 
 * Revision 5.1.1.1  94/08/18  11:47:20  gdburns
 * Use buffers so as to not confuse ksr() in kenyad.
 * 
 * Revision 5.1  94/05/18  12:58:01  gdburns
 * Ohio Release
 * 
 * Revision 2.3  94/04/22  12:46:10  gdburns
 * Ohio Release
 * 
 * Revision 2.2.1.1  93/10/13  17:16:43  gdburns
 * Move ksigblock() before nsend() due to new kernel.
 * 
 * Revision 2.2  93/05/05  16:41:52  vaigl-j
 * pre-release to 2.3
 *
 *	Function:	- detaches caller from the local kenya server
 *			- based on Trollius 2.0 Copyright 1990
 *			  The Ohio State University and Cornell
 *			  Research Foundation
 *	Accepts:	- target process ID
 *			- exit status
 *	Returns:	- 0 or ERROR
 */

#include <events.h>
#include <kio.h>
#include <ksignal.h>
#include <net.h>
#include <portable.h>
#include <preq.h>
#include <t_types.h>
#include <typical.h>
#include <terror.h>

/*
 * external variables
 */
extern struct kio_t	_kio;		/* Kernel Input/Output */

int
lpdetach(pid, status)

int			pid;
int			status;

{
	struct nmsg	nhead;		/* network header */
	struct preq  	request;	/* kenya request */
	struct preply	reply;		/* kenya reply */
	int		mask;

	request.pq_src_node = ltot(LOCAL);
	request.pq_src_event = ltot((int4) -getpid());
	request.pq_pid = ltot(pid ? (int4) pid : (int4) getpid());
	request.pq_status = ltot((int4) status);
	request.pq_req = ltot(PQDETACH);

	nhead.nh_node = LOCAL;
	nhead.nh_event = EVKENYAD;
	nhead.nh_type = 0;
	nhead.nh_flags = 0;
	nhead.nh_length = sizeof(request);
	nhead.nh_msg = (char *) &request;
	mask = ksigblock(sigmask(SIGUDIE) | sigmask(SIGARREST));

	if (nsend(&nhead)) {
		ksigsetmask(mask);
		return(ERROR);
	}

	nhead.nh_event = -getpid();
	nhead.nh_flags = 0;
	nhead.nh_length = sizeof(reply);
	nhead.nh_msg = (char *) &reply;

	if (nrecv(&nhead)) {
		ksigsetmask(mask);
		return(ERROR);
	}

	ksigsetmask(mask);

	if (reply.pr_reply) {
		errno = ttol(reply.pr_reply);
		return(ERROR);
	} else {
		_kio.ki_rtf &= ~RTF_KENYA;
		return(0);
	}
}

/*
 *	rpdetach
 *
 *	Function:	- now just a wrapper for lpdetach()
 *			- obsolete; don't use this, use lpdetach()
 *	Accepts:	- destination node
 *			- target process ID
 *			- exit status
 *	Returns:	- 0 or ERROR
 */
int
rpdetach(node, pid, status)

int4			node;
int			pid;
int			status;

{
	if ((node != LOCAL) && (node != getnodeid())) {
		errno = EBADNODE;
		return(ERROR);
	}

	return(lpdetach(pid, status));
}
