/*
 *	Ohio Trollius
 *      Copyright 1996 The Ohio State University
 *      GDB/RBD
 *
 *	$Id: TRIL.c,v 6.1 96/11/24 00:25:45 nevin Rel $
 *
 *	Function:	- f2c F77 interface for libtrillium functions
 */

#include <stdlib.h>

#include <lam_config.h>

#include <portable.h>
#include <preq.h>
#include <terror.h>

/*
 * external functions
 */
extern char		*f2cstring();

/*
 * F77/C interface
 */
#if FORTRANNOUNDERSCORE
#define rpwt_		rpwt
#define rpldgo_		rpldgo
#endif

/*
 * simple wrappers
 */
void rpwt_(n, p, s, ie) int4 *n, *p, *s, *ie;
		{ *ie = rpwait(n, p, s) ? errno : 0; }

/*
 * thicker wrappers
 */
void
rpldgo_(srcnode, destnode, filename, flags, pid, idx, ierror, lstr)

int4			*srcnode;
int4			*destnode;
char			*filename;
int4			*flags;
int4			*pid;
int4			*idx;
int4			*ierror;
unsigned int		lstr;

{
	char		*cstr;
	int		r;

	if ((cstr = f2cstring(filename, lstr)) == 0) {
		*ierror = errno;
		return;
	}

	r = rploadgo(*srcnode, *destnode, cstr, *flags, (char **) 0, pid, idx);
	*ierror = r ? errno : 0;

	free(cstr);
}
