/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD
 *
 *	$Id: textent.c,v 6.1 96/11/23 22:54:35 nevin Rel $
 *
 *	Function:	- return extent of datatype
 *	Accepts:	- datatype
 *			- ptr to extent (returned value)
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>

int
MPI_Type_extent(dtype, pextent)

MPI_Datatype		dtype;
MPI_Aint		*pextent;

{
	lam_initerr();
	lam_setfunc(BLKMPITEXTENT);

	if (dtype == MPI_DATATYPE_NULL) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPITEXTENT, lam_mkerr(MPI_ERR_TYPE, 0)));
	}
	else if (pextent == 0) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPITEXTENT, lam_mkerr(MPI_ERR_ARG, 0)));
	}
	else {
		*pextent = dtype->dt_upper - dtype->dt_lower;
	}

	lam_resetfunc(BLKMPITEXTENT);
	return(MPI_SUCCESS);
}
