/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD
 *
 *	$Id: pack.c,v 6.1 96/11/23 22:53:38 nevin Rel $
 *
 *	Function:	- pack from data buffer
 *	Accepts:	- data buffer
 *			- data count
 *			- data type
 *			- packing buffer
 *			- packing buffer size
 *			- ptr packing buffer position
 *			- communicator
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>

int
MPI_Pack(buf, count, dtype, packbuf, packsize, ppackpos, comm)

void			*buf;
int			count;
MPI_Datatype		dtype;
void			*packbuf;
int			packsize;
int			*ppackpos;
MPI_Comm		comm;

{
	int		size;
	char		*p;

	lam_initerr();
	lam_setfunc(BLKMPIPACK);
/*
 * Check the arguments.
 */
	if (comm == MPI_COMM_NULL) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPIPACK, lam_mkerr(MPI_ERR_COMM, 0)));
	}

	if (dtype == MPI_DATATYPE_NULL) {
		return(lam_errfunc(comm,
			BLKMPIPACK, lam_mkerr(MPI_ERR_TYPE, 0)));
	}

	if (count < 0) {
		return(lam_errfunc(comm,
			BLKMPIPACK, lam_mkerr(MPI_ERR_COUNT, 0)));
	}

	if ((packsize < 0) || (ppackpos == 0)) {
		return(lam_errfunc(comm,
			BLKMPIPACK, lam_mkerr(MPI_ERR_ARG, 0)));
	}

	if ((*ppackpos < 0) || ((*ppackpos >= packsize) && (packsize > 0))) {
		return(lam_errfunc(comm,
			BLKMPIPACK, lam_mkerr(MPI_ERR_ARG, 0)));
	}

	if ((packsize > 0) && (packbuf == 0)) {
		return(lam_errfunc(comm,
			BLKMPIPACK, lam_mkerr(MPI_ERR_BUFFER, 0)));
	}
/*
 * Pack the data.
 */
	p = ((char *) packbuf) + *ppackpos;
	size = packsize - *ppackpos;

	size = lam_pack((char *) buf, count, dtype, p, size);

	if (size < 0) {
		return(lam_errfunc(comm,
			BLKMPIPACK, lam_mkerr(MPI_ERR_TRUNCATE, 0)));
	}

	*ppackpos += size;

	lam_resetfunc(BLKMPIPACK);
	return(MPI_SUCCESS);
}
