/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD
 *
 *	$Id: lamupdown.c,v 6.1 96/11/23 22:53:21 nevin Rel $
 *
 *	Function:	- take top level info down
 *			- take error info up
 */

#include <mpi.h>
#include <mpisys.h>

/*
 * global variables
 */
int			lam_topfunc = 0;
int			lam_toproot;
int			lam_toprootgps;

/*
 *	lam_setfunc
 *
 *	Function:	- set top level function
 *	Accepts:	- local function type
 */
void
lam_setfunc(locfunc)

int			locfunc;

{
	if (lam_topfunc == 0) {
		lam_topfunc = locfunc;
	}
}

/*
 *	lam_resetfunc
 *
 *	Function:	- reset function at top level
 *	Accepts:	- local function type
 */
void
lam_resetfunc(locfunc)

int			locfunc;

{
	struct _fyiproc	*p;			/* favourite pointer */

	if (lam_topfunc == locfunc) {
		p = (struct _fyiproc *) _kio.ki_fyi;
		lam_topfunc = p->fyp_func = 0;
	}
}

/*
 *	lam_getfunc
 *
 *	Function:	- get top level function
 *	Returns:	- top level function
 */
int
lam_getfunc()

{
	return(lam_topfunc);
}

/*
 *	lam_setparam
 *
 *	Function:	- set top level parameters
 *	Accepts:	- local function type
 *			- root global/local rank (collective comm.)
 *			- root node/index GPS (collective comm.)
 */
void
lam_setparam(locfunc, root, rootgps)

int			locfunc;
int			root;
int			rootgps;

{
	if (lam_topfunc == locfunc) {
		lam_toproot = root;
		lam_toprootgps = rootgps;
	}
}

/*
 *	lam_getparam
 *
 *	Function:	- get top level parameters
 *	Accepts:	- ptr root ranks
 *			- ptr root GPS
 */
void
lam_getparam(proot, prootgps)

int			*proot;
int			*prootgps;

{
	*proot = lam_toproot;
	*prootgps = lam_toprootgps;
}

/*
 *	lam_mkerr
 *
 *	Function:	- form an error code
 *	Accepts:	- error class
 *			- error value
 *	Returns:	- error code
 */
int
lam_mkerr(class, error)

int			class;
int			error;

{
	int		errcode;

	errcode = ((error & 0xFFFF) << 8) | (lam_topfunc & 0xFF);
	errcode = (errcode << 8) | (class & 0xFF);
	return(errcode);
}

/*
 *	lam_bkerr
 *
 *	Function:	- break error code into components
 *	Accepts:	- error code
 *			- ptr class (returned value)
 *			- ptr function (returned value)
 *			- ptr error (returned value)
 */
void
lam_bkerr(errcode, class, func, error)

int			errcode;
int			*class;
int			*func;
int			*error;

{
	*class = errcode & 0xFF;
	errcode >>= 8;
	*func = errcode & 0xFF;
	errcode >>= 8;
	*error = errcode & 0xFFFF;
}

/*
 *	lam_errfunc
 *
 *	Function:	- handle MPI errors according to error mode
 *			- pass error up to top level
 *			- call error handler at top level
 *	Accepts:	- communicator
 *			- local function type
 *			- error code
 *	Returns:	- error code
 */
int
lam_errfunc(errcomm, locfunc, errcode)

MPI_Comm		errcomm;
int			locfunc;
int			errcode;

{
	MPI_Comm	comm;			/* communicator */
	MPI_Errhandler	errhdl;			/* error handler */
	int		class;			/* error class */
	int		func;			/* function type */
	int		error;			/* errno value */
	int		errsave;		/* saved error code */
	int		f77index;		/* f77 error handler */
	struct _fyiproc	*p;			/* favourite pointer */

	errsave = errcode;

	lam_bkerr(errcode, &class, &func, &error);

	if (func == locfunc) {

		comm = (errcomm) ? errcomm : MPI_COMM_WORLD;
		
		errhdl = comm->c_errhdl;
		f77index = errhdl->eh_f77hdl;

		if (f77index < 0) {
			(errhdl->eh_func)(&comm, &errcode);
		} else {
			(errhdl->eh_func)(&f77index, &errcode);
		}

		p = (struct _fyiproc *) _kio.ki_fyi;
		lam_topfunc = p->fyp_func = 0;
	}

	return(errsave);
}

/*
 *	lam_nukefunc
 *
 *	Function:	- reset top function (cleanup)
 */
void
lam_nukefunc()

{
	lam_topfunc = 0;
}
