/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD
 *
 *	$Id: lammisc.c,v 6.1 96/11/23 22:53:05 nevin Rel $
 *
 *	Function:	- miscellaneous functions
 */

#include <stdlib.h>

#include <mpi.h>
#include <mpisys.h>
#include <terror.h>

/*
 *	lam_chkarg
 *
 *	Function:	- check point-to-point arguments
 *	Accepts:	- buffer/count/datatype/peer rank/tag/comm.
 *	Returns:	- MPI_SUCCESS or error code
 */
int
lam_chkarg(buf, count, dtype, rank, tag, comm)

void			*buf;
int			count;
MPI_Datatype		dtype;
int			rank;
int			tag;
MPI_Comm		comm;

{
	if (count < 0) {
		return(lam_mkerr(MPI_ERR_COUNT, 0));
	}

	if (dtype == MPI_DATATYPE_NULL || (!dtype->dt_commit)) {
		return(lam_mkerr(MPI_ERR_TYPE, 0));
	}

	if ((tag > LAM_MAXTAG) || ((tag < 0) && (tag != MPI_ANY_TAG) &&
			(tag != MPI_GER_TAG) && (tag != MPI_MERGE_TAG))) {
		return(lam_mkerr(MPI_ERR_TAG, 0));
	}

	if (comm == MPI_COMM_NULL) {
		return(lam_mkerr(MPI_ERR_COMM, 0));
	}

	if ((rank != MPI_PROC_NULL) && (rank != MPI_ANY_SOURCE)) {
		if (LAM_IS_INTER(comm)) {
			if ((rank < 0) || (rank >= comm->c_rgroup->g_nprocs)) {
				return(lam_mkerr(MPI_ERR_RANK, 0));
			}
		} else {
			if ((rank < 0) || (rank >= comm->c_group->g_nprocs)) {
				return(lam_mkerr(MPI_ERR_RANK, 0));
			}
		}
	}

	return(MPI_SUCCESS);
}

/*
 *	lam_cubedim
 *
 *	Function:	- get dimension of inscribing hypercube
 *	Accepts:	- # processes
 *	Returns:	- dimension or -1
 */
int
lam_cubedim(nprocs)

int			nprocs;

{
	int		dim;
	unsigned	size;

	if (nprocs < 1) return(-1);

	for (dim = 0, size = 1; size < nprocs; ++dim, size <<= 1);

	return(dim);
}

/*
 *	lam_hibit
 *
 *	Function:	- get position of the highest bit set
 *	Accepts:	- process rank
 *			- hypercube dimension
 *	Returns:	- position or -1
 */
int
lam_hibit(rank, dim)

int			rank;
int			dim;

{
	unsigned	mask;

	if ((rank < 1) || (dim < 1)) return(-1);

	--dim;
	mask = 1 << dim;

	for (; dim >= 0; --dim, mask >>= 1) {
		if (rank & mask) break;
	}

	return(dim);
}

/*
 *	lam_emtpystat
 *
 *	Function:	- set status to empty
 *	Accepts:	- ptr status
 */
void
lam_emptystat(pstat)

MPI_Status		*pstat;

{
	pstat->MPI_SOURCE = MPI_ANY_SOURCE;
	pstat->MPI_TAG = MPI_ANY_TAG;
	pstat->MPI_ERROR = MPI_ERR_PENDING;
	pstat->st_count = 0;
	pstat->st_nelem = 0;
	pstat->st_length = 0;
	pstat->st_dtype = MPI_DATATYPE_NULL;
}
