/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD
 *
 *	$Id: keycreate.c,v 6.1 96/11/23 22:52:47 nevin Rel $
 *
 *	Function:	- create an attribute key
 *	Accepts:	- copy function
 *			- delete function
 *			- ptr key value
 *			- extra state info
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>
#include <terror.h>

/*
 * external functions
 */
extern struct _attrkey	*lam_getattr();

int
MPI_Keyval_create(cpyfunc, delfunc, pkey, extra)

int			(*cpyfunc)();
int			(*delfunc)();
int			*pkey;
void			*extra;

{
	int		key;
	struct _attrkey	*p;

	lam_initerr();
	lam_setfunc(BLKMPIKEYCREATE);
/*
 * Check the arguments.
 */
	if (pkey == 0) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPIKEYCREATE, lam_mkerr(MPI_ERR_ARG, 0)));
	}
/*
 * Create the key.
 */
	if ((key = lam_mkkey()) < 0) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPIKEYCREATE, lam_mkerr(MPI_ERR_OTHER, errno)));
	}

	*pkey = key;
	p = lam_getattr(key);
	if (p == 0) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPIKEYCREATE, lam_mkerr(MPI_ERR_OTHER, errno)));
	}
/*
 * Fill the attribute information.
 */
	p->ak_copy = cpyfunc;
	p->ak_del = delfunc;
	p->ak_extra = extra;
	p->ak_refcount = 1;
	p->ak_f77comm = -1;
	p->ak_flags = 0;

	lam_resetfunc(BLKMPIKEYCREATE);
	return(MPI_SUCCESS);
}
