/*
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	NJN/RBD
 *
 *	$Id: getcount.c,v 6.1.1.1 97/02/24 13:57:40 nevin Exp $
 *
 *	Function:	- get # top-level elements
 *	Accepts:	- status
 *			- datatype
 *			- count (out)
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>

int
MPI_Get_count(stat, dtype, count)

MPI_Status		*stat;
MPI_Datatype		dtype;
int			*count;

{
	lam_initerr();
	lam_setfunc(BLKMPIGETCOUNT);
/*
 * Check the arguments.
 */
	if ((count == 0) || (stat == 0) || (stat->st_length < 0)) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPIGETCOUNT, lam_mkerr(MPI_ERR_ARG, 0)));
	}

	if ((dtype == MPI_DATATYPE_NULL) || ((dtype != stat->st_dtype) &&
				(stat->st_dtype != MPI_DATATYPE_NULL) &&
				(stat->st_dtype != MPI_PACKED) &&
				(dtype != MPI_PACKED))) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPIGETCOUNT, lam_mkerr(MPI_ERR_TYPE, 0)));
	}
/*
 * Find the count.
 */
	if (dtype->dt_size == 0 || (stat->st_length % dtype->dt_size) != 0) {
		*count = MPI_UNDEFINED;
	} else {
		*count = stat->st_length / dtype->dt_size;
	}

	lam_resetfunc(BLKMPIGETCOUNT);
	return(MPI_SUCCESS);
}
