/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD
 *
 *	$Id: cgroup.c,v 6.1 96/11/23 22:51:26 nevin Rel $
 *
 *	Function:	- get communicator group (create a new group)
 *	Accepts:	- communicator
 *			- ptr to group
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>

int
MPI_Comm_group(comm, pgroup)

MPI_Comm		comm;
MPI_Group		*pgroup;

{
	lam_initerr();
	lam_setfunc(BLKMPICOMMGROUP);

	if (comm == MPI_COMM_NULL) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPICOMMGROUP, lam_mkerr(MPI_ERR_COMM, 0)));
	}

	if (pgroup == 0) {
		return(lam_errfunc(comm,
			BLKMPICOMMGROUP, lam_mkerr(MPI_ERR_ARG, 0)));
	}

	*pgroup = comm->c_group;
	comm->c_group->g_refcount++;

	lam_resetfunc(BLKMPICOMMGROUP);
  	return(MPI_SUCCESS);
}
