/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD
 *
 *	$Id: attrget.c,v 6.1 96/11/23 22:50:50 nevin Rel $
 *
 *	Function:	- get attribute value
 *	Accepts:	- communicator
 *			- attribute key
 *			- ptr attribute value (returned value)
 *			- ptr found flag (returned value)
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>

/*
 * external functions
 */
extern struct _attrkey	*lam_getattr();
extern struct _attr	*lam_getkey();

int
MPI_Attr_get(comm, key, value, found)

MPI_Comm		comm;
int			key;
void			*value;
int			*found;

{
	struct _attr	*p;

	lam_initerr();
	lam_setfunc(BLKMPIATTRGET);
/*
 * Check the arguments.
 */
	if (comm == MPI_COMM_NULL) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPIATTRGET, lam_mkerr(MPI_ERR_COMM, 0)));
	}

	if ((value == 0) || (found == 0)) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPIATTRGET, lam_mkerr(MPI_ERR_ARG, 0)));
	}

	if (lam_getattr(key) == 0) {
		return(lam_errfunc(comm,
			BLKMPIATTRGET, lam_mkerr(MPI_ERR_ARG, 0)));
	}
/*
 * Check if the key is attached to the communicator.
 */
	p = lam_getkey(comm, key);
	if (p == 0) {
		*found = 0;
	} else {
		*found = 1;
		*((void **) value) = p->a_value;
	}

	lam_resetfunc(BLKMPIATTRGET);
	return(MPI_SUCCESS);
}
