/*
 *	Ohio Trollius
 *	Copyright 1994 The Ohio State University
 *	GDB
 *
 *	$Log:	kdoom.c,v $
 * Revision 6.1  96/11/23  22:49:10  nevin
 * Ohio Release
 * 
 * Revision 6.0  96/08/30  18:45:32  nevin
 * Ohio Release
 * 
 * Revision 5.2  94/08/22  14:01:38  gdburns
 * Ohio Release
 * 
 * Revision 5.1.1.1  94/08/18  11:37:29  gdburns
 * upgrade for new kernel
 * 
 * Revision 5.1  94/05/18  12:45:22  gdburns
 * Ohio Release
 * 
 * Revision 2.3  94/04/22  12:39:28  gdburns
 * Ohio Release
 * 
 * Revision 2.2  93/07/19  20:00:08  gdburns
 * pre-release to 2.3
 * 
 *	Function:	- delivers a signal to a process
 *	Accepts:	- process identifier (0 means self)
 *			- signal number
 *	Returns:	- 0 or ERROR
 */

#include <kio.h>
#include <kreq.h>
#include <terror.h>
#include <typical.h>

/*
 * external variables
 */
extern struct kio_t	_kio;			/* kernel I/O block */

/*
 * external functions
 */
extern int		_cipc_kreq();		/* make kernel request */
extern void		_ksig_follow();		/* check signals */

int
kdoom(pid, signal)

int			pid;
int			signal;

{
	struct kreq	req;			/* kernel request */
	struct kreply	reply;			/* kernel reply */
/*
 * Check the signal number bounds.
 */
	if ((signal < 1) || (signal > TNSIG)) {
		errno = EINVAL;
		return(ERROR);
	}
/*
 * Formulate the KQDOOM kernel request.
 */
	req.kq_req = KQDOOM;
	req.kq_index = _kio.ki_index;
	req.kq_pid = pid;
	req.kq_signal = sigmask(signal);

	if (_cipc_kreq(&req, &reply)) {
		return(ERROR);
	}
/*
 * Check signals.
 */
	if (reply.kr_signal) {
		_kio.ki_signal |= reply.kr_signal;
		_ksig_follow();
	}

	if (reply.kr_reply) {
		errno = reply.kr_reply;
		return(ERROR);
	}

	return(0);
}
