/*
 *	Ohio Trollius
 *	Copyright 1995 The Ohio State University
 *	GDB/RBD
 *
 *	$Log:	rreq.h,v $
 * Revision 6.1  96/11/23  21:55:31  nevin
 * Ohio Release
 * 
 * Revision 6.0  96/02/29  13:54:04  gdburns
 * Ohio Release
 * 
 * Revision 5.2.1.1  96/02/14  21:18:10  gdburns
 * Merge RQLOAD and RQSETROUTE into RQSETROUTES.
 * 
 * Revision 5.2  94/08/22  14:00:45  gdburns
 * Ohio Release
 * 
 * Revision 5.1  94/05/18  12:44:38  gdburns
 * Ohio Release
 * 
 * Revision 2.3  94/04/22  12:49:06  gdburns
 * Ohio Release
 * 
 *	Function:	- constants and templates associated with the router
 *			- based on Trollius 2.0 Copyright 1990
 *			  The Ohio State University and Cornell
 *			  Research Foundation
 */

#ifndef _RREQ
#define _RREQ

#include <net.h>
#include <portable.h>

/*
 * misc.
 */
#define RNRENT		10		/* # new route enties */

/*
 * router requests
 */
#define RQMAX		7		/* # router requests */
#define RQGETROUTE	0		/* translate node to event */
#define RQSETSMART	1		/* set smartness */
#define RQSETROUTES	2		/* adds route entries */
#define RQGETNODES	3		/* get matching node ID list */
#define RQREMROUTE	4		/* remove one specific node */
#define RQGETSMART	5		/* wait for a smart local router */
#define RQGETNTYPE	6		/* count matching nodes */

/*
 * router request types
 */
#define RDUMB		1		/* dumb router without table */
#define RSMART		2		/* smart router with table */

/*
 * router request template
 */
struct rreq {
	int4		rq_src_event;	/* client's event */
	int4		rq_request;	/* specific router request */
	int4		rq_nodeid;	/* node ID */
	int4		rq_nrents;	/* # route entries */
	int4		rq_event;	/* forwarding event */
	int4		rq_pid;		/* process ID */
	int4		rq_nodetype;	/* node type */
	int4		rq_typemask;	/* type mask */
#define rq_smartness	rq_typemask	/* smartness true/false */
};

/*
 * router reply template
 */
struct rreply {
	int4		rr_reply;	/* return code */
	int4		rr_nodetype;	/* node type */
	int4		rr_event;	/* forwarding event */
	int4		rr_event2;	/* min-route event */
	int4		rr_link2;	/* min-route link # */
	int4		rr_link;	/* forwarding link # */
	int4		rr_ntype;	/* # of nodes of given type */
};

/*
 * route table entry
 */
struct route {
	int4		r_nodeid;	/* destination node */
	int4		r_event;	/* forward to this event */
	int4		r_link;		/* forward to this link # */
	int4		r_event2;	/* min-route event */
	int4		r_link2;	/* min-route link # */
	int4		r_nodetype;	/* NT bits defined in net.h */
};

/*
 * prototypes
 */
#ifndef __ARGS
#if __STDC__ || defined(c_plusplus) || defined(__cplusplus)
#define __ARGS(a)	a
#else
#define __ARGS(a)	()
#endif
#endif

#ifdef __cplusplus
extern "C" {
#endif

extern int		getnodes __ARGS((int4 *pnodes, int4 nnodes,
					int4 nodetype, int4 typemask));
extern int4		getntype __ARGS((int4 nodetype, int4 typemask));
extern int		getrent __ARGS((struct route *rent));
extern int		getrentc __ARGS((struct route *rent));
extern int		getroute __ARGS((struct nmsg *nhead));
extern int4		getrtype __ARGS((int4 node));
extern int		getsmart __ARGS((void));
extern int		rrsetsmart __ARGS((int4 node, int smartness));
extern int		rremrent __ARGS((int4 node, int4 destnode));
extern int		rrsetrents __ARGS((int4 node, struct route *prents,
					int4 nrents));

#ifdef __cplusplus
}
#endif

#endif
