/*
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	GDB
 *
 *	$Id: ndi.h,v 6.1.1.1 97/01/21 10:02:37 nevin Exp $
 * 
 *	Function:	- node identifier parsing
 */

#ifndef _NDI_H
#define _NDI_H

#include "all_list.h"
#include "lam.h"

/*
 * node identifier list entry
 */
struct ndi {
	int4		ndi_node;	/* ID itself */
	int4		ndi_flags;	/* descriptive flags */
	int4		ndi_count;	/* # IDs actually represented */
	int4		ndi_index;	/* position in list (legacy) */
};

/*
 * prototypes
 */
#ifndef __ARGS
#if __STDC__ || defined(c_plusplus) || defined(__cplusplus)
#define __ARGS(a)	a
#else
#define __ARGS(a)	()
#endif
#endif

#ifdef __cplusplus
extern "C" {
#endif

extern LIST *	ndi_parse __ARGS((int argc, char ** argv, char *** othersv));
extern LIST *	ndi_resolve __ARGS((LIST * nodelist));
extern void	ndi_fmt __ARGS((int4 node, char * fmt_str));
extern int4	ndi_parse1 __ARGS((char * s));
extern void	ndi_usage __ARGS((void));

#ifdef __cplusplus
}
#endif

#endif	/* _NDI_H */
