/*
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	RBD
 *
 *	$Id: args.h,v 6.1.1.1 97/01/21 09:55:38 nevin Exp $
 *
 *	Function:	- command line argument parsing
 */

#ifndef _ARGS
#define _ARGS

#include "lam.h"

/*
 * prototypes
 */
#ifndef __ARGS
#if __STDC__ || defined(c_plusplus) || defined(__cplusplus)
#define __ARGS(a)	a
#else
#define __ARGS(a)	()
#endif
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*
 * argument vector package
 */
extern int		argvadd __ARGS((int *argc,
					char ***argv, const char *arg));
extern int		argvcount __ARGS((char **argv));
extern int		argvlen __ARGS((char **argv));
extern char		**argvdup __ARGS((char **argv));
extern char		*argvglue __ARGS((char **argv, int delim, int maxlen));
extern char		**argvbreak __ARGS((const char *args, int delim));
extern void		argvfree __ARGS((char **argv));

/*
 * backwards compatible option interfaces
 */
extern int		do_args __ARGS((int *argcp, char **argv));
extern int		expand_nodes __ARGS((void));
extern int		get_2nd_let __ARGS((int let));
extern int		intparam __ARGS((int c, int *p));
extern int		opt_chosen __ARGS((int o));
extern int		opt_taken __ARGS((int let));
extern int		xtoi __ARGS((char **cpp, int *ip));
extern char		*getparam __ARGS((int let));
extern void		exclusive __ARGS((const char *str));
extern void		followed __ARGS((const char *str));
extern void		free_nodes __ARGS((void));
extern void		twoletter __ARGS((const char *str));
extern void		validopts __ARGS((const char *str));

/*
 * ID parsing package
 */
extern int		nid_parse __ARGS((int *argc, char **argv));
extern int		pid_parse __ARGS((int *argc, char **argv));
extern int4		nid_count __ARGS((void));
extern int4		nid_parse1 __ARGS((char *s));
extern char		*nid_fmt __ARGS((int4 node));
extern void		nid_get __ARGS((int *ixp, int *idp, int *flp));
extern void		pid_get __ARGS((int *ixp, int *idp, int *flp));
extern void		nid_free __ARGS((void));
extern void		pid_free __ARGS((void));
extern void		nid_usage __ARGS((void));

/*
 * backwards compatible ID interfaces
 */
extern int		parse_nodes __ARGS((int *argc, char **argv));
extern int		parse_procs __ARGS((int *argc, char **argv));
extern int4		mnnodeid __ARGS((const char *string));
extern char		*mnemonic __ARGS((int4 node));
extern void		getnode __ARGS((int *ixp, int *idp, int *flagsp));
extern void		getproc __ARGS((int *ixp, int *idp, int *flagsp));
extern void		mnusage __ARGS((void));

#ifdef __cplusplus
}
#endif

#endif	/* _ARGS */
