/*
 *	Ohio Trollius
 *	Copyright 1995 The Ohio State University
 *	GDB
 *
 *	$Log:	rfclose.c,v $
 * Revision 6.1  96/11/23  19:58:50  nevin
 * Ohio Release
 * 
 * Revision 6.0  96/02/29  13:50:07  gdburns
 * Ohio Release
 * 
 * Revision 5.2.1.1  95/11/20  13:10:12  gdburns
 * Remove Cubix.
 * Qualify names for LAM.
 * 
 * Revision 5.2  94/08/22  13:59:13  gdburns
 * Ohio Release
 * 
 * Revision 5.1  94/05/18  10:58:10  gdburns
 * Ohio Release
 * 
 * Revision 2.3  94/04/22  12:38:25  gdburns
 * Ohio Release
 *
 *	Function:	- closes a file using remote filed
 *	Accepts:	- runtime file descriptor
 *	Returns:	- 0 or ERROR
 */

#include <events.h>
#include <freq.h>
#include <ksignal.h>
#include <net.h>
#include <typical.h>

/*
 * external variables
 */
extern int		errno;		/* error number */
extern struct fclient	_ufd[FUMAX];	/* client file descriptor table */

/*
 * external functions
 */
extern int		_fdvalid();	/* check validity of file desc */

int
lam_rfclose(fd)

int			fd;

{
	struct nmsg	nhead;		/* network message desc. */
	struct freq	*request;	/* filed request */
	struct freply	*reply;		/* filed reply */
	int		mask;		/* signal mask */
/*
 * Do simple error checking.
 */
	if (_fdvalid(fd)) return(LAMERROR);

	request = (struct freq *) nhead.nh_data;
	reply = (struct freply *) nhead.nh_data;

	request->fq_src_node = getnodeid();
	request->fq_src_event = -getpid();
	request->fq_req = FQCLOSE;
	request->fq_tfd = _ufd[fd].fu_tfd;

	if ((fd <= 2) && (_ufd[fd].fu_node == NOTNODEID)) {
		_ufd[fd].fu_node = getorigin();
	}

	nhead.nh_node = _ufd[fd].fu_node;
	nhead.nh_event = EVFILED;
	nhead.nh_type = 0;
	nhead.nh_flags = 0;
	nhead.nh_length = 0;
	nhead.nh_msg = 0;
	mask = ksigblock(sigmask(SIGUDIE) | sigmask(SIGARREST));

	if (nsend(&nhead)) {
		ksigsetmask(mask);
		return(LAMERROR);
	}

	nhead.nh_event = -getpid();

	if (nrecv(&nhead)) {
		ksigsetmask(mask);
		return(LAMERROR);
	}

	ksigsetmask(mask);

	if (reply->fr_errno != 0) {
		errno = reply->fr_errno;
		return(LAMERROR);
	} else {
		_ufd[fd].fu_tflags = 0;
		return(0);
	}
}

/*
 * backwards compatibility
 */
int rfclose(fd) int fd; { return(lam_rfclose(fd)); }
