/*
 *	Ohio Trollius
 *	Copyright 1995 The Ohio State University
 *	GDB
 *
 *	$Log:	do_wait.int.c,v $
 * Revision 6.1  96/11/23  18:45:13  nevin
 * Ohio Release
 * 
 * Revision 6.0  96/02/29  13:32:11  gdburns
 * Ohio Release
 * 
 * Revision 5.2.1.1  96/02/26  21:02:47  gdburns
 * major overhaul
 * 
 * Revision 5.2  94/08/22  13:51:30  gdburns
 * Ohio Release
 * 
 */

#include <net.h>
#include <typical.h>

/*
 * global functions
 */
void			do_wait_block();
void			do_wait_running();

/*
 * local functions
 */
static void		ack_handler();
static void		to_handler();

/*
 * external functions
 */
extern void		do_ack();
extern void		kio_intr();
extern int		kio_to();

/*
 * local variables
 */
static void		*pto_actual_sv;
static void		(*timeout_fn_sv)();

/*
 *	do_wait_block
 *
 *	Function:	- blocks on message receive while servicing
 *			  interrupts
 *			- if no receive, services one interrupt
 *	Accepts:	- ack socket
 *			- packet descriptor
 *			- timeout function
 *			- timeout value
 */
void
do_wait_block(sd_ack, pnh_packet, timeout_fn, pto_actual)

int			sd_ack;
struct nmsg		*pnh_packet;
void			(*timeout_fn)();
void			*pto_actual;

{
	timeout_fn_sv = timeout_fn;
	pto_actual_sv = pto_actual;

	if (frecv(pnh_packet)) lampanic("lamd (frecv)");

	if (kio_to(pto_actual, pto_actual ? to_handler : (void (*)()) 0))
			lampanic("lamd (kio_to)");

	kio_intr(sd_ack, ack_handler, FALSE);
}

/*
 *	do_wait_running
 *
 *	Function:	- waits for one interrupt and handles it
 *	Accepts:	- ack socket
 *			- timeout function
 *			- timeout value
 *	Returns:	- packet received?
 */
void
do_wait_running(sd_ack, timeout_fn, pto_actual)

int			sd_ack;
void			(*timeout_fn)();
void			*pto_actual;

{
	timeout_fn_sv = timeout_fn;
	pto_actual_sv = pto_actual;

	if (kio_to(pto_actual, pto_actual ? to_handler : (void (*)()) 0))
			lampanic("lamd (kio_to)");

	kio_intr(sd_ack, ack_handler, FALSE);
}

/*
 *	to_handler
 *
 *	Function:	- calls the current timeout handler
 *			- possibly updates the current timeout handler
 *			  and current timeout interval
 */
static void
to_handler()

{
	(*timeout_fn_sv)(&timeout_fn_sv, &pto_actual_sv);

	if (kio_to(pto_actual_sv, pto_actual_sv ? to_handler : (void (*)()) 0))
			lampanic("lamd (kio_to)");
}

/*
 *	ack_handler
 *
 *	Function:	- calls the ack handler
 *			- possibly updates the current timeout handler
 *			  and current timeout interval
 */
static void
ack_handler()

{
	do_ack(&timeout_fn_sv, &pto_actual_sv);

	if (kio_to(pto_actual_sv, pto_actual_sv ? to_handler : (void (*)()) 0))
			lampanic("lamd (kio_to)");
}
