/*
 *	Ohio Trollius
 *	Copyright 1995 The Ohio State University
 *	GDB
 *
 *	$Log:	do_load.c,v $
 * Revision 6.1  96/11/23  18:40:01  nevin
 * Ohio Release
 * 
 * Revision 6.0  96/02/29  13:30:07  gdburns
 * Ohio Release
 * 
 *	Function:	- UDP Internet datalink output
 *			- loads output link information
 */

#include <stdlib.h>

#include <dl_inet.h>
#include <events.h>
#include <kreq.h>
#include <portable.h>

/*
 * external variables
 */
extern struct dolink	*dolinks;	/* link table */
extern int		dol_cnt;	/* dol table length */
extern int		do_fault;	/* watch for faulty links */

/*
 * local variables
 */
static int4		config[3];	/* configuration parameters */

/*
 * global functions
 */
void			(*(do_loadinit()))();
void			(*(do_loadlinks()))();

/*
 * external functions
 */
extern void		(*(do_init2()))();

/*
 *	do_loadinit
 *
 *	Function:	- initializes the link table
 *			- receives neighbour link info from dli
 *			- blocks on a special event until info is received
 */
void (*(
do_loadinit()))()

{
	struct kmsg	khead;		/* kernel message desc. */

	khead.k_event = EVDLOINIT;
	khead.k_type = 0;
	khead.k_flags = 0;
	khead.k_length = sizeof(config);
	khead.k_msg = (char *) config;
/*
 * Receive the length of the link array.
 */
	if (krecv(&khead)) lampanic("dlo_inet (krecv)");

	return((void (*)()) do_loadlinks);
}

/*
 *	do_loadlinks
 *
 *	Function:	- loads link information from dli
 */
void (*(
do_loadlinks()))()

{
	struct kmsg	khead;			/* kernel message desc. */

	dol_cnt = (int) config[0];
	do_fault = (int) config[2];

	khead.k_event = EVDLOINIT;
	khead.k_type = 0;
	khead.k_flags = 0;
	khead.k_length = dol_cnt * sizeof(struct dolink);

	dolinks = (struct dolink *) malloc((unsigned) khead.k_length);
	if (!dolinks) lampanic("dlo_inet (malloc)");

	khead.k_msg = (char *) dolinks;
/*
 * Receive the neighbour link information.
 */
	if (krecv(&khead)) lampanic("dlo_inet (krecv)");

	return(do_init2());
}
