
#include <stdio.h>
#include <glib.h>
#include <gdk/gdk.h>
#include <gtk/gtk.h>

#include <gtk--.h>

class MainWindowClass : public Gtk_Window {
private:
  Gtk_HBox main_hbox;
  Gtk_HBox hbox;
  Gtk_Button button;
  Gtk_Toolbar toolbar;
  
  void quit_pressed_cb(void);
  void toolbar_button_cb(char *);
  
public:

   MainWindowClass (void);
  ~MainWindowClass (void);

};

Gtk_Main *app;

void MainWindowClass::toolbar_button_cb(char *c)
{
  printf("toolbar_button_cb : %s\n",c);
}

MainWindowClass::MainWindowClass(void) : Gtk_Window(GTK_WINDOW_TOPLEVEL),
  main_hbox(FALSE,0),
  hbox(FALSE,0),
  button("Quit")
{

  set_usize(400,50);
  
  add(&main_hbox);

  main_hbox.add(&hbox);
  
  hbox.pack_start(&button,FALSE,FALSE,0);
  hbox.pack_start(&toolbar,FALSE,FALSE,0);

  connect_to_method(button.clicked,this,&quit_pressed_cb);
#ifdef GTKMM_HAVE_MEMBER_TEMPLATES
  toolbar.append_item("Click me", "toolbar btn", "", 0,
		      this, &toolbar_button_cb, "'Click me' button");
  toolbar.append_space();

  toolbar.append_item("Click me too", "other toolbar btn", "", 0,
		      this, &toolbar_button_cb, "'Click me too' button");
#endif
  toolbar.append_button("Click me also", "duh", "", 0,
			ToolbarConnector<MainWindowClass, char*>(this, &toolbar_button_cb, "This is from a connector"));

  toolbar.append_button("Toggle me", "toggle duh", "", 0,
			ToolbarConnector<MainWindowClass, char*>(this, &toolbar_button_cb, "This is from a toggle connector"),
			GTK_TOOLBAR_CHILD_TOGGLEBUTTON);

  toolbar.show();
  button.show();
  hbox.show();
  main_hbox.show();
}

MainWindowClass::~MainWindowClass(void)
{}

void MainWindowClass::quit_pressed_cb(void)
{
  app->quit();
}

gint main(gint argc, gchar **argv)
{
  MainWindowClass *main_window;
  
  app = new Gtk_Main(&argc,&argv);

  main_window = new MainWindowClass;
  main_window->show();
  
  app->run();

  return(0);
}

