/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */


/* Modifed for gtk-- by sac@transmeta.com */
#include <gtk--.h>
#include <gtk/gtk.h>


class scribble_drawing_area  : public Gtk_DrawingArea
{
  /* Backing pixmap for drawing area */

  GdkPixmap *pixmap;

  /* Create a new backing pixmap of the appropriate size */
  int handle_configure_event (GdkEventConfigure *event)
  {
    GtkWidget *widget = GTK_WIDGET(gtkobj());
    
    if (pixmap)
      gdk_pixmap_unref(pixmap);

    pixmap = gdk_pixmap_new(get_window(),  width(), height(), -1);

    gdk_draw_rectangle (pixmap,
			GTK_WIDGET(gtkobj())->style->white_gc,
			TRUE,
			0, 0,
			width(),
			height());

    return TRUE;
  }

  /* Redraw the screen from the backing pixmap */
  int handle_expose_event (GdkEventExpose *event)
  {
    gdk_draw_pixmap(get_window(),
		    GTK_WIDGET (gtkobj())->style->fg_gc[GTK_WIDGET_STATE (GTK_WIDGET(gtkobj()))],
		    pixmap,
		    event->area.x, event->area.y,
		    event->area.x, event->area.y,
		    event->area.width, event->area.height);

    return FALSE;
  }

  /* Draw a rectangle on the screen */
  void 
  draw_brush (gdouble x, gdouble y)
  {
    GdkRectangle update_rect;
    update_rect.x = (int)x - 5;
    update_rect.y = (int)y - 5;
    update_rect.width = 10;
    update_rect.height = 10;
    gdk_draw_rectangle (pixmap,
			GTK_WIDGET (gtkobj())->style->black_gc,
			TRUE,
			update_rect.x, update_rect.y,
			update_rect.width, update_rect.height);
    draw (&update_rect);
  }

  gint
  handle_button_press_event (GdkEventButton *event)
  {
    if (event->button == 1 && pixmap != NULL)
      draw_brush (event->x, event->y);

    return TRUE;
  }

  gint
  handle_motion_notify_event (GdkEventMotion *event)
  {
    int x, y;
    GdkModifierType state;
    if (event->is_hint)
      gdk_window_get_pointer (event->window, &x, &y, &state);
    else
      {
	x = (int)event->x;
	y = (int)event->y;
	state = (GdkModifierType) event->state;
      }
    
    if (state & GDK_BUTTON1_MASK && pixmap != NULL)
      draw_brush (x, y);
  
    return TRUE;
  }


public:

  scribble_drawing_area ()
    : pixmap (0)
  {
    /* Signals used to handle backing pixmap */
    connect_to_method (expose_event, this, &handle_expose_event);
    connect_to_method (configure_event, this, &handle_configure_event);

    /* Event signals */
    connect_to_method (motion_notify_event, this, &handle_motion_notify_event);
    connect_to_method (button_press_event, this, &handle_button_press_event);

    set_events (GDK_EXPOSURE_MASK
		| GDK_LEAVE_NOTIFY_MASK
		| GDK_BUTTON_PRESS_MASK
		| GDK_POINTER_MOTION_MASK
		| GDK_POINTER_MOTION_HINT_MASK);
    
  }
};



class scribble_window : public Gtk_Window
{

  Gtk_VBox vbox;
  scribble_drawing_area drawing_area;
  Gtk_Button button;

  
  void quit ()
  {
    gtk_exit (0);
  }

public:  
  
  scribble_window ()
    :  Gtk_Window(GTK_WINDOW_TOPLEVEL),
       vbox (FALSE, 0),
       button ("quit")
  {
    add (&vbox);

    /* Create the drawing area */
    drawing_area.size (400, 400);
    vbox.pack_start (&drawing_area, TRUE, TRUE, 0);


    /* Add the button */
    vbox.pack_start (&button, FALSE, FALSE, 0);

    connect_to_method (button.clicked, this, &quit);
    connect_to_method (destroy, this, &quit);

    drawing_area.show();
    button.show();
    vbox.show();
  }
  
};


int
main (int argc, char *argv[])
{
  scribble_window *window;
  Gtk_Main myapp(&argc, &argv);

  window = new scribble_window;
  window->show();

  myapp.run();

  return 0;
}
