/* 
   XRContext.m

   GSContext for GNUstep GUI X/RAW Backend.  Conceptually, instances of 
   this subclass encapsulate a connection to an X display (X server).

   Copyright (C) 1996 Free Software Foundation, Inc.

   Author:  Felipe A. Rodriguez <far@ix.netcom.com>
   Date: November 1998
   
   This file is part of the GNUstep GUI X/RAW Backend.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/ 

#include <config.h>
#include <stdlib.h>
											 
#include <Foundation/NSData.h>
#include <Foundation/NSArray.h>
#include <Foundation/NSProcessInfo.h>

#include <gnustep/xraw/XRContext.h>
#include <gnustep/xraw/XRScreen.h>


//
//  Class variables
//
static GSContext *_currentXRContext = nil;				// the current context



//
// The backend implementation of GSContext
//
@implementation XRContext

//
// Class methods
//
+ (void)initialize
{
	if (self == [XRContext class])
		{
		_currentXRContext = [GSContext currentContext];
		NSDebugLog(@"Initialize XRContext class\n");
		}
}														// return X display of
														// the current context	
+ (Display*) currentXDisplay		{ return [_currentXRContext xDisplay]; }

+ (void) destroyContext:(GSContext *) context		
{													  
	XCloseDisplay([context xDisplay]);					// Close the X Display
	[super _destroyContext: context];
}													

//
// Instance methods
//
- initWithContextInfo: (NSDictionary *)info				// designated init for
{														// drawing contexts
int xScreen;
XRScreen *screen;

	[super initWithContextInfo: info ];

    if ((xDisplay = XOpenDisplay(NULL)) == NULL) 		// open a connection to
		{												// the X server
		NSLog(@"Cannot connect to the X server.  Exiting.\n");
		exit(-1);
		}												// Create an X window 
														// to display initial
	screen = (XRScreen *)[NSScreen mainScreen];			// drawings. window is
	xScreen = [screen xScreen];							// never mapped. 
	xDisplayRootWindow = RootWindow(xDisplay,xScreen);
	xAppRootWindow = XCreateSimpleWindow(xDisplay, xDisplayRootWindow,
										0, 0, 100, 100, 1, 1,
										BlackPixel(xDisplay, xScreen));
	return self;
}

- (void)dealloc
{
	XDestroyWindow (xDisplay, xAppRootWindow);			// Destroy context's  
														// root X Window  
	[super dealloc];									
}

- (BOOL)isDrawingToScreen			{ return YES; }

//
// Controlling the Context
//
- (void)wait						{}					
- (void)interruptExecution			{}
- (void)resetCommunication			{}
- (void)flush						{ XFlush(xDisplay); }

//
// Controlling the X Display connection
//
- (Display*)xDisplay				{ return xDisplay; }
- (Window)xAppRootWindow			{ return xAppRootWindow; }
- (Window)xDisplayRootWindow		{ return xDisplayRootWindow; }

- (void)setXDisplay:(Display *)xdisplay
{
	xDisplay = xdisplay;
}

//
// Coordinate translation
//
- (NSPoint)userPointFromXPoint:(NSPoint)xPoint
{
	xPoint.y += 0;			// fixes weird bug where otherwise window view cont
	return xPoint;			// rect origin is at -40.  optimiztion bug?
}

- (NSPoint)XPointFromUserPoint:(NSPoint)userPoint
{
	return userPoint;
}

- (NSSize)userSizeFromXSize:(NSSize)xSize
{
	return xSize;
}

- (NSSize)XSizeFromUserSize:(NSSize)userSize
{
	return userSize;
}

@end

//
// Category methods for X based backends
//
@implementation XRContext (GNUstepXRAW)

+ (GSContext*) currentContext		{ return _currentXRContext; }

+ (void) setCurrentContext: (GSContext *)context		// set app's current
{														// drawing destination
	_currentXRContext = context;						// (default context)
}

@end
